/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.core.security;

import com.jrockit.mc.common.string.CodecToolkit;
import com.jrockit.mc.core.security.SecurityException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.Key;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.PBEParameterSpec;
import javax.crypto.spec.SecretKeySpec;

class DecryptedStorage {
    private static final String HMAC_ALGORITHM = "HmacSHA1";
    private static final String RANDOM_GEN_ALGORITHM = "SHA1PRNG";
    static final int RANDOM_SEED_LEN = 8;
    private static final int ITERATION_COUNT = 4711;
    private static final String SEP = "_";
    UUID storeId;
    long nextId;
    Map<String, Object> objects;

    DecryptedStorage() {
        this.objects = new HashMap<String, Object>();
        this.storeId = UUID.randomUUID();
    }

    DecryptedStorage(String encryptedStore, String cipher, String pwd) throws Exception {
        String[] parts = encryptedStore.split(SEP);
        String encryptedStoreData = parts[0];
        String encryptedStoreSign = parts[1];
        byte[] data = CodecToolkit.base64Decode((String)encryptedStoreData);
        byte[] salt = new byte[8];
        byte[] encoded = new byte[data.length - salt.length];
        System.arraycopy(data, 0, salt, 0, salt.length);
        System.arraycopy(data, salt.length, encoded, 0, encoded.length);
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 4711);
        Cipher pbeCipher = Cipher.getInstance(cipher);
        pbeCipher.init(2, DecryptedStorage.getKey(cipher, pwd), pbeParamSpec);
        byte[] decrypted = pbeCipher.doFinal(encoded);
        if (!DecryptedStorage.calculateSignature(decrypted, pwd).equals(encryptedStoreSign)) {
            throw new SecurityException("Incorrect signature");
        }
        ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(decrypted));
        this.nextId = ois.readLong();
        this.storeId = (UUID)ois.readObject();
        this.objects = (Map)ois.readObject();
    }

    String getEncrypted(String cipher, String pwd) throws Exception {
        SecureRandom random = SecureRandom.getInstance(RANDOM_GEN_ALGORITHM, "SUN");
        return this.getEncrypted(cipher, pwd, random.generateSeed(8));
    }

    String getEncrypted(String cipher, String pwd, byte[] salt) throws Exception {
        PBEParameterSpec pbeParamSpec = new PBEParameterSpec(salt, 4711);
        Cipher pbeCipher = Cipher.getInstance(cipher);
        pbeCipher.init(1, DecryptedStorage.getKey(cipher, pwd), pbeParamSpec);
        byte[] data = this.asByteArray();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(salt);
        bos.write(pbeCipher.doFinal(data));
        bos.flush();
        return String.valueOf(CodecToolkit.base64Encode((byte[])bos.toByteArray())) + SEP + DecryptedStorage.calculateSignature(data, pwd);
    }

    private byte[] asByteArray() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(bos);
        oos.writeLong(this.nextId);
        oos.writeObject(this.storeId);
        oos.writeObject(this.objects);
        oos.flush();
        return bos.toByteArray();
    }

    private static String calculateSignature(byte[] data, String pwd) throws Exception {
        SecretKeySpec signingKey = new SecretKeySpec(pwd.getBytes(), HMAC_ALGORITHM);
        Mac mac = Mac.getInstance(HMAC_ALGORITHM);
        mac.init(signingKey);
        return CodecToolkit.base64Encode((byte[])mac.doFinal(data));
    }

    private static Key getKey(String cipher, String pwd) throws Exception {
        PBEKeySpec keySpec = new PBEKeySpec(pwd.toCharArray());
        SecretKeyFactory keyFac = SecretKeyFactory.getInstance(cipher);
        return keyFac.generateSecret(keySpec);
    }
}

