/*
 * Decompiled with CFR 0.152.
 */
package com.sun.deploy.util;

import com.sun.deploy.trace.Trace;
import com.sun.deploy.trace.TraceLevel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class StringQuoteUtil {
    private static final char SQUO = '\'';
    private static final char DQUO = '\"';
    private static final char ESCC = '\\';
    private static final char NILL = '\u0000';

    public static List parseCommandLine(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringBuffer stringBuffer = null;
        char c = '\u0000';
        boolean bl = false;
        boolean bl2 = false;
        if (string == null) {
            return arrayList;
        }
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c2 = string.charAt(i);
            if (bl2) {
                if (bl) {
                    stringBuffer.append(c2);
                    bl = false;
                } else if (c == '\u0000') {
                    if (StringQuoteUtil.isWhiteSpace(c2)) {
                        bl2 = false;
                    } else if (c2 == '\'' || c2 == '\"') {
                        c = c2;
                        stringBuffer.append(c2);
                    } else {
                        stringBuffer.append(c2);
                    }
                } else if (c2 == c && (i + 1 == n || StringQuoteUtil.isWhiteSpace(string.charAt(i + 1)))) {
                    stringBuffer.append(c2);
                    c = '\u0000';
                } else {
                    stringBuffer.append(c2);
                }
                if (!bl2 || i == n - 1) {
                    arrayList.add(StringQuoteUtil.unquoteIfNeeded(stringBuffer.toString()));
                    bl2 = false;
                    stringBuffer = null;
                    continue;
                }
                if (c2 != '\\') continue;
                bl = true;
                continue;
            }
            if (StringQuoteUtil.isWhiteSpace(c2)) continue;
            bl2 = true;
            stringBuffer = new StringBuffer();
            --i;
        }
        Trace.println(" --- parseCommandLine converted : " + string + "\ninto:\n" + arrayList, TraceLevel.SECURITY);
        return arrayList;
    }

    public static String getStringByCommandList(List list) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            if (bl) {
                stringBuffer.append(" ");
            } else {
                bl = true;
            }
            String string = (String)iterator.next();
            stringBuffer.append(StringQuoteUtil.quoteIfNeeded(string));
        }
        return stringBuffer.toString();
    }

    public static String quoteIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        if (StringQuoteUtil.containsWhiteSpace(string) && !StringQuoteUtil.isQuoted(string)) {
            if (StringQuoteUtil.containsUnescaped(string, '\"')) {
                return "\"" + StringQuoteUtil.escapeInstances(string, '\"') + "\"";
            }
            return "\"" + string + "\"";
        }
        return string;
    }

    public static String unquoteIfNeeded(String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (StringQuoteUtil.isQuoted(string)) {
            return StringQuoteUtil.unescapeInstances(string.substring(1, n - 1), string.charAt(0));
        }
        return string;
    }

    private static boolean containsWhiteSpace(String string) {
        for (int i = 0; i < string.length(); ++i) {
            if (!StringQuoteUtil.isWhiteSpace(string.charAt(i))) continue;
            return true;
        }
        return false;
    }

    private static boolean isQuoted(String string) {
        int n = string.length() - 1;
        if (n < 1) {
            return false;
        }
        return (string.charAt(0) == '\"' && string.charAt(n) == '\"' || string.charAt(0) == '\'' && string.charAt(n) == '\'') && !StringQuoteUtil.containsUnescaped(string.substring(1, n), string.charAt(0));
    }

    private static boolean isWhiteSpace(char c) {
        return c == ' ' || c == '\t' || c == '\n' || c == '\r' || c == '\f';
    }

    private static boolean containsUnescaped(String string, char c) {
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                ++i;
                continue;
            }
            if (string.charAt(i) != c) continue;
            return true;
        }
        return false;
    }

    private static String escapeInstances(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '\\') {
                stringBuffer.append(string.charAt(i++));
                if (i >= string.length()) continue;
                stringBuffer.append(string.charAt(i));
                continue;
            }
            if (string.charAt(i) == c) {
                stringBuffer.append('\\');
                stringBuffer.append(c);
                continue;
            }
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }

    private static String unescapeInstances(String string, char c) {
        StringBuffer stringBuffer = new StringBuffer();
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            if (i != n - 1 && string.charAt(i) == '\\' && string.charAt(i + 1) == c) continue;
            stringBuffer.append(string.charAt(i));
        }
        return stringBuffer.toString();
    }
}

