/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.celleditors;

import com.jrockit.mc.rjmx.ui.celleditors.NumberCellEditor;
import java.lang.reflect.Array;
import org.eclipse.swt.widgets.Composite;

public class ArrayLengthCellEditor
extends NumberCellEditor<Integer> {
    private Class<?> arrayType;
    private Object oldValue;

    public ArrayLengthCellEditor(Composite parent, Class<?> arrayType) {
        super(parent, Integer.class, true, false);
        this.arrayType = arrayType;
        if (!arrayType.isArray()) {
            throw new IllegalArgumentException(arrayType + " is not an array type");
        }
    }

    @Override
    protected void doSetValue(Object value) {
        this.oldValue = value;
        if (value == null) {
            super.doSetValue(null);
        } else if (this.arrayType.isAssignableFrom(value.getClass())) {
            super.doSetValue(Array.getLength(value));
        }
    }

    @Override
    protected Object doGetValue() {
        Integer newLength = (Integer)this.currentValue();
        if (newLength == null) {
            return null;
        }
        if (this.oldValue != null && Array.getLength(this.oldValue) == newLength) {
            return this.oldValue;
        }
        return Array.newInstance(this.arrayType.getComponentType(), (int)newLength);
    }
}

