/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.celleditors;

import com.jrockit.mc.rjmx.ui.celleditors.ClearableTextCellEditor;
import java.lang.reflect.Constructor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.widgets.Composite;

class StringConstructorCellEditor<T>
extends ClearableTextCellEditor {
    private T current;
    private Constructor<? extends T> constructor;
    boolean allowNull;

    public StringConstructorCellEditor(Composite parent, Class<? extends T> type) {
        this(parent, type, true);
    }

    public StringConstructorCellEditor(Composite parent, Class<? extends T> type, boolean allowNull) {
        super(parent, allowNull);
        this.allowNull = allowNull;
        try {
            this.constructor = type.getConstructor(String.class);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    protected void editOccured(ModifyEvent e) {
        try {
            String str = this.text.getText().trim();
            this.current = this.allowNull && "".equals(str) ? null : this.constructor.newInstance(str);
            this.setValueValid(true);
        }
        catch (Exception ex) {
            this.setValueValid(false);
        }
    }

    protected T currentValue() {
        return this.current;
    }

    protected void doSetValue(Object value) {
        this.current = value;
        super.doSetValue((Object)(value == null ? "" : this.current.toString()));
    }

    protected Object doGetValue() {
        return this.current;
    }

    public static boolean checkContructor(Class<?> forType) {
        Constructor<?>[] constructorArray = forType.getConstructors();
        int n = constructorArray.length;
        int n2 = 0;
        while (n2 < n) {
            Constructor<?> c = constructorArray[n2];
            Class<?>[] args = c.getParameterTypes();
            if (args.length == 1 && args[0].equals(String.class)) {
                return true;
            }
            ++n2;
        }
        return false;
    }
}

