/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.column;

import com.jrockit.mc.common.util.TypeHandling;
import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.ui.celleditors.AttributeEditingSupport;
import com.jrockit.mc.rjmx.ui.column.ChangeValueAction;
import com.jrockit.mc.rjmx.ui.column.Column;
import com.jrockit.mc.rjmx.ui.column.CopyColumnsHandler;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.Messages;
import com.jrockit.mc.rjmx.ui.column.TreeColumnComposite;
import com.jrockit.mc.rjmx.ui.column.TypedLabelProvider;
import com.jrockit.mc.rjmx.ui.column.VirtualColumnsManager;
import com.jrockit.mc.ui.handlers.InFocusHandlerActivator;
import com.jrockit.mc.ui.handlers.Toolkit;
import com.jrockit.mc.ui.misc.TreeStructureContentProvider;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.eclipse.core.commands.IHandler;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.menus.IMenuService;
import org.eclipse.ui.services.IServiceLocator;

public class AttributeInspector
extends TreeColumnComposite {
    protected MenuManager menuManager = new MenuManager();
    private Set<IAttributeInfo> invalidValues = new HashSet<IAttributeInfo>();
    private TypedLabelProvider<IReadOnlyAttribute> valueLabelProvider = new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

        @Override
        protected Color getForegroundTyped(IReadOnlyAttribute value) {
            if (AttributeInspector.this.invalidValues.contains(value.getInfo())) {
                return JFaceResources.getColorRegistry().get("ERROR_COLOR");
            }
            if (value.getValue() == null) {
                return JFaceResources.getColorRegistry().get("QUALIFIER_COLOR");
            }
            return null;
        }

        @Override
        protected Font getFontTyped(IReadOnlyAttribute value) {
            if (value.getValue() == null) {
                return JFaceResources.getFontRegistry().getItalic("org.eclipse.jface.textfont");
            }
            return JFaceResources.getFontRegistry().get("org.eclipse.jface.textfont");
        }

        @Override
        protected Color getBackgroundTyped(IReadOnlyAttribute element) {
            if (AttributeInspector.this.valueColumn.getEditingSupport() != null && ((AttributeEditingSupport)AttributeInspector.this.valueColumn.getEditingSupport()).canEdit(element)) {
                return AttributeInspector.this.getDisplay().getSystemColor(29);
            }
            return null;
        }

        @Override
        protected String getToolTipTextTyped(IReadOnlyAttribute value) {
            if (value != null && AttributeInspector.this.invalidValues.contains(value.getInfo())) {
                return NLS.bind((String)Messages.AttributeInspector_ILLEGAL_OPERAND, (Object)TypeHandling.simplifyType((String)value.getInfo().getType()));
            }
            if (value != null && value.getValue() == null) {
                return Messages.AttributeInspector_VALUE_IS_NULL;
            }
            return null;
        }

        @Override
        protected String getTextTyped(IReadOnlyAttribute element) {
            if (element.getValue() == null) {
                return String.valueOf('<') + TypeHandling.simplifyType((String)element.getInfo().getType()) + '>';
            }
            return TypeHandling.getValueString((Object)element.getValue());
        }
    };
    protected Column nameColumn;
    protected Column valueColumn;
    protected Column typeColumn;
    private VirtualColumnsManager virtualColumns;

    public AttributeInspector(Composite parent, IDialogSettings settings) {
        super(parent, 0, settings);
        this.getViewer().setUseHashlookup(true);
        this.getViewer().setContentProvider((IContentProvider)new TreeStructureContentProvider());
        this.virtualColumns = new VirtualColumnsManager(this, settings);
        this.nameColumn = new Column(Messages.AttributeInspector_NAME_COLUMN_HEADER, "name", new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

            @Override
            protected String getTextTyped(IReadOnlyAttribute attr) {
                return attr.getInfo().getName();
            }

            @Override
            protected String getDefaultText(Object element) {
                return element == null ? "" : element.toString();
            }
        });
        this.valueColumn = new Column(Messages.AttributeInspector_VALUE_COLUMN_HEADER, "value", this.valueLabelProvider);
        this.typeColumn = new Column(Messages.AttributeInspector_TYPE_COLUMN_HEADER, "type", new TypedLabelProvider<IReadOnlyAttribute>(IReadOnlyAttribute.class){

            @Override
            protected String getTextTyped(IReadOnlyAttribute paramater) {
                return TypeHandling.simplifyType((String)paramater.getInfo().getType());
            }
        });
        this.addVirtualColumns(this.nameColumn, this.valueColumn, this.typeColumn);
        Iterator<IColumn> visibleColumns = this.getColumns().iterator();
        if (visibleColumns.hasNext()) {
            this.sortColumn(visibleColumns.next(), 0);
        }
        this.setupContextMenu();
        CopyColumnsHandler copyHandler = new CopyColumnsHandler(this.getColumns(), this.virtualColumns.getColumns());
        this.getViewer().addSelectionChangedListener((ISelectionChangedListener)copyHandler);
        InFocusHandlerActivator handlerActivator = new InFocusHandlerActivator(ActionFactory.COPY.getCommandId(), (IHandler)copyHandler);
        this.getViewer().getControl().addFocusListener((FocusListener)handlerActivator);
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)this.getViewer());
        this.getViewer().refresh();
    }

    protected final void addVirtualColumns(IColumn ... cols) {
        IColumn[] iColumnArray = cols;
        int n = cols.length;
        int n2 = 0;
        while (n2 < n) {
            IColumn column = iColumnArray[n2];
            this.virtualColumns.addColumn(column);
            ++n2;
        }
    }

    protected boolean isColumnVisible(IColumn column) {
        return this.virtualColumns.isVisible(column);
    }

    public void enableValueEditing(final Runnable editedCallback) {
        this.valueColumn.setEditingSupport(new AttributeEditingSupport((ColumnViewer)this.getViewer()){

            @Override
            protected void setValue(Object element, Object value) {
                super.setValue(element, value);
                AttributeInspector.this.invalidValues.clear();
                if (editedCallback != null) {
                    editedCallback.run();
                }
                this.getViewer().refresh(element);
            }
        });
        this.updateColumn(this.valueColumn);
    }

    public void setAttributesUntyped(Object[] attributes) {
        this.getViewer().setInput((Object)attributes);
        this.getViewer().refresh();
    }

    public void setAttributes(Collection<? extends IReadOnlyAttribute> attribute) {
        this.setAttributesUntyped(attribute.toArray());
    }

    public void setAttributesInvalid(Collection<? extends IAttributeInfo> attribute) {
        this.invalidValues.addAll(attribute);
    }

    private void setupContextMenu() {
        Menu menu = this.menuManager.createContextMenu(this.getViewer().getControl());
        this.getViewer().getControl().setMenu(menu);
        this.menuManager.add(this.virtualColumns.getSortingMenu());
        this.menuManager.add(this.virtualColumns.getVisibilityMenu());
        this.menuManager.add((IContributionItem)new Separator());
        this.menuManager.add(Toolkit.createPushItem((IServiceLocator)PlatformUI.getWorkbench(), (ActionFactory)ActionFactory.COPY));
        this.menuManager.add((IContributionItem)new MenuManager(Messages.CopyAction_COPY_SETTINGS_MENU_TEXT, "com.jrockit.mc.ui.copysettings"));
        this.menuManager.add((IContributionItem)new Separator());
        IMenuService ms = (IMenuService)PlatformUI.getWorkbench().getService(IMenuService.class);
        if (ms != null) {
            ms.populateContributionManager((ContributionManager)this.menuManager, "popup:org.eclipse.ui.popup.any");
        }
        this.menuManager.add((IAction)new ChangeValueAction((ISelectionProvider)this.getViewer(), this));
    }

    boolean canEditElementValue(Object element) {
        return this.isColumnVisible(this.valueColumn) && this.valueColumn.getEditingSupport() != null && ((AttributeEditingSupport)this.valueColumn.getEditingSupport()).canEdit(element);
    }

    void editElement(Object element) {
        this.getViewer().editElement(element, this.getColumns().indexOf(this.valueColumn));
    }
}

