/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.column;

import com.jrockit.mc.rjmx.ui.column.ColumnCompositeComparator;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.AbstractColumnLayout;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Item;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public abstract class ColumnComposite
extends Composite {
    private static final String WIDTH_SECTION = "column_widths";
    private static final int DEFAULT_WIDTH = 50;
    private Map<IColumn, ColumnData> columnData = new HashMap<IColumn, ColumnData>();
    private List<IColumn> columns = new ArrayList<IColumn>();
    private IDialogSettings columnWidths;
    private AbstractColumnLayout layout;
    private final ColumnCompositeComparator comparator;

    public ColumnComposite(Composite parent, IDialogSettings settings, AbstractColumnLayout layout) {
        super(parent, 0);
        this.columnWidths = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)WIDTH_SECTION);
        this.layout = layout;
        this.setLayout((Layout)layout);
        this.comparator = new ColumnCompositeComparator();
    }

    public void updateColumn(IColumn column) {
        ColumnData colData = this.columnData.get(column);
        if (colData != null) {
            colData.viewerColumn.setEditingSupport(column.getEditingSupport());
            colData.viewerColumn.setLabelProvider((CellLabelProvider)column.getLabelProvider());
            colData.columnItem.setText(column.getName());
            this.getViewer().refresh();
        }
    }

    public void addColumn(final IColumn column, int virtualIndex) {
        ColumnData colData = this.columnData.get(column);
        if (colData == null) {
            int index = this.getRealIndex(virtualIndex);
            colData = new ColumnData();
            colData.virtualIndex = virtualIndex;
            colData.columnItem = this.createColumnWidget(column.getId(), index, 0);
            colData.columnItem.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    ColumnComposite.this.sortColumn(column, 0);
                }
            });
            colData.viewerColumn = new ViewerColumn(this.getViewer(), (Widget)colData.columnItem){};
            this.columns.add(index, column);
            this.columnData.put(column, colData);
            this.layout.setColumnData((Widget)colData.columnItem, (ColumnLayoutData)new ColumnWeightData(this.loadColumnWidth(column.getId())));
            this.layout();
        }
        this.updateColumn(column);
    }

    public void removeColumn(IColumn column) {
        this.columnData.remove((Object)column).columnItem.dispose();
        this.columns.remove(column);
        this.layout();
    }

    public void sortColumn(IColumn column, int sortOrder) {
        this.comparator.setColumn(column, sortOrder);
        this.updateColumnWidget(this.columnData.get((Object)column).columnItem);
        this.getViewer().refresh();
    }

    protected void columnRemoved(String columnId, int columnWidth) {
        this.columnWidths.put(columnId, columnWidth);
    }

    protected abstract ColumnViewer getViewer();

    protected abstract Item createColumnWidget(String var1, int var2, int var3);

    protected abstract void updateColumnWidget(Item var1);

    private int loadColumnWidth(String columnId) {
        return this.columnWidths.get(columnId) != null ? Math.max(50, this.columnWidths.getInt(columnId)) : 50;
    }

    private int getRealIndex(int virtualIndex) {
        int i = 0;
        while (i < this.columns.size()) {
            if (this.columnData.get((Object)this.columns.get((int)i)).virtualIndex > virtualIndex) {
                return i;
            }
            ++i;
        }
        return this.columns.size();
    }

    public List<IColumn> getColumns() {
        return this.columns;
    }

    protected ColumnCompositeComparator getViewerComparator() {
        return this.comparator;
    }

    private static class ColumnData {
        int virtualIndex;
        Item columnItem;
        ViewerColumn viewerColumn;

        private ColumnData() {
        }
    }
}

