/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.column;

import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.SortObjectProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;

public class ColumnCompositeComparator
extends ViewerComparator {
    private IColumn column;
    private boolean sortAscending = true;
    private ColumnLabelProvider labelProvider;

    public void setColumn(IColumn column, int sortOrder) {
        this.sortAscending = this.sortColumnAscending(sortOrder, column);
        this.column = column;
        this.labelProvider = column.getLabelProvider();
    }

    private boolean sortColumnAscending(int sortOrder, IColumn column) {
        switch (sortOrder) {
            case 128: {
                return true;
            }
            case 1024: {
                return false;
            }
        }
        return this.column != column ? true : !this.sortAscending;
    }

    public int getSortOrder() {
        return this.sortAscending ? 128 : 1024;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        if (this.labelProvider instanceof SortObjectProvider) {
            int compare = ((SortObjectProvider)this.labelProvider).getSortObject(e1).compareTo(((SortObjectProvider)this.labelProvider).getSortObject(e2));
            return this.sortAscending ? compare : -compare;
        }
        if (this.labelProvider != null) {
            int compare = this.labelProvider.getText(e1).compareTo(this.labelProvider.getText(e2));
            return this.sortAscending ? compare : -compare;
        }
        int compare = super.compare(viewer, e1, e2);
        return this.sortAscending ? compare : -compare;
    }
}

