/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.column;

import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.ui.dnd.ClipboardManager;
import com.jrockit.mc.ui.dnd.TableStringBuilder;
import java.util.Iterator;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreePath;

public class CopyColumnsHandler
extends AbstractHandler
implements ISelectionChangedListener {
    private final Iterable<IColumn> visibleColumns;
    private final Iterable<IColumn> allColumns;
    private IStructuredSelection lastSelection;

    public CopyColumnsHandler(Iterable<IColumn> visibleColumns, Iterable<IColumn> allColumns) {
        this.visibleColumns = visibleColumns;
        this.allColumns = allColumns;
        this.setBaseEnabled(false);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        ISelection selection = event.getSelection();
        if (!selection.isEmpty() && selection instanceof IStructuredSelection) {
            this.lastSelection = (IStructuredSelection)selection;
            this.setBaseEnabled(true);
        } else {
            this.setBaseEnabled(false);
        }
    }

    public Object execute(ExecutionEvent event) throws ExecutionException {
        Iterable<IColumn> columns;
        ClipboardManager cbm = ClipboardManager.getDefault();
        TableStringBuilder stb = new TableStringBuilder(cbm.shouldCopyAsCsv());
        Iterable<IColumn> iterable = columns = cbm.shouldCopyOnlyVisible() ? this.visibleColumns : this.allColumns;
        if (cbm.shouldCopyColumnHeaders()) {
            for (IColumn column : columns) {
                stb.appendCellHeader(column.getName(), null);
            }
            stb.appendNewLine();
        }
        if (this.lastSelection instanceof ITreeSelection) {
            TreePath[] treePathArray = ((ITreeSelection)this.lastSelection).getPaths();
            int n = treePathArray.length;
            int n2 = 0;
            while (n2 < n) {
                TreePath path = treePathArray[n2];
                for (IColumn column : columns) {
                    int indent = cbm.shouldIndentForStructure() ? path.getSegmentCount() - 1 : 0;
                    stb.appendCell(column.getLabelProvider().getText(path.getLastSegment()), indent);
                }
                stb.appendNewLine();
                ++n2;
            }
        } else {
            Iterator it = this.lastSelection.iterator();
            while (it.hasNext()) {
                for (IColumn column : columns) {
                    stb.appendCell(column.getLabelProvider().getText(it.next()), 0);
                }
                stb.appendNewLine();
            }
        }
        cbm.setContents(stb.toString());
        return null;
    }
}

