/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.column;

import com.jrockit.mc.rjmx.ui.column.ColumnComposite;
import com.jrockit.mc.rjmx.ui.column.IColumn;
import com.jrockit.mc.rjmx.ui.column.Messages;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;

public class VirtualColumnsManager {
    private static final String VISIBILITY_SECTION = "hidden_columns";
    private int visibleCount;
    private IDialogSettings hiddenColumnsSettings;
    private MenuManager visibilityMenu = new MenuManager(Messages.ColumnCollection_VISIBILE_COLUMNS);
    private MenuManager sortMenu = new MenuManager(Messages.AttributeInspector_SORT_COLUMNS_MENU_HEADER);
    private ColumnComposite control;
    private List<IColumn> columns = new ArrayList<IColumn>();

    public VirtualColumnsManager(ColumnComposite control, IDialogSettings settings) {
        this.hiddenColumnsSettings = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)VISIBILITY_SECTION);
        this.control = control;
    }

    public void addColumn(final IColumn column) {
        this.columns.add(column);
        final MenuManager sortColumnMenu = new MenuManager(column.getName());
        sortColumnMenu.add((IAction)this.createSortAction(true, column));
        sortColumnMenu.add((IAction)this.createSortAction(false, column));
        sortColumnMenu.setVisible(false);
        this.sortMenu.add((IContributionItem)sortColumnMenu);
        final int index = this.visibilityMenu.getItems().length;
        this.visibilityMenu.add((IAction)new Action(column.getName(), 2){
            {
                super($anonymous0, $anonymous1);
                this.setChecked(!VirtualColumnsManager.this.hiddenColumnsSettings.getBoolean(iColumn.getId()) && this.createWidget());
            }

            public void run() {
                if (this.isChecked()) {
                    if (!this.createWidget()) {
                        this.setChecked(false);
                    }
                } else {
                    this.disposeWidget();
                }
            }

            private void disposeWidget() {
                VirtualColumnsManager.this.control.removeColumn(column);
                VirtualColumnsManager.this.hiddenColumnsSettings.put(column.getId(), true);
                sortColumnMenu.setVisible(false);
                sortColumnMenu.markDirty();
                VirtualColumnsManager.this.updateEnablement(-1);
            }

            private boolean createWidget() {
                try {
                    VirtualColumnsManager.this.control.addColumn(column, index);
                    VirtualColumnsManager.this.hiddenColumnsSettings.put(column.getId(), false);
                    sortColumnMenu.setVisible(true);
                    sortColumnMenu.markDirty();
                    VirtualColumnsManager.this.updateEnablement(1);
                    return true;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }
        });
    }

    private void updateEnablement(int change) {
        this.visibleCount += change;
        if (this.visibleCount > 2) {
            return;
        }
        boolean enableAllChecked = this.visibleCount == 2;
        IContributionItem[] iContributionItemArray = this.visibilityMenu.getItems();
        int n = iContributionItemArray.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action;
            IContributionItem i = iContributionItemArray[n2];
            action.setEnabled(!(action = ((ActionContributionItem)i).getAction()).isChecked() || enableAllChecked);
            ++n2;
        }
    }

    public Iterable<IColumn> getColumns() {
        return this.columns;
    }

    public boolean isVisible(IColumn column) {
        return !this.hiddenColumnsSettings.getBoolean(column.getId());
    }

    public IContributionItem getVisibilityMenu() {
        return this.visibilityMenu;
    }

    public IContributionItem getSortingMenu() {
        return this.sortMenu;
    }

    private Action createSortAction(final boolean up, final IColumn column) {
        String text = up ? Messages.AttributeInspector_SORT_COLUMN_ASCENDING_MENU_ITEM : Messages.AttributeInspector_SORT_COLUMN_DESCENDING_MENU_ITEM;
        return new Action(text){

            public void run() {
                VirtualColumnsManager.this.control.sortColumn(column, up ? 128 : 1024);
            }
        };
    }
}

