/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.ui.UIPlugin;
import java.awt.Color;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Table;

public class AbstractAttributeLabelProvider
implements ITableLabelProvider,
ITableFontProvider,
ITableColorProvider {
    private org.eclipse.swt.graphics.Color greyedOutColor;
    private final IMRIMetaDataService attributeInfoManager;
    private final ISubscriptionService attributeSubscriptionService;
    private final IConnectionHandle connectionHandle;

    public AbstractAttributeLabelProvider(Table table, IConnectionHandle handle) {
        this.connectionHandle = handle;
        this.attributeInfoManager = (IMRIMetaDataService)handle.getServiceOrDummy(IMRIMetaDataService.class);
        this.attributeSubscriptionService = (ISubscriptionService)handle.getServiceOrDummy(ISubscriptionService.class);
    }

    public void dispose() {
        if (this.greyedOutColor != null) {
            this.greyedOutColor.dispose();
            this.greyedOutColor = null;
        }
    }

    public Font getFont(Object element, int columnIndex) {
        IMRIMetaData info = element instanceof IMRIMetaData ? (IMRIMetaData)element : this.attributeInfoManager.getMetaData((MRI)element);
        if (columnIndex == 0 && MRIMetaDataToolkit.isWritable((IMRIMetaDataProvider)info)) {
            return UIPlugin.getDefault().getFontColorToolkit().getBoldTableFont();
        }
        return UIPlugin.getDefault().getFontColorToolkit().getNormalTableFont();
    }

    public org.eclipse.swt.graphics.Color getBackground(Object element, int columnIndex) {
        return null;
    }

    public org.eclipse.swt.graphics.Color getForeground(Object element, int columnIndex) {
        MRI descriptor = element instanceof MRI ? (MRI)element : ((IMRIMetaData)element).getMRI();
        if (this.getAttributeSubscriptionService().isMRIUnavailable(descriptor)) {
            if (this.greyedOutColor == null) {
                Color c = GraphSettingRegistry.getGreyedOutAWTColor();
                this.greyedOutColor = new org.eclipse.swt.graphics.Color((Device)Display.getCurrent(), c.getRed(), c.getGreen(), c.getBlue());
            }
            return this.greyedOutColor;
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }

    protected ISubscriptionService getAttributeSubscriptionService() {
        return this.attributeSubscriptionService;
    }

    protected IConnectionHandle getConnectionHandle() {
        return this.connectionHandle;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        return null;
    }
}

