/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.string.StringToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ServiceException;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValue;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AccessibleComposite;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorToolTipTextProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeModelEvent;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorDialog;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.IAttributeModelListener;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.TableToolTipMouseTrackAdapter;
import com.jrockit.mc.rjmx.ui.internal.ValueStatistics;
import com.jrockit.mc.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.IToolTipTextProvider;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.Row;
import com.jrockit.mc.ui.model.fields.StringField;
import com.jrockit.mc.ui.model.fields.StructuredRowSelection;
import com.jrockit.mc.ui.site.SectionSite;
import java.math.BigDecimal;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class AccessibleAttributeComposite
extends AccessibleComposite {
    public static final int FIELD_COUNT;
    public static final Field FIELD_ATTRIBUTE;
    public static final Field FIELD_VALUE;
    public static final Field FIELD_MINIMUM;
    public static final Field FIELD_MAXIMUM;
    public static final Field FIELD_AVERAGE;
    public static final Field FIELD_ATTRIBUTE_SPECIFICATION;
    private static Field[] FIELD_PROTOTYPES;
    private IConnectionHandle m_connectionHandle;
    private AttributeModel m_attributeModel;
    private Map<MRI, ValueStatistics> m_valueStatistics;
    private boolean m_showTimestamp;
    private boolean m_unformattedValues;

    static {
        int fieldCount = 0;
        FIELD_ATTRIBUTE = new StringField(fieldCount++);
        FIELD_VALUE = new StringField(fieldCount++);
        FIELD_MINIMUM = new StringField(fieldCount++);
        FIELD_MAXIMUM = new StringField(fieldCount++);
        FIELD_AVERAGE = new StringField(fieldCount++);
        FIELD_ATTRIBUTE_SPECIFICATION = new StringField(fieldCount++);
        FIELD_COUNT = fieldCount;
        FieldToolkit.initializeFields((String)"com.jrockit.mc.rjmx.ui.internal.fields", AccessibleAttributeComposite.class);
        FIELD_ATTRIBUTE.setWidthWeight(100);
        FIELD_VALUE.setWidthWeight(50);
        FIELD_MINIMUM.setWidthWeight(50);
        FIELD_MAXIMUM.setWidthWeight(50);
        FIELD_AVERAGE.setWidthWeight(50);
        FIELD_ATTRIBUTE_SPECIFICATION.setWidthWeight(100);
        FIELD_PROTOTYPES = new Field[]{FIELD_ATTRIBUTE, FIELD_VALUE, FIELD_MINIMUM, FIELD_MAXIMUM, FIELD_AVERAGE, FIELD_ATTRIBUTE_SPECIFICATION};
    }

    public AccessibleAttributeComposite(Composite parent, int style, FormToolkit formToolkit, IConnectionHandle connectionHandle, SectionSite site, AttributeModel attributeModel, FreezeModel freezeModel) throws ServiceException {
        super(parent, style, formToolkit, site, FIELD_PROTOTYPES, freezeModel);
        this.m_connectionHandle = connectionHandle;
        this.m_attributeModel = attributeModel;
        this.m_valueStatistics = new HashMap<MRI, ValueStatistics>();
        Table table = this.getFieldTableViewer().getTable();
        table.addMouseTrackListener((MouseTrackListener)new TableToolTipMouseTrackAdapter(table, new IToolTipTextProvider(){
            private final AttributeDescriptorToolTipTextProvider attributeToolTipTextProvider;
            {
                this.attributeToolTipTextProvider = new AttributeDescriptorToolTipTextProvider(AccessibleAttributeComposite.this.getConnectionHandle());
            }

            public String getToolTipText(Object obj) {
                MRI attribute = (MRI)((Row)obj).getElement();
                if (!AccessibleAttributeComposite.this.getFreezeModel().isFreezed()) {
                    return this.attributeToolTipTextProvider.getToolTipText(attribute);
                }
                return this.attributeToolTipTextProvider.getAttributeDescriptorToolTipText(attribute, ((ValueStatistics)AccessibleAttributeComposite.this.m_valueStatistics.get(attribute)).getLastValue());
            }
        }));
        final ISubscriptionService subscriptionService = (ISubscriptionService)this.getConnectionHandle().getServiceOrThrow(ISubscriptionService.class);
        this.m_attributeModel.addAttributeModelListener(new IAttributeModelListener(table){
            private final IMRIValueListener m_attributeValueListener;
            {
                this.m_attributeValueListener = new IMRIValueListener(){

                    public void valueChanged(final MRIValueEvent event) {
                        DisplayToolkit.safeAsyncExec((Widget)table, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MRI attribute = event.getSubscriptionAttribute();
                                ValueStatistics valueStatistics = (ValueStatistics)AccessibleAttributeComposite.this.m_valueStatistics.get(attribute);
                                if (valueStatistics != null) {
                                    valueStatistics.updateStatistics(event.getValue(), event.getTimestamp());
                                }
                                if (!AccessibleAttributeComposite.this.getFreezeModel().isFreezed()) {
                                    AccessibleAttributeComposite.this.getFieldTableViewer().refresh();
                                }
                            }
                        });
                    }
                };
            }

            private void addAttribute(MRI attribute) {
                MRIValueEvent valueEvent = subscriptionService.getLastMRIValueEvent(attribute);
                if (valueEvent == null) {
                    AccessibleAttributeComposite.this.m_valueStatistics.put(attribute, new ValueStatistics(null, 0L));
                } else {
                    AccessibleAttributeComposite.this.m_valueStatistics.put(attribute, new ValueStatistics(valueEvent.getValue(), valueEvent.getTimestamp()));
                }
                subscriptionService.addMRIValueListener(attribute, this.m_attributeValueListener);
            }

            private void removeAttribute(MRI attribute) {
                subscriptionService.removeMRIValueListener(attribute, this.m_attributeValueListener);
                AccessibleAttributeComposite.this.m_valueStatistics.remove(attribute);
            }

            @Override
            public void attributeAdded(AttributeModelEvent event, boolean enabled) {
                this.addAttribute(event.getAttribute());
                AccessibleAttributeComposite.this.getFieldTableViewer().refresh();
            }

            @Override
            public void attributeRemoved(AttributeModelEvent event) {
                this.removeAttribute(event.getAttribute());
                if (!AccessibleAttributeComposite.this.getFieldTableViewer().getTable().isDisposed()) {
                    AccessibleAttributeComposite.this.getFieldTableViewer().refresh();
                }
            }

            @Override
            public void attributeChanged(AttributeModelEvent event) {
                this.removeAttribute(event.getFromAttribute());
                this.addAttribute(event.getAttribute());
                AccessibleAttributeComposite.this.getFieldTableViewer().refresh();
            }
        });
        this.getFieldTableViewer().setInput((Object)this.m_attributeModel);
    }

    private IConnectionHandle getConnectionHandle() {
        return this.m_connectionHandle;
    }

    @Override
    protected AbstractFieldTableContentProvider createFieldTableContentProvider() {
        return new AttributeFieldTableContentProvider();
    }

    @Override
    protected Composite createControlComposite(FormToolkit formToolkit) {
        ScrolledComposite sc = this.createControlCompositeWrapper();
        final Composite buttonComposite = formToolkit.createComposite((Composite)sc);
        GridData gridData = new GridData(4, 4, true, true);
        buttonComposite.setLayoutData((Object)gridData);
        buttonComposite.setLayout((Layout)new GridLayout(1, true));
        Button addAttributeButton = formToolkit.createButton(buttonComposite, Messages.ChartComposite_BUTTON_ADD_TEXT, 0);
        GridData gd3 = new GridData(4, 4, false, false);
        addAttributeButton.setLayoutData((Object)gd3);
        addAttributeButton.setImage(RJMXUIPlugin.getDefault().getImage("add-obj.gif"));
        addAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeSelectorDialog dialog = new AttributeSelectorDialog(buttonComposite.getShell(), true, false);
                MRI[] current = AccessibleAttributeComposite.this.m_attributeModel.getAttributeDescriptors();
                MRI[] selectedAttributes = dialog.show(AccessibleAttributeComposite.this.getConnectionHandle(), new MRI[0], current);
                if (selectedAttributes.length > 0) {
                    MRI[] mRIArray = selectedAttributes;
                    int n = selectedAttributes.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MRI attribute = mRIArray[n2];
                        AccessibleAttributeComposite.this.m_attributeModel.add(attribute);
                        ++n2;
                    }
                }
            }
        });
        Button removeAttributeButton = formToolkit.createButton(buttonComposite, Messages.ChartComposite_BUTTON_REMOVE_TEXT, 0);
        GridData gd4 = new GridData(4, 4, false, false);
        removeAttributeButton.setLayoutData((Object)gd4);
        removeAttributeButton.setImage(RJMXUIPlugin.getDefault().getImage("remove-obj.png"));
        removeAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredRowSelection selection = (StructuredRowSelection)AccessibleAttributeComposite.this.getFieldTableViewer().getSelection();
                Iterator i = selection.iterator();
                while (i.hasNext()) {
                    AccessibleAttributeComposite.this.m_attributeModel.remove((MRI)i.next());
                }
            }
        });
        Button clearStatisticsButton = formToolkit.createButton(buttonComposite, Messages.AccessibleAttributeComposite_BUTTON_CLEAR_STATISTICS_LABEL, 0);
        GridData gd5 = new GridData(4, 4, false, false);
        clearStatisticsButton.setLayoutData((Object)gd5);
        clearStatisticsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                for (ValueStatistics statistics : AccessibleAttributeComposite.this.m_valueStatistics.values()) {
                    statistics.resetStatistics();
                    AccessibleAttributeComposite.this.getFieldTableViewer().refresh();
                }
            }
        });
        final Button timestampButton = formToolkit.createButton(buttonComposite, Messages.AccessibleAttributeComposite_CHECKBOX_TIMESTAMPS_LABEL, 32);
        GridData gd7 = new GridData(4, 4, false, false);
        timestampButton.setLayoutData((Object)gd7);
        timestampButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessibleAttributeComposite.this.m_showTimestamp = timestampButton.getSelection();
            }
        });
        timestampButton.setSelection(this.m_showTimestamp);
        final Button unformattedButton = formToolkit.createButton(buttonComposite, Messages.AccessibleAttributeComposite_CHECKBOX_UNFORMATTED_VALUES_LABEL, 32);
        GridData gd8 = new GridData(4, 4, false, false);
        unformattedButton.setLayoutData((Object)gd8);
        unformattedButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AccessibleAttributeComposite.this.m_unformattedValues = unformattedButton.getSelection();
            }
        });
        unformattedButton.setSelection(this.m_unformattedValues);
        this.wrapControlComposite(sc, buttonComposite);
        return sc;
    }

    private ValueStatistics getValueStatistics(MRI attribute) {
        return this.m_valueStatistics.get(attribute);
    }

    private boolean showTimeStamps() {
        return this.m_showTimestamp;
    }

    private boolean showUnformatedValues() {
        return this.m_unformattedValues;
    }

    private final class AttributeFieldTableContentProvider
    extends AbstractFieldTableContentProvider {
        private final DateFormat dateFormat = DateFormat.getTimeInstance();
        private final NumberFormat numberFormat = NumberFormat.getNumberInstance();
        private final NumberFormat format = NumberFormat.getIntegerInstance();

        private AttributeFieldTableContentProvider() {
        }

        public Object[] getColumnObject(Object inputRowElement) {
            MRI attribute;
            ValueStatistics statistics;
            if (inputRowElement instanceof MRI && (statistics = AccessibleAttributeComposite.this.getValueStatistics(attribute = (MRI)inputRowElement)) != null) {
                return new Object[]{MRIMetaDataToolkit.getDisplayName((IConnectionHandle)AccessibleAttributeComposite.this.getConnectionHandle(), (MRI)attribute), this.buildValueTimestampString(statistics.getLastValue(), statistics.getLastTimestamp()), this.buildValueTimestampString(statistics.getMinimumValue(), statistics.getMinimumTimestamp()), this.buildValueTimestampString(statistics.getMaximumValue(), statistics.getMaximumTimestamp()), this.buildValueTimestampString(statistics.getAverageValue(), statistics.getLastTimestamp()), MBeanPropertiesOrderer.getAttributePath(attribute)};
            }
            return new Object[]{"", "", "", "", "", ""};
        }

        private String buildValueTimestampString(Object value, long timeStamp) {
            if (value == MRIValue.UNAVAILABLE_VALUE || value == null) {
                return MRIValue.UNAVAILABLE_VALUE.toString();
            }
            if (!AccessibleAttributeComposite.this.showTimeStamps()) {
                return this.buildValue(value);
            }
            StringBuilder sb = new StringBuilder(this.buildValue(value));
            sb.append(" @ ");
            sb.append(this.dateFormat.format(new Date(timeStamp)));
            return sb.toString();
        }

        private String buildValue(Object value) {
            if (AccessibleAttributeComposite.this.showUnformatedValues() || !(value instanceof Number)) {
                return StringToolkit.toString((Object)value);
            }
            if (value instanceof Double || value instanceof Float || value instanceof BigDecimal) {
                return this.numberFormat.format(value);
            }
            return this.format.format(value);
        }

        public Object[] getRowElements(Object inputElement) {
            if (inputElement instanceof AttributeModel) {
                AttributeModel attributeModel = (AttributeModel)inputElement;
                return attributeModel.getAttributeDescriptors();
            }
            return new Object[0];
        }
    }
}

