/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageHandle;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageService;
import com.jrockit.mc.rjmx.ui.internal.MultiplierIterator;
import java.util.ArrayList;
import java.util.Iterator;
import se.hirt.greychart.data.DataChangeListener;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.ITimestampedData;

class AttributeDataSeries
implements DataSeries<ITimestampedData> {
    private final IAttributeStorageService m_service;
    private final MRI m_attribute;
    private AttributeStorageHandle m_handle;
    private double m_multiplier;

    AttributeDataSeries(IAttributeStorageService service, MRI attribute) {
        this.m_service = service;
        this.m_attribute = attribute;
    }

    public void dispose() {
        if (this.m_handle != null) {
            this.m_handle.dispose();
            this.m_handle = null;
        }
    }

    AttributeStorageHandle getHandle() {
        if (this.m_handle == null) {
            this.m_handle = this.m_service.getAttributeStorage(this.m_attribute);
        }
        return this.m_handle;
    }

    public void addChangeListener(DataChangeListener listener) {
    }

    public void removeChangeListener(DataChangeListener listener) {
    }

    public boolean hasData() {
        return true;
    }

    public Iterator<ITimestampedData> createIterator(long min, long max) {
        if (this.getHandle() == null) {
            return new ArrayList(0).iterator();
        }
        return new MultiplierIterator(this.getHandle().iterator(), this.m_multiplier);
    }

    public MRI getAttributeDescriptor() {
        return this.m_attribute;
    }

    public void setMultiplier(double multiplier) {
        this.m_multiplier = multiplier;
    }

    public int hashCode() {
        return this.m_attribute == null ? 0 : this.m_attribute.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AttributeDataSeries other = (AttributeDataSeries)obj;
        return !(this.m_attribute == null ? other.m_attribute != null : !this.m_attribute.equals((Object)other.m_attribute));
    }
}

