/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.persistence.internal.AttributeBundleModel;
import com.jrockit.mc.rjmx.services.ServiceException;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.internal.AttributeExceptionEvent;
import com.jrockit.mc.rjmx.subscription.internal.AttributeReregisteredEvent;
import com.jrockit.mc.rjmx.subscription.storage.internal.DefaultAttributeStorageService;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageService;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeXYDataProvider;
import com.jrockit.mc.rjmx.util.internal.XmlSerializerToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Observable;
import java.util.Set;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class AttributeDescriptorModel
extends Observable
implements XmlEnabled {
    private static final String XML_ATTRIBUTE_ENABLED = "attributeEnabled";
    private static final String XML_LOG_TO_HISTORICAL_DATA = "logToHistoricalData";
    private final List<MRI> m_descriptorList = new ArrayList<MRI>();
    private final AttributeChartModel m_attributeChartModel;
    private final ExceptionHandler m_subscriptionExceptionHandler;
    private final DefaultAttributeStorageService m_storageService;
    private final ISubscriptionService m_subscriptionService;
    private boolean m_logToHistoricalData;
    private boolean m_persistenceEnabled;

    public AttributeDescriptorModel(IConnectionHandle handle, AttributeChartModel model) throws ServiceException {
        this.m_storageService = (DefaultAttributeStorageService)handle.getServiceOrThrow(IAttributeStorageService.class);
        this.m_subscriptionService = (ISubscriptionService)handle.getServiceOrThrow(ISubscriptionService.class);
        this.m_attributeChartModel = model;
        this.m_subscriptionExceptionHandler = new ExceptionHandler();
    }

    public void addSubscriptionStateListener(ISubscriptionStateListener listener) {
        this.m_subscriptionExceptionHandler.addSubscriptionStateListener(listener);
    }

    public void removeSubscriptionStateListener(ISubscriptionStateListener listener) {
        this.m_subscriptionExceptionHandler.removeSubscriptionStateListener(listener);
    }

    public void startPersistence() throws IOException {
        this.m_storageService.getPersistentDataAggregator().enablePersistence((AttributeBundleModel)this.m_attributeChartModel, this.m_attributeChartModel.getAttributesInTable());
        this.m_persistenceEnabled = true;
        this.setChanged();
    }

    public void stopPersistence() throws IOException {
        this.m_storageService.getPersistentDataAggregator().disablePersistence((AttributeBundleModel)this.m_attributeChartModel);
        this.m_persistenceEnabled = false;
        this.setChanged();
    }

    public boolean getPersistenceEnabled() {
        return this.m_persistenceEnabled;
    }

    private AttributeXYDataProvider getDataProvider() {
        return (AttributeXYDataProvider)this.m_attributeChartModel.getDataProvider();
    }

    public List<MRI> getAttributeDescriptors() {
        ArrayList<MRI> list = new ArrayList<MRI>();
        list.addAll(this.m_descriptorList);
        return Collections.unmodifiableList(list);
    }

    public MRI[] createAttributeDescriptorArray() {
        return this.m_descriptorList.toArray(new MRI[this.m_descriptorList.size()]);
    }

    public boolean remove(MRI attributeDescriptor) {
        if (this.m_descriptorList.remove(attributeDescriptor)) {
            this.m_attributeChartModel.setAttributeDescriptors(this.createAttributeDescriptorArray());
            if (this.getDataProvider() != null) {
                this.getDataProvider().removeSubscriptionAttribute(attributeDescriptor);
            }
            if (this.m_subscriptionExceptionHandler != null) {
                this.m_subscriptionService.removeMRIValueListener(attributeDescriptor, (IMRIValueListener)this.m_subscriptionExceptionHandler);
            }
            if (this.getPersistenceEnabled()) {
                try {
                    this.startPersistence();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not remove " + attributeDescriptor + " from persistence.", e);
                }
            }
            this.setChanged();
            this.m_attributeChartModel.notifyObservers();
            return true;
        }
        return false;
    }

    public boolean add(MRI attributeDescriptor, boolean enabled) {
        if (this.m_descriptorList.contains(attributeDescriptor)) {
            return false;
        }
        if (this.m_descriptorList.add(attributeDescriptor)) {
            this.m_attributeChartModel.setAttributeDescriptors(this.createAttributeDescriptorArray());
            if (this.getDataProvider() != null) {
                this.getDataProvider().addSubscriptionAttribute(attributeDescriptor, enabled);
            }
            if (this.m_subscriptionExceptionHandler != null) {
                this.m_subscriptionService.addMRIValueListener(attributeDescriptor, (IMRIValueListener)this.m_subscriptionExceptionHandler);
            }
            if (this.getPersistenceEnabled()) {
                try {
                    this.m_attributeChartModel.setAttributeDescriptors(this.createAttributeDescriptorArray());
                    this.startPersistence();
                }
                catch (IOException e) {
                    throw new RuntimeException("Could not remove " + attributeDescriptor + " from persistence.", e);
                }
            }
            this.setChanged();
            this.m_attributeChartModel.notifyObservers();
            return true;
        }
        return false;
    }

    public void removeAll(List<MRI> attributeDescriptors) {
        for (MRI descriptor : attributeDescriptors) {
            this.remove(descriptor);
        }
    }

    public void exportToXml(Element parentNode) {
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        Set<MRI> enabled = this.getDataProvider().getAttributeDescriptors();
        for (MRI ad : this.m_descriptorList) {
            Element mriElement = XmlSerializerToolkit.exportToXml((MRI)ad, (Element)e);
            XmlToolkit.setSetting((Element)mriElement, (String)XML_ATTRIBUTE_ENABLED, (boolean)enabled.contains(ad));
        }
        XmlToolkit.setSetting((Element)e, (String)XML_LOG_TO_HISTORICAL_DATA, (String)Boolean.toString(this.m_logToHistoricalData));
        this.getChartModel().exportChartModelToXml(e);
    }

    public String getComponentTag() {
        return "chartModel";
    }

    public void initializeFromXml(Element node) throws Exception {
        List attributeNodes = XmlToolkit.getChildElementsByTag((Node)node, (String)"AttributeName");
        for (Element element : attributeNodes) {
            boolean enabled = XmlToolkit.getSetting((Element)element, (String)XML_ATTRIBUTE_ENABLED, (boolean)true);
            this.add(XmlSerializerToolkit.createAttributeDescriptorFromXml((Element)element), enabled);
        }
        this.m_logToHistoricalData = Boolean.valueOf(XmlToolkit.getSetting((Element)node, (String)XML_LOG_TO_HISTORICAL_DATA, (String)Boolean.FALSE.toString()));
        this.getChartModel().initializeChartModelFromXml(node);
        this.setChanged();
        this.notifyObservers();
    }

    public AttributeChartModel getChartModel() {
        return this.m_attributeChartModel;
    }

    private static class ExceptionHandler
    implements IMRIValueListener {
        private final List<ISubscriptionStateListener> m_subscriptionStateListeners = new ArrayList<ISubscriptionStateListener>();

        private ExceptionHandler() {
        }

        public void valueChanged(MRIValueEvent event) {
            if (event instanceof AttributeExceptionEvent || event instanceof AttributeReregisteredEvent || event.getValue() == null) {
                this.notifySubscriptionStateListeners();
            }
        }

        public void addSubscriptionStateListener(ISubscriptionStateListener listener) {
            this.m_subscriptionStateListeners.add(listener);
        }

        public void removeSubscriptionStateListener(ISubscriptionStateListener listener) {
            this.m_subscriptionStateListeners.remove(listener);
        }

        private void notifySubscriptionStateListeners() {
            for (ISubscriptionStateListener iSubscriptionStateListener : this.m_subscriptionStateListeners) {
                iSubscriptionStateListener.onSubscriptionStateChange();
            }
        }
    }

    public static interface ISubscriptionStateListener {
        public void onSubscriptionStateChange();
    }
}

