/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.string.StringToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.ui.misc.IToolTipTextProvider;
import com.jrockit.mc.ui.model.fields.NumberField;

public class AttributeDescriptorToolTipTextProvider
implements IToolTipTextProvider {
    private final IConnectionHandle connectionHandle;

    public AttributeDescriptorToolTipTextProvider(IConnectionHandle connectionHandle) {
        this.connectionHandle = connectionHandle;
    }

    public String getToolTipText(Object obj) {
        return this.getAttributeDescriptorToolTipText((MRI)obj);
    }

    public String getAttributeDescriptorToolTipText(MRI attribute) {
        Object value = null;
        try {
            value = ((ISubscriptionService)this.connectionHandle.getServiceOrDummy(ISubscriptionService.class)).getLastMRIValueEvent(attribute).getValue();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.getAttributeDescriptorToolTipText(attribute, value);
    }

    public String getAttributeDescriptorToolTipText(MRI attribute, Object value) {
        StringBuffer toolTipText = new StringBuffer();
        toolTipText.append(MRIMetaDataToolkit.getDisplayName((IConnectionHandle)this.connectionHandle, (MRI)attribute));
        toolTipText.append(": ");
        if (value instanceof Number) {
            toolTipText.append(NumberField.formatNumber((Number)((Number)value)));
        } else {
            toolTipText.append(StringToolkit.toString((Object)value));
        }
        toolTipText.append(" (");
        if (this.connectionHandle.isConnected()) {
            toolTipText.append(((IMRIMetaDataService)this.connectionHandle.getServiceOrDummy(IMRIMetaDataService.class)).getMetaData(attribute).getValueType());
        } else {
            toolTipText.append(Messages.AttributeDescriptorToolTipTextProvider_ATTRIBUTE_DESCRIPTOR_DISCONNECTED_TYPE);
        }
        toolTipText.append(", ");
        toolTipText.append(MBeanPropertiesOrderer.getAttributePath(attribute));
        toolTipText.append(")");
        return toolTipText.toString();
    }
}

