/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ITimingService;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AttributeChangeEvent;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorToolTipTextProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeDialConfigurationPage;
import com.jrockit.mc.rjmx.ui.internal.AttributeModel;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.IAttributeChangeListener;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.util.internal.XmlSerializerToolkit;
import com.jrockit.mc.ui.dial.DeviceDescriptionFactory;
import com.jrockit.mc.ui.dial.Dial;
import com.jrockit.mc.ui.dial.DialConfiguration;
import com.jrockit.mc.ui.dial.DialFieldInformation;
import com.jrockit.mc.ui.dial.DialInformationViewer;
import com.jrockit.mc.ui.dial.DialViewer;
import com.jrockit.mc.ui.dial.IDeviceDescription;
import com.jrockit.mc.ui.dial.IDialInformationProvider;
import com.jrockit.mc.ui.dial.IDialProvider;
import com.jrockit.mc.ui.dial.MovingDial;
import com.jrockit.mc.ui.dial.WatermarkDial;
import com.jrockit.mc.ui.dial.WatermarkDialFieldInformation;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.IToolTipTextProvider;
import com.jrockit.mc.ui.model.fields.ByteField;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.NormalizedScientificNotationField;
import com.jrockit.mc.ui.model.fields.NumberField;
import com.jrockit.mc.ui.model.fields.PercentageField;
import com.jrockit.mc.ui.model.fields.SecondsField;
import com.jrockit.mc.ui.model.fields.TicksFields;
import com.jrockit.mc.ui.model.fields.TimeSpanField;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Element;

public class AttributeDial
extends Dial {
    public static final String TAG_ATTRIBUTE_DIAL_COMPOSITE = "AttributeDial";
    public static final String KEY_MAX_DIAL = "max";
    public static final String KEY_CURRENT_DIAL = "current";
    private MRI m_attributeDescriptor;
    private DialConfiguration m_dialConfiguration;
    private final IMRIValueListener m_attributeValueListener;
    private final AttributeModel m_attributeModel;
    private final FreezeModel m_freezeModel;
    private final IConnectionHandle m_handle;
    private Set<IAttributeChangeListener> m_attributeChangeListeners;

    public AttributeDial(AttributeModel attributeModel, FreezeModel freezeModel, IConnectionHandle handle) {
        this.m_handle = handle;
        this.m_attributeValueListener = new ValueListener();
        this.m_attributeModel = attributeModel;
        this.m_freezeModel = freezeModel;
    }

    private ISubscriptionService getSubscriptionService() {
        return (ISubscriptionService)this.getConnectionHandle().getServiceOrNull(ISubscriptionService.class);
    }

    private IConnectionHandle getConnectionHandle() {
        return this.m_handle;
    }

    private void reconfigureInfoViewer() {
        DialInformationViewer infoViewer = this.getDialInformationViewer();
        infoViewer.clear();
        infoViewer.addDialInformationProvider(KEY_CURRENT_DIAL, (IDialInformationProvider)new DialFieldInformation(this.createField(Messages.AttributeDialSectionPart_CURRENT_DIAL_VALUE_TEXT, this.m_attributeDescriptor, this.m_dialConfiguration.getValueType())));
        if (this.m_dialConfiguration.getUseWatermark()) {
            this.getDialInformationViewer().addDialInformationProvider(KEY_MAX_DIAL, (IDialInformationProvider)new WatermarkDialFieldInformation(this.createField(Messages.AttributeDialSectionPart_MAX_DIAL_VALUE_TEXT, this.m_attributeDescriptor, this.m_dialConfiguration.getValueType())));
        }
    }

    private void reconfigureDialViewer() {
        DialViewer dialViewer = this.getDialViewer();
        dialViewer.clear();
        dialViewer.addDialProvider(KEY_CURRENT_DIAL, (IDialProvider)new MovingDial());
        if (this.m_dialConfiguration.getUseWatermark()) {
            dialViewer.addDialProvider(KEY_MAX_DIAL, (IDialProvider)new WatermarkDial(this.m_dialConfiguration.getWatermarkColor()));
        }
        dialViewer.setGradientRange(this.m_dialConfiguration.getGradientBeginValue(), this.m_dialConfiguration.getGradientEndValue(), this.m_dialConfiguration.getGradientBeginColor(), this.m_dialConfiguration.getGradientEndColor());
        dialViewer.setDeviceDescription(DeviceDescriptionFactory.getDeviceDescription((String)this.m_dialConfiguration.getValueType(), AttributeDial.createDeviceDescriptions(this.m_handle)));
    }

    public void configureDial(DialConfiguration dialConfiguration, MRI attribute) {
        ISubscriptionService service = this.getSubscriptionService();
        if (service != null) {
            this.setAttribute(attribute, service);
            this.m_dialConfiguration = dialConfiguration;
            this.reconfigureDialViewer();
            this.reconfigureInfoViewer();
            this.getDialViewer().setTitle(dialConfiguration.getTitle());
            MRIValueEvent event = service.getLastMRIValueEvent(this.m_attributeDescriptor);
            if (event != null) {
                this.processSubscriptionEvent(event);
            }
        } else {
            throw new IllegalStateException();
        }
    }

    protected void clearWatermark() {
        WatermarkDial wd = (WatermarkDial)this.getDialViewer().getDialProvider(KEY_MAX_DIAL);
        WatermarkDialFieldInformation wi = (WatermarkDialFieldInformation)this.getDialInformationViewer().getDialInformationProvider(KEY_MAX_DIAL);
        if (wi != null) {
            wi.clearWatermark();
        }
        if (wd != null) {
            wd.clearWatermark();
        }
    }

    public Control createDialControl(Composite parent, FormToolkit formToolkit, IAction ... additionalActions) {
        Composite composite = super.createDialComposite(parent, formToolkit);
        MenuManager menuManager = new MenuManager();
        menuManager.add((IAction)new ClearWatermark());
        IAction[] iActionArray = additionalActions;
        int n = additionalActions.length;
        int n2 = 0;
        while (n2 < n) {
            IAction action = iActionArray[n2];
            menuManager.add(action);
            ++n2;
        }
        menuManager.add((IContributionItem)new Separator());
        menuManager.add((IAction)new PropertiesAction());
        this.getDialViewer().setMenu(menuManager.createContextMenu((Control)this.getDialViewer()));
        this.getDialViewer().setToolTipTextProvider((IToolTipTextProvider)new AttributeDescriptorToolTipTextProvider(this.getConnectionHandle()){

            @Override
            public String getToolTipText(Object obj) {
                return super.getAttributeDescriptorToolTipText(AttributeDial.this.m_attributeDescriptor);
            }
        });
        return composite;
    }

    private void configure() {
        AttributeDialConfigurationPage dp = new AttributeDialConfigurationPage(this.m_handle, this.m_dialConfiguration, this.m_attributeDescriptor, AttributeDial.createDeviceDescriptions(this.m_handle), this.m_attributeModel.getAttributeDescriptors());
        OnePageWizardDialog dialog = new OnePageWizardDialog(this.getDialViewer().getShell(), (IWizardPage)dp);
        dialog.setTitle(Messages.AttributeDialSectionPart_CONFIGURE_DIAL_TITLE_TEXT);
        if (dialog.open() == 0) {
            this.configureDial(dp.getConfiguration(), dp.getAttribute());
        }
    }

    public static List<IDeviceDescription> createDeviceDescriptions(IConnectionHandle handle) {
        ArrayList<IDeviceDescription> list = new ArrayList<IDeviceDescription>(DeviceDescriptionFactory.getDeviceDescriptions());
        IDeviceDescription desc = AttributeDial.createTimespanFromTicksDescription(handle);
        if (desc != null) {
            list.add(desc);
        }
        return list;
    }

    private static IDeviceDescription createTimespanFromTicksDescription(IConnectionHandle handle) {
        ITimingService p;
        block4: {
            p = (ITimingService)handle.getServiceOrDummy(ITimingService.class);
            if (p.isTicksSupported()) break block4;
            return null;
        }
        try {
            return DeviceDescriptionFactory.createTimeSpanBackground((String)"ticks", (double)p.getTicksPerSecond(), (String)Messages.AttributeDialSectionPart_TIME_SPAN_FROM_TICKS_TEXT);
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
        }
        catch (IOException e) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.SEVERE, "Error getting ticks per second", e);
        }
        return null;
    }

    public void exportToXml(Element parentNode) {
        if (this.m_dialConfiguration != null && this.m_attributeDescriptor != null) {
            Element e1 = XmlToolkit.createElement((Element)parentNode, (String)TAG_ATTRIBUTE_DIAL_COMPOSITE);
            this.m_dialConfiguration.exportToXml(e1);
            XmlSerializerToolkit.exportToXml((MRI)this.m_attributeDescriptor, (Element)e1);
        }
    }

    public void initializeSettingsFromXml(Element node) throws Exception {
        Element attributeNode = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)"AttributeName");
        if (attributeNode != null) {
            MRI readAttribute = XmlSerializerToolkit.createAttributeDescriptorFromXml((Element)attributeNode);
            if (!readAttribute.equals((Object)this.getAttribute())) {
                return;
            }
            Element configurationNode = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)"dialConfiguration");
            if (configurationNode != null) {
                DialConfiguration dialConfiguration = new DialConfiguration();
                dialConfiguration.initializeFromXml(configurationNode);
                this.configureDial(dialConfiguration, readAttribute);
            }
        }
    }

    protected void processSubscriptionEvent(final MRIValueEvent event) {
        if (!this.m_freezeModel.isFreezed()) {
            DisplayToolkit.safeAsyncExec((Widget)this.getDialViewer(), (Runnable)new Runnable(){

                @Override
                public void run() {
                    if (event.getValue() instanceof Number) {
                        double value = ((Number)event.getValue()).doubleValue() * AttributeDial.this.m_dialConfiguration.getMultiplier();
                        AttributeDial.this.setInput(value);
                    }
                }
            });
        }
    }

    private void setAttribute(MRI attributeDescriptor, ISubscriptionService service) {
        if (attributeDescriptor != this.m_attributeDescriptor) {
            this.enableNoValueYetVeil(true);
            this.fireAttributeChangedEvent(this.m_attributeDescriptor, attributeDescriptor);
            if (this.m_attributeDescriptor != null) {
                this.m_attributeDescriptor = null;
                service.removeMRIValueListener(this.m_attributeValueListener);
            }
            if (attributeDescriptor != null) {
                this.m_attributeDescriptor = attributeDescriptor;
                service.addMRIValueListener(attributeDescriptor, this.m_attributeValueListener);
            }
        }
    }

    public MRI getAttribute() {
        return this.m_attributeDescriptor;
    }

    public void dispose() {
        if (this.m_attributeDescriptor != null) {
            this.fireAttributeChangedEvent(this.m_attributeDescriptor, null);
            this.m_attributeDescriptor = null;
            ISubscriptionService service = this.getSubscriptionService();
            if (service != null) {
                service.removeMRIValueListener(this.m_attributeValueListener);
            }
        }
        super.dispose();
    }

    public void addAttributeChangeListener(IAttributeChangeListener listener) {
        if (this.m_attributeChangeListeners == null) {
            this.m_attributeChangeListeners = new HashSet<IAttributeChangeListener>();
        }
        this.m_attributeChangeListeners.add(listener);
    }

    public void removeAttributeChangeListener(IAttributeChangeListener listener) {
        this.m_attributeChangeListeners.remove(listener);
    }

    protected void fireAttributeChangedEvent(MRI oldAttribute, MRI newAttribute) {
        if (this.m_attributeChangeListeners != null && !this.m_attributeChangeListeners.isEmpty()) {
            AttributeChangeEvent e = new AttributeChangeEvent((Object)this, oldAttribute, newAttribute);
            for (IAttributeChangeListener listener : this.m_attributeChangeListeners) {
                listener.attributeChanged(e);
            }
        }
    }

    private Field createField(String displayName, MRI descriptor, String type) {
        String unit = AttributeToolkit.getUnitString((IConnectionHandle)this.getConnectionHandle(), (MRI)descriptor);
        Field field = this.createDynamicField(type, unit);
        if (field == null) {
            field = AttributeDial.createStaticField(type, unit);
        }
        field.setName(displayName);
        return field;
    }

    private Field createDynamicField(String type, String unit) {
        if ("ticks".equals(type)) {
            TicksFields ticksField = new TicksFields(0);
            ITimingService p = (ITimingService)this.getConnectionHandle().getServiceOrDummy(ITimingService.class);
            try {
                if (p.isTicksSupported()) {
                    ticksField.setTickPerSecond(p.getTicksPerSecond());
                }
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return ticksField;
        }
        return null;
    }

    private static Field createStaticField(String type, String unit) {
        if ("percentage".equals(type)) {
            return new PercentageField(0);
        }
        if ("time.span.ms".equals(type)) {
            return new TimeSpanField(0);
        }
        if ("time.span.s".equals(type)) {
            return new SecondsField(0);
        }
        if ("small.number".equals(type)) {
            return new NumberField(0);
        }
        if ("scientific.notation".equals(type)) {
            return new NormalizedScientificNotationField(0, 1);
        }
        if ("bytes".equals(type)) {
            return new ByteField(0);
        }
        if ("%".equals(unit)) {
            return new PercentageField(0);
        }
        if ("bytes".equals(unit)) {
            return new ByteField(0);
        }
        return new NormalizedScientificNotationField(0, 1);
    }

    public class ClearWatermark
    extends Action {
        public ClearWatermark() {
            super(Messages.AttributeDialSectionPart_CLEAR_WATERMARK_MENU_TEXT);
        }

        public void run() {
            AttributeDial.this.clearWatermark();
        }

        public boolean isEnabled() {
            return AttributeDial.this.getDialViewer().getDialProvider(AttributeDial.KEY_MAX_DIAL) != null;
        }
    }

    public class PropertiesAction
    extends Action {
        public PropertiesAction() {
            super(Messages.AttributeDialSectionPart_DIAL_PROPETIES_TEXT);
        }

        public void run() {
            AttributeDial.this.configure();
        }
    }

    public class ValueListener
    implements IMRIValueListener {
        public void valueChanged(MRIValueEvent event) {
            AttributeDial.this.processSubscriptionEvent(event);
        }
    }
}

