/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AttributeDial;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorDialog;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.ui.dial.DialConfiguration;
import com.jrockit.mc.ui.dial.DialConfigurationPage;
import com.jrockit.mc.ui.dial.IDeviceDescription;
import com.jrockit.mc.ui.misc.ColorConstants;
import com.jrockit.mc.ui.misc.MCColor;
import java.util.List;
import java.util.logging.Level;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

class AttributeDialConfigurationPage
extends DialConfigurationPage {
    private final IConnectionHandle m_handle;
    private MRI m_attribute;
    private MRI m_currentSelected;
    private final MRI m_originalSelected;
    private MRI[] m_currentAttributes;
    private Text m_attributeText;

    public AttributeDialConfigurationPage(IConnectionHandle handle, DialConfiguration config, MRI attribute, List<IDeviceDescription> deviceDescriptions) {
        super(config, deviceDescriptions);
        this.m_handle = handle;
        this.m_attribute = attribute;
        this.m_currentSelected = attribute;
        this.m_originalSelected = attribute;
    }

    public AttributeDialConfigurationPage(IConnectionHandle handle, DialConfiguration config, MRI attribute, List<IDeviceDescription> deviceDescriptions, MRI[] currentAttributes) {
        this(handle, config, attribute, deviceDescriptions);
        this.m_currentAttributes = currentAttributes;
    }

    public AttributeDialConfigurationPage(IConnectionHandle handle, MRI[] currentAttributes) {
        this(handle, AttributeDialConfigurationPage.createEmptyDialConfiguration(), null, AttributeDial.createDeviceDescriptions(handle), currentAttributes);
    }

    public void createControl(Composite parent) {
        int columns = 3;
        this.createAttributeSelector(parent, columns);
        this.createType(parent, columns);
        this.createTitle(parent, columns);
        this.createMultiplier(parent, columns);
        this.createGradientBegin(parent, columns);
        this.createGradientEnd(parent, columns);
        this.createWatermark(parent, columns);
        this.createColors(parent);
        this.setControl((Control)parent);
        GridLayout layout = new GridLayout(columns, false);
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        parent.setLayout((Layout)layout);
        this.load();
        this.update();
    }

    protected boolean validates() {
        boolean validates = super.validates();
        if (validates) {
            if (this.m_currentSelected == null) {
                this.setMessage(Messages.AttributeDialSectionPart_SELECT_AN_ATTRIVUTE_ERROR_TEXT, 3);
                return false;
            }
            if (this.attributeAlreadySelected()) {
                this.setMessage(Messages.AttributeDialConfigurationPage_ATTRIBUTE_ALREADY_SELECTED_ERROR_TEXT, 3);
                return false;
            }
        }
        return validates;
    }

    private boolean attributeAlreadySelected() {
        if (this.m_currentAttributes != null && !this.m_currentSelected.equals((Object)this.m_originalSelected)) {
            MRI[] mRIArray = this.m_currentAttributes;
            int n = this.m_currentAttributes.length;
            int n2 = 0;
            while (n2 < n) {
                MRI attribute = mRIArray[n2];
                if (this.m_currentSelected.equals((Object)attribute)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    protected void load() {
        super.load();
        this.m_attributeText.setText(AttributeDialConfigurationPage.getAttributeName(this.m_currentSelected));
    }

    protected void store() {
        super.store();
        this.m_attribute = this.m_currentSelected;
    }

    private static String getAttributeName(MRI descriptor) {
        return descriptor == null ? Messages.AttributeDialSectionPart_NO_ATTRIBUTE_SELECTED_TEXT : descriptor.getDataPath();
    }

    private void selectAttribute() {
        MRI[] selection;
        MRI[] mRIArray;
        AttributeSelectorDialog d = new AttributeSelectorDialog(this.getShell(), false, true);
        if (this.m_currentSelected != null) {
            MRI[] mRIArray2 = new MRI[1];
            mRIArray = mRIArray2;
            mRIArray2[0] = this.m_currentSelected;
        } else {
            mRIArray = selection = new MRI[]{};
        }
        MRI[] suggestion = this.m_currentAttributes != null ? this.m_currentAttributes : (this.m_attribute != null ? new MRI[]{this.m_attribute} : new MRI[]{});
        MRI[] selected = d.show(this.m_handle, selection, suggestion);
        if (selected.length > 0 && !selected[0].equals((Object)this.m_currentSelected)) {
            this.m_currentSelected = selected[0];
            DialConfiguration config = AttributeDialConfigurationPage.createDefaultDialConfiguration(this.m_handle, this.m_currentSelected);
            this.getConfiguration().setGradientBeginValue(config.getGradientBeginValue());
            this.getConfiguration().setGradientEndValue(config.getGradientEndValue());
            this.getConfiguration().setMultiplier(config.getMultiplier());
            this.getConfiguration().setTitle(config.getTitle());
            this.getConfiguration().setValueType(config.getValueType());
            this.getConfiguration().setGradientBeginColor(config.getGradientBeginColor());
            this.getConfiguration().setGradientEndColor(config.getGradientEndColor());
            this.getConfiguration().setWatermarkColor(config.getWatermarkColor());
            this.load();
            this.update();
        }
    }

    protected void createAttributeSelector(Composite parent, int columns) {
        GridData gd1 = new GridData(4, 0x1000000, false, false);
        Label label = new Label(parent, 0);
        label.setText(Messages.AttributeDialSectionPart_ATTRIBUTE_NAME_TEXT);
        label.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 0x1000000, true, false);
        gd2.horizontalSpan = 4 - columns;
        this.m_attributeText = new Text(parent, 2056);
        this.m_attributeText.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 0x1000000, false, false);
        Button button = this.createAttributeSelectorButton(parent);
        button.setLayoutData((Object)gd3);
    }

    protected Button createAttributeSelectorButton(Composite parent) {
        Button button = new Button(parent, 0);
        button.setText(Messages.AttributeDialSectionPart_SELECT_ATTRIBUTE_TEXT);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeDialConfigurationPage.this.selectAttribute();
            }
        });
        return button;
    }

    public static DialConfiguration createDefaultDialConfiguration(IConnectionHandle handle, MRI attributeDescriptor) {
        String unitString = AttributeToolkit.getUnitString((IConnectionHandle)handle, (MRI)attributeDescriptor);
        DialConfiguration dc = new DialConfiguration();
        Double d = AttributeToolkit.getMultiplier((IConnectionHandle)handle, (MRI)attributeDescriptor);
        dc.setMultiplier(d == null ? 1.0 : d);
        dc.setTitle(MRIMetaDataToolkit.getDisplayName((IConnectionHandle)handle, (MRI)attributeDescriptor));
        if ("%".equals(unitString)) {
            dc.setGradientBeginValue(0.0);
            dc.setGradientEndValue(1.0);
        }
        dc.setGradientBeginColor(AttributeDialConfigurationPage.getColor(handle, attributeDescriptor, "dial.gradient.begin.color", ColorConstants.DIAL_NO_GRADIENT_COLOR));
        dc.setGradientEndColor(AttributeDialConfigurationPage.getColor(handle, attributeDescriptor, "dial.gradient.end.color", ColorConstants.DIAL_NO_GRADIENT_COLOR));
        dc.setGradientBeginValue(AttributeDialConfigurationPage.getValue(handle, attributeDescriptor, "dial.gradient.begin.value", Double.NEGATIVE_INFINITY));
        dc.setGradientEndValue(AttributeDialConfigurationPage.getValue(handle, attributeDescriptor, "dial.gradient.end.value", Double.NEGATIVE_INFINITY));
        dc.setValueType("small.number");
        dc.setWatermarkColor(ColorConstants.DIAL_STANDARD_COLOR);
        if ("%".equals(unitString)) {
            dc.setValueType("percentage");
        }
        if ("bytes".equals(unitString)) {
            dc.setValueType("bytes");
        }
        if ("ticks".equals(unitString)) {
            dc.setValueType("ticks");
        }
        return dc;
    }

    private static DialConfiguration createEmptyDialConfiguration() {
        DialConfiguration dc = new DialConfiguration();
        dc.setMultiplier(1.0);
        dc.setTitle("");
        dc.setGradientBeginColor(ColorConstants.DIAL_NO_GRADIENT_COLOR);
        dc.setGradientEndColor(ColorConstants.DIAL_NO_GRADIENT_COLOR);
        dc.setGradientBeginValue(Double.NEGATIVE_INFINITY);
        dc.setGradientEndValue(Double.POSITIVE_INFINITY);
        dc.setValueType("small.number");
        dc.setWatermarkColor(ColorConstants.DIAL_STANDARD_COLOR);
        return dc;
    }

    private static Object getMetaData(IConnectionHandle handle, MRI descriptor, String property) {
        return ((IMRIMetaDataService)handle.getServiceOrDummy(IMRIMetaDataService.class)).getMetaData(descriptor, property);
    }

    private static MCColor getColor(IConnectionHandle handle, MRI ad, String property, MCColor defaultColor) {
        MCColor color;
        Object object = AttributeDialConfigurationPage.getMetaData(handle, ad, property);
        if (object instanceof String && (color = MCColor.createFromInternetColorString((String)((String)object))) != null) {
            return color;
        }
        return defaultColor;
    }

    public static double getValue(IConnectionHandle handle, MRI ad, String property, double defaultValue) {
        String stringValue;
        Object object = AttributeDialConfigurationPage.getMetaData(handle, ad, property);
        if (object instanceof String && (stringValue = (String)object).length() != 0) {
            try {
                return Double.parseDouble((String)object);
            }
            catch (NumberFormatException nfe) {
                RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Error parsing meta data value '" + object + "'for property " + property);
            }
        }
        return defaultValue;
    }

    public MRI getAttribute() {
        return this.m_attribute;
    }
}

