/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ITimingService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.IMRIValueListener;
import com.jrockit.mc.rjmx.subscription.ISubscriptionService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.internal.AttributeToolkit;
import com.jrockit.mc.rjmx.subscription.internal.AttributeValueToolkit;
import com.jrockit.mc.rjmx.ui.IAttributeVisualizer;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AbstractAttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorToolTipTextProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorDialog;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.InternalToolkit;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.TableToolTipMouseTrackAdapter;
import com.jrockit.mc.rjmx.util.internal.XmlSerializerToolkit;
import com.jrockit.mc.ui.fields.AbstractFieldTableContentProvider;
import com.jrockit.mc.ui.fields.FieldLabelProvider;
import com.jrockit.mc.ui.fields.FieldToolkit;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.IToolTipTextProvider;
import com.jrockit.mc.ui.model.fields.ByteField;
import com.jrockit.mc.ui.model.fields.Field;
import com.jrockit.mc.ui.model.fields.PercentageField;
import com.jrockit.mc.ui.model.fields.Row;
import com.jrockit.mc.ui.model.fields.StringField;
import com.jrockit.mc.ui.model.fields.TicksFields;
import com.jrockit.mc.ui.model.fields.TimeField;
import com.jrockit.mc.ui.model.fields.TimeSpanField;
import com.jrockit.mc.ui.sections.FieldTableViewerSectionPart;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.logging.Level;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.management.OperationsException;
import javax.management.ReflectionException;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableFontProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeFieldTableSectionPart
extends FieldTableViewerSectionPart
implements IAttributeVisualizer,
XmlEnabled {
    public static final String TAG_ATTRIBUTE_TABLE_SECTION_PART = "AttribubteTableSectionPart";
    public static final String SECTION_TITLE = "AbstractAttributeVisualizerTitle";
    public static final String XML_ATTRIBUTE_SECTION_IDENTIFIER = "sectionIdentifier";
    private static final Field[] FIELD_PROTOTYPES = new Field[]{DashboardProvider.FIELD_ATTRIBUTE_DESCRIPTOR_NAME, DashboardProvider.FIELD_MBEAN_NAME, DashboardProvider.FIELD_ATTRIBUTE_NAME, DashboardProvider.FIELD_LAST_ATTRIBUTE_VALUE, DashboardProvider.FIELD_ATTRIBUTE_UNIT, DashboardProvider.FIELD_TIMESTAMP};
    private static final String DIALOG_SET_VALUE_DEFAULT_VALUE = "";
    private Dashboard m_attributeDescriptorModel;
    private IConnectionHandle m_connectionHandle;

    public AttributeFieldTableSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier, FIELD_PROTOTYPES, RJMXUIPlugin.getDefault().getMCDialogSettings());
    }

    @Override
    public boolean add(MRI attributeDescriptor) {
        return this.getModel().add(attributeDescriptor);
    }

    @Override
    public boolean remove(MRI attributeDescriptor) {
        return this.getModel().remove(attributeDescriptor);
    }

    @Override
    public List<MRI> getAttributeDescriptors() {
        ArrayList<MRI> list = new ArrayList<MRI>();
        for (DashboardEntry de : this.getModel().getDashboardEntries()) {
            list.add(de.descriptor);
        }
        return list;
    }

    @Override
    public Control getControl() {
        return this.getSection();
    }

    public void dispose() {
        this.getModel().clear();
        super.dispose();
    }

    protected Composite createRightControl(Composite parent) {
        FormToolkit toolkit = this.getFormToolkit();
        Composite buttonContainer = toolkit.createComposite(parent);
        GridData gd1 = new GridData(4, 4, false, false);
        Button addButton = this.createAddButton(toolkit, buttonContainer);
        addButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, false, false);
        Button removeButton = this.createRemoveButton(toolkit, buttonContainer);
        removeButton.setLayoutData((Object)gd2);
        GridData gd3 = new GridData(4, 4, false, false);
        Button setButton = this.createSetButton(toolkit, buttonContainer);
        setButton.setLayoutData((Object)gd3);
        GridLayout layout = new GridLayout(1, true);
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        return buttonContainer;
    }

    private Button createSetButton(FormToolkit toolkit, Composite parent) {
        final AttributeValueFactory factory = new AttributeValueFactory();
        final Button button = toolkit.createButton(parent, Messages.AttributeTableSectionPart_BUTTON_SET_VALUE_TEXT, 0);
        button.setLayoutData((Object)new GridData(4, 1, true, false));
        button.setEnabled(false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)AttributeFieldTableSectionPart.this.getTableViewer().getSelection();
                if (selection.size() == 1) {
                    DashboardEntry entry = (DashboardEntry)selection.getFirstElement();
                    Object value = AttributeFieldTableSectionPart.this.askUserForAttributeValue(button.getShell(), entry);
                    if (value != null) {
                        AttributeFieldTableSectionPart.this.setAttributeValue(AttributeFieldTableSectionPart.this.m_connectionHandle, entry.descriptor, value);
                    }
                }
            }
        });
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection.size() == 1) {
                    DashboardEntry entry = (DashboardEntry)selection.getFirstElement();
                    button.setEnabled(MRIMetaDataToolkit.isWritable((IMRIMetaDataProvider)entry.info) && factory.getSupporedTypes().contains(entry.info.getValueType()));
                }
            }
        });
        return button;
    }

    private Button createRemoveButton(FormToolkit toolkit, Composite parent) {
        Button button = toolkit.createButton(parent, Messages.AttributeTableSectionPart_BUTTON_REMOVE_TEXT, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection sel = (IStructuredSelection)AttributeFieldTableSectionPart.this.getTableViewer().getSelection();
                if (!sel.isEmpty()) {
                    Iterator it = sel.iterator();
                    while (it.hasNext()) {
                        AttributeFieldTableSectionPart.this.remove(((DashboardEntry)it.next()).descriptor);
                    }
                    AttributeFieldTableSectionPart.this.refreshViewer();
                }
            }
        });
        return button;
    }

    private void add(MRI[] descriptors) {
        IMRIMetaDataService attributeInfoService = (IMRIMetaDataService)this.getConnectionHandle().getServiceOrDummy(IMRIMetaDataService.class);
        ArrayList<MRI> addList = new ArrayList<MRI>(Arrays.asList(descriptors));
        int i = 0;
        while (i < addList.size()) {
            IMRIMetaData info = addList.get(i) instanceof IMRIMetaData ? (IMRIMetaData)addList.get(i) : attributeInfoService.getMetaData(addList.get(i));
            if (MRIMetaDataToolkit.isComposite((IMRIMetaDataProvider)info)) {
                IMRIMetaData[] children = MRIMetaDataToolkit.getCompositeChildren((IConnectionHandle)this.getConnectionHandle(), (IMRIMetaData)info);
                addList.addAll(Arrays.asList(children));
            } else {
                this.add(info.getMRI());
            }
            ++i;
        }
    }

    private Button createAddButton(FormToolkit toolkit, final Composite parent) {
        Button button = toolkit.createButton(parent, Messages.AttributeTableSectionPart_BUTTON_ADD_TEXT, 0);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeSelectorDialog dialog = new AttributeSelectorDialog(parent.getShell(), true, false);
                MRI[] current = AttributeFieldTableSectionPart.this.getAttributeDescriptors().toArray(new MRI[AttributeFieldTableSectionPart.this.getAttributeDescriptors().size()]);
                MRI[] selectedAttributes = dialog.show(AttributeFieldTableSectionPart.this.getConnectionHandle(), new MRI[0], current);
                if (selectedAttributes.length > 0) {
                    AttributeFieldTableSectionPart.this.add(selectedAttributes);
                    AttributeFieldTableSectionPart.this.refreshViewer();
                }
            }
        });
        return button;
    }

    protected Object askUserForAttributeValue(Shell shell, DashboardEntry entry) {
        AttributeValueFactory valueFactory;
        InputDialog dialog;
        String unitString = AttributeToolkit.getUnitString((IConnectionHandle)this.getConnectionHandle(), (MRI)entry.info.getMRI());
        String enterText = unitString != null ? NLS.bind((String)Messages.AttributeTableSectionPart_MESSAGE_ENTER_VALUE_FOR_ATTRIBUTE_WITH_UNIT_PART, (Object[])new Object[]{entry.info.getMRI().getDataPath(), entry.info.getValueType(), unitString}) : NLS.bind((String)Messages.AttributeTableSectionPart_MESSAGE_ENTER_VALUE_FOR_ATTRIBUTE, (Object)entry.info.getMRI().getDataPath(), (Object)entry.info.getValueType());
        String defaultValueString = DIALOG_SET_VALUE_DEFAULT_VALUE;
        if (entry.lastValueEvent != null && entry.lastValueEvent.getValue() != null) {
            defaultValueString = String.valueOf(entry.lastValueEvent.getValue());
        }
        if ((dialog = new InputDialog(shell, Messages.AttributeTableSectionPart_DIALOG_SET_VALUE_TITLE, enterText, defaultValueString, new IInputValidator(valueFactory = new AttributeValueFactory(), entry){
            private final /* synthetic */ AttributeValueFactory val$valueFactory;
            private final /* synthetic */ DashboardEntry val$entry;
            {
                this.val$valueFactory = attributeValueFactory;
                this.val$entry = dashboardEntry;
            }

            public String isValid(String newText) {
                if (this.val$valueFactory.create(this.val$entry.info.getValueType(), newText) != null) {
                    return null;
                }
                return NLS.bind((String)Messages.AttributeTableSectionPart_MESSAGE_INVALID_TYPE, (Object)this.val$entry.info.getValueType());
            }
        })).open() == 0 && dialog.getValue() != null) {
            return valueFactory.create(entry.info.getValueType(), dialog.getValue());
        }
        return null;
    }

    private void setAttributeValue(IConnectionHandle connectionHandle, MRI descriptor, Object value) {
        try {
            AttributeValueToolkit.setAttribute((MBeanServerConnection)((MBeanServerConnection)connectionHandle.getServiceOrDummy(MBeanServerConnection.class)), (MRI)descriptor, (Object)value);
        }
        catch (OperationsException ex) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.AttributeTableSectionPart_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)ex);
        }
        catch (MBeanException ex) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.AttributeTableSectionPart_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)ex);
        }
        catch (ReflectionException ex) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.AttributeTableSectionPart_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)ex);
        }
        catch (IOException ex) {
            DialogToolkit.showExceptionDialogAsync((Display)Display.getDefault(), (String)Messages.AttributeTableSectionPart_ERROR_MESSAGE_PROBLEM_SETTING_ATTRIBUTE, (Throwable)ex);
        }
    }

    public boolean setFormInput(Object input) {
        if (input instanceof IConnectionHandle) {
            this.m_connectionHandle = (IConnectionHandle)input;
            return true;
        }
        return false;
    }

    protected final IConnectionHandle getConnectionHandle() {
        return this.m_connectionHandle;
    }

    protected void initializeSection(Section section) {
    }

    protected final Dashboard getModel() {
        if (this.m_attributeDescriptorModel == null) {
            this.m_attributeDescriptorModel = new Dashboard(this.getConnectionHandle());
        }
        return this.m_attributeDescriptorModel;
    }

    protected Composite createTopControl(Composite container) {
        return null;
    }

    public void initializePart() {
        super.initializePart();
        if (!this.getConnectionHandle().isConnected()) {
            return;
        }
        GraphSettingRegistry grr = (GraphSettingRegistry)this.getConnectionHandle().getServiceOrNull(GraphSettingRegistry.class);
        this.getTableViewer().setContentProvider((IContentProvider)new DashboardProvider(this.getConnectionHandle()));
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider(this.getFields(), this.getTableViewer().getTable(), this.getConnectionHandle(), grr));
        this.getTableViewer().getTable().addMouseTrackListener((MouseTrackListener)new TableToolTipMouseTrackAdapter(this.getTableViewer().getTable(), new IToolTipTextProvider(){
            private final IToolTipTextProvider attributeToolTipTextProvider;
            {
                this.attributeToolTipTextProvider = new AttributeDescriptorToolTipTextProvider(AttributeFieldTableSectionPart.this.getConnectionHandle());
            }

            public String getToolTipText(Object obj) {
                return this.attributeToolTipTextProvider.getToolTipText((Object)((DashboardEntry)((Row)obj).getElement()).descriptor);
            }
        }));
        this.getTableViewer().setInput((Object)this.getModel());
        this.getModel().addObserver(new ViewerRefresher((Viewer)this.getTableViewer()));
    }

    public void refreshPart() {
        super.refreshPart();
        if (this.isStale()) {
            this.refreshViewer();
        }
    }

    protected void refreshViewer() {
        this.getTableViewer().refresh();
    }

    public void exportToXml(Element parentNode) {
        MRI[] plottedSubscriptionAttributes;
        Element e = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        XmlToolkit.setSetting((Element)e, (String)SECTION_TITLE, (String)this.getSection().getText());
        XmlToolkit.setSetting((Element)e, (String)XML_ATTRIBUTE_SECTION_IDENTIFIER, (String)this.getSectionIdentifier());
        MRI[] mRIArray = plottedSubscriptionAttributes = this.getAttributeDescriptors().toArray(new MRI[this.getAttributeDescriptors().size()]);
        int n = plottedSubscriptionAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            MRI plottedSubscriptionAttribute = mRIArray[n2];
            XmlSerializerToolkit.exportToXml((MRI)plottedSubscriptionAttribute, (Element)e);
            ++n2;
        }
    }

    public void initializeFromXml(Element node) throws MalformedObjectNameException {
        this.getSection().setText(XmlToolkit.getSetting((Element)node, (String)SECTION_TITLE, (String)DIALOG_SET_VALUE_DEFAULT_VALUE));
        this.setSectionIdentifier(XmlToolkit.getSetting((Element)node, (String)XML_ATTRIBUTE_SECTION_IDENTIFIER, (String)"unknown"));
        this.setHelpContextID(this.getSectionIdentifier());
        List attributeNodes = XmlToolkit.getChildElementsByTag((Node)node, (String)"AttributeName");
        for (Element element : attributeNodes) {
            this.add(XmlSerializerToolkit.createAttributeDescriptorFromXml((Element)element));
        }
    }

    public String getComponentTag() {
        return TAG_ATTRIBUTE_TABLE_SECTION_PART;
    }

    @Override
    public void clear() {
        for (MRI mri : this.getAttributeDescriptors()) {
            this.remove(mri);
        }
    }

    @Override
    public Object getProperty(String key) {
        if (key.equals("title")) {
            return this.getSection().getText();
        }
        return null;
    }

    @Override
    public boolean setProperty(String key, Object value) {
        if (key.equals("title")) {
            if (value instanceof String) {
                this.getSection().setText((String)value);
                this.getSection().layout(true, true);
                return true;
            }
            throw new IllegalArgumentException("Property " + key + " must be a string");
        }
        return InternalToolkit.unsupportedKey(key);
    }

    static final class AttributeEventValueField
    extends Field {
        private static final TimeSpanField TIME_SPAN_FIELD = new TimeSpanField(0);
        private static final TimeField TIME_FIELD = new TimeField(0);
        private static final ByteField BYTE_FIELD = new ByteField(0);
        private static final PercentageField PERCENTAGE_FIELD = new PercentageField(0);
        private static final TicksFields TICKS_FIELD = new TicksFields(0);

        public AttributeEventValueField(int id) {
            super(id);
            this.setFilterable(false);
        }

        public String formatObject(Object object) {
            if (object != null) {
                Field field;
                Double factor;
                MRIValueEvent ave = (MRIValueEvent)object;
                Object theValue = ave.getValue();
                String unitString = AttributeToolkit.getUnitString((IConnectionHandle)ave.getConnectionHandle(), (MRI)ave.getSubscriptionAttribute());
                if (theValue instanceof Number && (factor = AttributeToolkit.getMultiplier((IConnectionHandle)ave.getConnectionHandle(), (MRI)ave.getSubscriptionAttribute())) != null) {
                    double d = ((Number)theValue).doubleValue() * factor;
                    theValue = d;
                }
                if (theValue != null && (field = this.getFieldForUnitString(ave.getConnectionHandle(), unitString)) != null) {
                    return field.formatObject(theValue);
                }
                return super.formatObject((Object)String.valueOf(theValue));
            }
            return super.formatObject(null);
        }

        public String formatForClipboard(Object object) {
            if (object != null) {
                Field field;
                MRIValueEvent ave = (MRIValueEvent)object;
                String unitString = AttributeToolkit.getUnitString((IConnectionHandle)ave.getConnectionHandle(), (MRI)ave.getSubscriptionAttribute());
                Object value = ave.getValue();
                if (value != null && (field = this.getFieldForUnitString(ave.getConnectionHandle(), unitString)) != null) {
                    return field.formatForClipboard(value);
                }
                return AttributeEventValueField.defaultFormat((Object)value);
            }
            return AttributeEventValueField.defaultFormat(null);
        }

        private Field getFieldForUnitString(IConnectionHandle handle, String unitString) {
            if ("bytes".equals(unitString)) {
                return BYTE_FIELD;
            }
            if ("ms".equals(unitString)) {
                return TIME_SPAN_FIELD;
            }
            if ("%".equals(unitString)) {
                return PERCENTAGE_FIELD;
            }
            if ("date".equals(unitString)) {
                return TIME_FIELD;
            }
            if ("ticks".equals(unitString)) {
                this.initializeTicksPersecond(handle);
                return TICKS_FIELD;
            }
            return null;
        }

        private void initializeTicksPersecond(IConnectionHandle handle) {
            if (Double.isNaN(TICKS_FIELD.getTicksPerSecond())) {
                try {
                    ITimingService op = (ITimingService)handle.getServiceOrDummy(ITimingService.class);
                    TICKS_FIELD.setTickPerSecond(op.getTicksPerSecond());
                }
                catch (UnsupportedOperationException e) {
                    TICKS_FIELD.setTickPerSecond(Double.NEGATIVE_INFINITY);
                }
                catch (IOException e) {
                    RJMXUIPlugin.getDefault().getLogger().log(Level.SEVERE, "Problem getting ticks/seconds", e);
                }
            }
        }
    }

    protected static final class AttributeLabelProvider
    extends FieldLabelProvider
    implements ITableFontProvider,
    ITableColorProvider {
        private final IConnectionHandle m_connectionHandle;
        private final GraphSettingRegistry m_registry;
        private final AbstractAttributeLabelProvider m_oldSchool;

        public AttributeLabelProvider(Field[] fields, Table table, IConnectionHandle service, GraphSettingRegistry registry) {
            super(fields);
            this.m_connectionHandle = service;
            this.m_registry = registry;
            this.m_oldSchool = new AbstractAttributeLabelProvider(table, this.m_connectionHandle);
        }

        protected MRI getDescriptor(Object element) {
            return ((DashboardEntry)((Row)element).getElement()).descriptor;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex != 0) {
                return null;
            }
            ISubscriptionService service = (ISubscriptionService)this.m_connectionHandle.getServiceOrNull(ISubscriptionService.class);
            if (service != null) {
                MRI descriptor = this.getDescriptor(element);
                if (!this.m_connectionHandle.isConnected() || service.isMRIUnavailable(descriptor)) {
                    return GraphSettingRegistry.getGreyedOutColorThumbnail();
                }
                return this.m_registry.getColorThumbnail(descriptor);
            }
            return null;
        }

        public Font getFont(Object element, int columnIndex) {
            return this.m_oldSchool.getFont(this.getDescriptor(element), columnIndex);
        }

        public Color getBackground(Object element, int columnIndex) {
            return this.m_oldSchool.getBackground(this.getDescriptor(element), columnIndex);
        }

        public Color getForeground(Object element, int columnIndex) {
            return this.m_oldSchool.getForeground(this.getDescriptor(element), columnIndex);
        }
    }

    public static final class AttributeValueFactory {
        private final Map<String, Class<?>> m_supportedTypes = new HashMap();

        public AttributeValueFactory() {
            this.m_supportedTypes.put(Byte.TYPE.getName(), Byte.class);
            this.m_supportedTypes.put(Boolean.TYPE.getName(), Boolean.class);
            this.m_supportedTypes.put(Short.TYPE.getName(), Short.class);
            this.m_supportedTypes.put(Integer.TYPE.getName(), Integer.class);
            this.m_supportedTypes.put(Long.TYPE.getName(), Long.class);
            this.m_supportedTypes.put(Float.TYPE.getName(), Float.class);
            this.m_supportedTypes.put(Double.TYPE.getName(), Double.class);
            this.m_supportedTypes.put(Byte.class.getName(), Byte.class);
            this.m_supportedTypes.put(Boolean.class.getName(), Boolean.class);
            this.m_supportedTypes.put(Short.class.getName(), Short.class);
            this.m_supportedTypes.put(Integer.class.getName(), Integer.class);
            this.m_supportedTypes.put(Long.class.getName(), Long.class);
            this.m_supportedTypes.put(Float.class.getName(), Float.class);
            this.m_supportedTypes.put(Double.class.getName(), Double.class);
            this.m_supportedTypes.put(String.class.getName(), String.class);
        }

        public Object create(String type, String dataValue) {
            try {
                if (this.m_supportedTypes.containsKey(type)) {
                    Class<?> attributeClass = this.m_supportedTypes.get(type);
                    Class[] stringParam = new Class[]{String.class};
                    Constructor<?> c = attributeClass.getConstructor(stringParam);
                    return c.newInstance(dataValue);
                }
            }
            catch (RuntimeException re) {
                throw new RuntimeException(re);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        public Collection<String> getSupporedTypes() {
            return this.m_supportedTypes.keySet();
        }
    }

    public static final class Dashboard
    extends Observable {
        private final IMRIMetaDataService m_infoService;
        private final ISubscriptionService m_subscriptionService;
        private final IMRIValueListener m_valueListener;
        private final Map<MRI, DashboardEntry> m_entries = new LinkedHashMap<MRI, DashboardEntry>();

        public Dashboard(IConnectionHandle handle) {
            this.m_infoService = (IMRIMetaDataService)handle.getServiceOrDummy(IMRIMetaDataService.class);
            this.m_subscriptionService = (ISubscriptionService)handle.getServiceOrDummy(ISubscriptionService.class);
            this.m_valueListener = new IMRIValueListener(){

                public void valueChanged(MRIValueEvent event) {
                    if (Dashboard.this.update(event)) {
                        Dashboard.this.setChanged();
                        Dashboard.this.notifyObservers();
                    }
                }
            };
        }

        public synchronized List<DashboardEntry> getDashboardEntries() {
            return Collections.unmodifiableList(new ArrayList<DashboardEntry>(this.m_entries.values()));
        }

        public synchronized boolean add(MRI attributeDescriptor) {
            if (!this.m_entries.containsKey(attributeDescriptor)) {
                this.m_entries.put(attributeDescriptor, this.createDashboardEntry(attributeDescriptor));
                this.m_subscriptionService.addMRIValueListener(attributeDescriptor, this.m_valueListener);
                return true;
            }
            return false;
        }

        public synchronized boolean remove(MRI attributeDescriptor) {
            if (this.m_entries.containsKey(attributeDescriptor)) {
                this.m_entries.remove(attributeDescriptor);
                this.m_subscriptionService.removeMRIValueListener(attributeDescriptor, this.m_valueListener);
                return true;
            }
            return false;
        }

        public synchronized void clear() {
            MRI[] desc;
            MRI[] mRIArray = desc = this.m_entries.keySet().toArray(new MRI[this.m_entries.size()]);
            int n = desc.length;
            int n2 = 0;
            while (n2 < n) {
                MRI element = mRIArray[n2];
                this.remove(element);
                ++n2;
            }
        }

        private synchronized boolean update(MRIValueEvent event) {
            DashboardEntry entry = this.m_entries.get(event.getSubscriptionAttribute());
            if (entry != null) {
                entry.lastValueEvent = event;
                return true;
            }
            return false;
        }

        private DashboardEntry createDashboardEntry(MRI descriptor) {
            IMRIMetaData info = this.m_infoService.getMetaData(descriptor);
            MRIValueEvent event = this.m_subscriptionService.getLastMRIValueEvent(descriptor);
            return new DashboardEntry(descriptor, info, event);
        }
    }

    public static final class DashboardEntry {
        public final MRI descriptor;
        public final IMRIMetaData info;
        public volatile MRIValueEvent lastValueEvent;
        public long timeStamp;

        public DashboardEntry(MRI descriptor, IMRIMetaData info, MRIValueEvent event) {
            assert (descriptor != null);
            assert (info != null);
            this.info = info;
            this.descriptor = descriptor;
            this.lastValueEvent = event;
        }
    }

    public static final class DashboardProvider
    extends AbstractFieldTableContentProvider {
        public static final int FIELD_COUNT;
        public static final Field FIELD_ATTRIBUTE_DESCRIPTOR_NAME;
        public static final Field FIELD_LAST_ATTRIBUTE_VALUE;
        public static final Field FIELD_TIMESTAMP;
        public static final Field FIELD_ATTRIBUTE_NAME;
        public static final Field FIELD_ATTRIBUTE_UNIT;
        public static final Field FIELD_MBEAN_NAME;
        private final IConnectionHandle m_connectionHandler;

        static {
            int fieldCount = 0;
            FIELD_ATTRIBUTE_DESCRIPTOR_NAME = new StringField(fieldCount++);
            FIELD_LAST_ATTRIBUTE_VALUE = new AttributeEventValueField(fieldCount++);
            FIELD_TIMESTAMP = new TimeField(fieldCount++);
            FIELD_ATTRIBUTE_NAME = new StringField(fieldCount++);
            FIELD_ATTRIBUTE_UNIT = new StringField(fieldCount++);
            FIELD_MBEAN_NAME = new StringField(fieldCount++);
            FIELD_COUNT = fieldCount;
            FieldToolkit.initializeFields((String)"com.jrockit.mc.rjmx.ui.internal.fields", DashboardProvider.class);
            FIELD_ATTRIBUTE_DESCRIPTOR_NAME.setMinWidth(100);
            FIELD_ATTRIBUTE_DESCRIPTOR_NAME.setWidthWeight(188);
            FIELD_ATTRIBUTE_DESCRIPTOR_NAME.setVisible(true);
            FIELD_LAST_ATTRIBUTE_VALUE.setMinWidth(100);
            FIELD_LAST_ATTRIBUTE_VALUE.setWidthWeight(300);
            FIELD_LAST_ATTRIBUTE_VALUE.setVisible(true);
            FIELD_TIMESTAMP.setVisible(false);
            FIELD_TIMESTAMP.setMinWidth(100);
            FIELD_TIMESTAMP.setWidthWeight(188);
            FIELD_ATTRIBUTE_NAME.setVisible(false);
            FIELD_ATTRIBUTE_NAME.setMinWidth(100);
            FIELD_ATTRIBUTE_NAME.setWidthWeight(188);
            FIELD_ATTRIBUTE_UNIT.setVisible(false);
            FIELD_ATTRIBUTE_UNIT.setMinWidth(100);
            FIELD_ATTRIBUTE_UNIT.setWidthWeight(188);
            FIELD_MBEAN_NAME.setVisible(false);
            FIELD_MBEAN_NAME.setMinWidth(200);
            FIELD_MBEAN_NAME.setWidthWeight(188);
        }

        public DashboardProvider(IConnectionHandle handle) {
            this.m_connectionHandler = handle;
        }

        public Object[] getColumnObject(Object inputRowElement) {
            DashboardEntry entry = (DashboardEntry)inputRowElement;
            IMRIMetaData info = entry.info;
            ObjectName name = info.getMRI().getObjectName();
            Object[] result = new Object[FIELD_COUNT];
            result[DashboardProvider.FIELD_ATTRIBUTE_DESCRIPTOR_NAME.INDEX] = MRIMetaDataToolkit.getDisplayName((IConnectionHandle)this.m_connectionHandler, (MRI)info.getMRI());
            result[DashboardProvider.FIELD_ATTRIBUTE_NAME.INDEX] = info.getMRI().getDataPath();
            result[DashboardProvider.FIELD_MBEAN_NAME.INDEX] = name == null ? null : name.toString();
            result[DashboardProvider.FIELD_LAST_ATTRIBUTE_VALUE.INDEX] = entry.lastValueEvent;
            result[DashboardProvider.FIELD_ATTRIBUTE_UNIT.INDEX] = AttributeToolkit.getUnitString((IConnectionHandle)this.m_connectionHandler, (MRI)info.getMRI());
            if (entry.lastValueEvent != null) {
                result[DashboardProvider.FIELD_TIMESTAMP.INDEX] = entry.lastValueEvent.getTimestamp();
            }
            return result;
        }

        public Object[] getRowElements(Object inputElement) {
            if (inputElement instanceof Dashboard) {
                Dashboard model = (Dashboard)inputElement;
                return model.getDashboardEntries().toArray();
            }
            return new Object[0];
        }
    }

    private final class ViewerRefresher
    implements Observer {
        private static final int MAX_WAIT_FOR_CONSECUTIVE_UPDATES = 333;
        private volatile boolean m_aboutToUpdate = false;
        private final Viewer m_viewer;

        public ViewerRefresher(Viewer viewer) {
            this.m_viewer = viewer;
        }

        @Override
        public void update(Observable o, Object arg) {
            if (!this.m_aboutToUpdate) {
                this.m_aboutToUpdate = true;
                DisplayToolkit.safeAsyncExec((Widget)this.m_viewer.getControl(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        DisplayToolkit.safeTimerExec((Widget)ViewerRefresher.this.m_viewer.getControl(), (int)333, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ViewerRefresher.this.m_aboutToUpdate = false;
                                AttributeFieldTableSectionPart.this.refreshViewer();
                            }
                        });
                    }
                });
            }
        }
    }
}

