/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeLabelProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;

class AttributeLabelProvider
implements ITableLabelProvider {
    private final ILabelProvider providerDelegate;
    private final GraphSettingRegistry graphSettingRegistry;

    public AttributeLabelProvider(TreeViewer viewer, GraphSettingRegistry graphSettingRegistry) {
        this.providerDelegate = new MBeanTreeLabelProvider(viewer);
        this.graphSettingRegistry = graphSettingRegistry;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        Object data = ((ITreeNode)element).getUserData();
        if (columnIndex == 0) {
            return this.providerDelegate.getImage(element);
        }
        if (columnIndex == 2 && data instanceof IMRIMetaData) {
            return this.graphSettingRegistry.getColorThumbnail(((IMRIMetaData)data).getMRI());
        }
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof IMRIMetaData) {
            IMRIMetaData info = (IMRIMetaData)data;
            if (columnIndex == 0) {
                String dataPath = info.getMRI().getDataPath();
                return dataPath.substring(dataPath.lastIndexOf(47) + 1);
            }
            if (columnIndex == 1 && MRIMetaDataToolkit.isNumerical((IMRIMetaData)info)) {
                return this.graphSettingRegistry.getMultiplier(info.getMRI()).toString();
            }
            if (columnIndex == 2) {
                return null;
            }
        } else if (columnIndex == 0) {
            return this.providerDelegate.getText(element);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

