/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlEnabled;
import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.internal.AttributeModelEvent;
import com.jrockit.mc.rjmx.ui.internal.IAttributeModelListener;
import com.jrockit.mc.rjmx.util.internal.XmlSerializerToolkit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

class AttributeModel
implements XmlEnabled {
    private static final String TAG_ATTRIBUTE_MODEL = "AttributeModel";
    private IConnectionHandle m_connectionHandle;
    private IMRIMetaDataService m_attributeInfoService;
    private final List<MRI> m_attributes = new ArrayList<MRI>();
    private final List<IAttributeModelListener> m_listeners = Collections.synchronizedList(new ArrayList());

    public void setConnectionHandle(IConnectionHandle connectionHandle) {
        this.m_connectionHandle = connectionHandle;
        this.m_attributeInfoService = (IMRIMetaDataService)this.m_connectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
    }

    public void clear() {
        while (!this.m_attributes.isEmpty()) {
            this.remove(this.m_attributes.get(0));
        }
    }

    public boolean add(MRI mri) {
        return this.add(mri, true);
    }

    public boolean add(MRI attribute, boolean enabled) {
        if (attribute == null) {
            throw new NullPointerException("You may not add null attributes to an AttributeModel!");
        }
        if (this.m_attributes.contains(attribute)) {
            return false;
        }
        IMRIMetaData info = this.m_attributeInfoService.getMetaData(attribute);
        if (MRIMetaDataToolkit.isComposite((IMRIMetaDataProvider)info)) {
            boolean res = false;
            IMRIMetaData[] iMRIMetaDataArray = MRIMetaDataToolkit.getCompositeChildren((IConnectionHandle)this.m_connectionHandle, (IMRIMetaData)info);
            int n = iMRIMetaDataArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMRIMetaData child = iMRIMetaDataArray[n2];
                res |= this.add(child.getMRI(), enabled);
                ++n2;
            }
            return res;
        }
        if (this.m_attributes.add(attribute)) {
            AttributeModelEvent event = AttributeModelEvent.createAddEvent(this, attribute);
            for (IAttributeModelListener listener : this.m_listeners) {
                listener.attributeAdded(event, enabled);
            }
            return true;
        }
        return false;
    }

    public boolean remove(MRI attribute) {
        if (this.m_attributes.remove(attribute)) {
            AttributeModelEvent event = AttributeModelEvent.createRemoveEvent(this, attribute);
            for (IAttributeModelListener listener : this.m_listeners) {
                listener.attributeRemoved(event);
            }
            return true;
        }
        return false;
    }

    public boolean change(MRI fromAttribute, MRI toAttribute) {
        if (this.m_attributes.contains(fromAttribute) && !this.m_attributes.contains(toAttribute)) {
            int index = this.m_attributes.indexOf(fromAttribute);
            this.m_attributes.remove(index);
            this.m_attributes.add(index, toAttribute);
            AttributeModelEvent event = AttributeModelEvent.createChangeEvent(this, fromAttribute, toAttribute);
            for (IAttributeModelListener listener : this.m_listeners) {
                listener.attributeChanged(event);
            }
            return true;
        }
        return false;
    }

    public MRI[] getAttributeDescriptors() {
        return this.m_attributes.toArray(new MRI[this.m_attributes.size()]);
    }

    public boolean contains(MRI attribute) {
        return this.m_attributes.contains(attribute);
    }

    public void addAttributeModelListener(IAttributeModelListener listener) {
        this.m_listeners.add(listener);
    }

    public void removeAttributeModelListener(IAttributeModelListener listener) {
        this.m_listeners.remove(listener);
    }

    public void exportToXml(Element parentNode) {
        Element node = XmlToolkit.createElement((Element)parentNode, (String)this.getComponentTag());
        for (MRI attribute : this.m_attributes) {
            XmlSerializerToolkit.exportToXml((MRI)attribute, (Element)node);
        }
    }

    public String getComponentTag() {
        return TAG_ATTRIBUTE_MODEL;
    }

    public void initializeFromXml(Element node) throws Exception {
        List attributeNodes = XmlToolkit.getChildElementsByTag((Node)node, (String)"AttributeName");
        for (Element e : attributeNodes) {
            this.add(XmlSerializerToolkit.createAttributeDescriptorFromXml((Element)e));
        }
    }
}

