/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeRefreshJob;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeSorter;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.fields.FilterMatcher;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;

public class AttributeSelectorComponent
extends Composite {
    private static Color filterColorForeground = UIPlugin.getDefault().getFontColorToolkit().getFilterForegroundColor();
    private static Color filterColorBackground = UIPlugin.getDefault().getFontColorToolkit().getFilterBackgroundColor();
    private TreeViewer mbeanTreeViewer;
    private MBeanTreeRefreshJob mbeanTreeRefreshJob;
    private final List<MRI> selectedAttributes;
    private final boolean multiSelectionAllowed;
    private final boolean showNumericalsOnly;
    private final ListenerList selectionChangedListeners;
    private String filterText;

    public AttributeSelectorComponent(Composite parent, int style, boolean multiSelection, boolean numericalsOnly) {
        super(parent, style);
        this.multiSelectionAllowed = multiSelection;
        this.showNumericalsOnly = numericalsOnly;
        this.selectedAttributes = new ArrayList<MRI>();
        this.selectionChangedListeners = new ListenerList();
        this.initComponent();
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add((Object)listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove((Object)listener);
    }

    protected void fireSelectionChanged(final SelectionChangedEvent event) {
        Object[] objectArray = this.selectionChangedListeners.getListeners();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            final ISelectionChangedListener l = (ISelectionChangedListener)listener;
            SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

                public void run() {
                    l.selectionChanged(event);
                }
            });
            ++n2;
        }
    }

    public MRI[] getSelection() {
        return this.selectedAttributes.toArray(new MRI[this.selectedAttributes.size()]);
    }

    public void setInput(IConnectionHandle handle, MRI[] selection, MRI[] expansion) {
        this.mbeanTreeViewer.setInput((Object)handle);
        this.expandNodes(this.getAttibuteInfosFromAttributeDescriptors(handle, expansion));
        IMRIMetaData[] selectionMetaData = this.getAttibuteInfosFromAttributeDescriptors(handle, selection);
        this.expandNodes(selectionMetaData);
        this.selectNodes(selectionMetaData);
    }

    private IMRIMetaData[] getAttibuteInfosFromAttributeDescriptors(IConnectionHandle connectionHandle, MRI[] descriptors) {
        if (descriptors == null || descriptors.length == 0) {
            return new IMRIMetaData[0];
        }
        IMRIMetaDataService attributeInfoService = (IMRIMetaDataService)connectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
        IMRIMetaData[] infos = new IMRIMetaData[descriptors.length];
        int i = 0;
        while (i < descriptors.length) {
            infos[i] = attributeInfoService.getMetaData(descriptors[i]);
            ++i;
        }
        return infos;
    }

    protected int getTreeStyle() {
        int style = 2048;
        style = this.multiSelectionAllowed ? (style |= 2) : (style |= 4);
        return style;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, this.getTreeStyle());
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new MBeanTreeContentProvider(viewer, false));
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanTreeLabelProvider(viewer));
        return viewer;
    }

    private void initComponent() {
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        this.setLayout((Layout)layout);
        Composite filterAreaComposite = new Composite((Composite)this, 0);
        GridLayout filterLayout = new GridLayout(2, false);
        filterLayout.marginWidth = 0;
        filterLayout.marginHeight = 0;
        filterAreaComposite.setLayout((Layout)filterLayout);
        filterAreaComposite.setLayoutData((Object)new GridData(4, 128, true, false));
        Label filterLabel = new Label(filterAreaComposite, 0);
        filterLabel.setText(Messages.AttributeSelectorDialog_LABEL_FILTER_TEXT);
        filterLabel.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        final Text filterText = new Text(filterAreaComposite, 2048);
        filterText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!filterText.isDisposed()) {
                    String text = filterText.getText();
                    if (text != null && text.length() > 0) {
                        filterText.setForeground(filterColorForeground);
                        filterText.setBackground(filterColorBackground);
                        AttributeSelectorComponent.this.setFilterText(text);
                    } else {
                        filterText.setBackground(null);
                        filterText.setForeground(null);
                        AttributeSelectorComponent.this.setFilterText(null);
                    }
                }
            }
        });
        this.mbeanTreeViewer = this.createTreeViewer(this);
        this.mbeanTreeViewer.setUseHashlookup(true);
        this.mbeanTreeRefreshJob = new MBeanTreeRefreshJob(this.mbeanTreeViewer);
        this.mbeanTreeViewer.setSorter((ViewerSorter)new MBeanTreeSorter());
        this.mbeanTreeViewer.addFilter((ViewerFilter)new AttributeTreeFilter(this.showNumericalsOnly));
        this.mbeanTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                AttributeSelectorComponent.this.selectedAttributes.clear();
                Iterator iter = ((IStructuredSelection)event.getSelection()).iterator();
                while (iter.hasNext()) {
                    Object selectedElement = ((ITreeNode)iter.next()).getUserData();
                    if (!(selectedElement instanceof IMRIMetaData)) continue;
                    IMRIMetaData metaData = (IMRIMetaData)selectedElement;
                    if (!AttributeSelectorComponent.this.multiSelectionAllowed && MRIMetaDataToolkit.isComposite((IMRIMetaDataProvider)metaData)) continue;
                    AttributeSelectorComponent.this.selectedAttributes.add(metaData.getMRI());
                }
                AttributeSelectorComponent.this.fireSelectionChanged(new SelectionChangedEvent((ISelectionProvider)AttributeSelectorComponent.this.mbeanTreeViewer, (ISelection)new StructuredSelection((Object[])AttributeSelectorComponent.this.getSelection())));
            }
        });
        this.mbeanTreeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                Object element = selection.getFirstElement();
                AttributeSelectorComponent.this.mbeanTreeViewer.setExpandedState(element, !AttributeSelectorComponent.this.mbeanTreeViewer.getExpandedState(element));
            }
        });
        this.mbeanTreeViewer.getTree().setLayoutData((Object)new GridData(1808));
    }

    private void setFilterText(String text) {
        this.mbeanTreeRefreshJob.cancel();
        if (text == null || text.length() == 0) {
            this.filterText = null;
        } else {
            this.filterText = text.toLowerCase();
            this.filterText = FilterMatcher.autoAddKleene((String)this.filterText, (FilterMatcher.Where)FilterMatcher.Where.AFTER);
        }
        this.mbeanTreeRefreshJob.schedule(600L);
    }

    private void expandNodes(IMRIMetaData[] attributes) {
        if (attributes == null || attributes.length == 0) {
            return;
        }
        MBeanTreeContentProvider contentProvider = (MBeanTreeContentProvider)this.mbeanTreeViewer.getContentProvider();
        IMRIMetaData[] iMRIMetaDataArray = attributes;
        int n = attributes.length;
        int n2 = 0;
        while (n2 < n) {
            IMRIMetaData attribute = iMRIMetaDataArray[n2];
            ITreeNode node = contentProvider.findNode(attribute);
            if (node != null) {
                this.mbeanTreeViewer.expandToLevel((Object)node, 0);
            }
            ++n2;
        }
    }

    private void selectNodes(IMRIMetaData[] selected) {
        if (selected == null || selected.length == 0) {
            return;
        }
        MBeanTreeContentProvider contentProvider = (MBeanTreeContentProvider)this.mbeanTreeViewer.getContentProvider();
        ArrayList<TreePath> paths = new ArrayList<TreePath>();
        IMRIMetaData[] iMRIMetaDataArray = selected;
        int n = selected.length;
        int n2 = 0;
        while (n2 < n) {
            IMRIMetaData element = iMRIMetaDataArray[n2];
            ITreeNode node = contentProvider.findNode(element);
            if (node != null) {
                LinkedList<ITreeNode> path = new LinkedList<ITreeNode>();
                while (node != null) {
                    path.addFirst(node);
                    node = node.getParent();
                }
                paths.add(new TreePath(path.toArray()));
            }
            ++n2;
        }
        this.mbeanTreeViewer.setSelection((ISelection)new TreeSelection(paths.toArray(new TreePath[paths.size()])));
    }

    private boolean matchesFilterText(String stringToTest) {
        if (this.filterText != null) {
            return FilterMatcher.getInstance().match(stringToTest.toLowerCase(), this.filterText);
        }
        return true;
    }

    class AttributeTreeFilter
    extends ViewerFilter {
        private final boolean showOnlyNumericalAttributes;

        public AttributeTreeFilter(boolean onlyNumericals) {
            this.showOnlyNumericalAttributes = onlyNumericals;
        }

        public boolean select(Viewer viewer, Object parentElement, Object element) {
            block6: {
                ITreeNode[] children;
                ITreeNode node;
                block5: {
                    ITableLabelProvider tableLabelProvider;
                    node = (ITreeNode)element;
                    if (!(node.getUserData() instanceof IMRIMetaData)) break block5;
                    IMRIMetaData info = (IMRIMetaData)node.getUserData();
                    if (this.showOnlyNumericalAttributes && !MRIMetaDataToolkit.isNumerical((IMRIMetaData)info) && !MRIMetaDataToolkit.isComposite((IMRIMetaDataProvider)info)) {
                        return false;
                    }
                    IBaseLabelProvider baseLabelProvider = AttributeSelectorComponent.this.mbeanTreeViewer.getLabelProvider();
                    ILabelProvider labelProvider = baseLabelProvider instanceof ILabelProvider ? (ILabelProvider)baseLabelProvider : null;
                    ITableLabelProvider iTableLabelProvider = tableLabelProvider = baseLabelProvider instanceof ITableLabelProvider ? (ITableLabelProvider)baseLabelProvider : null;
                    if (tableLabelProvider == null && labelProvider == null) break block6;
                    while (node != null) {
                        String nodeText;
                        String string = labelProvider != null ? labelProvider.getText((Object)node) : (nodeText = tableLabelProvider != null ? tableLabelProvider.getColumnText((Object)node, 0) : "");
                        if (AttributeSelectorComponent.this.matchesFilterText(nodeText)) {
                            return true;
                        }
                        node = node.getParent();
                    }
                    break block6;
                }
                ITreeNode[] iTreeNodeArray = children = node.getChildren();
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    ITreeNode element2 = iTreeNodeArray[n2];
                    if (this.select(viewer, element, element2)) {
                        return true;
                    }
                    ++n2;
                }
            }
            return false;
        }
    }
}

