/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorComponent;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.ui.dialogs.MCTitleAreaDialog;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;

public class AttributeSelectorDialog
extends MCTitleAreaDialog {
    private final boolean multiSelectionAllowed;
    private final boolean showNumericalsOnly;
    private AttributeSelectorComponent selectorComponent;

    public AttributeSelectorDialog(Shell parentShell, boolean multiSelection, boolean numericalsOnly) {
        super(parentShell);
        this.multiSelectionAllowed = multiSelection;
        this.showNumericalsOnly = numericalsOnly;
        this.setTitleImage(RJMXUIPlugin.getDefault().getImage("attribute-browser-wiz.gif"));
    }

    public MRI[] show(IConnectionHandle connectionHandle, MRI[] selected, MRI[] expanded) {
        if (connectionHandle.isConnected()) {
            this.create();
            this.getButton(0).setEnabled(false);
            this.selectorComponent.setInput(connectionHandle, selected, expanded);
            DisplayToolkit.placeDialogInCenter((Shell)this.getParentShell(), (Shell)this.getShell());
            if (this.open() == 0) {
                return this.selectorComponent.getSelection();
            }
        }
        return new MRI[0];
    }

    protected Control createContents(Composite parent) {
        this.getShell().setText(Messages.AttributeSelectorDialog_SELECT_ATTRIOBUTE_DIALOG_TITLE);
        Control contents = super.createContents(parent);
        contents.getShell().setSize(620, 500);
        contents.getShell().setImage(RJMXUIPlugin.getDefault().getImage("non-numerical-attribute-16.png"));
        this.setMessage(Messages.AttributeSelectorDialog_MESSAGE);
        this.setTitle(Messages.AttributeSelectorDialog_TEXT);
        return contents;
    }

    protected int getTreeStyle() {
        int style = 2048;
        style = this.multiSelectionAllowed ? (style |= 2) : (style |= 4);
        return style;
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, this.getTreeStyle());
        TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new MBeanTreeContentProvider(viewer, false));
        viewer.setLabelProvider((IBaseLabelProvider)new MBeanTreeLabelProvider(viewer));
        return viewer;
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        dialogArea.setLayout((Layout)new GridLayout());
        this.selectorComponent = new AttributeSelectorComponent(dialogArea, 0, this.multiSelectionAllowed, this.showNumericalsOnly);
        this.selectorComponent.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MRI[] attributes = AttributeSelectorDialog.this.selectorComponent.getSelection();
                AttributeSelectorDialog.this.getButton(0).setEnabled(attributes != null && attributes.length > 0);
            }
        });
        this.selectorComponent.setLayoutData(new GridData(4, 4, true, true));
        DisplayToolkit.placeDialogInCenter((Shell)this.getParentShell(), (Shell)this.getShell());
        return dialogArea;
    }
}

