/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.util.TimeRange;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.services.ITimingService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.internal.AbstractAttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorToolTipTextProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeLabelProvider;
import com.jrockit.mc.rjmx.ui.internal.AttributeSelectorDialog;
import com.jrockit.mc.rjmx.ui.internal.ChartComposite;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.ui.dial.RefreshController;
import com.jrockit.mc.ui.misc.DialogToolkit;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.misc.TreeLayout;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.TreeEditor;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.widgets.FormToolkit;
import se.hirt.greychart.TickDensity;

public class AttributeSubscriptionChart
extends ChartComposite {
    private MenuItem logToHistoricalDataItem;
    private IConnectionHandle connectionHandle;
    private AttributeDescriptorModel attributeDescriptorModel;
    private Observer observer;
    private AttributeDescriptorModel.ISubscriptionStateListener stateListener;
    private RefreshController m_refreshController;

    public AttributeSubscriptionChart(Composite parent, int style, FormToolkit toolkit, AttributeDescriptorModel model, final IConnectionHandle connectionHandle, final FreezeModel freezeModel) {
        super(parent, style, toolkit, model.getChartModel(), freezeModel, new ChartComposite.IChartDataToolTipTextProvider(connectionHandle){
            private final AttributeDescriptorToolTipTextProvider toolTipTextProvider;
            {
                this.toolTipTextProvider = new AttributeDescriptorToolTipTextProvider(iConnectionHandle);
            }

            @Override
            public String getToolTipText(String seriesName, Number value, MRI attribute) {
                return this.toolTipTextProvider.getAttributeDescriptorToolTipText(attribute, value);
            }
        });
        this.connectionHandle = connectionHandle;
        this.attributeDescriptorModel = model;
        this.getTableViewer().setLabelProvider((IBaseLabelProvider)new AbstractAttributeLabelProvider(this.getTableViewer().getTable(), connectionHandle){

            @Override
            public String getColumnText(Object element, int columnIndex) {
                return MRIMetaDataToolkit.getDisplayName((IConnectionHandle)this.getConnectionHandle(), (MRI)((MRI)element));
            }

            @Override
            public Image getColumnImage(Object element, int columnIndex) {
                MRI descriptor = (MRI)element;
                if (this.getAttributeSubscriptionService().isMRIUnavailable(descriptor)) {
                    return GraphSettingRegistry.getGreyedOutColorThumbnail();
                }
                return AttributeSubscriptionChart.this.getGraphSettingsRegistry().getColorThumbnail(descriptor);
            }

            @Override
            public void addListener(ILabelProviderListener listener) {
            }

            @Override
            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            @Override
            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.observer = new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                AttributeSubscriptionChart.this.logToHistoricalDataItem.setSelection(AttributeSubscriptionChart.this.attributeDescriptorModel.getPersistenceEnabled());
            }
        };
        this.attributeDescriptorModel.addObserver(this.observer);
        this.stateListener = new AttributeDescriptorModel.ISubscriptionStateListener(){

            @Override
            public void onSubscriptionStateChange() {
                DisplayToolkit.safeAsyncExec((Widget)AttributeSubscriptionChart.this.getTableViewer().getTable(), (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AttributeSubscriptionChart.this.getTableViewer().refresh();
                    }
                });
            }
        };
        this.attributeDescriptorModel.addSubscriptionStateListener(this.stateListener);
        this.m_refreshController = new RefreshController(this.getDisplay());
        this.m_refreshController.add(new IRefreshable(){

            public boolean refresh() {
                if (!freezeModel.isFreezed() && connectionHandle.isConnected()) {
                    long now = AttributeSubscriptionChart.this.getServerTime() * 1000L * 1000L;
                    AttributeSubscriptionChart.this.setRange(new TimeRange(now - AttributeSubscriptionChart.this.getWorldWidth(), now));
                    AttributeSubscriptionChart.this.refreshChartIFNoticable();
                }
                AttributeSubscriptionChart.this.setZoomEnablement();
                return true;
            }
        });
        this.m_refreshController.start();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                AttributeSubscriptionChart.this.m_refreshController.stop();
            }
        });
        this.setAxisDensity(TickDensity.NORMAL);
        this.showLast(60000000000L);
    }

    protected boolean isUpdateNoticable() {
        if (this.getDeviceWidth() == this.getLastDeviceWidth() && this.getLastDeviceWidth() != 0) {
            long now = this.getServerTime() * 1000L * 1000L;
            long timePassed = now - this.getLastMax();
            return timePassed > 2000000000L;
        }
        return true;
    }

    private void refreshChartIFNoticable() {
        if (this.isUpdateNoticable()) {
            this.refreshChart();
        }
    }

    @Override
    protected void createShowMenu(Menu parent) {
        Menu showAllMenu = new Menu(parent);
        MenuItem showAll = new MenuItem(parent, 64);
        showAll.setText(Messages.ChartComposite_SHOW_MENU_TEXT);
        showAll.setMenu(showAllMenu);
        this.createLastMenuItem(showAllMenu, Messages.ChartComposite_SHOW_LAST_15_SECONDS, 15000000000L);
        this.createLastMenuItem(showAllMenu, Messages.ChartComposite_SHOW_LAST_MINUTE, 60000000000L);
        this.createLastMenuItem(showAllMenu, Messages.ChartComposite_SHOW_LAST_10_MINUTES, 600000000000L);
        this.createLastMenuItem(showAllMenu, Messages.ChartComposite_SHOW_LAST_HOUR, 3600000000000L);
        this.createLastMenuItem(showAllMenu, Messages.ChartComposite_SHOW_LAST_DAY, 86400000000000L);
        this.createLastMenuItem(showAllMenu, Messages.ChartComposite_SHOW_LAST_WEEK, 604800000000000L);
    }

    private void createLastMenuItem(Menu parent, String label, final long nanoSeconds) {
        MenuItem item = new MenuItem(parent, 0);
        item.setText(label);
        item.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AttributeSubscriptionChart.this.showLast(nanoSeconds);
            }
        });
    }

    protected void showLast(long nanoSeconds) {
        this.setWorldWidth(nanoSeconds);
        long end = this.getServerTime() * 1000L * 1000L;
        long start = end - nanoSeconds;
        this.setRange(new TimeRange(start, end));
        this.refreshChart();
        this.getFreezeModel().setFreezed(false);
    }

    public long getServerTime() {
        return ((ITimingService)this.connectionHandle.getServiceOrDummy(ITimingService.class)).getApproximateServerTime();
    }

    @Override
    public void addMenuItems(Menu popupMenu) {
        super.addMenuItems(popupMenu);
        this.logToHistoricalDataItem = new MenuItem(popupMenu, 32);
        this.logToHistoricalDataItem.setText(Messages.AttributeSubscriptionChart_MENU_ITEM_LOG_TO_HISTORICAL_DATA_TEXT);
        this.logToHistoricalDataItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (AttributeSubscriptionChart.this.logToHistoricalDataItem.getEnabled()) {
                        if (AttributeSubscriptionChart.this.logToHistoricalDataItem.getSelection()) {
                            AttributeSubscriptionChart.this.attributeDescriptorModel.startPersistence();
                        } else {
                            AttributeSubscriptionChart.this.attributeDescriptorModel.stopPersistence();
                        }
                        AttributeSubscriptionChart.this.attributeDescriptorModel.notifyObservers();
                    }
                }
                catch (Exception e1) {
                    DialogToolkit.showException((Shell)AttributeSubscriptionChart.this.getShell(), (String)Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_ERROR_TEXT, (String)Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_IO_ERROR_MESSAGE, (Throwable)e1);
                    DialogToolkit.showError((Shell)AttributeSubscriptionChart.this.getShell(), (String)Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_ERROR_TEXT, (String)Messages.ChartSectionPart_DIALOG_HISTORICAL_DATA_LOGGING_MULTIPLE_EDITORS_ERROR_MESSAGE);
                }
            }
        });
    }

    @Override
    protected void addButtonPressed() {
        AttributeSelectorDialog dialog = new AttributeSelectorDialog(null, true, true){

            @Override
            protected TreeViewer createTreeViewer(Composite parent) {
                final Tree tree = new Tree(parent, this.getTreeStyle() | 0x10000);
                final TreeViewer viewer = new TreeViewer(tree);
                tree.setHeaderVisible(true);
                TreeLayout layout = new TreeLayout();
                TreeColumn column = new TreeColumn(tree, 16384);
                column.setText(Messages.ChartSectionPart_ATTRIBUTE_SELECTOR_NAME_COLUMN);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(70, 50, true));
                column = new TreeColumn(tree, 0x1000000);
                column.setText(Messages.ChartSectionPart_ATTRIBUTE_SELECTOR_MULTIPLIER_COLUMN);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 20, true));
                column = new TreeColumn(tree, 0x1000000);
                column.setText(Messages.ChartSectionPart_ATTRIBUTE_SELECTOR_COLOR_COLUMN);
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(15, 15, true));
                tree.setLayout((Layout)layout);
                viewer.setContentProvider((IContentProvider)new MBeanTreeContentProvider(viewer, false));
                viewer.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider(viewer, AttributeSubscriptionChart.this.getGraphSettingsRegistry()));
                final TreeEditor editor = new TreeEditor(tree);
                editor.horizontalAlignment = 16384;
                editor.grabHorizontal = true;
                editor.minimumWidth = 50;
                tree.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseDown(MouseEvent e) {
                        TreeItem item;
                        if (e.button != 1 || (e.stateMask & SWT.MOD4) != 0) {
                            return;
                        }
                        Control oldEditor = editor.getEditor();
                        if (oldEditor != null) {
                            oldEditor.dispose();
                        }
                        if ((item = tree.getItem(new Point(e.x, e.y))) == null || !(item.getData() instanceof IMRIMetaData)) {
                            return;
                        }
                        int columnNum = 0;
                        if (item.getBounds(1).contains(e.x, e.y)) {
                            columnNum = 1;
                        } else if (item.getBounds(2).contains(e.x, e.y)) {
                            columnNum = 2;
                        } else {
                            return;
                        }
                        final Button newEditor = new Button((Composite)tree, 0);
                        final int editedColumn = columnNum;
                        newEditor.setText(Messages.ChartSectionPart_EDIT_TEXT);
                        newEditor.addSelectionListener((SelectionListener)new SelectionAdapter(){

                            public void widgetSelected(SelectionEvent e) {
                                IMRIMetaData info = (IMRIMetaData)item.getData();
                                if (editedColumn == 1) {
                                    AttributeSubscriptionChart.this.editMultiplier(info.getMRI(), AttributeSubscriptionChart.this.getGraphSettingsRegistry());
                                } else {
                                    AttributeSubscriptionChart.this.editColor(info.getMRI(), AttributeSubscriptionChart.this.getGraphSettingsRegistry());
                                }
                                newEditor.dispose();
                                viewer.refresh();
                            }
                        });
                        newEditor.setFocus();
                        editor.setEditor((Control)newEditor, item, columnNum);
                    }
                });
                return viewer;
            }

            protected void okPressed() {
                AttributeSubscriptionChart.this.getGraphSettingsRegistry().commit();
                AttributeSubscriptionChart.this.updateMultipliersAndPaints();
                super.okPressed();
            }
        };
        MRI[] selectedAttributes = dialog.show(this.connectionHandle, new MRI[0], this.attributeDescriptorModel.createAttributeDescriptorArray());
        this.getGraphSettingsRegistry().rollback();
        if (selectedAttributes.length > 0) {
            IMRIMetaDataService attributeInfoService = (IMRIMetaDataService)this.connectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
            ArrayList<MRI> addList = new ArrayList<MRI>(Arrays.asList(selectedAttributes));
            int i = 0;
            while (i < addList.size()) {
                MRI object = addList.get(i);
                IMRIMetaData info = object instanceof IMRIMetaData ? (IMRIMetaData)object : attributeInfoService.getMetaData(object);
                if (MRIMetaDataToolkit.isNumerical((IMRIMetaData)info)) {
                    this.attributeDescriptorModel.add(info.getMRI(), true);
                } else if (MRIMetaDataToolkit.isComposite((IMRIMetaDataProvider)info)) {
                    IMRIMetaData[] children = MRIMetaDataToolkit.getCompositeChildren((IConnectionHandle)this.connectionHandle, (IMRIMetaData)info);
                    addList.addAll(Arrays.asList(children));
                }
                ++i;
            }
            if (this.attributeDescriptorModel.hasChanged()) {
                this.attributeDescriptorModel.notifyObservers();
            }
        }
    }

    @Override
    protected void removeButtonPressed() {
        this.attributeDescriptorModel.removeAll(this.getSelectedAttributes());
        this.attributeDescriptorModel.notifyObservers();
    }
}

