/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.util.TimeRange;
import com.jrockit.mc.rjmx.RJMXPlugin;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import com.jrockit.mc.rjmx.subscription.storage.internal.AbstractAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageEventType;
import com.jrockit.mc.rjmx.subscription.storage.internal.AttributeStorageHandle;
import com.jrockit.mc.rjmx.subscription.storage.internal.BufferingAttributeStorage;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageListener;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageService;
import com.jrockit.mc.rjmx.ui.internal.AttributeDataSeries;
import com.jrockit.mc.rjmx.ui.internal.ChartComposite;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.IAttributeDataSeriesProvider;
import com.jrockit.mc.ui.misc.DisplayToolkit;
import java.awt.Color;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.Widget;
import se.hirt.greychart.YAxis;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DataSeriesDescriptor;
import se.hirt.greychart.data.ITimestampedData;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;
import se.hirt.greychart.impl.DefaultXYGreyChart;
import se.hirt.greychart.impl.DefaultYAxis;
import se.hirt.greychart.impl.TimestampedDataProvider;

public class AttributeXYDataProvider
extends TimestampedDataProvider
implements IAttributeDataSeriesProvider<ITimestampedData> {
    private final IAttributeStorageService m_storageService;
    private final IAttributeStorageListener m_storageListener;
    private final Map<MRI, AttributeStorageHandle> m_attributeHandles;
    private DefaultXYGreyChart m_chart;
    private GraphSettingRegistry m_registry;
    private ChartComposite m_chartComposite;
    private TimeRange m_range;

    public AttributeXYDataProvider(IAttributeStorageService storageService) {
        this.m_storageService = storageService;
        this.m_storageListener = new IAttributeStorageListener(){

            public void storageUpdated(AttributeStorageEventType type, MRIValueEvent event) {
                long eventTimestampNanos = event.getTimestamp() * 1000L * 1000L;
                if (AttributeXYDataProvider.this.m_range == null) {
                    AttributeXYDataProvider.this.m_range = new TimeRange(eventTimestampNanos, eventTimestampNanos);
                } else {
                    AttributeXYDataProvider.this.m_range = AttributeXYDataProvider.this.m_range.createExpanded(eventTimestampNanos);
                }
                DisplayToolkit.safeAsyncExec((Widget)AttributeXYDataProvider.this.m_chartComposite, (Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AttributeXYDataProvider.this.m_chartComposite.refreshChart();
                    }
                });
            }
        };
        this.m_attributeHandles = new HashMap<MRI, AttributeStorageHandle>();
    }

    public AttributeDataSeries getDataSeries(MRI attributeDescriptor) {
        DataSeries[] dataSeriesArray = this.getDataSeries();
        int n = dataSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSeries ds = dataSeriesArray[n2];
            AttributeDataSeries atd = (AttributeDataSeries)ds;
            if (atd.getAttributeDescriptor().equals((Object)attributeDescriptor)) {
                return atd;
            }
            ++n2;
        }
        return null;
    }

    public void setChart(ChartComposite c) {
        this.m_chartComposite = c;
    }

    public void setGreyChart(DefaultXYGreyChart chart) {
        this.m_chart = chart;
    }

    public void setGraphSettingsRegistry(GraphSettingRegistry reg) {
        this.m_registry = reg;
    }

    @Override
    public MRI getAttributeDescriptor(DataSeries<ITimestampedData> s) {
        return ((AttributeDataSeries)s).getAttributeDescriptor();
    }

    public Set<MRI> getAttributeDescriptors() {
        HashSet<MRI> mris = new HashSet<MRI>();
        DataSeries[] dataSeriesArray = this.getDataSeries();
        int n = dataSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSeries ds = dataSeriesArray[n2];
            AttributeDataSeries atd = (AttributeDataSeries)ds;
            mris.add(atd.getAttributeDescriptor());
            ++n2;
        }
        return mris;
    }

    public long getMaxX() {
        return this.m_range.getStartTimestamp();
    }

    public long getMinX() {
        return this.m_range.getEndTimestamp();
    }

    @Override
    public void setRange(TimeRange tr) {
        this.m_range = tr;
    }

    DataSeriesDescriptor createDescriptor(Color color, MRI descriptor) {
        DefaultDataSeriesDescriptor dsd = new DefaultDataSeriesDescriptor();
        dsd.setLineColor(color);
        dsd.setDrawLine(true);
        dsd.setName(descriptor.getDataPath());
        dsd.setYAxis(this.getFirstLeftAxis());
        dsd.setMode(this.m_chartComposite.getChartModel().getRenderingMode());
        return dsd;
    }

    private DefaultYAxis getFirstLeftAxis() {
        YAxis[] yAxis;
        YAxis[] yAxisArray = yAxis = this.m_chart.getYAxis();
        int n = yAxis.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis y = yAxisArray[n2];
            if (((DefaultYAxis)y).getPosition() == YAxis.Position.LEFT) {
                return (DefaultYAxis)y;
            }
            ++n2;
        }
        return (DefaultYAxis)yAxis[0];
    }

    public void addSubscriptionAttribute(MRI attributeDescriptor, boolean enabled) {
        if (!this.hasAttributeDescriptor(attributeDescriptor)) {
            AttributeStorageHandle storageHandle = this.getStorage(attributeDescriptor);
            if (storageHandle == null) {
                BufferingAttributeStorage attributeStorage = new BufferingAttributeStorage(RJMXPlugin.getDefault().getMaxAttributeValuesPerChart());
                this.getStorageService().setAttributeStorage(attributeDescriptor, (AbstractAttributeStorage)attributeStorage);
                storageHandle = this.getStorage(attributeDescriptor);
            }
            storageHandle.setStorageListener(this.m_storageListener);
            this.m_attributeHandles.put(attributeDescriptor, storageHandle);
            this.setEnabled(attributeDescriptor, enabled);
        }
    }

    private boolean hasAttributeDescriptor(MRI attributeDescriptor) {
        return this.getDataSeries(attributeDescriptor) != null;
    }

    private AttributeStorageHandle getStorage(MRI attributeDescriptor) {
        return this.getStorageService().getAttributeStorage(attributeDescriptor);
    }

    private IAttributeStorageService getStorageService() {
        return this.m_storageService;
    }

    public void removeSubscriptionAttribute(MRI attributeDescriptor) {
        this.setEnabled(attributeDescriptor, false);
        AttributeStorageHandle handle = this.m_attributeHandles.remove(attributeDescriptor);
        handle.dispose();
    }

    @Override
    public void setEnabled(MRI attributeDescriptor, boolean enable) {
        AttributeDataSeries ds = this.getDataSeries(attributeDescriptor);
        if (enable && ds == null) {
            ds = new AttributeDataSeries(this.getStorageService(), attributeDescriptor);
            this.addDataSeries(ds);
            Color c = this.m_registry.getAWTColor(attributeDescriptor);
            this.m_chart.setDescriptor((DataSeries)ds, this.createDescriptor(c, attributeDescriptor));
        } else if (!enable && ds != null) {
            this.removeDataSeries(ds);
            this.m_chart.removeDescriptor((DataSeries)ds);
            ds.dispose();
        }
    }

    @Override
    public void setMultiplier(MRI attributeDescriptor, Double multiplier) {
        AttributeDataSeries ds = this.getDataSeries(attributeDescriptor);
        if (ds != null) {
            ds.setMultiplier(multiplier);
        }
    }

    @Override
    public TimeRange getRange() {
        return this.m_range;
    }
}

