/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.util.TimeRange;
import com.jrockit.mc.greychart.ui.model.TickDensityName;
import com.jrockit.mc.greychart.ui.views.ChartCanvas;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AntiAliasingListener;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.IAttributeDataSeriesProvider;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.rjmx.ui.internal.TableToolTipMouseTrackAdapter;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.accessibility.AccessibilityConstants;
import com.jrockit.mc.ui.accessibility.FocusTracker;
import com.jrockit.mc.ui.accessibility.MCAccessibleListener;
import com.jrockit.mc.ui.misc.IToolTipTextProvider;
import com.jrockit.mc.ui.model.fields.ByteField;
import com.jrockit.mc.ui.model.fields.Field;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JComponent;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.accessibility.AccessibleListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import se.hirt.greychart.ChartRenderer;
import se.hirt.greychart.GreyChart;
import se.hirt.greychart.JChartComponent;
import se.hirt.greychart.SelectionRenderer;
import se.hirt.greychart.TickDensity;
import se.hirt.greychart.TickFormatter;
import se.hirt.greychart.XAxis;
import se.hirt.greychart.YAxis;
import se.hirt.greychart.data.DataSeries;
import se.hirt.greychart.data.DataSeriesDescriptor;
import se.hirt.greychart.data.DefaultXYData;
import se.hirt.greychart.data.ITimestampedData;
import se.hirt.greychart.data.IXYData;
import se.hirt.greychart.impl.DefaultDataSeriesDescriptor;
import se.hirt.greychart.impl.DefaultXYGreyChart;
import se.hirt.greychart.impl.DefaultXYLineRenderer;
import se.hirt.greychart.impl.DefaultYAxis;
import se.hirt.greychart.impl.DoubleFormatter;
import se.hirt.greychart.impl.EmptyTitleRenderer;
import se.hirt.greychart.impl.IntFormatter;
import se.hirt.greychart.impl.NanosXAxis;
import se.hirt.greychart.impl.OptimizingProvider;
import se.hirt.greychart.impl.SamplePoint;
import se.hirt.greychart.impl.TimestampFormatter;

public abstract class ChartComposite
extends Composite
implements ICheckStateListener {
    protected static final long ONE_SECOND = 1000000000L;
    protected static final long ONE_MINUTE = 60000000000L;
    protected static final long ONE_HOUR = 3600000000000L;
    protected static final long ONE_DAY = 86400000000000L;
    protected static final long ONE_WEEK = 604800000000000L;
    protected static final long ONE_YEAR = 31622400000000000L;
    protected static final long MINIMUM_ZOOM_IN_LEVEL_SECONDS = 1000000000L;
    private static final double ZOOM_FACTOR_MENU_OUT = 2.0;
    private static final double ZOOM_FACTOR_MENU_IN = 0.5;
    private static final double ZOOM_FACTOR_WHEEL_OUT = 1.25;
    private static final double ZOOM_FACTOR_WHEEL_IN = 0.8;
    private static final double ZOOM_MIDDLE = 0.5;
    private ChartCanvas chartCanvas;
    private CheckboxTableViewer attributesTableViewer;
    private Button addAttributeButton;
    private Button removeAttributeButton;
    private MenuItem zoomInItem;
    private MenuItem zoomOutItem;
    private AntiAliasingListener antialiasingListener;
    private final AttributeChartModel m_chartModel;
    private final FreezeModel m_freezeModel;
    private final JChartComponent m_chartPanel;
    private final IChartDataToolTipTextProvider m_chartDataToolTipTextProvider;
    private DefaultXYGreyChart<ITimestampedData> m_chart;
    private long m_lastMax = Long.MAX_VALUE;
    private int m_lastDeviceWidth;
    private long m_worldWidth;

    public ChartComposite(Composite parent, int style, FormToolkit toolkit, AttributeChartModel model, FreezeModel freezeModel, IChartDataToolTipTextProvider chartDataToolTipTextProvider) {
        super(parent, style);
        this.setLayout((Layout)new FillLayout());
        this.m_chartModel = model;
        this.m_freezeModel = freezeModel;
        this.m_chartPanel = this.createChartPanel();
        this.setupAntiAliasingListener();
        this.m_chartDataToolTipTextProvider = chartDataToolTipTextProvider;
        this.setupObservers();
        this.createClient(this, toolkit);
        Menu m = new Menu((Control)this.chartCanvas);
        this.addMenuItems(m);
        this.chartCanvas.setMenu(m);
        this.setupAccessibility();
        this.createAttributeTablePopupMenu();
        toolkit.adapt((Composite)this);
        this.setupMouseTracker();
        this.getChart().setDataSeriesProvider(this.m_chartModel.getDataProvider());
        this.updateUI();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)ChartComposite.this.antialiasingListener);
            }
        });
        this.hookSelectionListener();
        this.setupMouseWheelListener();
    }

    public void refreshChart() {
        if (!this.chartCanvas.isDisposed()) {
            this.m_chart.setXAxis(this.m_chart.getXAxis());
            this.chartCanvas.redraw();
            this.recordGraphWindow();
        }
    }

    protected final long getWorldWidth() {
        return this.m_worldWidth;
    }

    protected int getLastDeviceWidth() {
        return this.m_lastDeviceWidth;
    }

    protected long getLastMax() {
        return this.m_lastMax;
    }

    protected int getDeviceWidth() {
        return this.chartCanvas.getClientArea().width;
    }

    private void recordGraphWindow() {
        this.m_lastMax = this.getWorldWindowMax();
        this.m_lastDeviceWidth = this.getDeviceWidth();
    }

    private long getWorldWindowMax() {
        return this.getAxis().getMax().longValue();
    }

    private NanosXAxis getAxis() {
        return (NanosXAxis)this.getChart().getXAxis();
    }

    private void hookSelectionListener() {
        this.chartCanvas.getSelection().addObserver((Observer)new ZoomSelectionListener());
    }

    private void setupMouseWheelListener() {
        this.addListener(37, new Listener(){

            public void handleEvent(Event event) {
                if (ChartComposite.this.getFreezeModel() != null && !ChartComposite.this.getFreezeModel().isFreezed()) {
                    return;
                }
                Rectangle bounds = ChartComposite.this.getAxis().getRenderedBounds();
                int x = Math.max(event.x - bounds.x, 0);
                x = Math.min(x, bounds.width);
                double location = (double)x / (double)bounds.width;
                if (event.count > 0) {
                    ChartComposite.this.zoom(0.8, location);
                } else if (event.count < 0) {
                    ChartComposite.this.zoom(1.25, location);
                }
            }
        });
    }

    private void setupAntiAliasingListener() {
        this.antialiasingListener = new AntiAliasingListener(this.m_chartPanel.getChart());
        UIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this.antialiasingListener);
    }

    private void setupAccessibility() {
        FocusTracker.enableFocusTracking((Composite)this.chartCanvas);
        final MCAccessibleListener accessabilityListener = new MCAccessibleListener();
        accessabilityListener.setComponentType(AccessibilityConstants.COMPONENT_TYPE_GRAPH);
        this.chartCanvas.getAccessible().addAccessibleListener((AccessibleListener)accessabilityListener);
        this.m_chartModel.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                accessabilityListener.setName(ChartComposite.this.m_chartModel.getChartTitle());
            }
        });
    }

    private void setupMouseTracker() {
        if (this.m_freezeModel != null) {
            this.chartCanvas.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                public void mouseHover(MouseEvent e) {
                    if (!ChartComposite.this.getDataProvider().hasData()) {
                        return;
                    }
                    if (ChartComposite.this.m_chartDataToolTipTextProvider != null && ChartComposite.this.getFreezeModel().isFreezed()) {
                        org.eclipse.swt.graphics.Rectangle clientArea = ChartComposite.this.chartCanvas.getClientArea();
                        Rectangle plotArea = ChartComposite.this.getChartPanel().getRenderedChartBounds();
                        int topMargin = plotArea.x + clientArea.x;
                        int leftMargin = plotArea.y + clientArea.y;
                        Point mousePoint = new Point(e.x - topMargin, e.y - leftMargin);
                        SamplePoint closestSample = null;
                        DataSeries closestSeries = null;
                        long distance = Long.MAX_VALUE;
                        OptimizingProvider[] optimizingProviderArray = ChartComposite.this.getChart().getOptimizingProvider().getChildren();
                        int n = optimizingProviderArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            OptimizingProvider provider = optimizingProviderArray[n2];
                            Iterator samples = provider.getSamples(plotArea.width);
                            DefaultYAxis yaxis = ChartComposite.this.getChart().getDescriptor(provider.getDataSeries()).getYAxis();
                            SamplePoint data = ChartComposite.getClosestPoint(yaxis, mousePoint, samples);
                            if (data != null) {
                                long newDistance = ChartComposite.getSquaredDistance(yaxis, data, mousePoint);
                                if (closestSample == null || newDistance < distance) {
                                    closestSample = data;
                                    closestSeries = provider.getDataSeries();
                                    distance = newDistance;
                                    if (distance == 0L) break;
                                }
                            }
                            ++n2;
                        }
                        if (closestSample != null) {
                            DefaultXYData xyData = new DefaultXYData((Object)closestSample.x, (Object)ChartComposite.this.getChart().getDescriptor(closestSeries).getYAxis().convertAxisValueToDrawingCoordinate(closestSample.y));
                            ((DefaultXYLineRenderer)ChartComposite.this.getChart().getSeriesPlotRenderer()).circleValue((IXYData)xyData);
                            ChartComposite.this.chartCanvas.setToolTipText(ChartComposite.this.m_chartDataToolTipTextProvider.getToolTipText(ChartComposite.this.getChart().getDescriptor(closestSeries).getName(), closestSample.y, ChartComposite.this.getDataProvider().getAttributeDescriptor((DataSeries<ITimestampedData>)closestSeries)));
                            ChartComposite.this.chartCanvas.redraw();
                        }
                    } else {
                        ChartComposite.this.clearCircledValue();
                    }
                }

                public void mouseExit(MouseEvent e) {
                    ChartComposite.this.clearCircledValue();
                }
            });
        }
    }

    private JChartComponent createChartPanel() {
        DefaultXYGreyChart chart;
        this.m_chart = chart = new DefaultXYGreyChart();
        chart.setTitleRenderer((ChartRenderer)new EmptyTitleRenderer((GreyChart)chart, 10));
        chart.setIndexRenderer(null);
        chart.setAntialiasingEnabled(AntiAliasingListener.isUsingAntialiasing());
        chart.setAutoUpdateOnAxisChange(false);
        chart.setAutoUpdateOnDataChange(false);
        DefaultXYLineRenderer plotRenderer = (DefaultXYLineRenderer)chart.getPlotRenderer();
        plotRenderer.setUseClip(false);
        plotRenderer.setDrawOnXAxis(true);
        plotRenderer.setExtrapolateMissingData(false);
        NanosXAxis d = new NanosXAxis((GreyChart)chart);
        d.setFormatter((TickFormatter)TimestampFormatter.createNanoTimestampFormatter());
        chart.setXAxis((XAxis)d);
        chart.getXAxis().setTitle(Messages.ChartComposite_X_AXIS_TITLE);
        DefaultYAxis yAxis = new DefaultYAxis((GreyChart)chart);
        yAxis.setPosition(YAxis.Position.LEFT);
        chart.addYAxis((YAxis)yAxis);
        return new JChartComponent((GreyChart)chart);
    }

    public void updateUI() {
        this.updateChartAndTable();
        this.updateXAxis();
        this.updateYAxis();
    }

    private void updateChartAndTable() {
        if (!this.attributesTableViewer.getTable().isDisposed() && !this.chartCanvas.isDisposed()) {
            this.attributesTableViewer.setInput((Object)this.getChartModel().getAttributesInTable());
            this.m_chartModel.getGraphSettingsRegistry().trackMultipliersForAttributes(this.m_chartModel.getAttributesInTable());
            this.updateMultipliersAndPaints();
            this.updateRenderingMode();
            this.antialiasingListener.updateAntialiasing();
            this.updateChartTitle();
            this.refreshChart();
        }
    }

    private void updateXAxis() {
        NanosXAxis xAxis = (NanosXAxis)this.getChart().getXAxis();
        xAxis.setTitle(this.getChartModel().getXAxis().getTitle());
        this.chartCanvas.redraw();
    }

    private void updateYAxis() {
        DefaultYAxis yAxisLeft = this.getFirstLeftAxis();
        yAxisLeft.setTitle(this.getChartModel().getYAxis().getTitle());
        switch (this.getChartModel().getYAxis().getDataType()) {
            case BYTES: {
                yAxisLeft.setContentType("bytes");
                yAxisLeft.setFormatter(new TickFormatter(){
                    private final Field m_field = new ByteField(0);

                    public String getUnitString(Number min, Number max) {
                        return "";
                    }

                    public String format(Number value, Number min, Number max, Number labelDistance) {
                        return this.m_field.formatObject((Object)value);
                    }
                });
                break;
            }
            case COUNT: {
                yAxisLeft.setContentType("count");
                yAxisLeft.setFormatter((TickFormatter)new IntFormatter());
                break;
            }
            case NONE: {
                yAxisLeft.setContentType("unknown");
                yAxisLeft.setFormatter((TickFormatter)new DoubleFormatter());
                break;
            }
            case PERCENT: {
                yAxisLeft.setContentType("unknown");
                yAxisLeft.setFormatter((TickFormatter)new DoubleFormatter(){

                    public String format(Number value, Number min, Number max, Number labelDistance) {
                        return String.valueOf(super.format(value, min, max, labelDistance)) + "%";
                    }
                });
            }
        }
        switch (this.getChartModel().getYAxis().getRangeType()) {
            case AUTO: {
                yAxisLeft.setAutoRangeEnabled(true);
                yAxisLeft.setAlwaysShowZero(false);
                yAxisLeft.setAutoPadding(0.2);
                break;
            }
            case AUTO_ZERO: {
                yAxisLeft.setAutoRangeEnabled(true);
                yAxisLeft.setAlwaysShowZero(true);
                yAxisLeft.setAutoPadding(0.2);
                break;
            }
            case CUSTOM: {
                yAxisLeft.setAutoRangeEnabled(false);
                yAxisLeft.setAlwaysShowZero(false);
                yAxisLeft.setRange(this.getChartModel().getYAxis().getMinValue(), this.getChartModel().getYAxis().getMaxValue());
                yAxisLeft.setAutoPadding(0.0);
            }
        }
        this.chartCanvas.redraw();
    }

    private DefaultYAxis getFirstLeftAxis() {
        YAxis[] yAxis;
        YAxis[] yAxisArray = yAxis = this.getChart().getYAxis();
        int n = yAxis.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis y = yAxisArray[n2];
            if (((DefaultYAxis)y).getPosition() == YAxis.Position.LEFT) {
                return (DefaultYAxis)y;
            }
            ++n2;
        }
        return (DefaultYAxis)yAxis[0];
    }

    private void setupObservers() {
        this.getChartModel().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ChartComposite.this.updateChartAndTable();
            }
        });
        this.getChartModel().getXAxis().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ChartComposite.this.updateXAxis();
            }
        });
        this.getChartModel().getYAxis().addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                ChartComposite.this.updateYAxis();
            }
        });
    }

    public AttributeChartModel getChartModel() {
        return this.m_chartModel;
    }

    protected FreezeModel getFreezeModel() {
        return this.m_freezeModel;
    }

    protected final TableViewer getTableViewer() {
        return this.attributesTableViewer;
    }

    IAttributeDataSeriesProvider<ITimestampedData> getDataProvider() {
        return this.m_chartModel.getDataProvider();
    }

    private void clearCircledValue() {
        ((DefaultXYLineRenderer)this.getChart().getSeriesPlotRenderer()).circleValue(null);
        this.chartCanvas.setToolTipText(null);
        this.chartCanvas.redraw();
    }

    public JChartComponent getChartPanel() {
        return this.m_chartPanel;
    }

    public DefaultXYGreyChart<ITimestampedData> getChart() {
        return (DefaultXYGreyChart)this.getChartPanel().getChart();
    }

    public Menu getZoomMenu() {
        return null;
    }

    private static SamplePoint getClosestPoint(DefaultYAxis yaxis, Point mousePoint, Iterator<SamplePoint> s) {
        SamplePoint result = null;
        long distance = Long.MAX_VALUE;
        Iterator<SamplePoint> iter = s;
        while (iter.hasNext()) {
            SamplePoint data = iter.next();
            long tmpDist = ChartComposite.getSquaredDistance(yaxis, data, mousePoint);
            if (tmpDist >= distance) continue;
            distance = tmpDist;
            result = data;
        }
        return result;
    }

    private static long getSquaredDistance(DefaultYAxis yaxis, SamplePoint data, Point mousePoint) {
        long xdiff = data.x - mousePoint.x;
        long ydiff = yaxis.convertAxisValueToDrawingCoordinate(data.y) - mousePoint.y;
        return xdiff * xdiff + ydiff * ydiff;
    }

    protected void addMenuItems(final Menu popupMenu) {
        this.createShowMenu(popupMenu);
        this.createRangeMenu(popupMenu);
        this.createLabelDensityMenu(popupMenu);
        this.createContentTypeMenu(popupMenu);
        this.createRenderingModeMenu(popupMenu);
        this.createTitleMenu(popupMenu);
        this.addZoomItems(popupMenu);
        MenuItem exportItem = new MenuItem(popupMenu, 0);
        exportItem.setText(Messages.ChartComposite_MENU_ITEM_EXPORT_AS_IMAGE_TEXT);
        exportItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                popupMenu.setVisible(false);
                Display.getCurrent().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        String fileName;
                        ImageData swtData = ChartComposite.this.captureComponentImage();
                        FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell().getShell(), 8192);
                        dialog.setFilterExtensions(new String[]{"*.png"});
                        while ((fileName = dialog.open()) != null) {
                            File f;
                            if (!fileName.toLowerCase().endsWith(".png")) {
                                fileName = fileName.concat(".png");
                            }
                            if ((f = new File(fileName)).exists() && !MessageDialog.openQuestion((Shell)ChartComposite.this.getShell(), (String)Messages.ChartComposite_DIALOG_FILE_EXISTS_TITLE, (String)NLS.bind((String)Messages.ChartComposite_DIALOG_OVERWRITE_QUESTION_TEXT, (Object)fileName))) continue;
                            ImageLoader loader = new ImageLoader();
                            loader.data = new ImageData[]{swtData};
                            loader.save(fileName, 5);
                            break;
                        }
                    }
                });
            }
        });
    }

    protected void createShowMenu(Menu popupMenu) {
    }

    private void addZoomItems(Menu popupMenu) {
        this.zoomInItem = new MenuItem(popupMenu, 0);
        this.zoomInItem.setText(Messages.ChartComposite_MENU_ZOOM_IN_TEXT);
        this.zoomInItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.zoomIn();
            }
        });
        this.zoomOutItem = new MenuItem(popupMenu, 0);
        this.zoomOutItem.setText(Messages.ChartComposite_MENU_ZOOM_OUT_TEXT);
        this.zoomOutItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.zoomOut();
            }
        });
    }

    private void createAttributeTablePopupMenu() {
        Menu popupMenu = new Menu((Control)this.getTableViewer().getTable());
        final MenuItem editColorItem = new MenuItem(popupMenu, 0);
        editColorItem.setText(Messages.ChartSectionPart_EDIT_COLOR_TEXT);
        editColorItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChartComposite.this.attributesTableViewer.getSelection();
                MRI descriptor = (MRI)selection.getFirstElement();
                ChartComposite.this.editColor(descriptor, ChartComposite.this.getGraphSettingsRegistry());
                ChartComposite.this.getGraphSettingsRegistry().commit();
                ChartComposite.this.updateChartAndTable();
            }
        });
        editColorItem.setEnabled(false);
        final MenuItem[] editMultiplierItemHolder = new MenuItem[1];
        if (this.getGraphSettingsRegistry().canUpdateMultiplier()) {
            MenuItem editMultiplierItem;
            editMultiplierItemHolder[0] = editMultiplierItem = new MenuItem(popupMenu, 0);
            editMultiplierItem.setText(Messages.ChartSectionPart_EDIT_MULTIPLIER_TEXT);
            editMultiplierItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    IStructuredSelection selection = (IStructuredSelection)ChartComposite.this.getTableViewer().getSelection();
                    MRI descriptor = (MRI)selection.getFirstElement();
                    ChartComposite.this.editMultiplier(descriptor, ChartComposite.this.getGraphSettingsRegistry());
                    ChartComposite.this.getGraphSettingsRegistry().commit();
                    ChartComposite.this.updateChartAndTable();
                }
            });
            editMultiplierItem.setEnabled(false);
        }
        this.getTableViewer().addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                boolean enable = ((IStructuredSelection)ChartComposite.this.getTableViewer().getSelection()).size() == 1;
                editColorItem.setEnabled(enable);
                if (editMultiplierItemHolder[0] != null) {
                    editMultiplierItemHolder[0].setEnabled(enable);
                }
            }
        });
        this.attributesTableViewer.getTable().setMenu(popupMenu);
    }

    protected void editMultiplier(MRI descriptor, GraphSettingRegistry manager) {
        InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartSectionPart_EDIT_MULTIPLIER_TEXT, Messages.ChartSectionPart_ENTER_MULTIPLIER_VALUE_TEXT, manager.getMultiplier(descriptor).toString(), new IInputValidator(){

            public String isValid(String newText) {
                try {
                    Double.parseDouble(newText);
                    return null;
                }
                catch (NumberFormatException e) {
                    return Messages.ChartSectionPart_MULTIPLIER_MUST_BE_NUMBER_TEXT;
                }
            }
        });
        if (dialog.open() == 0) {
            manager.registerUndoableMultiplierChange(descriptor, new Double(dialog.getValue()));
        }
    }

    protected void editColor(MRI descriptor, GraphSettingRegistry manager) {
        ColorDialog dialog = new ColorDialog(Display.getCurrent().getActiveShell());
        Color awtColor = manager.getAWTColor(descriptor);
        RGB rgb = new RGB(awtColor.getRed(), awtColor.getGreen(), awtColor.getBlue());
        dialog.setRGB(rgb);
        RGB newRGB = dialog.open();
        if (newRGB != null) {
            manager.registerUndoableColorChange(descriptor, new Color(newRGB.red, newRGB.green, newRGB.blue));
        }
    }

    protected void updateMultipliersAndPaints() {
        MRI[] subscriptionAttributes;
        MRI[] mRIArray = subscriptionAttributes = this.getChartModel().getAttributesInTable();
        int n = subscriptionAttributes.length;
        int n2 = 0;
        while (n2 < n) {
            MRI mri = mRIArray[n2];
            this.getDataProvider().setMultiplier(mri, this.getGraphSettingsRegistry().getMultiplier(mri));
            if (this.getDataProvider().getDataSeries(mri) != null) {
                this.updateDescriptor(mri);
            }
            ++n2;
        }
    }

    private void updateDescriptor(MRI mri) {
        this.getChart().setDescriptor(this.getDataProvider().getDataSeries(mri), this.createDescriptor(this.getGraphSettingsRegistry().getAWTColor(mri), mri));
    }

    DataSeriesDescriptor createDescriptor(Color color, MRI descriptor) {
        DefaultDataSeriesDescriptor oldDescriptor = this.getChart().getDescriptor(this.getDataProvider().getDataSeries(descriptor));
        DefaultDataSeriesDescriptor newDescriptor = (DefaultDataSeriesDescriptor)new DefaultDataSeriesDescriptor().setLineColor(color).setDrawLine(true).setName(descriptor.getDataPath()).setYAxis(this.getFirstLeftAxis());
        if (oldDescriptor != null) {
            return ChartComposite.merge(oldDescriptor, newDescriptor);
        }
        return newDescriptor;
    }

    private static DataSeriesDescriptor merge(DefaultDataSeriesDescriptor oldDescriptor, DefaultDataSeriesDescriptor newDescriptor) {
        return oldDescriptor.merge(newDescriptor);
    }

    protected Composite createClient(Composite parent, FormToolkit toolkit) {
        Composite container = toolkit.createComposite(parent);
        GridLayout gLayout = new GridLayout(2, false);
        gLayout.marginWidth = 0;
        gLayout.marginHeight = 0;
        container.setLayout((Layout)gLayout);
        this.chartCanvas = new ChartCanvas(container, (JComponent)this.getChartPanel());
        this.chartCanvas.setLayoutData((Object)new GridData(4, 4, true, true));
        toolkit.adapt((Composite)this.chartCanvas);
        Composite indexComposite = toolkit.createComposite(container, 0);
        Table table = toolkit.createTable(indexComposite, 65570);
        this.attributesTableViewer = new CheckboxTableViewer(table);
        this.attributesTableViewer.addCheckStateListener((ICheckStateListener)this);
        this.attributesTableViewer.setCheckStateProvider(new ICheckStateProvider(){

            public boolean isGrayed(Object element) {
                return false;
            }

            public boolean isChecked(Object element) {
                return ChartComposite.this.getDataProvider().getDataSeries((MRI)element) != null;
            }
        });
        this.attributesTableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.attributesTableViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ((MRI)element).getDataPath();
            }

            public Image getImage(Object element) {
                if (element instanceof IMRIMetaData) {
                    return ChartComposite.this.m_chartModel.getGraphSettingsRegistry().getColorThumbnail(((IMRIMetaData)element).getMRI());
                }
                return ChartComposite.this.m_chartModel.getGraphSettingsRegistry().getColorThumbnail((MRI)element);
            }
        });
        this.attributesTableViewer.getTable().addMouseTrackListener((MouseTrackListener)new TableToolTipMouseTrackAdapter(this.attributesTableViewer.getTable(), new IToolTipTextProvider(){

            public String getToolTipText(Object obj) {
                return MBeanPropertiesOrderer.getAttributePath((MRI)obj);
            }
        }));
        GridData gd2 = new GridData(4, 4, true, true);
        this.attributesTableViewer.getControl().setLayoutData((Object)gd2);
        Composite buttonComposite = toolkit.createComposite(indexComposite, 32);
        buttonComposite.setLayoutData((Object)new GridData(4, 4, false, false));
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.makeColumnsEqualWidth = true;
        gridLayout.numColumns = 2;
        buttonComposite.setLayout((Layout)gridLayout);
        this.createButtons(buttonComposite, toolkit);
        GridData gd = new GridData(4, 4, false, true);
        gd.widthHint = Math.max(buttonComposite.computeSize((int)-1, (int)-1).x + 2, 195);
        indexComposite.setLayoutData((Object)gd);
        GridLayout indexLayout = new GridLayout(1, false);
        indexLayout.marginWidth = 2;
        indexLayout.marginHeight = 2;
        indexComposite.setLayout((Layout)indexLayout);
        toolkit.paintBordersFor(container);
        toolkit.paintBordersFor(indexComposite);
        return container;
    }

    protected void createButtons(Composite buttonComposite, FormToolkit toolkit) {
        GridData gd1 = new GridData(4, 4, true, false);
        this.addAttributeButton = toolkit.createButton(buttonComposite, Messages.ChartComposite_BUTTON_ADD_TEXT, 0);
        this.addAttributeButton.setImage(RJMXUIPlugin.getDefault().getImage("add-graph-16.png"));
        this.addAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.addButtonPressed();
            }
        });
        this.addAttributeButton.setLayoutData((Object)gd1);
        GridData gd2 = new GridData(4, 4, true, false);
        this.removeAttributeButton = toolkit.createButton(buttonComposite, Messages.ChartComposite_BUTTON_REMOVE_TEXT, 0);
        this.removeAttributeButton.setImage(RJMXUIPlugin.getDefault().getImage("remove-graph-16.png"));
        this.removeAttributeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.removeButtonPressed();
            }
        });
        this.removeAttributeButton.setLayoutData((Object)gd2);
    }

    void setWorldWidth(long width) {
        this.m_worldWidth = width;
    }

    private void createRangeMenu(Menu popupMenu) {
        MenuItem rangeItem = new MenuItem(popupMenu, 64);
        rangeItem.setText(Messages.ChartComposite_MENU_Y_AXIS_RANGE_TEXT);
        Menu rangeMenu = new Menu(popupMenu);
        rangeItem.setMenu(rangeMenu);
        MenuItem autoRangeItem = new MenuItem(rangeMenu, 0);
        autoRangeItem.setText(Messages.ChartComposite_MENU_AUTO_RANGE_TEXT);
        autoRangeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.m_chartModel.getYAxis().setRangeType(ChartModel.AxisRange.AUTO);
                ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
            }
        });
        MenuItem autoRangeZeroItem = new MenuItem(rangeMenu, 0);
        autoRangeZeroItem.setText(Messages.ChartComposite_MENU_AUTO_RANGE_ZERO_TEXT);
        autoRangeZeroItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.m_chartModel.getYAxis().setRangeType(ChartModel.AxisRange.AUTO_ZERO);
                ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
            }
        });
        MenuItem customRangeItem = new MenuItem(rangeMenu, 0);
        customRangeItem.setText(Messages.ChartComposite_MENU_CUSTOM_RANGE_TEXT);
        customRangeItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                RangeInputDialog rangeInputDialog = new RangeInputDialog(Display.getCurrent().getActiveShell());
                if (rangeInputDialog.open() == 0) {
                    ChartComposite.this.m_chartModel.getYAxis().setRangeType(ChartModel.AxisRange.CUSTOM);
                    ChartComposite.this.m_chartModel.getYAxis().setMinValue(rangeInputDialog.getFromValue());
                    ChartComposite.this.m_chartModel.getYAxis().setMaxValue(rangeInputDialog.getToValue());
                    ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
                }
            }
        });
    }

    private void createLabelDensityMenu(Menu popupMenu) {
        MenuItem labelDensityItem = new MenuItem(popupMenu, 64);
        labelDensityItem.setText(Messages.ChartComposite_MENU_LABEL_DENSITY_TEXT);
        Menu labelDensityMenu = new Menu(popupMenu);
        labelDensityItem.setMenu(labelDensityMenu);
        TickDensity[] tickDensityArray = TickDensity.values();
        int n = tickDensityArray.length;
        int n2 = 0;
        while (n2 < n) {
            TickDensity tickDensity = tickDensityArray[n2];
            this.addDensityMenuItem(labelDensityMenu, tickDensity);
            ++n2;
        }
    }

    private void createRenderingModeMenu(Menu popupMenu) {
        MenuItem labelRenderingModeItem = new MenuItem(popupMenu, 64);
        labelRenderingModeItem.setText(Messages.ChartComposite_MENU_RENDERING_MODE_TEXT);
        Menu renderingModeMenu = new Menu(popupMenu);
        labelRenderingModeItem.setMenu(renderingModeMenu);
        this.addRenderingModeMenuItem(renderingModeMenu, Messages.ChartComposite_MENU_RENDERING_MODE_SUBSAMPLING_TEXT, DataSeriesDescriptor.RenderingMode.SUBSAMPLING);
        this.addRenderingModeMenuItem(renderingModeMenu, Messages.ChartComposite_MENU_RENDERING_MODE_AVERAGING_TEXT, DataSeriesDescriptor.RenderingMode.AVERAGING);
    }

    private void addRenderingModeMenuItem(Menu renderingModeMenu, String menuName, final DataSeriesDescriptor.RenderingMode mode) {
        MenuItem renderingModeMenuItem = new MenuItem(renderingModeMenu, 0);
        renderingModeMenuItem.setText(menuName);
        renderingModeMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.getChartModel().setRenderingMode(mode);
                ChartComposite.this.getChartModel().notifyObservers();
            }
        });
    }

    private void addDensityMenuItem(Menu labelDensityMenu, final TickDensity tickDensity) {
        MenuItem densityMenuItem = new MenuItem(labelDensityMenu, 0);
        densityMenuItem.setText(TickDensityName.getReadableName((TickDensity)tickDensity));
        densityMenuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.setAxisDensity(tickDensity);
            }
        });
    }

    protected void setAxisDensity(TickDensity tickDensity) {
        YAxis[] yAxisArray = this.getChart().getYAxis();
        int n = yAxisArray.length;
        int n2 = 0;
        while (n2 < n) {
            YAxis yaxis = yAxisArray[n2];
            ((DefaultYAxis)yaxis).setTickDensity(tickDensity);
            ++n2;
        }
    }

    private void createContentTypeMenu(Menu popupMenu) {
        MenuItem contentItem = new MenuItem(popupMenu, 64);
        contentItem.setText(Messages.ChartComposite_MENU_CONTENT_TYPE);
        Menu contentTypeMenu = new Menu(popupMenu);
        contentItem.setMenu(contentTypeMenu);
        MenuItem bytesItem = new MenuItem(contentTypeMenu, 0);
        bytesItem.setText(Messages.ChartComposite_MENU_CONTENT_TYPE_BYTES);
        bytesItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.m_chartModel.getYAxis().setDataType(ChartModel.DataType.BYTES);
                ChartComposite.this.m_chartModel.getYAxis().setRangeType(ChartModel.AxisRange.AUTO_ZERO);
                ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
            }
        });
        MenuItem percentItem = new MenuItem(contentTypeMenu, 0);
        percentItem.setText(Messages.ChartComposite_MENU_CONTENT_TYPE_PERCENT);
        percentItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.m_chartModel.getYAxis().setDataType(ChartModel.DataType.PERCENT);
                ChartComposite.this.m_chartModel.getYAxis().setMinValue(0);
                ChartComposite.this.m_chartModel.getYAxis().setMaxValue(100);
                ChartComposite.this.m_chartModel.getYAxis().setRangeType(ChartModel.AxisRange.CUSTOM);
                ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
            }
        });
        MenuItem countItem = new MenuItem(contentTypeMenu, 0);
        countItem.setText(Messages.ChartComposite_MENU_CONTENT_TYPE_COUNT);
        countItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.m_chartModel.getYAxis().setDataType(ChartModel.DataType.COUNT);
                ChartComposite.this.m_chartModel.getYAxis().setRangeType(ChartModel.AxisRange.AUTO_ZERO);
                ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
            }
        });
        MenuItem defaultItem = new MenuItem(contentTypeMenu, 0);
        defaultItem.setText(Messages.ChartComposite_MENU_CONTENT_TYPE_NONE);
        defaultItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChartComposite.this.m_chartModel.getYAxis().setDataType(ChartModel.DataType.NONE);
                ChartComposite.this.m_chartModel.getYAxis().setRangeType(ChartModel.AxisRange.AUTO_ZERO);
                ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
            }
        });
    }

    private void createTitleMenu(Menu popupMenu) {
        MenuItem rangeItem = new MenuItem(popupMenu, 64);
        rangeItem.setText(Messages.ChartComposite_MENU_EDIT_TITLES_TEXT);
        Menu rangeMenu = new Menu(popupMenu);
        rangeItem.setMenu(rangeMenu);
        MenuItem graphTitleItem = new MenuItem(rangeMenu, 0);
        graphTitleItem.setText(Messages.ChartComposite_MENU_GRAPH_TITLE_TEXT);
        graphTitleItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                String defaultValue = ChartComposite.this.m_chartModel.getChartTitle();
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartComposite_INPUT_GRAPH_TITLE_TITLE, Messages.ChartComposite_INPUT_GRAPH_TITLE_MESSAGE, defaultValue, null);
                if (inputDialog.open() == 0) {
                    ChartComposite.this.m_chartModel.setChartTitle(inputDialog.getValue());
                    ChartComposite.this.m_chartModel.notifyObservers();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem yAxisTitleItem = new MenuItem(rangeMenu, 0);
        yAxisTitleItem.setText(Messages.ChartComposite_MENU_Y_AXIS_TITLE_TEXT);
        yAxisTitleItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartComposite_INPUT_Y_AXIS_TITLE_TITLE, Messages.ChartComposite_INPUT_Y_AXIS_TITLE_MESSAGE, ChartComposite.this.getFirstLeftAxis().getTitle(), null);
                if (inputDialog.open() == 0) {
                    ChartComposite.this.m_chartModel.getYAxis().setTitle(inputDialog.getValue());
                    ChartComposite.this.m_chartModel.getYAxis().notifyObservers();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        MenuItem xAxisTitleItem = new MenuItem(rangeMenu, 0);
        xAxisTitleItem.setText(Messages.ChartComposite_MENU_X_AXIS_TITLE_TEXT);
        xAxisTitleItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                InputDialog inputDialog = new InputDialog(Display.getCurrent().getActiveShell(), Messages.ChartComposite_INPUT_X_AXIS_TITLE_TITLE, Messages.ChartComposite_INPUT_X_AXIS_TITLE_MESSAGE, ChartComposite.this.getChart().getXAxis().getTitle(), null);
                if (inputDialog.open() == 0) {
                    ChartComposite.this.m_chartModel.getXAxis().setTitle(inputDialog.getValue());
                    ChartComposite.this.m_chartModel.getXAxis().notifyObservers();
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        this.getDataProvider().setEnabled((MRI)event.getElement(), event.getChecked());
        this.updateMultipliersAndPaints();
        this.refreshChart();
    }

    protected void addButtonPressed() {
    }

    protected void removeButtonPressed() {
    }

    public List<MRI> getSelectedAttributes() {
        return ((IStructuredSelection)this.attributesTableViewer.getSelection()).toList();
    }

    public void setRange(TimeRange tr) {
        if (!this.zoomInItem.isDisposed()) {
            this.setZoomEnablement();
            long startL = tr.getStartTimestamp();
            long endL = tr.getEndTimestamp();
            long width = endL - startL;
            startL = Math.max(0L, startL);
            endL = Math.min(endL, 2529792000000000000L);
            if (width < 1000000000L) {
                long middle = (startL + endL) / 2L;
                startL = middle - 500000000L;
                endL = middle + 500000000L;
                this.zoomInItem.setEnabled(false);
            }
            ((NanosXAxis)this.getChart().getXAxis()).setRange((Number)startL, (Number)endL);
            this.getDataProvider().setRange(new TimeRange(startL, endL));
            this.m_worldWidth = endL - startL;
        }
    }

    private void updateRenderingMode() {
        DataSeries[] dataSeriesArray = this.m_chart.getSeriesDataProvider().getDataSeries();
        int n = dataSeriesArray.length;
        int n2 = 0;
        while (n2 < n) {
            DataSeries series = dataSeriesArray[n2];
            this.m_chart.getDescriptor(series).setMode(this.getChartModel().getRenderingMode());
            ++n2;
        }
    }

    protected void setZoomEnablement() {
        boolean zoomingAllowed = this.getFreezeModel() == null || this.getFreezeModel().isFreezed();
        this.zoomInItem.setEnabled(zoomingAllowed);
        this.zoomOutItem.setEnabled(zoomingAllowed);
    }

    public ImageData captureComponentImage() {
        Section s = this.findUndisposedSectionParent();
        GC gc = new GC((Drawable)s);
        Point p = s.getSize();
        Image image = new Image((Device)Display.getCurrent(), p.x, p.y);
        org.eclipse.swt.graphics.Rectangle cliprect = gc.getClipping();
        gc.setClipping(cliprect.x, cliprect.y, p.x, p.y);
        gc.copyArea(image, 0, 0);
        gc.dispose();
        ImageData imageData = image.getImageData();
        image.dispose();
        return imageData;
    }

    private Section findUndisposedSectionParent() {
        ChartComposite c = this;
        while (!c.isDisposed() && c.getParent() != null) {
            if (c.getParent() instanceof Section) {
                if (c.getParent().isDisposed()) break;
                return (Section)c.getParent();
            }
            c = c.getParent();
        }
        return null;
    }

    private void updateChartTitle() {
        Section sectionParent = this.findUndisposedSectionParent();
        if (sectionParent != null) {
            sectionParent.setText(this.m_chartModel.getChartTitle());
            sectionParent.layout();
            sectionParent.redraw();
        }
    }

    private void zoom(double factor, double location) {
        long axisStart = this.getAxis().getMin().longValue();
        long axisEnd = this.getAxis().getMax().longValue();
        long axisWidth = axisEnd - axisStart;
        long zoomPoint = (long)((double)axisStart + (double)axisWidth * location);
        long newStart = (long)((double)zoomPoint - (double)(zoomPoint - axisStart) * factor);
        long newEnd = (long)((double)zoomPoint + (double)(axisEnd - zoomPoint) * factor);
        this.setRange(new TimeRange(newStart, newEnd));
        this.refreshChart();
    }

    public void zoomIn() {
        this.zoom(0.5, 0.5);
    }

    public void zoomOut() {
        this.zoom(2.0, 0.5);
    }

    public GraphSettingRegistry getGraphSettingsRegistry() {
        return this.m_chartModel.getGraphSettingsRegistry();
    }

    public static interface IChartDataToolTipTextProvider {
        public String getToolTipText(String var1, Number var2, MRI var3);
    }

    public class RangeInputDialog
    extends Dialog {
        private Button okButton;
        private Text errorMessageText;
        private Text fromText;
        private Text toText;
        private Number fromValue;
        private Number toValue;

        public RangeInputDialog(Shell parentShell) {
            super(parentShell);
        }

        protected void configureShell(Shell shell) {
            super.configureShell(shell);
            shell.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_TITLE);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.okButton = this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.fromText.setFocus();
            DefaultYAxis yaxis = ChartComposite.this.getFirstLeftAxis();
            if (yaxis.isAutoRangeEnabled()) {
                this.fromText.setText("0");
                this.toText.setText("100");
            } else {
                this.fromText.setText(yaxis.getMin().toString());
                this.toText.setText(yaxis.getMax().toString());
            }
        }

        protected Button getOkButton() {
            return this.okButton;
        }

        protected void validateInput() {
            String errorMessage = null;
            try {
                if (Double.parseDouble(this.fromText.getText()) > Double.parseDouble(this.toText.getText())) {
                    errorMessage = Messages.ChartComposite_DIALOG_RANGE_INPUT_MESSAGE_FROM_SMALLER_THAN_TO;
                }
            }
            catch (NumberFormatException e) {
                errorMessage = Messages.ChartComposite_DIALOG_RANGE_INPUT_MESSAGE_MUST_BE_NUMBERS;
            }
            this.setErrorMessage(errorMessage);
        }

        protected Control createDialogArea(Composite parent) {
            Composite composite = (Composite)super.createDialogArea(parent);
            Label label = new Label(composite, 64);
            label.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_TEXT);
            GridData data = new GridData(1796);
            data.widthHint = this.convertHorizontalDLUsToPixels(300);
            label.setLayoutData((Object)data);
            label.setFont(parent.getFont());
            this.createCustomArea(composite);
            this.fromText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RangeInputDialog.this.validateInput();
                }
            });
            this.toText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    RangeInputDialog.this.validateInput();
                }
            });
            this.errorMessageText = new Text(composite, 8);
            this.errorMessageText.setLayoutData((Object)new GridData(768));
            this.errorMessageText.setBackground(this.errorMessageText.getDisplay().getSystemColor(22));
            RangeInputDialog.applyDialogFont((Control)composite);
            return composite;
        }

        public void setErrorMessage(String errorMessage) {
            this.errorMessageText.setText(errorMessage == null ? "" : errorMessage);
            this.getOkButton().setEnabled(errorMessage == null);
        }

        protected Control createCustomArea(Composite parent) {
            Composite numberFields = new Composite(parent, 0);
            numberFields.setLayout((Layout)new GridLayout(2, false));
            GridData gd = new GridData(4, 4, true, false);
            gd.widthHint = 80;
            Label minimumLabel = new Label(numberFields, 0);
            minimumLabel.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_MINIMUM_TEXT);
            minimumLabel.setLayoutData((Object)new GridData(4, 4, false, false));
            this.fromText = new Text(numberFields, 2052);
            this.fromText.setLayoutData((Object)gd);
            Label maximumLabel = new Label(numberFields, 0);
            maximumLabel.setText(Messages.ChartComposite_DIALOG_RANGE_INPUT_MAXIMUM_TEXT);
            maximumLabel.setLayoutData((Object)new GridData(4, 4, false, false));
            this.toText = new Text(numberFields, 2052);
            this.toText.setLayoutData((Object)gd);
            return numberFields;
        }

        public Number getFromValue() {
            return this.fromValue;
        }

        public Number getToValue() {
            return this.toValue;
        }

        protected void okPressed() {
            this.fromValue = Double.parseDouble(this.fromText.getText());
            this.toValue = Double.parseDouble(this.toText.getText());
            super.okPressed();
        }
    }

    class ZoomSelectionListener
    implements Observer {
        private SelectionRenderer m_selectionRenderer;

        ZoomSelectionListener() {
        }

        @Override
        public void update(Observable o, Object arg) {
            if (ChartComposite.this.chartCanvas.getSelection().isFinished() && this.m_selectionRenderer != null && this.m_selectionRenderer.hasValidSelection()) {
                long start = this.m_selectionRenderer.getSelectedStartX().longValue();
                long end = this.m_selectionRenderer.getSelectedEndX().longValue();
                ChartComposite.this.getDataProvider().setRange(new TimeRange(start, end));
                ChartComposite.this.setRange(new TimeRange(start, end));
                ChartComposite.this.refreshChart();
                ChartComposite.this.chartCanvas.setSelectionRenderer(null);
            }
            if (ChartComposite.this.chartCanvas.getSelection().isBeginSelection()) {
                if (ChartComposite.this.m_freezeModel != null) {
                    ChartComposite.this.m_freezeModel.setFreezed(true);
                }
                this.m_selectionRenderer = ChartComposite.this.getChart().createSelectionRenderer();
                ChartComposite.this.chartCanvas.setSelectionRenderer(this.m_selectionRenderer);
            }
        }
    }
}

