/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.IAttributeDataSeriesProvider;
import java.util.Observable;
import java.util.logging.Level;
import org.w3c.dom.Element;
import se.hirt.greychart.data.DataSeriesDescriptor;

public class ChartModel<T>
extends Observable {
    public static final String XML_TAG_CHART_MODEL = "chartModel";
    public static final String XML_Y_RANGE_SETTING = "yRangeSetting";
    public static final String XML_RENDERING_MODE_SETTING = "renderingModeSetting";
    public static final String XML_DATA_TYPE_SETTING = "dataTypeSetting";
    public static final String XML_FROM_RANGE_VALUE = "rangeFromValue";
    public static final String XML_TO_RANGE_VALUE = "rangeToValue";
    public static final String XML_Y_AXIS_TITLE = "yAxisTitle";
    public static final String XML_X_AXIS_TITLE = "xAxisTitle";
    public static final String XML_CHART_TITLE = "chartTitle";
    public static final String DEFAULT_PERCENT_TITLE = "(%)";
    public static final String NO_VALUE = "";
    private final GraphSettingRegistry m_graphSettingsRegistry;
    private final Axis m_xAxis = new Axis();
    private final RangedAxis m_yAxis = new RangedAxis();
    private final IAttributeDataSeriesProvider<T> m_dataProvider;
    private String m_title = "";
    private boolean m_allowNegativeDisplayOffsets;
    private DataSeriesDescriptor.RenderingMode m_renderingMode = DataSeriesDescriptor.RenderingMode.AVERAGING;

    public ChartModel(GraphSettingRegistry graphSettingsRegistry, IAttributeDataSeriesProvider<T> provider) {
        this.m_graphSettingsRegistry = graphSettingsRegistry;
        this.m_dataProvider = provider;
    }

    public Axis getXAxis() {
        return this.m_xAxis;
    }

    public RangedAxis getYAxis() {
        return this.m_yAxis;
    }

    public String getComponentTag() {
        return XML_TAG_CHART_MODEL;
    }

    public void setRenderingMode(DataSeriesDescriptor.RenderingMode mode) {
        this.m_renderingMode = mode;
        this.setChanged();
    }

    public DataSeriesDescriptor.RenderingMode getRenderingMode() {
        return this.m_renderingMode;
    }

    public GraphSettingRegistry getGraphSettingsRegistry() {
        return this.m_graphSettingsRegistry;
    }

    public void setChartTitle(String title) {
        this.m_title = title;
        this.setChanged();
    }

    public String getChartTitle() {
        return this.m_title;
    }

    public void setAllowNegativeDisplayOffsets(boolean alloow) {
        this.m_allowNegativeDisplayOffsets = alloow;
        this.setChanged();
    }

    public boolean getAllowNegativeDisplayOffsets() {
        return this.m_allowNegativeDisplayOffsets;
    }

    public IAttributeDataSeriesProvider<T> getDataProvider() {
        return this.m_dataProvider;
    }

    public void exportChartModelToXml(Element parentNode) {
        XmlToolkit.setSetting((Element)parentNode, (String)XML_Y_RANGE_SETTING, (String)this.getYAxis().getRangeType().toString());
        if (this.getYAxis().getRangeType() == AxisRange.CUSTOM) {
            XmlToolkit.setSetting((Element)parentNode, (String)XML_FROM_RANGE_VALUE, (String)String.valueOf(this.getYAxis().getMinValue()));
            XmlToolkit.setSetting((Element)parentNode, (String)XML_TO_RANGE_VALUE, (String)String.valueOf(this.getYAxis().getMaxValue()));
        }
        XmlToolkit.setSetting((Element)parentNode, (String)XML_Y_AXIS_TITLE, (String)this.m_yAxis.getTitle());
        XmlToolkit.setSetting((Element)parentNode, (String)XML_X_AXIS_TITLE, (String)this.m_xAxis.getTitle());
        XmlToolkit.setSetting((Element)parentNode, (String)XML_CHART_TITLE, (String)this.getChartTitle());
        XmlToolkit.setSetting((Element)parentNode, (String)XML_DATA_TYPE_SETTING, (String)this.getYAxis().getDataType().toString());
        XmlToolkit.setSetting((Element)parentNode, (String)XML_RENDERING_MODE_SETTING, (String)this.getRenderingMode().toString());
        this.getGraphSettingsRegistry().exportToXml(parentNode);
    }

    public void initializeChartModelFromXml(Element node) {
        DataType dataTypeValue;
        block8: {
            AxisRange yRangeValue = AxisRange.AUTO;
            dataTypeValue = DataType.NONE;
            try {
                yRangeValue = AxisRange.valueOf(XmlToolkit.getSetting((Element)node, (String)XML_Y_RANGE_SETTING, (String)"0"));
                this.getYAxis().setRangeType(yRangeValue);
                if (yRangeValue == AxisRange.CUSTOM) {
                    this.getYAxis().setMinValue(new Double(XmlToolkit.getSetting((Element)node, (String)XML_FROM_RANGE_VALUE, (String)NO_VALUE)));
                    this.getYAxis().setMaxValue(new Double(XmlToolkit.getSetting((Element)node, (String)XML_TO_RANGE_VALUE, (String)NO_VALUE)));
                }
            }
            catch (IllegalArgumentException ex) {
                RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem reading range values.", ex);
                if (yRangeValue != AxisRange.CUSTOM) break block8;
                this.getYAxis().setMinValue(0.0);
                this.getYAxis().setMaxValue(100.0);
            }
        }
        try {
            this.setRenderingMode(DataSeriesDescriptor.RenderingMode.valueOf((String)XmlToolkit.getSetting((Element)node, (String)XML_RENDERING_MODE_SETTING, (String)"0")));
        }
        catch (IllegalArgumentException ex) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem reading rendering mode.", ex);
        }
        try {
            dataTypeValue = DataType.valueOf(XmlToolkit.getSetting((Element)node, (String)XML_DATA_TYPE_SETTING, (String)"0"));
            this.getYAxis().setDataType(dataTypeValue);
        }
        catch (IllegalArgumentException ex) {
            RJMXUIPlugin.getDefault().getLogger().log(Level.WARNING, "Problem reading range values.", ex);
            this.getYAxis().setDataType(dataTypeValue);
        }
        this.getYAxis().setTitle(XmlToolkit.getSetting((Element)node, (String)XML_Y_AXIS_TITLE, (String)NO_VALUE));
        this.getXAxis().setTitle(XmlToolkit.getSetting((Element)node, (String)XML_X_AXIS_TITLE, (String)NO_VALUE));
        this.setChartTitle(XmlToolkit.getSetting((Element)node, (String)XML_CHART_TITLE, (String)NO_VALUE));
        Element registryNode = XmlToolkit.getFirstChildNodeByTag((Element)node, (String)this.m_graphSettingsRegistry.getComponentTag());
        if (registryNode != null) {
            this.getGraphSettingsRegistry().initializeFromXml(registryNode);
        }
        this.getXAxis().notifyObservers();
        this.getYAxis().notifyObservers();
        this.notifyObservers();
    }

    public static class Axis
    extends Observable {
        private String m_title = "";

        public String getTitle() {
            return this.m_title;
        }

        public void setTitle(String title) {
            this.m_title = title;
            this.setChanged();
        }
    }

    public static enum AxisRange {
        AUTO,
        CUSTOM,
        AUTO_ZERO;

    }

    public static enum DataType {
        NONE,
        BYTES,
        PERCENT,
        COUNT;

    }

    public static class RangedAxis
    extends Axis {
        private AxisRange m_rangeType = AxisRange.CUSTOM;
        private DataType m_dataType = DataType.NONE;
        private Number m_minValue = 0;
        private Number m_maxValue = 100;

        public Number getMinValue() {
            return this.m_minValue;
        }

        public Number getMaxValue() {
            return this.m_maxValue;
        }

        public void setMinValue(Number minValue) {
            this.m_minValue = minValue;
            this.setChanged();
        }

        public void setMaxValue(Number maxValue) {
            this.m_maxValue = maxValue;
            this.setChanged();
        }

        public void setRangeType(AxisRange rangeType) {
            if (rangeType == this.m_rangeType) {
                return;
            }
            this.m_rangeType = rangeType;
            this.setChanged();
        }

        public AxisRange getRangeType() {
            return this.m_rangeType;
        }

        public void setDataType(DataType type) {
            this.m_dataType = type;
            this.setChanged();
        }

        public DataType getDataType() {
            return this.m_dataType;
        }
    }
}

