/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.storage.internal.IAttributeStorageService;
import com.jrockit.mc.rjmx.ui.internal.AttributeChartModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeDescriptorModel;
import com.jrockit.mc.rjmx.ui.internal.AttributeModelEvent;
import com.jrockit.mc.rjmx.ui.internal.AttributeSubscriptionChart;
import com.jrockit.mc.rjmx.ui.internal.AttributeXYDataProvider;
import com.jrockit.mc.rjmx.ui.internal.ChartModel;
import com.jrockit.mc.rjmx.ui.internal.CombinedAttributeSectionPart;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.GraphSettingRegistry;
import com.jrockit.mc.rjmx.ui.internal.IAttributeModelListener;
import com.jrockit.mc.rjmx.ui.internal.LogToHistoricalDataAction;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import org.eclipse.jface.action.IAction;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CombinedChartSectionPart
extends CombinedAttributeSectionPart {
    public static final String TAG_COMBINED_CHART_SECTION_PART = "CombinedChartSectionPart";
    private AttributeChartModel m_chartModel;
    private AttributeDescriptorModel m_attributeDescriptorModel;

    public CombinedChartSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
    }

    private void addLoggingAction() {
        if (this.m_attributeDescriptorModel != null) {
            final LogToHistoricalDataAction lhda = new LogToHistoricalDataAction(this.getSection().getShell(), this.m_attributeDescriptorModel);
            this.getMCToolBarManager().add((IAction)lhda);
            this.m_attributeDescriptorModel.addObserver(new Observer(){

                @Override
                public void update(Observable o, Object arg) {
                    lhda.setChecked(CombinedChartSectionPart.this.m_attributeDescriptorModel.getPersistenceEnabled());
                    CombinedChartSectionPart.this.getMCToolBarManager().update();
                }
            });
        }
    }

    @Override
    protected Control createGraphicalControl(Composite parent, FormToolkit formToolkit, FreezeModel freezeModel) throws Exception {
        IConnectionHandle connection = this.getConnectionHandle();
        AttributeXYDataProvider dataProvider = new AttributeXYDataProvider((IAttributeStorageService)connection.getServiceOrThrow(IAttributeStorageService.class));
        final IMRIMetaDataService attributeInfoService = (IMRIMetaDataService)connection.getServiceOrThrow(IMRIMetaDataService.class);
        this.m_chartModel = new AttributeChartModel(new GraphSettingRegistry(connection.getServerDescriptor().getGUID(), attributeInfoService), dataProvider);
        dataProvider.setGraphSettingsRegistry(this.m_chartModel.getGraphSettingsRegistry());
        this.m_attributeDescriptorModel = new AttributeDescriptorModel(connection, this.m_chartModel);
        this.getAttributeModel().addAttributeModelListener(new IAttributeModelListener(){

            @Override
            public void attributeAdded(AttributeModelEvent event, boolean enabled) {
                MRI attribute = event.getAttribute();
                IMRIMetaData info = attributeInfoService.getMetaData(attribute);
                if (MRIMetaDataToolkit.isNumerical((IMRIMetaData)info)) {
                    CombinedChartSectionPart.this.m_attributeDescriptorModel.add(info.getMRI(), enabled);
                }
            }

            @Override
            public void attributeRemoved(AttributeModelEvent event) {
                CombinedChartSectionPart.this.m_attributeDescriptorModel.remove(event.getAttribute());
            }

            @Override
            public void attributeChanged(AttributeModelEvent event) {
            }
        });
        this.m_attributeDescriptorModel.addObserver(new Observer(){

            @Override
            public void update(Observable o, Object arg) {
                if (!(o instanceof AttributeDescriptorModel)) {
                    return;
                }
                AttributeDescriptorModel adm = (AttributeDescriptorModel)o;
                List<MRI> attributes = adm.getAttributeDescriptors();
                ArrayList<MRI> addedAttributes = new ArrayList<MRI>();
                Iterator<Object> iterator = attributes.iterator();
                while (iterator.hasNext()) {
                    MRI ao;
                    MRI attribute = ao = iterator.next();
                    if (CombinedChartSectionPart.this.getAttributeModel().contains(attribute)) continue;
                    addedAttributes.add(attribute);
                }
                for (MRI attribute : addedAttributes) {
                    CombinedChartSectionPart.this.getAttributeModel().add(attribute);
                }
                ArrayList<MRI> removedAttributes = new ArrayList<MRI>();
                MRI[] mRIArray = CombinedChartSectionPart.this.getAttributeModel().getAttributeDescriptors();
                int n = mRIArray.length;
                int n2 = 0;
                while (n2 < n) {
                    MRI attribute = mRIArray[n2];
                    if (!attributes.contains(attribute) && MRIMetaDataToolkit.isNumerical((IMRIMetaData)attributeInfoService.getMetaData(attribute))) {
                        removedAttributes.add(attribute);
                    }
                    ++n2;
                }
                for (MRI attribute : removedAttributes) {
                    CombinedChartSectionPart.this.getAttributeModel().remove(attribute);
                }
            }
        });
        AttributeSubscriptionChart chart = new AttributeSubscriptionChart(parent, 0, formToolkit, this.m_attributeDescriptorModel, connection, freezeModel);
        dataProvider.setGreyChart(chart.getChart());
        dataProvider.setChart(chart);
        this.addLoggingAction();
        return chart;
    }

    public String getComponentTag() {
        return TAG_COMBINED_CHART_SECTION_PART;
    }

    @Override
    protected void exportExtraToXml(Element node) {
        super.exportExtraToXml(node);
        this.m_attributeDescriptorModel.exportToXml(node);
    }

    @Override
    protected void initializeExtraFromXml(Element node) throws Exception {
        List l = XmlToolkit.getChildElementsByTag((Node)node, (String)this.m_attributeDescriptorModel.getComponentTag());
        if (l.size() > 0) {
            this.m_attributeDescriptorModel.initializeFromXml((Element)l.get(0));
        }
        super.initializeExtraFromXml(node);
    }

    @Override
    public boolean setProperty(String key, Object value) {
        if (value instanceof String) {
            if (key.equals("title")) {
                this.storeProperty(key, value);
                this.updateTitle((String)value);
                this.m_chartModel.setChartTitle((String)value);
                this.m_chartModel.notifyObservers();
                return true;
            }
            if (key.equals("axisY")) {
                this.storeProperty(key, value);
                this.m_chartModel.getYAxis().setTitle((String)value);
                this.m_chartModel.getYAxis().notifyObservers();
                return true;
            }
            if (key.equals("axisX")) {
                this.storeProperty(key, value);
                this.m_chartModel.getXAxis().setTitle((String)value);
                this.m_chartModel.getXAxis().notifyObservers();
                return true;
            }
        } else if (value instanceof ChartModel.AxisRange) {
            if (key.equals("rangeTypeY")) {
                this.storeProperty(key, value);
                this.m_chartModel.getYAxis().setRangeType((ChartModel.AxisRange)((Object)value));
                this.m_chartModel.getYAxis().notifyObservers();
                return true;
            }
        } else if (value instanceof ChartModel.DataType && key.equals("dataType")) {
            this.storeProperty(key, value);
            this.m_chartModel.getYAxis().setDataType((ChartModel.DataType)((Object)value));
            this.m_chartModel.getYAxis().notifyObservers();
            return true;
        }
        return super.setProperty(key, value);
    }
}

