/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.xml.XmlToolkit;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.AttributeChangeEvent;
import com.jrockit.mc.rjmx.ui.internal.AttributeDial;
import com.jrockit.mc.rjmx.ui.internal.AttributeDialConfigurationPage;
import com.jrockit.mc.rjmx.ui.internal.AttributeModelEvent;
import com.jrockit.mc.rjmx.ui.internal.CombinedAttributeSectionPart;
import com.jrockit.mc.rjmx.ui.internal.FreezeModel;
import com.jrockit.mc.rjmx.ui.internal.IAttributeChangeListener;
import com.jrockit.mc.rjmx.ui.internal.IAttributeModelListener;
import com.jrockit.mc.rjmx.ui.internal.Messages;
import com.jrockit.mc.ui.dial.RefreshController;
import com.jrockit.mc.ui.misc.IRefreshable;
import com.jrockit.mc.ui.wizards.OnePageWizardDialog;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CombinedDialsSectionPart
extends CombinedAttributeSectionPart {
    public static final String TAG_COMBINED_DIALS_SECTION_PART = "CombinedDialsSectionPart";
    private AddDialAction m_addDialAction;
    private RemoveDialAction m_removeDialAction;
    private Composite m_dialsHolder;
    private List<AttributeDial> m_attributeDials;
    private final RefreshController m_refreshController;

    public CombinedDialsSectionPart(Composite parent, FormToolkit toolkit, int style, String sectionIdentifier) {
        super(parent, toolkit, style, sectionIdentifier);
        this.m_refreshController = new RefreshController(parent.getDisplay());
    }

    @Override
    public void dispose() {
        this.getController().stop();
        super.dispose();
    }

    private RefreshController getController() {
        return this.m_refreshController;
    }

    public void initializePart() {
        super.initializePart();
        this.m_addDialAction = new AddDialAction();
        this.getMCToolBarManager().add((IAction)this.m_addDialAction, 0);
        this.m_removeDialAction = new RemoveDialAction();
        this.getMCToolBarManager().add((IAction)this.m_removeDialAction, 0);
    }

    @Override
    protected void updateView(boolean useAccessibilityMode) {
        super.updateView(useAccessibilityMode);
        if (useAccessibilityMode) {
            if (this.m_addDialAction != null && this.getMCToolBarManager().getActions().contains((Object)this.m_addDialAction)) {
                this.getMCToolBarManager().remove((IAction)this.m_addDialAction);
                this.getMCToolBarManager().remove((IAction)this.m_removeDialAction);
            }
        } else if (this.m_addDialAction != null && !this.getMCToolBarManager().getActions().contains((Object)this.m_addDialAction)) {
            this.getMCToolBarManager().add((IAction)this.m_addDialAction, 0);
            this.getMCToolBarManager().add((IAction)this.m_removeDialAction, 0);
        }
    }

    @Override
    protected Control createGraphicalControl(Composite parent, final FormToolkit formToolkit, final FreezeModel freezeModel) {
        final ScrolledComposite sc = new ScrolledComposite(parent, 768);
        formToolkit.adapt((Composite)sc);
        this.m_dialsHolder = formToolkit.createComposite((Composite)sc);
        final GridLayout gridLayout = new GridLayout(0, true);
        gridLayout.horizontalSpacing = 0;
        this.m_dialsHolder.setLayout((Layout)gridLayout);
        final IAttributeChangeListener attributeChangeListener = new IAttributeChangeListener(){

            @Override
            public void attributeChanged(AttributeChangeEvent e) {
                CombinedDialsSectionPart.this.getAttributeModel().change(e.getOldAttribute(), e.getNewAttribute());
            }
        };
        this.m_attributeDials = new ArrayList<AttributeDial>();
        this.getAttributeModel().addAttributeModelListener(new IAttributeModelListener(){

            @Override
            public void attributeAdded(AttributeModelEvent event, boolean enabled) {
                MRI attribute = event.getAttribute();
                ++gridLayout.numColumns;
                AttributeDial attributeDial = new AttributeDial(CombinedDialsSectionPart.this.getAttributeModel(), freezeModel, CombinedDialsSectionPart.this.getConnectionHandle());
                Control dialControl = attributeDial.createDialControl(CombinedDialsSectionPart.this.m_dialsHolder, formToolkit, new IAction[]{new RemoveAction(attributeDial)});
                attributeDial.configureDial(AttributeDialConfigurationPage.createDefaultDialConfiguration(CombinedDialsSectionPart.this.getConnectionHandle(), attribute), attribute);
                dialControl.setLayoutData((Object)new GridData(4, 4, true, true));
                CombinedDialsSectionPart.this.m_attributeDials.add(attributeDial);
                attributeDial.addAttributeChangeListener(attributeChangeListener);
                CombinedDialsSectionPart.this.m_dialsHolder.layout(true, true);
                CombinedDialsSectionPart.this.resizeScrollableComposite(sc);
                if (gridLayout.numColumns == 1 && CombinedDialsSectionPart.this.m_removeDialAction != null) {
                    CombinedDialsSectionPart.this.m_removeDialAction.setEnabled(true);
                    CombinedDialsSectionPart.this.getMCToolBarManager().update();
                }
                CombinedDialsSectionPart.this.getController().add((IRefreshable)attributeDial.getDialViewer());
                CombinedDialsSectionPart.this.getController().start();
            }

            @Override
            public void attributeRemoved(AttributeModelEvent event) {
                MRI attribute = event.getAttribute();
                for (AttributeDial attributeDial : CombinedDialsSectionPart.this.m_attributeDials) {
                    if (attribute == null || !attribute.equals((Object)attributeDial.getAttribute())) continue;
                    attributeDial.removeAttributeChangeListener(attributeChangeListener);
                    CombinedDialsSectionPart.this.m_attributeDials.remove((Object)attributeDial);
                    attributeDial.dispose();
                    --gridLayout.numColumns;
                    if (!CombinedDialsSectionPart.this.m_dialsHolder.isDisposed()) {
                        CombinedDialsSectionPart.this.m_dialsHolder.layout(true, true);
                        CombinedDialsSectionPart.this.resizeScrollableComposite(sc);
                        CombinedDialsSectionPart.this.getController().remove((IRefreshable)attributeDial.getDialViewer());
                        if (gridLayout.numColumns == 0) {
                            if (CombinedDialsSectionPart.this.m_removeDialAction != null) {
                                CombinedDialsSectionPart.this.m_removeDialAction.setEnabled(false);
                                CombinedDialsSectionPart.this.getMCToolBarManager().update();
                            }
                            CombinedDialsSectionPart.this.getController().stop();
                        }
                    }
                    return;
                }
            }

            @Override
            public void attributeChanged(AttributeModelEvent event) {
            }
        });
        sc.setContent((Control)this.m_dialsHolder);
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                CombinedDialsSectionPart.this.resizeScrollableComposite(sc);
            }
        });
        return sc;
    }

    private void resizeScrollableComposite(ScrolledComposite sc) {
        Point size = this.m_dialsHolder.computeSize(-1, -1);
        sc.setMinSize(size);
    }

    private void removeLastDial() {
        if (this.m_attributeDials.size() > 0) {
            this.remove(this.m_attributeDials.get(this.m_attributeDials.size() - 1).getAttribute());
        }
    }

    public String getComponentTag() {
        return TAG_COMBINED_DIALS_SECTION_PART;
    }

    @Override
    protected void exportExtraToXml(Element node) {
        super.exportExtraToXml(node);
        for (AttributeDial dial : this.m_attributeDials) {
            dial.exportToXml(node);
        }
    }

    @Override
    protected void initializeExtraFromXml(Element node) throws Exception {
        super.initializeExtraFromXml(node);
        List l = XmlToolkit.getChildElementsByTag((Node)node, (String)"AttributeDial");
        int i = 0;
        while (i < this.m_attributeDials.size()) {
            this.m_attributeDials.get(i).initializeSettingsFromXml((Element)l.get(i));
            ++i;
        }
    }

    private class AddDialAction
    extends Action {
        public AddDialAction() {
            super("", RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj.gif"));
            this.setToolTipText(Messages.DashboardSectionPart_ADD_DIAL_ACTION_TEXT);
            this.setText(Messages.DashboardSectionPart_ADD_DIAL_ACTION_TEXT);
            this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("add-obj-off.gif"));
            this.setId("add.dial");
        }

        public void run() {
            AttributeDialConfigurationPage dp = new AttributeDialConfigurationPage(CombinedDialsSectionPart.this.getConnectionHandle(), CombinedDialsSectionPart.this.getAttributeModel().getAttributeDescriptors());
            OnePageWizardDialog dialog = new OnePageWizardDialog(CombinedDialsSectionPart.this.getSection().getShell(), (IWizardPage)dp);
            dialog.setTitle(Messages.AttributeDialSectionPart_CONFIGURE_DIAL_TITLE_TEXT);
            if (dialog.open() == 0) {
                MRI selectedAttribute = dp.getAttribute();
                CombinedDialsSectionPart.this.add(selectedAttribute);
                for (AttributeDial attributeDial : CombinedDialsSectionPart.this.m_attributeDials) {
                    if (!attributeDial.getAttribute().equals((Object)selectedAttribute)) continue;
                    attributeDial.configureDial(dp.getConfiguration(), selectedAttribute);
                    return;
                }
            }
        }
    }

    private class RemoveAction
    extends Action {
        private final AttributeDial m_dial;

        public RemoveAction(AttributeDial dial) {
            this.setImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("remove-obj.png"));
            this.setText(Messages.DashboardSectionPart_REMOVE_CONTROL_TEXT);
            this.setToolTipText(Messages.DashboardSectionPart_REMOVE_CONTROL_TEXT);
            this.m_dial = dial;
        }

        public void run() {
            CombinedDialsSectionPart.this.remove(this.m_dial.getAttribute());
        }
    }

    private class RemoveDialAction
    extends Action {
        public RemoveDialAction() {
            super("", RJMXUIPlugin.getDefault().getMCImageDescriptor("remove-obj.png"));
            this.setToolTipText(Messages.DashboardSectionPart_REMOVE_DIAL_ACTION_TEXT);
            this.setText(Messages.DashboardSectionPart_REMOVE_DIAL_ACTION_TEXT);
            this.setDisabledImageDescriptor(RJMXUIPlugin.getDefault().getMCImageDescriptor("remove-obj-off.gif"));
            this.setId("remove.dial");
        }

        public void run() {
            CombinedDialsSectionPart.this.removeLastDial();
        }
    }
}

