/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.DefaultTreeNode;
import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.IConnectionHandle;
import com.jrockit.mc.rjmx.subscription.IMBeanHelperService;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataService;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.subscription.internal.DefaultMRIMetaDataService;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeOrderRefreshJob;
import com.jrockit.mc.ui.misc.DialogToolkit;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import java.util.Set;
import javax.management.ObjectName;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TreeItem;

public class MBeanTreeContentProvider
implements ITreeContentProvider,
MBeanPropertiesOrderer.IMBeanPropertiesOrderChangedListener {
    private IMRIMetaDataService metaDataService;
    private IConnectionHandle connectionHandle;
    private DefaultTreeNode[] domainNodes;
    private AttributeModelObserver treeUpdater;
    private boolean showOnlyBeans;
    private MBeanTreeOrderRefreshJob refreshJob;

    public MBeanTreeContentProvider(final TreeViewer treeViewer, boolean showOnlyBeans) {
        this.showOnlyBeans = showOnlyBeans;
        this.treeUpdater = new AttributeModelObserver(treeViewer);
        treeViewer.getTree().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseExit(MouseEvent e) {
                treeViewer.getTree().setToolTipText(null);
            }

            public void mouseHover(MouseEvent e) {
                if (treeViewer.getTree().isDisposed()) {
                    return;
                }
                TreeItem item = treeViewer.getTree().getItem(new Point(e.x, e.y));
                if (item == null) {
                    treeViewer.getTree().setToolTipText(null);
                    return;
                }
                Object data = ((ITreeNode)item.getData()).getUserData();
                if (data instanceof MBeanPropertiesOrderer.Property) {
                    MBeanPropertiesOrderer.Property property = (MBeanPropertiesOrderer.Property)data;
                    treeViewer.getTree().setToolTipText(String.valueOf(property.getKey()) + " = " + property.getValue());
                } else if (data instanceof IMRIMetaData && MBeanTreeContentProvider.this.connectionHandle != null) {
                    IMRIMetaData attributeInfo = (IMRIMetaData)data;
                    treeViewer.getTree().setToolTipText(String.valueOf(MRIMetaDataToolkit.getDisplayName((IConnectionHandle)MBeanTreeContentProvider.this.connectionHandle, (MRI)attributeInfo.getMRI())) + " - " + MBeanPropertiesOrderer.getAttributePath(attributeInfo.getMRI()));
                } else if (data != null) {
                    treeViewer.getTree().setToolTipText(null);
                }
            }
        });
        this.refreshJob = new MBeanTreeOrderRefreshJob(treeViewer);
        MBeanPropertiesOrderer.addPropertiesOrderChangedListener(this);
    }

    public Object[] getChildren(Object parentElement) {
        ITreeNode[] nodeChildren = ((ITreeNode)parentElement).getChildren();
        if (nodeChildren == null) {
            return new ITreeNode[0];
        }
        Object[] children = new ITreeNode[nodeChildren.length];
        System.arraycopy(nodeChildren, 0, children, 0, nodeChildren.length);
        return children;
    }

    public Object getParent(Object element) {
        return ((ITreeNode)element).getParent();
    }

    public boolean hasChildren(Object element) {
        ITreeNode[] children = ((ITreeNode)element).getChildren();
        return children != null && children.length > 0;
    }

    public Object[] getElements(Object inputElement) {
        if (this.domainNodes == null) {
            return new ITreeNode[0];
        }
        Object[] elements = new ITreeNode[this.domainNodes.length];
        System.arraycopy(this.domainNodes, 0, elements, 0, this.domainNodes.length);
        return elements;
    }

    public void dispose() {
        this.domainNodes = null;
        MBeanPropertiesOrderer.removePropertiesOrderChangedListener(this);
        this.refreshJob = null;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        if (newInput == null) {
            this.domainNodes = null;
            return;
        }
        if (this.metaDataService != null) {
            ((DefaultMRIMetaDataService)this.metaDataService).deleteObserver((Observer)this.treeUpdater);
        }
        this.connectionHandle = (IConnectionHandle)newInput;
        this.metaDataService = (IMRIMetaDataService)this.connectionHandle.getServiceOrDummy(IMRIMetaDataService.class);
        this.buildContentTree((TreeViewer)viewer);
        ((DefaultMRIMetaDataService)this.metaDataService).addObserver((Observer)this.treeUpdater);
    }

    public ITreeNode findNode(IMRIMetaData attribute) {
        ITreeNode[] set;
        MRI descriptor = attribute.getMRI();
        ObjectName bean = descriptor.getObjectName();
        ITreeNode node = this.findNode(bean);
        if (node == null) {
            return null;
        }
        ITreeNode[] iTreeNodeArray = set = node.getChildren();
        int n = set.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode element = iTreeNodeArray[n2];
            node = this.findAttribute(attribute, element);
            if (node != null) {
                return node;
            }
            ++n2;
        }
        return null;
    }

    public ITreeNode findNode(ObjectName bean) {
        String domain = bean.getDomain();
        MBeanPropertiesOrderer.Property[] properties = MBeanPropertiesOrderer.getOrderedProperties(bean);
        DefaultTreeNode node = null;
        DefaultTreeNode[] set = this.domainNodes;
        boolean found = false;
        int j = 0;
        while (j < set.length) {
            if (set[j].getUserData().equals(domain)) {
                node = set[j];
                set = set[j].getChildren();
                found = true;
                break;
            }
            ++j;
        }
        if (!found) {
            return null;
        }
        MBeanPropertiesOrderer.Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanPropertiesOrderer.Property propertie = propertyArray[n2];
            found = false;
            int j2 = 0;
            while (j2 < set.length) {
                if (set[j2].getUserData().equals(propertie)) {
                    node = set[j2];
                    set = set[j2].getChildren();
                    found = true;
                    break;
                }
                ++j2;
            }
            if (!found) {
                return null;
            }
            ++n2;
        }
        return node;
    }

    private ITreeNode findAttribute(IMRIMetaData attribute, ITreeNode node) {
        IMRIMetaData nodeAttribute = (IMRIMetaData)node.getUserData();
        if (nodeAttribute.equals(attribute)) {
            return node;
        }
        if (attribute.getMRI().getQualifiedName().startsWith(nodeAttribute.getMRI().getQualifiedName())) {
            ITreeNode[] children = node.getChildren();
            if (children == null) {
                return null;
            }
            ITreeNode[] iTreeNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                ITreeNode element = iTreeNodeArray[n2];
                node = this.findAttribute(attribute, element);
                if (node != null) {
                    return node;
                }
                ++n2;
            }
        }
        return null;
    }

    void buildContentTree(TreeViewer viewer) {
        Set<MRI> connectorAttributeSet = this.filterRootMembers(this.metaDataService.getAvailableMRIsOnServer());
        HashMap<ObjectName, List<DefaultTreeNode>> beanToAttributeNodeMap = new HashMap<ObjectName, List<DefaultTreeNode>>();
        for (MRI descriptor : connectorAttributeSet) {
            this.mapObjectNameToAttributeNode((Viewer)viewer, beanToAttributeNodeMap, descriptor.getObjectName(), this.metaDataService.getMetaData(descriptor));
        }
        HashMap<String, ITreeNode> propertyToNodeMap = new HashMap<String, ITreeNode>();
        HashMap<String, List<ITreeNode>> propertyToChildrenMap = new HashMap<String, List<ITreeNode>>();
        Iterator<Object> beanIterator = beanToAttributeNodeMap.keySet().iterator();
        while (beanIterator.hasNext()) {
            this.mapPropertiesToNodes(propertyToNodeMap, propertyToChildrenMap, (ObjectName)beanIterator.next());
        }
        try {
            Iterator castedIterator = ((IMBeanHelperService)this.connectionHandle.getServiceOrDummy(IMBeanHelperService.class)).getMBeanNames().iterator();
            beanIterator = castedIterator;
            while (beanIterator.hasNext()) {
                ObjectName bean = (ObjectName)beanIterator.next();
                this.mapPropertiesToNodes(propertyToNodeMap, propertyToChildrenMap, bean);
                if (beanToAttributeNodeMap.containsKey(bean)) continue;
                beanToAttributeNodeMap.put(bean, new ArrayList());
            }
        }
        catch (IOException e) {
            DialogToolkit.showException((Shell)Display.getCurrent().getActiveShell(), (String)e.getMessage(), (Throwable)e);
        }
        this.connectPropertyTree((Viewer)viewer, propertyToNodeMap, propertyToChildrenMap, beanToAttributeNodeMap);
    }

    private Set<MRI> filterRootMembers(Set<MRI> connectorAttributeSet) {
        HashSet<MRI> filteredAttributeSet = new HashSet<MRI>();
        for (MRI mri : connectorAttributeSet) {
            if (mri.getDataPath().indexOf(47) >= 0) continue;
            filteredAttributeSet.add(mri);
        }
        connectorAttributeSet = filteredAttributeSet;
        return connectorAttributeSet;
    }

    private void mapObjectNameToAttributeNode(Viewer viewer, Map<ObjectName, List<DefaultTreeNode>> beanToAttributeNodeMap, ObjectName bean, Object object) {
        if (object instanceof IMRIMetaData) {
            List<DefaultTreeNode> attributeList = beanToAttributeNodeMap.get(bean);
            if (attributeList == null) {
                attributeList = new ArrayList<DefaultTreeNode>();
                beanToAttributeNodeMap.put(bean, attributeList);
            }
            attributeList.add(this.createAttributeNode(viewer, null, (IMRIMetaData)object));
        } else if (object instanceof Collection) {
            Iterator memberIterator = ((Collection)object).iterator();
            while (memberIterator.hasNext()) {
                this.mapObjectNameToAttributeNode(viewer, beanToAttributeNodeMap, bean, memberIterator.next());
            }
        } else {
            throw new IllegalArgumentException("Can only map beans to AttributeInfo objects or collections.");
        }
    }

    private DefaultTreeNode createAttributeNode(Viewer viewer, DefaultTreeNode parent, IMRIMetaData info) {
        DefaultTreeNode attributeNode = new DefaultTreeNode((ITreeNode)parent, (Object)info);
        if (!this.showOnlyBeans && MRIMetaDataToolkit.isComposite((IMRIMetaDataProvider)info)) {
            IMRIMetaData[] subAttributes = MRIMetaDataToolkit.getCompositeChildren((IConnectionHandle)this.connectionHandle, (IMRIMetaData)info);
            DefaultTreeNode[] subNodes = new DefaultTreeNode[subAttributes.length];
            int i = 0;
            while (i < subAttributes.length) {
                subNodes[i] = this.createAttributeNode(viewer, attributeNode, subAttributes[i]);
                ++i;
            }
            this.sortNodes(viewer, subNodes);
            attributeNode.setChildren((ITreeNode[])subNodes);
        }
        return attributeNode;
    }

    private void sortNodes(Viewer viewer, DefaultTreeNode[] nodes) {
        ViewerSorter sorter;
        if (viewer instanceof TreeViewer && (sorter = ((TreeViewer)viewer).getSorter()) != null) {
            sorter.sort(viewer, (Object[])nodes);
        }
    }

    private void mapPropertiesToNodes(Map<String, ITreeNode> propertyToNodeMap, Map<String, List<ITreeNode>> propertyToChildrenMap, ObjectName bean) {
        MBeanPropertiesOrderer.Property[] properties = MBeanPropertiesOrderer.getOrderedProperties(bean);
        String parentPropertiesString = bean.getDomain();
        ITreeNode parentNode = propertyToNodeMap.get(parentPropertiesString);
        if (parentNode == null) {
            parentNode = new DefaultTreeNode((Object)parentPropertiesString);
            propertyToNodeMap.put(parentPropertiesString, parentNode);
        }
        StringBuilder propertiesStringBuilder = new StringBuilder();
        propertiesStringBuilder.append(parentPropertiesString);
        propertiesStringBuilder.append(':');
        MBeanPropertiesOrderer.Property[] propertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            MBeanPropertiesOrderer.Property property = propertyArray[n2];
            propertiesStringBuilder.append(property.getKey());
            propertiesStringBuilder.append('=');
            propertiesStringBuilder.append(property.getValue());
            String propertiesString = propertiesStringBuilder.toString();
            ITreeNode propertyNode = propertyToNodeMap.get(propertiesString);
            if (propertyNode == null) {
                propertyNode = new DefaultTreeNode(parentNode, (Object)property);
                propertyToNodeMap.put(propertiesString, propertyNode);
                if (parentNode != null) {
                    List<ITreeNode> parentChildren = propertyToChildrenMap.get(parentPropertiesString);
                    if (parentChildren == null) {
                        parentChildren = new ArrayList<ITreeNode>();
                        propertyToChildrenMap.put(parentPropertiesString, parentChildren);
                    }
                    parentChildren.add(propertyNode);
                }
            }
            parentNode = propertyNode;
            parentPropertiesString = propertiesString;
            propertiesStringBuilder.append(',');
            ++n2;
        }
    }

    private void connectPropertyTree(Viewer viewer, Map<String, ITreeNode> propertyToNodeMap, Map<String, List<ITreeNode>> propertyToChildrenMap, Map<ObjectName, List<DefaultTreeNode>> beanToAttributeNodeMap) {
        Iterator<Map.Entry<String, ITreeNode>> nodeEntryIterator = propertyToNodeMap.entrySet().iterator();
        ArrayList<DefaultTreeNode> domainNodesList = new ArrayList<DefaultTreeNode>();
        while (nodeEntryIterator.hasNext()) {
            List<ITreeNode> propertyChildren;
            Map.Entry<String, ITreeNode> nodeEntry = nodeEntryIterator.next();
            DefaultTreeNode propertyNode = (DefaultTreeNode)nodeEntry.getValue();
            if (propertyNode.getParent() == null) {
                domainNodesList.add(propertyNode);
            }
            if ((propertyChildren = propertyToChildrenMap.get(nodeEntry.getKey())) == null) {
                if (this.showOnlyBeans) continue;
                ObjectName bean = ((MBeanPropertiesOrderer.PropertyWithMBean)propertyNode.getUserData()).getBean();
                List<DefaultTreeNode> attributeList = beanToAttributeNodeMap.get(bean);
                DefaultTreeNode[] children = attributeList.toArray(new DefaultTreeNode[attributeList.size()]);
                this.sortNodes(viewer, children);
                propertyNode.setChildren((ITreeNode[])children);
                DefaultTreeNode[] defaultTreeNodeArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    DefaultTreeNode element = defaultTreeNodeArray[n2];
                    element.setParent((ITreeNode)propertyNode);
                    ++n2;
                }
                continue;
            }
            DefaultTreeNode[] children = propertyChildren.toArray(new DefaultTreeNode[propertyChildren.size()]);
            this.sortNodes(viewer, children);
            propertyNode.setChildren((ITreeNode[])children);
        }
        this.domainNodes = domainNodesList.toArray(new DefaultTreeNode[domainNodesList.size()]);
    }

    public boolean isShowOnlyBeans() {
        return this.showOnlyBeans;
    }

    @Override
    public void propertiesOrderChanged(PropertyChangeEvent e) {
        if (!e.getProperty().equals("console.ui.mbeanbrowser.showCompressedPaths")) {
            this.refreshJob.schedule();
        }
    }

    private static class AttributeModelObserver
    implements Observer {
        private final TreeViewer treeViewer;

        public AttributeModelObserver(TreeViewer treeViewer) {
            this.treeViewer = treeViewer;
        }

        @Override
        public void update(Observable source, final Object o) {
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    if (!AttributeModelObserver.this.treeViewer.getTree().isDisposed()) {
                        if (o instanceof IMRIMetaData) {
                            AttributeModelObserver.this.treeViewer.refresh(o);
                        } else {
                            AttributeModelObserver.this.treeViewer.refresh();
                        }
                    }
                }
            });
        }
    }
}

