/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.subscription.IMRIMetaDataProvider;
import com.jrockit.mc.rjmx.subscription.MRI;
import com.jrockit.mc.rjmx.subscription.MRIMetaDataToolkit;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import java.util.HashSet;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class MBeanTreeLabelProvider
implements ILabelProvider {
    private final TreeViewer associatedViewer;
    private final HashSet<ILabelProviderListener> labelProviderListeners = new HashSet();

    public MBeanTreeLabelProvider(TreeViewer associatedViewer) {
        this.associatedViewer = associatedViewer;
    }

    public Image getConsoleImage(String imageKey) {
        return RJMXUIPlugin.getDefault().getImage(imageKey);
    }

    public Image getImage(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
            if (this.associatedViewer.getExpandedState(element)) {
                return this.getConsoleImage("mbean-16.png");
            }
            return this.getConsoleImage("mbean-16.png");
        }
        if (data instanceof String || data instanceof MBeanPropertiesOrderer.Property) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
        }
        if (data instanceof IMRIMetaData) {
            IMRIMetaData info = (IMRIMetaData)data;
            if (this.associatedViewer.getExpandedState(data)) {
                if (info.getMRI().getType() == MRI.Type.NOTIFICATION) {
                    return this.getConsoleImage("composite-attribute-closed-16.png");
                }
                return this.getConsoleImage("composite-attribute-closed-16.png");
            }
            if (MRIMetaDataToolkit.isComposite((IMRIMetaDataProvider)info)) {
                if (info.getMRI().getType() == MRI.Type.NOTIFICATION) {
                    return this.getConsoleImage("composite-attribute-closed-16.png");
                }
                return this.getConsoleImage("composite-attribute-closed-16.png");
            }
            if (MRIMetaDataToolkit.isNumerical((IMRIMetaData)info)) {
                return this.getConsoleImage("numerical-attribute-16.png");
            }
            return this.getConsoleImage("non-numerical-attribute-16.png");
        }
        throw new IllegalArgumentException("This label provider only supports the ObjectName and AttributeInfo types.");
    }

    public String getText(Object element) {
        Object data = ((ITreeNode)element).getUserData();
        if (data instanceof String) {
            return (String)data;
        }
        if (data instanceof MBeanPropertiesOrderer.Property) {
            return this.formatProperty((MBeanPropertiesOrderer.Property)data);
        }
        if (data instanceof IMRIMetaData) {
            String dataPath = ((IMRIMetaData)data).getMRI().getDataPath();
            return dataPath.substring(dataPath.lastIndexOf(47) + 1);
        }
        throw new IllegalArgumentException("This label provider only supports the ObjectName and AttributeInfo types.");
    }

    private String formatProperty(MBeanPropertiesOrderer.Property data) {
        String value = data.getValue();
        if (value != null && "class".equals(data.getKey())) {
            return value.substring(value.lastIndexOf(46) + 1);
        }
        return value;
    }

    public void addListener(ILabelProviderListener listener) {
        this.labelProviderListeners.add(listener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
        this.labelProviderListeners.remove(listener);
    }
}

