/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.core.ITreeNode;
import com.jrockit.mc.rjmx.subscription.IMRIMetaData;
import com.jrockit.mc.rjmx.ui.internal.MBeanPropertiesOrderer;
import com.jrockit.mc.rjmx.ui.internal.MBeanTreeContentProvider;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.ui.progress.WorkbenchJob;

public class MBeanTreeOrderRefreshJob
extends WorkbenchJob {
    private final TreeViewer treeViewer;

    public MBeanTreeOrderRefreshJob(TreeViewer treeViewer) {
        super("MBean Tree Order Refresh Job");
        this.treeViewer = treeViewer;
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        this.refreshTree();
        return Status.OK_STATUS;
    }

    private void refreshTree() {
        Object[] oldSelectedObjects = this.retrieveSelectedObjects();
        Object[] oldExpandedObjects = this.retrieveExpandedLeafObjects();
        this.treeViewer.getTree().setRedraw(false);
        MBeanTreeContentProvider treeContentProvider = (MBeanTreeContentProvider)this.treeViewer.getContentProvider();
        treeContentProvider.buildContentTree(this.treeViewer);
        this.treeViewer.refresh(true);
        HashSet<ITreeNode> nodesToExpand = new HashSet<ITreeNode>();
        this.addNodesToExpand(treeContentProvider, nodesToExpand, oldSelectedObjects);
        this.addNodesToExpand(treeContentProvider, nodesToExpand, oldExpandedObjects);
        this.treeViewer.setExpandedElements(nodesToExpand.toArray());
        TreePath[] selectedTreePaths = this.createTreePaths(treeContentProvider, oldSelectedObjects);
        if (selectedTreePaths.length > 0) {
            this.treeViewer.setSelection((ISelection)new TreeSelection(selectedTreePaths));
        }
        this.treeViewer.getTree().setRedraw(true);
        this.treeViewer.getTree().redraw();
    }

    private Object[] retrieveSelectedObjects() {
        ITreeSelection selection = (ITreeSelection)this.treeViewer.getSelection();
        Object[] selectedNodes = selection.toArray();
        ArrayList<Object> selectedObjects = new ArrayList<Object>();
        Object[] objectArray = selectedNodes;
        int n = selectedNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object selectedNode = objectArray[n2];
            ITreeNode node = (ITreeNode)selectedNode;
            if (node.getChildren() == null) {
                selectedObjects.add(node.getUserData());
            }
            ++n2;
        }
        return selectedObjects.toArray();
    }

    private Object[] retrieveExpandedLeafObjects() {
        Object[] expandedNodes = this.treeViewer.getExpandedElements();
        ArrayList<Object> expandedLeafObjects = new ArrayList<Object>();
        Object[] objectArray = expandedNodes;
        int n = expandedNodes.length;
        int n2 = 0;
        while (n2 < n) {
            Object expandedNode = objectArray[n2];
            ITreeNode node = (ITreeNode)expandedNode;
            ITreeNode[] children = node.getChildren();
            if (children == null) {
                expandedLeafObjects.add(node.getUserData());
            } else {
                ITreeNode[] iTreeNodeArray = children;
                int n3 = children.length;
                int n4 = 0;
                while (n4 < n3) {
                    ITreeNode element = iTreeNodeArray[n4];
                    if (element.getChildren() == null) {
                        expandedLeafObjects.add(element.getUserData());
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return expandedLeafObjects.toArray();
    }

    private void addNodesToExpand(MBeanTreeContentProvider treeContentProvider, HashSet<ITreeNode> nodesToExpand, Object[] objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
                this.addNodesToRoot(nodesToExpand, treeContentProvider.findNode(((MBeanPropertiesOrderer.PropertyWithMBean)object).getBean()));
            } else if (object instanceof IMRIMetaData) {
                this.addNodesToRoot(nodesToExpand, treeContentProvider.findNode((IMRIMetaData)object));
            }
            ++n2;
        }
    }

    private void addNodesToRoot(HashSet<ITreeNode> nodesToExpand, ITreeNode node) {
        while (node != null) {
            nodesToExpand.add(node);
            node = node.getParent();
        }
    }

    private TreePath[] createTreePaths(MBeanTreeContentProvider treeContentProvider, Object[] objects) {
        ArrayList<TreePath> treePaths = new ArrayList<TreePath>();
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            ITreeNode node;
            MBeanPropertiesOrderer.PropertyWithMBean new_name;
            Object object = objectArray[n2];
            if (object instanceof MBeanPropertiesOrderer.PropertyWithMBean) {
                new_name = (MBeanPropertiesOrderer.PropertyWithMBean)object;
                node = treeContentProvider.findNode(new_name.getBean());
                if (node != null) {
                    treePaths.add(this.createTreePath(node));
                }
            } else if (object instanceof IMRIMetaData && (node = treeContentProvider.findNode((IMRIMetaData)(new_name = (IMRIMetaData)object))) != null) {
                treePaths.add(this.createTreePath(node));
            }
            ++n2;
        }
        return treePaths.toArray(new TreePath[treePaths.size()]);
    }

    private TreePath createTreePath(ITreeNode node) {
        LinkedList<ITreeNode> nodes = new LinkedList<ITreeNode>();
        while (node != null) {
            nodes.addFirst(node);
            node = node.getParent();
        }
        return new TreePath(nodes.toArray());
    }
}

