/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.common.util.Filter;
import com.jrockit.mc.common.util.FilteredIterator;
import com.jrockit.mc.rjmx.subscription.MRIValueEvent;
import java.util.Iterator;
import se.hirt.greychart.data.DefaultTimestampedData;
import se.hirt.greychart.data.ITimestampedData;

public class MultiplierIterator
implements Iterator<ITimestampedData> {
    private final Iterator<? extends MRIValueEvent> m_iterator;
    private final double m_multiplier;

    public MultiplierIterator(Iterator<? extends MRIValueEvent> iterator, double multiplier) {
        this.m_iterator = this.createValidNumericIterator(iterator);
        this.m_multiplier = multiplier;
    }

    private <E extends MRIValueEvent> Iterator<E> createValidNumericIterator(Iterator<E> iterator) {
        return new FilteredIterator(iterator, (Filter)new Filter<MRIValueEvent>(){

            public boolean accept(MRIValueEvent event) {
                return event != null && event.getValue() instanceof Number;
            }
        });
    }

    @Override
    public boolean hasNext() {
        return this.m_iterator.hasNext();
    }

    @Override
    public ITimestampedData next() {
        MRIValueEvent event = this.m_iterator.next();
        return new DefaultTimestampedData(Long.valueOf(event.getTimestamp() * 1000L * 1000L), (Number)(((Number)event.getValue()).doubleValue() * this.m_multiplier));
    }

    @Override
    public void remove() {
        this.m_iterator.remove();
    }
}

