/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.internal;

import com.jrockit.mc.rjmx.subscription.MRIValue;
import java.math.BigDecimal;
import java.math.BigInteger;

class ValueStatistics {
    private Object lastValue;
    private long startTimeStamp;
    private long lastTimeStamp;
    private Object averageValue;
    private Object minimumValue;
    private long minimumTimeStamp;
    private Object maximumValue;
    private long maximumTimeStamp;

    public ValueStatistics(Object value, long timeStamp) {
        this.resetStatistics(value, timeStamp);
    }

    public void updateStatistics(Object value, long timeStamp) {
        if (this.lastValue == null) {
            this.resetStatistics(value, timeStamp);
        } else if (value instanceof Number) {
            this.updateNumberStatistics((Number)value, timeStamp);
        } else if (value instanceof Comparable) {
            this.updateComparableStatistics((Comparable)value, timeStamp);
        } else {
            this.resetStatistics(value, timeStamp);
        }
    }

    private void updateNumberStatistics(Number number, long timeStamp) {
        if (number instanceof BigDecimal) {
            this.updateBigDecimalStatistics((BigDecimal)number, timeStamp);
        } else if (number instanceof BigInteger) {
            this.updateBigIntegerStatistics((BigInteger)number, timeStamp);
        } else {
            long totalInterval;
            if (number.doubleValue() < ((Number)this.minimumValue).doubleValue()) {
                this.minimumValue = number;
                this.minimumTimeStamp = timeStamp;
            }
            if (number.doubleValue() > ((Number)this.maximumValue).doubleValue()) {
                this.maximumValue = number;
                this.maximumTimeStamp = timeStamp;
            }
            if ((totalInterval = timeStamp - this.startTimeStamp) > 0L && this.minimumValue != this.maximumValue) {
                double average = ((Number)this.averageValue).doubleValue() * ((double)(this.lastTimeStamp - this.startTimeStamp) / (double)totalInterval);
                if ((average += (number.doubleValue() + ((Number)this.lastValue).doubleValue()) / 2.0 * ((double)(timeStamp - this.lastTimeStamp) / (double)totalInterval)) < ((Number)this.minimumValue).doubleValue()) {
                    average = ((Number)this.minimumValue).doubleValue();
                } else if (average > ((Number)this.maximumValue).doubleValue()) {
                    average = ((Number)this.maximumValue).doubleValue();
                }
                this.averageValue = average;
            }
            this.lastValue = number;
            this.lastTimeStamp = timeStamp;
        }
    }

    private void updateBigDecimalStatistics(BigDecimal number, long timeStamp) {
        long totalInterval;
        if (number.compareTo((BigDecimal)this.minimumValue) < 0) {
            this.minimumValue = number;
            this.minimumTimeStamp = timeStamp;
        }
        if (number.compareTo((BigDecimal)this.maximumValue) > 0) {
            this.maximumValue = number;
            this.maximumTimeStamp = timeStamp;
        }
        if ((totalInterval = timeStamp - this.startTimeStamp) > 0L && this.minimumValue != this.maximumValue) {
            BigDecimal average = ((BigDecimal)this.averageValue).multiply(new BigDecimal((double)(this.lastTimeStamp - this.startTimeStamp) / (double)totalInterval));
            if ((average = average.add(number.add((BigDecimal)this.lastValue).multiply(new BigDecimal(0.5 * (double)(timeStamp - this.lastTimeStamp) / (double)totalInterval)))).compareTo((BigDecimal)this.minimumValue) < 0) {
                average = (BigDecimal)this.minimumValue;
            } else if (average.compareTo((BigDecimal)this.maximumValue) > 0) {
                average = (BigDecimal)this.maximumValue;
            }
            this.averageValue = average;
        }
        this.lastValue = number;
        this.lastTimeStamp = timeStamp;
    }

    private void updateBigIntegerStatistics(BigInteger number, long timeStamp) {
        long totalInterval;
        if (number.compareTo((BigInteger)this.minimumValue) < 0) {
            this.minimumValue = number;
            this.minimumTimeStamp = timeStamp;
        }
        if (number.compareTo((BigInteger)this.maximumValue) > 0) {
            this.maximumValue = number;
            this.maximumTimeStamp = timeStamp;
        }
        if ((totalInterval = timeStamp - this.startTimeStamp) > 0L && this.minimumValue != this.maximumValue) {
            BigDecimal average = ((BigDecimal)this.averageValue).multiply(new BigDecimal((double)(this.lastTimeStamp - this.startTimeStamp) / (double)totalInterval));
            if ((average = average.add(new BigDecimal(number.add((BigInteger)this.lastValue)).multiply(new BigDecimal(0.5 * (double)(timeStamp - this.lastTimeStamp) / (double)totalInterval)))).compareTo(new BigDecimal((BigInteger)this.minimumValue)) < 0) {
                average = new BigDecimal((BigInteger)this.minimumValue);
            } else if (average.compareTo(new BigDecimal((BigInteger)this.maximumValue)) > 0) {
                average = new BigDecimal((BigInteger)this.maximumValue);
            }
            this.averageValue = average;
        }
        this.lastValue = number;
        this.lastTimeStamp = timeStamp;
    }

    private <T> void updateComparableStatistics(Comparable<T> value, long timestamp) {
        if (!this.lastValue.getClass().isInstance(value)) {
            this.resetStatistics(value, timestamp);
            return;
        }
        this.lastValue = value;
        this.lastTimeStamp = timestamp;
        this.averageValue = null;
        if (value.compareTo(this.minimumValue) < 0) {
            this.minimumValue = value;
            this.minimumTimeStamp = timestamp;
        } else if (value.compareTo(this.maximumValue) > 0) {
            this.maximumValue = value;
            this.maximumTimeStamp = timestamp;
        }
    }

    public void resetStatistics() {
        this.resetStatistics(this.lastValue, this.lastTimeStamp);
    }

    public void resetStatistics(Object value, long timeStamp) {
        this.lastValue = value;
        if (value instanceof Comparable) {
            this.minimumValue = this.maximumValue = value;
            this.averageValue = value instanceof Number ? value : null;
        } else if (value == MRIValue.UNAVAILABLE_VALUE) {
            this.maximumValue = this.averageValue = value;
            this.minimumValue = this.averageValue;
        } else {
            this.maximumValue = null;
            this.minimumValue = null;
            this.averageValue = null;
        }
        this.minimumTimeStamp = this.maximumTimeStamp = timeStamp;
        this.lastTimeStamp = this.maximumTimeStamp;
        this.startTimeStamp = this.maximumTimeStamp;
    }

    public Object getLastValue() {
        return this.lastValue;
    }

    public long getLastTimestamp() {
        return this.lastTimeStamp;
    }

    public Object getAverageValue() {
        return this.averageValue;
    }

    public Object getMinimumValue() {
        return this.minimumValue;
    }

    public long getMinimumTimestamp() {
        return this.minimumTimeStamp;
    }

    public Object getMaximumValue() {
        return this.maximumValue;
    }

    public long getMaximumTimestamp() {
        return this.maximumTimeStamp;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getName());
        sb.append('[');
        sb.append(this.lastValue);
        sb.append('@');
        sb.append(this.lastTimeStamp);
        if (this.averageValue != null) {
            sb.append(",average ");
            sb.append(this.averageValue);
        }
        if (this.minimumValue != null) {
            sb.append(",minimum ");
            sb.append(this.minimumValue);
            sb.append('@');
            sb.append(this.minimumTimeStamp);
        }
        if (this.maximumValue != null) {
            sb.append(",maximum ");
            sb.append(this.maximumValue);
            sb.append('@');
            sb.append(this.maximumTimeStamp);
        }
        sb.append(']');
        return sb.toString();
    }
}

