/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.operations;

import com.jrockit.mc.rjmx.services.IOperation;
import com.jrockit.mc.rjmx.ui.column.AttributeInspector;
import com.jrockit.mc.rjmx.ui.operations.InvocatorBuilderForm;
import com.jrockit.mc.rjmx.ui.operations.Messages;
import com.jrockit.mc.rjmx.ui.operations.OperationsLabelProvider;
import com.jrockit.mc.rjmx.util.internal.DefaultAttribute;
import com.jrockit.mc.ui.UIPlugin;
import com.jrockit.mc.ui.misc.ErrorDialog;
import java.text.DateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class ExecuteOperationForm
extends SashForm {
    private Text commandText;
    private CTabFolder results;
    private Button helpButton;
    private Button invokeButton;
    private InvocatorBuilderForm invocatorForm;
    private Callable<?> invocator;
    private Callable<?> helpInvocator;
    private Composite buttonContainer;

    public ExecuteOperationForm(Composite parent, IManagedForm form, FormToolkit formToolkit, String sectionId, boolean showOperationReturnType, IDialogSettings settings) {
        this(parent, form, formToolkit, sectionId, showOperationReturnType, settings, null);
    }

    public ExecuteOperationForm(Composite parent, IManagedForm form, final FormToolkit formToolkit, String sectionId, boolean showOperationReturnType, final IDialogSettings settings, final HelpProvider helpProvider) {
        super(parent, 512);
        this.setBackground(formToolkit.getColors().getBackground());
        Composite upperContainer = formToolkit.createComposite((Composite)this);
        upperContainer.setLayout((Layout)new GridLayout());
        IDialogSettings invocatorFormSettings = DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)"invocator_builder");
        this.invocatorForm = new InvocatorBuilderForm(upperContainer, form, formToolkit, showOperationReturnType, invocatorFormSettings, new InvocatorBuilderForm.InvocatorUpdateListener(){

            @Override
            public void onInvocatorUpdated(IOperation operation, Callable<?> invocator) {
                ExecuteOperationForm.this.invocator = invocator;
                if (helpProvider != null && operation != null) {
                    ExecuteOperationForm.this.helpInvocator = helpProvider.getHelpInvocator(operation);
                    ExecuteOperationForm.this.helpButton.setVisible(operation != null);
                    ExecuteOperationForm.this.invokeButton.setEnabled(ExecuteOperationForm.this.helpInvocator != null);
                }
                ExecuteOperationForm.this.invokeButton.setVisible(operation != null);
                ExecuteOperationForm.this.invokeButton.setEnabled(invocator != null);
                ExecuteOperationForm.this.commandText.setText(invocator == null ? "" : invocator.toString());
                ExecuteOperationForm.this.invokeButton.setImage(OperationsLabelProvider.getOperationIcon(operation));
                ExecuteOperationForm.this.buttonContainer.layout(true);
            }
        });
        this.buttonContainer = formToolkit.createComposite(upperContainer);
        this.buttonContainer.setLayoutData((Object)new GridData(768));
        if (helpProvider != null) {
            this.buttonContainer.setLayout((Layout)new GridLayout(3, false));
            this.helpButton = formToolkit.createButton(this.buttonContainer, Messages.ExecuteOperationForm_HELP_LABEL, 8);
            this.helpButton.setImage(UIPlugin.getDefault().getImage("help.gif"));
            this.helpButton.setVisible(false);
            this.helpButton.setLayoutData((Object)new GridData());
        } else {
            this.buttonContainer.setLayout((Layout)new GridLayout(2, false));
        }
        this.invokeButton = formToolkit.createButton(this.buttonContainer, Messages.ExecuteOperationForm_EXECUTE_BUTTON_TEXT, 8);
        this.invokeButton.setVisible(false);
        this.invokeButton.setLayoutData((Object)new GridData());
        this.commandText = new Text(this.buttonContainer, 72);
        this.commandText.setBackground(formToolkit.getColors().getBackground());
        this.commandText.setLayoutData((Object)new GridData(768));
        this.results = new CTabFolder((Composite)this, 262208);
        this.results.setBackground(formToolkit.getColors().getBackground());
        this.results.setVisible(false);
        this.results.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent event) {
                if (ExecuteOperationForm.this.results.getItemCount() <= 1) {
                    ExecuteOperationForm.this.results.setVisible(false);
                    ExecuteOperationForm.this.layout();
                }
            }
        });
        this.addResultsContextMenu();
        this.setWeights(new int[]{2, 1});
        this.invokeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExecuteOperationForm.this.createInvocationResult(formToolkit, settings, ExecuteOperationForm.this.invocator);
            }
        });
        if (helpProvider != null) {
            this.helpButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    ExecuteOperationForm.this.createInvocationResult(formToolkit, settings, ExecuteOperationForm.this.helpInvocator);
                }
            });
        }
    }

    private void createInvocationResult(FormToolkit formToolkit, IDialogSettings settings, Callable<?> invocator) {
        try {
            String resultTitle = NLS.bind((String)Messages.ExecuteOperationForm_RESULT_MSG, (Object)DateFormat.getDateTimeInstance(3, 2).format(new Date()), invocator);
            Object result = invocator.call();
            result = result == null ? "" : result;
            Object[] val = new DefaultAttribute(null, result).getChildren().toArray();
            final CTabItem tab = new CTabItem(this.results, 0);
            tab.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    Control c = tab.getControl();
                    if (c != null && !c.isDisposed()) {
                        c.dispose();
                    }
                }
            });
            tab.setText(resultTitle);
            if (val.length > 0) {
                AttributeInspector structuredResult = new AttributeInspector((Composite)this.results, settings);
                structuredResult.setAttributesUntyped(val);
                tab.setControl((Control)structuredResult);
            } else {
                Text textResult = formToolkit.createText((Composite)this.results, result.toString(), 576);
                tab.setControl((Control)textResult);
            }
            this.results.setVisible(true);
            this.results.setSelection(tab);
            this.layout();
        }
        catch (Exception e1) {
            ErrorDialog.showException((Shell)this.getShell(), (String)Messages.ExecuteOperationForm_FAILED_TO_EXECUTE, (String)NLS.bind((String)Messages.ExecuteOperationForm_FAILED_TO_EXECUTE_MSG, invocator), (Throwable)e1);
        }
    }

    private void addResultsContextMenu() {
        MenuManager mm = new MenuManager();
        mm.add((IAction)new Action(Messages.ExecuteOperationForm_CLOSE_ALL_LABEL){

            public void runWithEvent(Event event) {
                while (ExecuteOperationForm.this.results.getItemCount() != 0) {
                    ExecuteOperationForm.this.results.getItem(0).dispose();
                }
                ExecuteOperationForm.this.results.setVisible(false);
                ExecuteOperationForm.this.layout();
            }
        });
        Menu menu = mm.createContextMenu((Control)this.results);
        this.results.setMenu(menu);
    }

    public void setOperations(Collection<? extends IOperation> input) {
        this.invocatorForm.setOperations(input);
        this.layout(true);
    }

    public static interface HelpProvider {
        public Callable<?> getHelpInvocator(IOperation var1);
    }
}

