/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.rjmx.ui.operations;

import com.jrockit.mc.rjmx.services.IAttributeInfo;
import com.jrockit.mc.rjmx.services.IOperation;
import com.jrockit.mc.rjmx.services.IReadOnlyAttribute;
import com.jrockit.mc.rjmx.services.IllegalOperandException;
import com.jrockit.mc.rjmx.ui.column.AttributeInspector;
import com.jrockit.mc.rjmx.ui.operations.Messages;
import com.jrockit.mc.rjmx.ui.operations.OperationsLabelProvider;
import com.jrockit.mc.rjmx.util.internal.DefaultAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.ColumnViewerToolTipSupport;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;

public class InvocatorBuilderForm
extends SashForm {
    private List<IReadOnlyAttribute> attributes;
    private TableViewer operationsPart;
    private AttributeInspector parametersPart;
    private InvocatorUpdateListener invocatorUpdatedListener;

    public InvocatorBuilderForm(Composite parent, IManagedForm form, FormToolkit formToolkit, boolean showOperationReturnType, IDialogSettings settings, InvocatorUpdateListener invocatorUpdatedListener) {
        super(parent, 256);
        this.invocatorUpdatedListener = invocatorUpdatedListener;
        this.setBackground(formToolkit.getColors().getBackground());
        this.setLayoutData(new GridData(4, 4, true, true));
        this.operationsPart = InvocatorBuilderForm.createIOperationList((Composite)this, showOperationReturnType);
        this.operationsPart.getTable().setHeaderVisible(true);
        this.parametersPart = new AttributeInspector((Composite)this, DialogSettings.getOrCreateSection((IDialogSettings)settings, (String)"attributes"));
        this.parametersPart.enableValueEditing(new Runnable(){

            @Override
            public void run() {
                InvocatorBuilderForm.this.evaluateOperation(InvocatorBuilderForm.this.getSelectedOperation());
            }
        });
        this.parametersPart.setLayoutData(new GridData(4, 4, true, true));
        this.setWeights(new int[]{1, 2});
        this.operationsPart.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IOperation operation = InvocatorBuilderForm.this.getSelectedOperation();
                InvocatorBuilderForm.this.attributes = new ArrayList();
                if (operation != null) {
                    for (IAttributeInfo valueInfo : operation.getSignature()) {
                        InvocatorBuilderForm.this.attributes.add(new DefaultAttribute(valueInfo));
                    }
                }
                InvocatorBuilderForm.this.evaluateOperation(operation);
                InvocatorBuilderForm.this.parametersPart.setAttributes(InvocatorBuilderForm.this.attributes);
            }
        });
    }

    private static TableViewer createIOperationList(Composite parent, boolean showReturns) {
        TableViewer tableViewer = new TableViewer(new Composite(parent, 0), 67588);
        tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        tableViewer.setComparator(new ViewerComparator(){

            public int category(Object element) {
                if (element instanceof IOperation) {
                    return ((IOperation)element).getImpact().ordinal();
                }
                return 0;
            }
        });
        TableColumn tvc = new TableColumn(tableViewer.getTable(), 0);
        tvc.setText(Messages.OperationsSectionPart_TITLE);
        TableColumnLayout l = new TableColumnLayout();
        tableViewer.getTable().getParent().setLayout((Layout)l);
        l.setColumnData((Widget)tvc, (ColumnLayoutData)new ColumnWeightData(1));
        tableViewer.setLabelProvider((IBaseLabelProvider)new OperationsLabelProvider(showReturns));
        ColumnViewerToolTipSupport.enableFor((ColumnViewer)tableViewer);
        return tableViewer;
    }

    public void setOperations(Collection<? extends IOperation> input) {
        this.operationsPart.setInput(input);
    }

    private void evaluateOperation(IOperation operation) {
        try {
            Callable invocator = operation == null ? null : operation.getInvocator(this.getValues());
            this.invocatorUpdatedListener.onInvocatorUpdated(operation, invocator);
        }
        catch (IllegalOperandException e) {
            this.parametersPart.setAttributesInvalid(e.getInvalidValues());
            this.invocatorUpdatedListener.onInvocatorUpdated(operation, null);
        }
    }

    private Object[] getValues() {
        Object[] values = new Object[this.attributes.size()];
        int i = 0;
        while (i < values.length) {
            values[i] = this.attributes.get(i).getValue();
            ++i;
        }
        return values;
    }

    private IOperation getSelectedOperation() {
        IStructuredSelection str;
        ISelection selection = this.operationsPart.getSelection();
        if (!selection.isEmpty() && (str = (IStructuredSelection)selection).getFirstElement() instanceof IOperation) {
            return (IOperation)str.getFirstElement();
        }
        return null;
    }

    public static interface InvocatorUpdateListener {
        public void onInvocatorUpdated(IOperation var1, Callable<?> var2);
    }
}

