/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.views;

import com.jrockit.mc.browser.JVMBrowserPlugin;
import com.jrockit.mc.browser.views.Folder;
import com.jrockit.mc.browser.views.JVMBrowserView;
import com.jrockit.mc.browser.views.Messages;
import com.jrockit.mc.common.jvm.JVMDescriptor;
import com.jrockit.mc.core.AdapterUtil;
import com.jrockit.mc.rjmx.IServerHandle;
import com.jrockit.mc.rjmx.model.IDiscoveryInfo;
import com.jrockit.mc.rjmx.model.IServer;
import com.jrockit.mc.rjmx.ui.RJMXUIPlugin;
import com.jrockit.mc.ui.misc.AdaptingLabelProvider;
import com.jrockit.mc.ui.misc.TwoStateImageDescriptor;
import org.eclipse.jface.resource.DeviceResourceDescriptor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.ui.PlatformUI;

public class BrowserLabelProvider
extends AdaptingLabelProvider {
    private final long highlightServersFoundAfter = System.currentTimeMillis() + 2000L;
    private ImageData connectedOverlay = JVMBrowserPlugin.getDefault().getMCImageDescriptor("overlay_connected.png").getImageData();
    private ImageData disconnectedOverlay = JVMBrowserPlugin.getDefault().getMCImageDescriptor("overlay_disconnected.png").getImageData();
    private Image folderImage = PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
    private Image lockedFolderImage = (Image)this.getResourceManager().get((DeviceResourceDescriptor)new DecorationOverlayIcon(this.folderImage, JVMBrowserPlugin.getDefault().getMCImageDescriptor("padlock.png"), 3));

    public Image getImage(Object obj) {
        if (obj instanceof Folder) {
            return ((Folder)obj).isModifiable() ? this.folderImage : this.lockedFolderImage;
        }
        if (obj instanceof IServer) {
            IServer server = (IServer)obj;
            boolean connected = server.getServerHandle().getState() == IServerHandle.State.CONNECTED;
            ImageDescriptor image = (ImageDescriptor)AdapterUtil.getAdapter((Object)server, ImageDescriptor.class);
            if (image != null) {
                image = new TwoStateImageDescriptor(image, connected, this.connectedOverlay, this.disconnectedOverlay);
                return (Image)this.getResourceManager().get((DeviceResourceDescriptor)image);
            }
            return RJMXUIPlugin.getDefault().getImage(connected ? "connect.gif" : "disconnect.gif");
        }
        return super.getImage(obj);
    }

    public Font getFont(Object o) {
        IDiscoveryInfo di;
        if (o instanceof IServer && (di = ((IServer)o).getDiscoveryInfo()) != null && di.getDiscoveredTimestamp() > this.highlightServersFoundAfter && di.getDiscoveredTimestamp() + (long)JVMBrowserView.getHighlightTime() > System.currentTimeMillis()) {
            return JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont");
        }
        return super.getFont(o);
    }

    public String getText(Object element) {
        if (element instanceof Folder) {
            return ((Folder)element).getName();
        }
        if (element instanceof IServer) {
            return ((IServer)element).getServerHandle().getServerDescriptor().getDisplayName();
        }
        return super.getText(element);
    }

    public String getToolTipText(Object element) {
        if (element instanceof IServer) {
            boolean connected;
            IServerHandle serverHandle = ((IServer)element).getServerHandle();
            JVMDescriptor jvmInfo = serverHandle.getServerDescriptor().getJvmInfo();
            boolean bl = connected = serverHandle.getState() == IServerHandle.State.CONNECTED;
            if (jvmInfo != null) {
                String tt = BrowserLabelProvider.buildTooltip(null, Messages.JVMBrowserView_COMMAND_LINE, jvmInfo.getJavaCommandLine());
                tt = BrowserLabelProvider.buildTooltip(tt, Messages.JVMBrowserView_JAVA_VERSION, jvmInfo.getJavaVersion());
                tt = BrowserLabelProvider.buildTooltip(tt, Messages.JVMBrowserView_TOOLTIP_PID, String.valueOf(jvmInfo.getPid()));
                return BrowserLabelProvider.buildTooltip(tt, Messages.JVMBrowserView_CONNECTION_STATE, connected ? Messages.JVMBrowserView_CONNECTION_STATE_CONNECTED : Messages.JVMBrowserView_CONNECTION_STATE_NOT_CONNECTED);
            }
        }
        return super.getToolTipText(element);
    }

    private static String buildTooltip(String oldString, String title, String value) {
        if (value == null) {
            return oldString;
        }
        String newLine = String.valueOf(title) + ": " + value;
        newLine = newLine.length() > 150 ? String.valueOf(newLine.substring(0, 150)) + "..." : newLine;
        return oldString == null ? newLine : String.valueOf(oldString) + "\n" + newLine;
    }
}

