/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.views;

import com.jrockit.mc.browser.views.Folder;
import com.jrockit.mc.common.ICopyable;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;

public class FolderDndSupport
implements DropTargetListener,
DragSourceListener {
    private int currentOperation;
    private TreeViewer viewer;
    private Folder root;

    public FolderDndSupport(TreeViewer treeViewer, Folder rootFolder) {
        this.viewer = treeViewer;
        this.root = rootFolder;
        Transfer[] transfer = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        int oper = 3;
        this.viewer.addDropSupport(oper, transfer, (DropTargetListener)this);
        this.viewer.addDragSupport(oper, transfer, (DragSourceListener)this);
    }

    public void dragOver(DropTargetEvent event) {
        event.detail = this.getDragOverAction(event);
    }

    public void dragEnter(DropTargetEvent event) {
        this.currentOperation = event.detail == 16 ? 2 : event.detail;
        event.detail = this.getDragOverAction(event);
    }

    public void dragOperationChanged(DropTargetEvent event) {
        this.currentOperation = event.detail == 16 ? 2 : event.detail;
        event.detail = this.getDragOverAction(event);
    }

    public void drop(DropTargetEvent event) {
        boolean copy = event.detail == 1;
        Object element = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (event.item == null) {
            this.doDrop(element, this.root, copy);
        } else if (event.item.getData() instanceof Folder) {
            this.doDrop(element, (Folder)event.item.getData(), copy);
            this.viewer.setExpandedState(event.item.getData(), true);
        }
    }

    public void dragLeave(DropTargetEvent event) {
    }

    public void dropAccept(DropTargetEvent event) {
    }

    protected void doDrop(Object element, Folder inFolder, boolean copy) {
        if (copy) {
            ICopyable copyable;
            if (element instanceof ICopyable && (copyable = (ICopyable)element).isCopyable()) {
                inFolder.insert(copyable.copy());
            }
        } else {
            inFolder.insert(element);
        }
    }

    protected int getDragOverAction(DropTargetEvent event) {
        Object selected = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement();
        if (event.item == null) {
            return this.getDragOverAction(this.root, selected);
        }
        if (event.item.getData() instanceof Folder) {
            return this.getDragOverAction((Folder)event.item.getData(), selected);
        }
        return 0;
    }

    protected int getDragOverAction(Folder target, Object item) {
        if (target.isModifiable()) {
            if (this.isMoveable(item, target)) {
                return this.getDragOverAction(target, item, this.isCopyable(item) ? this.currentOperation : 2);
            }
            if (this.isCopyable(item)) {
                return this.getDragOverAction(target, item, 1);
            }
        }
        return 0;
    }

    protected int getDragOverAction(Folder target, Object item, int opertation) {
        if (item instanceof Folder) {
            Folder draggedFolder = (Folder)item;
            if (target.hasSubFolder(draggedFolder.getName())) {
                return 0;
            }
            if (target.isDescendentForm(draggedFolder)) {
                return 1;
            }
        }
        return opertation;
    }

    public void dragStart(DragSourceEvent event) {
        Object el;
        event.doit = ((IStructuredSelection)this.viewer.getSelection()).size() == 1 ? this.isCopyable(el = ((IStructuredSelection)this.viewer.getSelection()).getFirstElement()) || this.isMoveable(el, null) : false;
    }

    public void dragSetData(DragSourceEvent event) {
        LocalSelectionTransfer.getTransfer().setSelection(this.viewer.getSelection());
    }

    public void dragFinished(DragSourceEvent event) {
    }

    protected boolean isCopyable(Object item) {
        return item instanceof ICopyable && ((ICopyable)item).isCopyable();
    }

    protected boolean isMoveable(Object item, Object target) {
        if (item instanceof Folder) {
            Folder f = (Folder)item;
            return f.isModifiable();
        }
        return true;
    }
}

