/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.views;

import com.jrockit.mc.browser.views.Folder;
import com.jrockit.mc.common.Callback;
import com.jrockit.mc.common.IArray;
import com.jrockit.mc.common.IDescribable;
import com.jrockit.mc.rjmx.model.IDiscoveryInfo;
import com.jrockit.mc.rjmx.model.IServer;
import com.jrockit.mc.rjmx.model.internal.Server;
import com.jrockit.mc.rjmx.model.internal.ServerModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistable;

public class FolderStructure
implements IArray<Object>,
IPersistable {
    private static final String EMPTY_FOLDER_MEMENTO_TYPE = "EmptyFolder";
    private final ServerModel model;
    private Folder userRootFolder = new Folder(null, "UserFolderRoot"){

        @Override
        protected void performInsert(Object o, Folder into) {
            if (o instanceof Server) {
                Server s = (Server)o;
                s.setPath(into.getPath(true));
                FolderStructure.this.model.insert(new Server[]{s});
            } else if (o instanceof Folder) {
                Folder f = (Folder)o;
                f.setParent(into);
                FolderVisitor fv = new FolderVisitor();
                f.accept(fv);
                if (into == null) {
                    FolderStructure.this.model.remove((IServer[])fv.getServers());
                } else {
                    FolderStructure.this.model.insert(fv.getServers());
                }
            }
        }
    };
    private static Callback<Folder> clearDecriptors = new Callback<Folder>(){

        public void call(Folder f) throws Exception {
            f.clearLeafs();
        }
    };

    Folder getRootFolder() {
        return this.userRootFolder;
    }

    public FolderStructure(ServerModel model, IMemento state) {
        this.model = model;
        if (state != null) {
            IMemento[] iMementoArray = state.getChildren(EMPTY_FOLDER_MEMENTO_TYPE);
            int n = iMementoArray.length;
            int n2 = 0;
            while (n2 < n) {
                IMemento folder = iMementoArray[n2];
                this.userRootFolder.getFolder(folder.getTextData());
                ++n2;
            }
        }
    }

    void addFolder(String name) {
        this.userRootFolder.getFolder(name);
    }

    public boolean isEmpty() {
        return this.model.isEmpty();
    }

    public Object[] elements() {
        this.userRootFolder.accept(clearDecriptors);
        HashMap<IDescribable, Folder> discoveredFolders = new HashMap<IDescribable, Folder>();
        IServer[] iServerArray = this.model.elements();
        int n = iServerArray.length;
        int n2 = 0;
        while (n2 < n) {
            IServer server = iServerArray[n2];
            IDiscoveryInfo discovery = server.getDiscoveryInfo();
            if (discovery == null) {
                this.userRootFolder.getFolder(server.getPath()).addLeaf(server);
            } else {
                IDescribable provider = discovery.getProvider();
                Folder providerFolder = (Folder)discoveredFolders.get(provider);
                if (providerFolder == null) {
                    final String desc = provider.getDescription();
                    providerFolder = new Folder(null, provider.getName()){

                        @Override
                        public boolean isModifiable() {
                            return false;
                        }

                        @Override
                        public String getDescription() {
                            return desc;
                        }
                    };
                    discoveredFolders.put(provider, providerFolder);
                }
                providerFolder.getFolder(server.getPath()).addLeaf(server);
            }
            ++n2;
        }
        Collection<Object> customChildren = this.userRootFolder.getChildren();
        customChildren.addAll(discoveredFolders.values());
        return customChildren.toArray();
    }

    public void saveState(final IMemento memento) {
        this.userRootFolder.accept(new Callback<Folder>(){

            public void call(Folder f) throws Exception {
                if (!f.hasChildren() && f.getParent() != null) {
                    memento.createChild(FolderStructure.EMPTY_FOLDER_MEMENTO_TYPE).putTextData(f.getPath(true));
                }
            }
        });
    }

    private static class FolderVisitor
    implements Callback<Folder> {
        List<Server> servers = new ArrayList<Server>();

        private FolderVisitor() {
        }

        public void call(Folder f) throws Exception {
            for (Object o : f.getLeafs()) {
                if (!(o instanceof Server)) continue;
                Server s = (Server)o;
                s.setPath(f.getPath(true));
                this.servers.add(s);
            }
        }

        Server[] getServers() {
            Server[] handles = new Server[this.servers.size()];
            Iterator<Server> it = this.servers.iterator();
            int i = 0;
            while (i < handles.length) {
                handles[i] = it.next();
                ++i;
            }
            return handles;
        }
    }
}

