/*
 * Decompiled with CFR 0.152.
 */
package com.jrockit.mc.browser.wizards;

import com.jrockit.mc.browser.JVMBrowserPlugin;
import com.jrockit.mc.browser.wizards.ActionWizardPage;
import com.jrockit.mc.browser.wizards.ConnectionSelectionWizardPage;
import com.jrockit.mc.browser.wizards.ConnectionWizardModel;
import com.jrockit.mc.browser.wizards.ConnectionWizardPage;
import com.jrockit.mc.core.UserActionJob;
import com.jrockit.mc.rjmx.model.IServer;
import com.jrockit.mc.rjmx.model.internal.Server;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;

public class ConnectionWizard
extends Wizard
implements INewWizard {
    private static final String SECTION_CONNECTION_WIZARD = "com.jrockit.mc.browser.wizards.ConnectionWizard";
    private IServer server;
    private String serverPath;
    private final boolean startOnNewConnectionPage;
    private ConnectionWizardModel serverConnectModel;

    public ConnectionWizard() {
        this(null, null, false);
    }

    public ConnectionWizard(String serverPath) {
        this(null, serverPath, true);
    }

    public ConnectionWizard(IServer server) {
        this(server, null, true);
    }

    private ConnectionWizard(IServer server, String serverPath, boolean startOnNewConnectionPage) {
        this.server = server;
        this.serverPath = serverPath;
        this.setNeedsProgressMonitor(false);
        this.initializeDefaultPageImageDescriptor();
        this.initializeDialogSettings();
        this.startOnNewConnectionPage = startOnNewConnectionPage;
        this.serverConnectModel = new ConnectionWizardModel();
    }

    private void initializeDialogSettings() {
        IDialogSettings wizardSettings = JVMBrowserPlugin.getDefault().getDialogSettings().getSection(SECTION_CONNECTION_WIZARD);
        if (wizardSettings == null) {
            JVMBrowserPlugin.getDefault().getDialogSettings().addNewSection(SECTION_CONNECTION_WIZARD);
        }
        this.setDialogSettings(wizardSettings);
    }

    private void initializeDefaultPageImageDescriptor() {
        this.setDefaultPageImageDescriptor(JVMBrowserPlugin.getDefault().getMCImageDescriptor("bannerconwiz.gif"));
    }

    public boolean performFinish() {
        if (this.getConnectionWizardPage().isTheCurrentPage()) {
            this.getConnectionWizardPage().updateModel();
        } else if (this.serverConnectModel.action != null) {
            new UserActionJob(this.serverConnectModel.action).schedule();
        }
        if (this.serverConnectModel.createdServer != null) {
            this.serverConnectModel.serverModel.insert(new Server[]{this.serverConnectModel.createdServer});
        }
        return true;
    }

    public boolean canFinish() {
        if (this.getConnectionSelectionWizardPage().isTheCurrentPage()) {
            return false;
        }
        if (this.getConnectionWizardPage().isTheCurrentPage()) {
            return true;
        }
        if (this.getUserActionWizardPage().isTheCurrentPage()) {
            return this.getUserActionWizardPage().isPageComplete();
        }
        return false;
    }

    public void addPages() {
        this.addPage((IWizardPage)new ConnectionSelectionWizardPage(this.serverConnectModel));
        this.addPage((IWizardPage)new ConnectionWizardPage(this.server, this.serverPath, this.serverConnectModel));
        this.addPage((IWizardPage)new ActionWizardPage(this.serverConnectModel));
        if (this.startOnNewConnectionPage) {
            this.getConnectionWizardPage().setPreviousPage(null);
            this.getConnectionWizardPage().setNextPage((IWizardPage)this.getUserActionWizardPage());
            this.getUserActionWizardPage().setPreviousPage((IWizardPage)this.getConnectionWizardPage());
        } else {
            this.getConnectionSelectionWizardPage().setNextPage((IWizardPage)this.getUserActionWizardPage());
            this.getUserActionWizardPage().setPreviousPage((IWizardPage)this.getConnectionSelectionWizardPage());
        }
        if (this.server != null) {
            this.getConnectionWizardPage().setPreviousPage(null);
            this.getConnectionWizardPage().setNextPage(null);
        }
    }

    ConnectionSelectionWizardPage getConnectionSelectionWizardPage() {
        return (ConnectionSelectionWizardPage)this.getPage("com.jrockit.mc.browser.server.connect.server.selection");
    }

    ConnectionWizardPage getConnectionWizardPage() {
        return (ConnectionWizardPage)this.getPage(ConnectionWizardPage.PAGE_NAME);
    }

    ActionWizardPage getUserActionWizardPage() {
        return (ActionWizardPage)this.getPage("com.jrockit.mc.browser.server.connect.action.selection");
    }

    public IWizardPage getStartingPage() {
        return this.server != null ? this.getConnectionWizardPage() : (this.startOnNewConnectionPage ? this.getConnectionWizardPage() : this.getConnectionSelectionWizardPage());
    }

    public IWizardPage getPreviousPage(IWizardPage page) {
        return page.getPreviousPage();
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }
}

