/** pahooWeather.hpp
 * CۏɊւNXFC++wb_
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @	MinGW C++
 */
#ifndef PAHOOWEATHER_H
#define PAHOOWEATHER_H

#include <stdlib.h>
#include <tchar.h>
#include <string>
#include "pahooCache.hpp"

//Cے TԓVC\URL
#define JMA_WEEKLY_URL	"https://www.jma.go.jp/jp/week/"

//\ln_f[^t@C
#define FILE_SPOTS_LOCAL	"jmaweatherspots.xml"
#define FILE_SPOTS_PAHOO	"https://www.pahoo.org/e-soul/webtech/php06/program/jmaweatherspots.xml"

//UserAgent
extern std::string UserAgent;

//VC\
typedef struct _jmaWeeklyWeather {
	int year;						//N
	int month;						//
	int day;						//
	std::wstring day_of_week;		//j
	std::wstring weather;			//VC\
	std::string  image;				//VC\ACRURL
	std::string  rainy;				//~m
	std::string  temp_max;			//ōC
	std::string  temp_min;			//ŒC
	std::string  stationCode;		//\n_R[h
	std::wstring stationName;		//\n_
	std::wstring location;			//ݒn
} jmaWeeklyWeather_t;

//NX`
class pahooWeather {

public:
//RXgN^
pahooWeather(pahooCache* pCC);
~pahooWeather();

jmaWeeklyWeather_t jmaWeeklyWeather[10];
std::wstring errmsg = L"";		//G[bZ[W
std::string webapi = "";		//߂ŎgpWebAPIURL
pahooCache* pCC;				//LbVEVXe

bool isError(void);
std::wstring getError(void);
void setError(std::wstring str);
void resetError(void);
std::string getwebapi(void);

bool updateFileSpots(void);

int readJmaSpots(void);
std::string getJmaNearSpot(double longitude, double latitude, int forecast, double distanceMax);
void jmaGetWeatherForecastURL(long page, std::string *vpfd51, std::string *vpfw50);
bool jmaGetWeatherForecast(std::string station, int forecast);

private:
bool isExistsNewerFileSpots(void);
double distance(double long_a, double lati_a, double long_b, double lati_b);
double waverage(std::wstring ws);
std::wstring jmaShortWeather(std::wstring weather);
std::string jma_telop2url(int telop, int mode);

};

#endif
