/** weeklyweather.cpp
 * TԓVC\iCےTԗ\QƁj
 *
 * @copyright	(c)studio pahoo
 * @author		ppςӂ
 * @J	MinGW C++ + cURL + OpenSSL + Boost C++ Libraries
 *					+ WebView2Loader.dll + Leaflet + OSM (+ GoogleMap)
 * @QlURL		https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-16-01.shtm
 */
#include <iostream>
#include <fstream>
#include <stdio.h>
#include <stdlib.h>
#include <tchar.h>
#include <time.h>
#include <sstream>
#include <string>
#include <winsock2.h>
#include <windows.h>
#include <shlobj.h>
#include <commctrl.h>
#include <boost/format.hpp>
#include <gdiplus/gdiplus.h>
#include <ole2.h>
#include <richedit.h>
#include <boost/property_tree/xml_parser.hpp>
#include <boost/algorithm/string.hpp>
#include "mystrings.h"
#include "apikey.h"
#include "WebView2.h"
#include "pahooWebView2.hpp"
#include "pahooGeocode.hpp"
#include "pahooWeather.hpp"
#include "resource.h"

using namespace std;
using namespace Gdiplus;
using namespace boost;
using namespace boost::property_tree;

// 萔Ȃ ==================================================================
#define MAKER		"pahoo.org"			// 쐬
#define APPNAME		"weeklyweather"		// AvP[V
#define APPNAMEJP	"TԓVC\\"		// AvP[Vi{j
#define APPVERSION	"3.4.2"				// o[W
#define APPYEAR		"2020-25"			// 쐬N
#define REFERENCE	"https://www.pahoo.org/e-soul/webtech/cpp01/cpp01-16-01.shtm"	// QlTCg

// wvEt@C
#define HELPFILE	".\\etc\\help.chm"

// ftHgۑt@C
#define SAVEFILE	"weeklyweather.csv"

// LbVEfBNg
#define CACHEDIR_WEATHER	"pcache\\"

// LbVێԁiftHgGj(0FLbVȂ)
#define LIFE_CACHE_WEATHER	(2 * 60)

// \\ID
#define IDC_CAL_LABEL	1501		// t
#define IDC_RES_LABEL	1601		// VC\
#define IDC_RES_IMAGE	1701		// VCACR
#define IDC_TEMP_LABEL	1801		// ~mEŒEōC

// \\̍W
#define IDC_RES_X		10
#define IDC_RES_Y		430
#define IDC_RES_WIDTH	80

#define FORECAST_HEIGHT	140		// \\̍

// }bvɕ\}[J[摜URL
#define URL_MARKER "https://maps.google.co.jp/mapfiles/ms/icons/yellow-dot.png"
#define MAP_WIDTH		530		// n}̕isNZj
#define MAP_HEIGHT		300		// n}̍isNZj

// }bvID
#define MAP_ID			"map_id"
// oxEܓxilj
#define DEF_LONGITUDE	139.766667
double Longitude = DEF_LONGITUDE;
#define DEF_LATITUDE	35.681111
double Latitude  = DEF_LATITUDE;
// n}g嗦ilj
#define DEF_ZOOM	6
int Zoom = DEF_ZOOM;
// n}̎ށilj
#define DEF_MAPTYPE		"GSISTD"
string Maptype = DEF_MAPTYPE;

// \n_܂ł̍ő勗ikmj
#define DISTANCE_MAX	400

// ݂̃C^[tFCX
HINSTANCE hInst;

// AvP[VEEBhE
HWND hParent;

//WebView2EBhE
HWND hWebView2;

// ICoreWebView2FpahooWebView2.cpp Œ`D
extern ICoreWebView2* webView2;

// e|t@C
char tmpFname[MAX_PATH + 1];
wchar_t wUri[MAX_PATH * 2 + 1];

// AvP[VEEBhEʒu
unsigned hParent_X, hParent_Y;

// GDI+p
ULONG_PTR lpToken;

// L[i[ϐ
string Query;

// G[EbZ[Wi[pyύXsz
string ErrorMessage;

// UserAgent
string UserAgent;

// pahooWeatherIuWFNg
pahooWeather *pWT;

// pahooGeocodeIuWFNg
pahooGeocode *pGC;

// pahooCacheIuWFNg
pahooCache *pCC;

//WebView2nh̓w肷DyύXsz
enum class eAction {
	GetLatLong,				// ܓxEox擾ăuEU\
	GetZoomType,			// g嗦E}bv^Cv擾ăuEU\
	GetLatLongZoomType,		// ܓxEoxEg嗦E}bv^Cv擾ăuEU\
	Finish					// vOI
};
eAction selectAction = eAction::GetLatLongZoomType;

// o[W
string Version = (boost::format(R"(
%1%  o[W %2%

{AvP[VMIT LicensełD
lł̖p\łDRɉł܂D
Ĕzz̍ۂ́CL̒쌠\LCURLƖ{gpKLĂD

@Copyright by (c)studio pahoo, %3%
@https://www.pahoo.org/

ȂC{AvP[V̗p܂͉邱ƂɂĐĂ͈؊֒m܂DWebAPI̕ύXE~ɂĐɋ@\ȂȂꍇ܂D܂C񎟗p̑gDEƁEĉ̖ړIEeEɂĂ͈؊֒m܂D

{AvP[V́CL̃CuCt[[NCAPI𗘗pĂ܂D
@MinGWig++j^Boost C++Cu^libcurl^OpenSSL+^
@WebView2Loader.dll^Leaflet^OpenStreetMap^Google}bv
@Google Geocoding API^YOLPRecWIR[_API
)")
% APPNAMEJP
% APPVERSION
% APPYEAR
).str();

// TuEvO =====================================================
/**
 * p[^D
 * @param	Ȃ
 * @return	Ȃ
 */
void initParameter(void) {
	Query     = "";
	Longitude = DEF_LONGITUDE;
	Latitude  = DEF_LATITUDE;
	Zoom      = DEF_ZOOM;
	Maptype   = DEF_MAPTYPE;
	hParent_X = 0;
	hParent_Y = 0;
}

/**
 * ۑݒt@Cp[^ǂݍށD
 * @param	Ȃ
 * @return	Ȃ
 */
void loadParameter(void) {
	ptree pt;

	// lݒ
	initParameter();

	// XMLt@Cǂݍ
	try {
		xml_parser::read_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt);

		// XML
		try {
			// ``FbN
			if (optional<string>str = pt.get_optional<string>("parameter")) {
			} else {
				return;
			}
			// p[^ǂݍ
			for (auto it : pt.get_child("parameter")) {
				string type= it.second.get_optional<string>("<xmlattr>.type").value();
				if (type == "latitude") {
					Latitude = stod(it.second.data());
				} else if (type == "longitude") {
					Longitude = stod(it.second.data());
				} else if (type == "zoom") {
					Zoom = stoi(it.second.data());
				} else if (type == "maptype") {
					Maptype = (string)it.second.data();
				} else if (type == "wx") {
					hParent_X = (unsigned)stoi(it.second.data());
				} else if (type == "wy") {
					hParent_Y = (unsigned)stoi(it.second.data());
				} else if (type == "query") {
					Query = utf8_sjis((string)it.second.data());
				}
			}
		// ߎs珉lݒ
		} catch (xml_parser_error& e) {
			initParameter();
			return;
		}
	// ǂݍݎs珉lݒ
	} catch (xml_parser_error& e) {
		initParameter();
		return;
	}

	// AvP[VEEBhËʒuifXNgbv͈͊OȂ猴_ړj
	HWND hDesktop = GetDesktopWindow();
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hDesktop, &windowInfo);
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
}

/**
 * p[^ݒt@CɕۑD
 * @param	Ȃ
 * @return	Ȃ
 */
void saveParameter(void) {
#ifndef CMDAPP
	// AvP[VEEBhËʒu擾
	WINDOWINFO windowInfo;
	windowInfo.cbSize = sizeof(WINDOWINFO);
	GetWindowInfo(hParent, &windowInfo);
	hParent_X = (unsigned)windowInfo.rcWindow.left;
	hParent_Y = (unsigned)windowInfo.rcWindow.top;
	if (hParent_X >= (unsigned)windowInfo.rcWindow.right) {
		hParent_X = 0;
	}
	if (hParent_Y >= (unsigned)windowInfo.rcWindow.bottom) {
		hParent_Y = 0;
	}
#endif

	char lng[SIZE_BUFF + 1], lat[SIZE_BUFF + 1];
	snprintf(lng, SIZE_BUFF, "%.5f", Longitude);
	snprintf(lat, SIZE_BUFF, "%.5f", Latitude);

	// XMLt@C֏
	ptree pt;
	ptree& child1 = pt.add("parameter.param", lat);
	child1.add("<xmlattr>.type", "latitude");
	ptree& child2 = pt.add("parameter.param", lng);
	child2.add("<xmlattr>.type", "longitude");
	ptree& child3 = pt.add("parameter.param", to_string(Zoom));
	child3.add("<xmlattr>.type", "zoom");
	ptree& child4 = pt.add("parameter.param", Maptype);
	child4.add("<xmlattr>.type", "maptype");
	ptree& child5 = pt.add("parameter.param", (string)to_string(hParent_X));
	child5.add("<xmlattr>.type", "wx");
	ptree& child6 = pt.add("parameter.param", (string)to_string(hParent_Y));
	child6.add("<xmlattr>.type", "wy");
	ptree& child7 = pt.add("parameter.param", sjis_utf8(Query));
	child7.add("<xmlattr>.type", "query");

	const int indent = 4;
	write_xml(getMyPath(APPNAME) + APPNAME + ".xml", pt, std::locale(),
		xml_writer_make_settings<std::string>(' ', indent));
}

/**
 * p[^ۑݒt@C폜Cp[^D
 * @param	Ȃ
 * @return	Ȃ
 */
void delParameter(void) {
	remove((getMyPath(APPNAME) + APPNAME + ".xml").c_str());

	// lݒ
	initParameter();
}

// uEU\ ==============================================================
/**
 * VC\\iHTMLj쐬D
 * @param	Ȃ
 * @return	string 쐬HTML
 */
string makeForecastHTML(void) {
	static char buff1[SIZE_BUFF + 1];

	string html = (boost::format(R"(<table class="weather">
<caption>%1%̓VC\</caption>
<tr>
)")
% _WS(pWT->jmaWeeklyWeather[0].stationName)		// \n_
).str();

	// t̍s
	for (int i = 0; i <= 6; i++) {
		snprintf(buff1, SIZE_BUFF,
			"%02d/%02d<span class=\"wsmall\">(%s)</span>",
			pWT->jmaWeeklyWeather[i].month,
			pWT->jmaWeeklyWeather[i].day,
			_WS(pWT->jmaWeeklyWeather[i].day_of_week).c_str());

			html += (boost::format(R"(<td class="dt">%1%</td>
)")
% buff1
).str();
	}

	html += (boost::format(R"(</tr>
<tr>
)")
).str();

	// VC\̍s
	for (int i = 0; i <= 6; i++) {
		string small1 = "", small2 = "";
		if (pWT->jmaWeeklyWeather[i].rainy.length() > 3) {
			small1 = "<span class=\"wsmall\">";
			small2 = "</span>";
		}
		string temp_max = "-", temp_min = "-";
		if (pWT->jmaWeeklyWeather[i].temp_max != "") {
			temp_max = pWT->jmaWeeklyWeather[i].temp_max + "";
		}
		if (pWT->jmaWeeklyWeather[i].temp_min != "") {
			temp_min = pWT->jmaWeeklyWeather[i].temp_min + "";
		}
		html += (boost::format(R"(<td class="info">
%1%<br />
<img class="wicon" src="%2%" /><br />
%6%%3%%7%<br />
%4%/%5%
</td>
)")
% _WS(pWT->jmaWeeklyWeather[i].weather)
% pWT->jmaWeeklyWeather[i].image
% pWT->jmaWeeklyWeather[i].rainy
% temp_max
% temp_min
% small1
% small2
).str();
	}

	html += (boost::format(R"(
</tr>
</table>
)")
).str();

	return html;
}

/**
 * n}\HTML쐬D
 * @param	Ȃ
 * @return	string HTML
 */
string makeMapHTML(void) {
	string script = pGC->makeMapLeaflet(MAP_ID, Longitude, Latitude, Zoom, Maptype);
	string forecast = makeForecastHTML();

	string html = (boost::format(R"(<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="SJIS">
<title>TԓVC\</title>
<meta name="author" content="studio pahoo" />
<meta name="copyright" content="studio pahoo" />
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW" />
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache">
<meta http-equiv="X-UA-Compatible" content="IE=edge">
<style>
body {
	background-color: transparent;
	font-family: 'MS UI Gothic';
}
/* G[\ */
p.werror {
	color: red;
	font-size: 16px;
	font-weight: bold;
}
/* VC\\ */
table.weather {
	width: %2%px;
	height: %10%px;
	border:solid 1px #000000;
	border-collapse:collapse;
	margin-top:20px;
	line-height:120%%;
}
/* VC\\F\ */
table.weather td.dt {
	width: %2%px;
	border:solid 1px #000000;
	border-collapse: collapse;
	padding:4px;
	white-space:nowrap;
	text-align:center;
	font-size: 14px;
}
/* VC\\F\\ */
table.weather td.info {
	width: %2%px;
	border:solid 1px #000000;
	border-collapse: collapse;
	padding:4px;
	white-space:nowrap;
	text-align:center;
	font-size: 14px;
}
/* VC\\F\ACR */
img.wicon {
	width: 50px;
}
/* VC\\F */
span.wsmall {
	font-size: 12px;
}
</style>
%8%
</head>
<body>
<div id="%1%" style="width:%2%px; height:%3%px;"></div>
%9%
<form>
<input id="latitude"  type="hidden" value="%4%" />
<input id="longitude" type="hidden" value="%5%" />
<input id="zoom"      type="hidden" value="%6%" />
<input id="maptype"   type="hidden" value="%7%" />
</form>
</body>
</html>
)")
% MAP_ID						// n}ID
% MAP_WIDTH						// n}̕
% MAP_HEIGHT					// n}̍
% Latitude						// ܓx
% Longitude						// ox
% Zoom							// n}g嗦
% Maptype						// n}^Cv
% script						// n}`XNvg
% forecast						// VC\\HTML
% FORECAST_HEIGHT				// \\̍
).str();

	return html;
}

/**
 * G[bZ[W\pHTML쐬D
 * @param	Ȃ
 * @return	string 쐬HTML
 */
string makeErrorHTML(void) {
	string msg;
	if (pGC->isError()) {
		msg = _WS(pGC->getError());
		pGC->resetError();
	} else if (pCC->isError()) {
		msg = _WS(pCC->getError());
		pCC->resetError();
	} else if (pWT->isError()) {
		msg = _WS(pWT->getError());
		pWT->resetError();
	} else {
		msg = ErrorMessage;
	}
	return (boost::format(R"(<!DOCTYPE html>
<html lang="ja">
<head>
<meta charset="SJIS">
<title>G[</title>
<meta name="author" content="studio pahoo" />
<meta name="copyright" content="studio pahoo" />
<meta name="ROBOTS" content="NOINDEX,NOFOLLOW" />
<meta http-equiv="pragma" content="no-cache">
<meta http-equiv="cache-control" content="no-cache">
<style>
body {
	background-color: transparent;
	font-family: 'MS UI Gothic';
}
/* G[\ */
p.werror {
	color: red;
	font-size: 16px;
	font-weight: bold;
}
</style>
</head>
<body>
<p class="werror">G[F%1%D</p>
<form>
<input id="latitude"  type="hidden" value="%2%" />
<input id="longitude" type="hidden" value="%3%" />
<input id="zoom"      type="hidden" value="%4%" />
<input id="maptype"   type="hidden" value="%5%" />
</form>
</body>
</html>
)")
% msg							// G[EbZ[W
% Latitude						// ܓx
% Longitude						// ox
% Zoom							// n}g嗦
% Maptype						// n}^Cv
).str();
}

/**
 * HTMLt@CǂݍŁCuEUERg[ɕ\D
 * @param	char* tmpname ǂݍHTMLt@C
 * @return	Ȃ
 */
void viewBrowser(const char *tmpname) {
	string html;
	string fname;
	ofstream ofs;

	// \pHTMLt@C쐬
	if ((ErrorMessage == "") && (! pWT->isError()) && (! pGC->isError()) && (! pWT->isError())) {
		html = makeMapHTML();
	} else {
		html = makeErrorHTML();
	}
	ofs.open(tmpname);
	ofs << html;
	ofs.close();

	fname = (string) tmpname;
	std::replace(fname.begin(), fname.end(), '\\', '/');

	if (isWeb2Ready()) {
		webView2->Reload();
	}
}

/**
 * VC\擾CuEU\sD
 * @param	HWND hDlg  EBhEnh
 * @return	Ȃ
*/
void viewMapList(void) {
	string stationCode;

	// ł߂\n_TD
	stationCode = pWT->getJmaNearSpot(Longitude, Latitude, 1, DISTANCE_MAX);
//	cout << "stationCode =" << stationCode << endl;
	// VC\擾D
	pWT->jmaGetWeatherForecast(stationCode, 1);
	if (pGC->isError()) {
		ErrorMessage = _WS(pGC->getError());
	} else if (pWT->isError()) {
		ErrorMessage = _WS(pWT->getError());
	}

	// uEUERg[ɕ\
	viewBrowser(tmpFname);

	// G[EZbg
	ErrorMessage = "";
	pGC->resetError();
	pCC->resetError();
	pWT->resetError();
}

// ۑERs[ =============================================================
/**
 * w肵ssԍ̏Tԗ\CSVt@CɕۑFۑ
 * @param	const char* fname ۑt@C
 * @param	int cnt   ssԍ
 * @return	Ȃ
 */
void __saveCSV(const char *fname, int cnt) {
	ofstream outputfile(fname);

	// \n_
	outputfile << "\"" << "ܓx" << ",";
	outputfile << Latitude << "\"" << endl;
	outputfile << "\"" << "ox" << ",";
	outputfile << Longitude << "\"" << endl;
	outputfile << "\"" << "\\n_" << "\",\"";
	outputfile << _WS(pWT->jmaWeeklyWeather[0].stationName) << "\"" << endl;

	// x
	outputfile << "\"" << "" << "\",";
	outputfile << "\"" << "" << "\",";
	outputfile << "\"" << "j" << "\",";
	outputfile << "\"" << "V" << "\",";
	outputfile << "\"" << "ACRURL" << "\",";
	outputfile << "\"" << "~m()" << "\",";
	outputfile << "\"" << "ōC()" << "\",";
	outputfile << "\"" << "ŒC()" << "\"" << endl;

	// f[^{
	for (int i = 0; i < 7; i++) {
		outputfile << pWT->jmaWeeklyWeather[i].month << ",";
		outputfile << pWT->jmaWeeklyWeather[i].day << ",";
		outputfile << "\"" << _WS(pWT->jmaWeeklyWeather[i].day_of_week) << "\",";
		outputfile << "\"" << _WS(pWT->jmaWeeklyWeather[i].weather) << "\",";
		outputfile << "\"" << pWT->jmaWeeklyWeather[i].image << "\",";
		outputfile << "\"" << pWT->jmaWeeklyWeather[i].rainy << "\",";
		outputfile << "\"" << pWT->jmaWeeklyWeather[i].temp_max << "\",";
		outputfile << "\"" << pWT->jmaWeeklyWeather[i].temp_min << "\"" << endl;
		if (outputfile.bad()) {
			ErrorMessage = "CSVt@C݃G[";
			break;
		}
	}
	outputfile.close();
}

/**
 * w肵ssԍ̏TԓVC\CSVt@CɕۑFt@C_CAO
 * @param	int cnt ssԍ
 * @return	Ȃ
 */
void saveCSV(int cnt) {
	static char fname[MAX_PATH + 1];
	strcpy(fname, SAVEFILE);
	OPENFILENAME of;

	// OPENFILENAME\̂̃TCYZbg
	memset(&of, 0, sizeof(OPENFILENAME));
	of.lStructSize = sizeof(OPENFILENAME);
	// _CAO{bNXLEBhEւ̃nh
	of.hwndOwner = hParent;
	of.lpstrFilter = TEXT("CSVt@C(*.csv;*.txt)\0*.csv;*.txt\0ׂẴt@C(*.txt)\0*.txt\0\0");
	// t@Ci[obt@̃AhX
	of.lpstrFile = (LPTSTR)fname; 
	// lpstrFileoŎw肳obt@̃TCY
	of.nMaxFile = MAX_PATH;
	of.Flags = OFN_OVERWRITEPROMPT;
	// ftHg̊gqi[obt@̃AhX
	of.lpstrDefExt = TEXT("csv");
	// R_CAO̕\
	GetSaveFileName(&of);
	// t@Cۑ
	__saveCSV(fname, cnt);
}

/**
 * w肵ssԍ̏TԓVC\Nbv{[hɃRs[邽߂̕쐬D
 * @param	int cnt ssԍ
 * @return	string Rs[镶
 */
string copyText(int cnt) {
	static char buff[SIZE_BUFF + 1];
	ostringstream oss;

	// \n_
	oss << "ܓx\t" << Latitude  << endl;
	oss << "ox\t" << Longitude << endl;
	oss << "\\n_\t" << _WS(pWT->jmaWeeklyWeather[0].stationName) << endl;

	// x
	oss << "" << "\t";
	oss << "V" << "\t";
	oss << "ACRURL" << "\t";
	oss << "~m()" << "\t";
	oss << "ōC()" << "\t";
	oss << "ŒC()" << endl;

	// f[^{
	for (int i = 0; i < 7; i++) {
		snprintf(buff, SIZE_BUFF, "%02d/%02d(%s)",
			pWT->jmaWeeklyWeather[i].month, pWT->jmaWeeklyWeather[i].day,
			_WS(pWT->jmaWeeklyWeather[i].day_of_week).c_str());
		oss << buff << "\t";
		oss << _WS(pWT->jmaWeeklyWeather[i].weather) << "\t";
		oss << pWT->jmaWeeklyWeather[i].image << "\t";
		oss << pWT->jmaWeeklyWeather[i].rainy << "\t";
		oss << pWT->jmaWeeklyWeather[i].temp_max << "\t";
		oss << pWT->jmaWeeklyWeather[i].temp_min << endl;
	}
	return oss.str();
}

// o[W\_CAO =================================================
/**
 * CxgnhFo[W\_CAO
 * @param	HWND hDlg			EBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processHelp(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	string help;

	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		CenterWindow(hDlg);
		setStrEditBox(hDlg, IDC_TEXT_HELP, Version);
		break;

		// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// s
		case IDC_BUTTON_OK:
			EndDialog(hDlg, 0);
			break;
		default:
			return 1;
		}
		break;
		// vOI
	case WM_CLOSE:
		EndDialog(hDlg, 0);
		break;
	}
	return 0;
}

/**
 * wvE_CAO쐬
 * @param  HWND hDlg		eEBhEEnh
 * @param  DLGPROC handler	CxgEnh
 * @return Ȃ
 */
void createHelp(HWND hDlg, DLGPROC handler) {
	DialogBox(hInst, MAKEINTRESOURCE(IDD_DIALOG_VER), hDlg, (DLGPROC) handler);
}

// WebView2p֐Q ======================================================
/**
 * WebView2F_CAO
 * @param	HWND hDlg	eEBhEEnh
 * @return	Ȃ
*/
void initDialog(HWND hDlg) {
	HICON hIcon;
	ULONG_PTR lpToken;
	GdiplusStartupInput gpSI;
	string stationCode;
	hIcon = (HICON)LoadImage(hInst, MAKEINTRESOURCE(IDI_ICON), IMAGE_ICON, 16, 16, 0);
	SendMessage(hDlg, WM_SETICON, ICON_SMALL, (LPARAM)hIcon);
	ErrorMessage = "";

	// J[\v
	SetCursor(LoadCursor(NULL, IDC_WAIT));
	// IvVǂݍ
	loadParameter();
	// AvP[VEEBhEړ
	SetWindowPos(hParent, NULL, hParent_X, hParent_Y, 0, 0, (SWP_NOSIZE | SWP_NOZORDER | SWP_NOOWNERZORDER));
	pWT->resetError();
	pGC->resetError();
	// GDI+
	if (GdiplusStartup(&lpToken, &gpSI, NULL) != Gdiplus::Ok) {
		return;
	}

	// \n_t@CXVD
	pWT->updateFileSpots();

	// e|Et@C擾
	getTempFname(tmpFname);
	size_t wLen = 0;
	mbstowcs_s(&wLen, wUri, MAX_PATH * 2, tmpFname, MAX_PATH);
	// WebView2
	hWebView2 = createWebView2(hInst, hDlg, 10, 50, MAP_WIDTH + 30, MAP_HEIGHT + FORECAST_HEIGHT + 60, wUri);

	// Leafletp\ǂׂ
	const string url = "https://unpkg.com/leaflet@latest/";
	string contents = "";
	int httpStatus = 0;
	bool res = readWebContents(url, UserAgent, &contents, &httpStatus);
	if (res == FALSE) {
		ErrorMessage = "n}`惉CuiLeafletjpł܂";
	} else if ((httpStatus < 200) || (httpStatus > 299)) {
		ErrorMessage = "n}`惉CuiLeafletjpł܂";
	}

	// bZ[WE[v
	MSG msg;
	static bool flagWebView2 = false;
	while (GetMessage(&msg, nullptr, 0, 0)) {
		if (msg.message == WM_QUIT) {
			// IvVۑ
			// saveOption();
			DestroyWindow(hDlg);
		}
		TranslateMessage(&msg);
		DispatchMessage(&msg);
		if (!flagWebView2 && isWeb2Ready()) {
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// \n_t@Cǂݍ
			pWT->readJmaSpots();
			// Ŋ̗\n_擾
			stationCode = pWT->getJmaNearSpot(Longitude, Latitude, 1, DISTANCE_MAX);
			// \̎擾
			pWT->jmaGetWeatherForecast(stationCode, 1);
			if (pGC->isError()) {
				ErrorMessage = _WS(pGC->getError());
			} else if (pWT->isError()) {
				ErrorMessage = _WS(pWT->getError());
			}
			// uEUERg[ɕ\
			viewMapList();
			flagWebView2 = true;
		}
	}
}

/**
 * WebView2̃p[^oD
 * selectAction̒lɂēςB
 * @param	char* result	JavaScriptInhnf[^
 * @return	Ȃ
*/
void execScriptCompleted(string result) {
	double lat = 0, lng = 0;
	int zm = 0;
	string mt;

	// p[^ǂݍ
	vector<string> tokens;
	split(tokens, result, is_any_of(",\""));
	int cnt = 0;
	for (string ss: tokens) {
		switch (cnt) {
			case 1:
				lng = stod(ss);
				break;
			case 2:
				lat = stod(ss);
				break;
			case 3:
				zm = stoi(ss);
				break;
			case 4:
				mt = ss;
				break;
		}
		cnt++;
	}

	switch (selectAction) {
		// ܓxEox擾ăuEUɕ\
		case eAction::GetLatLong:
			Longitude = lng;
			Latitude  = lat;
			// uEUERg[ɕ\
			viewMapList();
			break;
		// g嗦E}bv^Cv擾ăuEUɕ\
		case eAction::GetZoomType:
			Zoom = zm;
			Maptype = mt;
			// uEUERg[ɕ\
			viewMapList();
			break;
		// ܓxEoxEg嗦E}bv^Cv擾ăuEUɕ\
		case eAction::GetLatLongZoomType:
			Longitude = lng;
			Latitude  = lat;
			Zoom = zm;
			Maptype = mt;
			// uEUERg[ɕ\
			viewMapList();
			break;
		// vOID
		default:
			// e|Et@C폜D
			Longitude = lng;
			Latitude  = lat;
			Zoom = zm;
			Maptype = mt;
			remove(tmpFname);
			// p[^ۑD
			saveParameter();
			// GDI+I
			GdiplusShutdown(lpToken);
			// vOI
			EndDialog(hParent, 0);
			DestroyWindow(hParent);
			break;
	}
//	cout << "Longitude: " << Longitude << endl;
//	cout << "Latitude: " << Latitude << endl;
//	cout << "Zoom: " << Zoom << endl;
//	cout << "Maptype: " << Maptype << endl;
}

/**
 * WebView2FJavaScriptInh
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
*/
class MyScriptCompletedHandler : public ICoreWebView2ExecuteScriptCompletedHandler {
public:
	HRESULT STDMETHODCALLTYPE Invoke(HRESULT error, PCWSTR result) override {
		if (SUCCEEDED(error)) {
			// PCWSTR  char* ϊ
			int requiredSize = WideCharToMultiByte(CP_UTF8, 0, result, -1, nullptr, 0, nullptr, nullptr);
			char* buffer = new char[requiredSize];
			WideCharToMultiByte(CP_UTF8, 0, result, -1, buffer, requiredSize, nullptr, nullptr);
			std::string res(buffer);
			// JavaScriptIɎs֐
			execScriptCompleted(res);
		}
		return S_OK;
	}

	HRESULT STDMETHODCALLTYPE QueryInterface(REFIID riid, void** ppvObject) override {
		return E_NOINTERFACE;
	}

	ULONG STDMETHODCALLTYPE AddRef(void) override {
		return 1;
	}

	ULONG STDMETHODCALLTYPE Release(void) override {
		return 1;
	}
};

// WebView2JavaScriptsDOMvf擾
MyScriptCompletedHandler* scriptCompletedHandler = new MyScriptCompletedHandler();

/**
 * WebView2ŃXNvgsCselectActionŎw肵ANVsD
 * @param	Ȃ
 * @param	Ȃ
 * @return	Ȃ
*/
void execScriptAndAction(void) {
	// vOIɎsJavaScript
	LPCWSTR js = L"document.getElementById('longitude').value + ',' + document.getElementById('latitude').value + ',' + document.getElementById('zoom').value + ',' + document.getElementById('maptype').value;";

	webView2->ExecuteScript(js, scriptCompletedHandler);
}

// CEBhE ==========================================================
/**
 * CxgnhFCEBhE
 * @param	HWND hDlg			eEBhEEnh
 * @paramm	UINT uMsg			bZ[Wʎq
 * @param	WPARAM wParam		bZ[W̍ŏ̃p[^
 * @paramL	PARAM lParam		bZ[W2Ԗڂ̃p[^
 * @return	INT_PTR CALLBACK	TRUEFbZ[W^FALSEF
 */
INT_PTR CALLBACK processMain(HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	wstring val;
	wstring wid;
	GdiplusStartupInput gpSI;
	static int cnt;		// ssԍ
	string stationCode;

	switch (uMsg) {
	// _CAO
	case WM_INITDIALOG:
		break;

	// {^
	case WM_COMMAND:
		switch (LOWORD(wParam)) {
		// 
		case IDM_EXEC:
		case IDC_BUTTON_EXEC:
			// J[\v
			SetCursor(LoadCursor(NULL, IDC_WAIT));
			// L[΃WIR[hAPIĂяo
			Query = getStrEditBox(hDlg, IDC_EDIT_QUERY);
			if (Query.length() > 0) {
				if (pGC->searchPoints(_SW(Query), UserAgent, 0) > 0) {
					Longitude = pGC->Ppoints[0].longitude;
					Latitude  = pGC->Ppoints[0].latitude;
				}
				// uEU\ƈꗗ\
				selectAction = eAction::GetZoomType;
				execScriptAndAction();
			} else {
				// uEU\ƈꗗ\
				selectAction = eAction::GetLatLongZoomType;
				execScriptAndAction();
			}
			// uEUERg[ɕ\
			viewMapList();
			break;

		// Zbg
		case IDC_BUTTON_RESET:
		case IDM_RESET:
			setStrEditBox(hDlg, IDC_EDIT_QUERY, "");
			initParameter();
			ErrorMessage = "";
			pGC->resetError();
			pCC->resetError();
			pWT->resetError();
			break;
		// ۑ
		case IDC_BUTTON_SAVE:
		case IDM_SAVE:
			saveCSV(cnt);
			break;
		// GoogleAPIL[ۑ
		case IDM_GOOGLE_APIKEY:
			createSetAPIkey(hDlg, LABEL_GOOGLE_API, FNAME_GOOGLE_API, URL_GOOGLE_API, &pGC->GoogleAPIkey);
			pGC->readGoogleApiKey();
			// GoogleAPIL[o^ȂftHg̃}bv^Cvɖ߂D
			Maptype = pGC->isGoogleApiKey() ? "GMRD" : DEF_MAPTYPE;
			// uEUERg[ɕ\
			viewMapList();
			break;
		// Yahoo!AvP[VIDۑ
		case IDM_YAHOO_APIKEY:
			createSetAPIkey(hDlg, LABEL_YAHOO_API, FNAME_YAHOO_API, URL_YAHOO_API, &pGC->YahooAPIkey);
			// uEUERg[ɕ\
			viewMapList();
			break;
		// LbVENA
		case IDM_CLEAR_CACHE:
			pCC->delCache(".+", 0);
			break;
		// ݒNA{AvI
		case IDM_CLEAR_PARAMETER:
			delParameter();
			// e|Et@C폜
			remove(tmpFname);
			// GDI+I
			GdiplusShutdown(lpToken);
			EndDialog(hDlg, 0);
			return 0;
			break;
		// wv
		case IDM_HELP:
			ShellExecute(hDlg, _T("open"), _T(HELPFILE), NULL, NULL, SW_RESTORE);
			break;
		// o[W\
		case IDM_VERSION:
			createHelp(hDlg, processHelp);
			break;
		// TCg
		case IDM_PAHOO:
			ShellExecute(NULL, _T("open"), _T(REFERENCE), NULL, NULL, SW_RESTORE);
			break;
		// Rs[
		case IDM_COPY:
		case IDC_BUTTON_COPY:
			setClipboardData(copyText(cnt));
			break;
		// ؂
		case IDM_DELETE:
			setStrEditBox(hDlg, IDC_EDIT_QUERY, "");
			break;
		// vOI
		case IDM_QUIT:
			selectAction = eAction::Finish;
			execScriptAndAction();
			break;
		default:
			return 1;
		}
		break;

	// vOI
	case WM_CLOSE:
		selectAction = eAction::Finish;
		execScriptAndAction();
		break;
	}
	return 0;
}

// CEvO =======================================================
/**
 * WindowsCvO
 * @param	HINSTANCE hInstance			CX^Xnh
 * @paramm	HINSTANCE hPrevInstance		gp(NULL)FWin16̖c
 * @param	LPSTR lpCmdLine				R}hC
 * @paramL	int nShowCmd				EBhE̕\@
 * @return	int ^[R[h
 */
int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, LPSTR lpCmdLine, int nShowCmd) {
	LoadLibrary("RICHED20.DLL");

	// UserAgent
	static OSVERSIONINFOEX os;
	GetVersion2(&os);
	UserAgent = (string)"Mozilla/5.0 (" + APPNAME + "/"
		+ APPVERSION + "/" + MAKER
		+ ", Windows NT " + to_string(os.dwMajorVersion) + "."
		+ to_string(os.dwMinorVersion) + ")";

	// pahooCacheIuWFNg
	pCC = new pahooCache(LIFE_CACHE_WEATHER, getMyPath(APPNAME) + CACHEDIR_WEATHER, UserAgent);
	// pahooWeatherIuWFNg
	pWT = new pahooWeather(pCC);
	// pahooGeocodeIuWFNg
	pGC = new pahooGeocode(APPNAME);

	// CE_CAO
	HWND hDlg = CreateDialog(hInstance, MAKEINTRESOURCE(IDD_MAIN), NULL, (DLGPROC)processMain);
	hInst = hInstance;
	hParent = hDlg;
	// CE_CAOD
	initDialog(hDlg);

	// IuWFNg
	delete pGC;
	delete pWT;
	delete pCC;

	return 0;
}

/*
 ** o[WAbv =====================================================
 *
 * @version 3.4.2 2025/11/08 gpCuXV
 * @version 3.4.1 2025/07/26 gpCuXV
 * @version 3.4.0 2025/03/22 LeafletANZXۃ`FbNǉCLbVVXesCCgpCuXV
 * @version 3.3.0 2025/02/23 w肵ꏊ\n_O̎ɃG[\
 * @version 3.2.2 2024/11/09 \n_t@CюgpCuXV
 * @version 3.2.1 2024/08/24 gpCuXV
 * @version 3.2.0 2024/05/06 Nɗ\n_t@CXV
 * @version 3.1.0 2024/05/03 API͏
 * @version 3.0.0 2024/04/29 EdgeuEUΉC64rbgΉC\n_t@CXV
 * @version 2.5.7 2024/03/30 \n_t@CюgpCuXV
 * @version 2.5.6 2023/12/30 \n_t@CюgpCuXV
 * @version 2.5.5 2023/11/23 gpCuXV
 * @version 2.5.4 2023/08/27 \n_t@CюgpCuXV
 * @version 2.5.3 2023/07/08 gpCuXV
 * @version 2.5.2 2023/03/18 \n_t@CюgpCuXV
 * @version 2.5.1 2023/02/11 \n_t@CюgpCuXV
 * @version 2.5.0 2022/09/24 EBhEʒuۑCCuXV
 * @version 2.4.0 2022/08/20 ݒNA@\ǉ
 * @version 2.3.1 2022/08/20 \n_t@CюgpCuXV
 * @version 2.3   2022/04/10 libcurlEOpenSSLŐVłɍXV
 * @version 2.2   2022/03/12 CےhЏXMLhttpsɑΉ
 * @version 2.1   2021/04/14 LbVEVXeFpahooCacheNX
 * @version 2.0   2021/03/14 CےhЏXML擾ɕύX
 * @version 1.2   2020/12/20 leafletXNvg̎QURLύX
 * @version 1.1   2020/12/05 __jma_readWeeklyWeather() 擾ύX
 * @version 1.0   2020/10/10 
 */
