﻿using System;
using System.Drawing;
using System.Windows.Forms;
using System.Runtime.InteropServices;
//
// Windows Forms C# アプリケーションによる動作サンプルを提供します。(COMから機能を利用)
//-------------------------------------------------------------------------------------
//
// 1.JwCADInfoをインストール。
//
// 2.エクスプローラでイメージ、プレビュー表示を確認。
//
// 3.Microsoft Visual Studio 2019 Community でこのプロジェクトをロード。
//
// 4.参照からJwCADInfoLibを一旦削除。
//
// 5.参照にJwCADInfo 1.0 タイプ ライブラリを追加。
//
// 6.実行環境に合わせて、64bitまたは32bitでビルドしてください。
//
namespace JwView
{
	public partial class Form1 : Form
	{
		/// <summary>
		/// 設定データファイル（適当にファイルパスを指定してください）
		/// </summary>
		const	string	c_UserFile = @"e:\temp\UserFile.xxx";

		/// <summary>
		/// プレビューウィンドウハンドル
		/// </summary>
		IntPtr	m_hViewWnd;

		/// <summary>
		/// イメージサイズ
		/// </summary>
		int		m_ImageSize;

		/// <summary>
		/// 対象ファイルのパス名
		/// </summary>
		string	m_strFile;

		/// <summary>
		/// JwCADInfoLibのCOM生成
		/// </summary>
		JwCADInfoLib.JwToolsLib	m_com = new JwCADInfoLib.JwToolsLib();

		/// <summary>
		/// 初期化
		/// </summary>
		public	Form1()
		{
			this.InitializeComponent();

			m_ImageSize = 256;
			radioButton6.Checked = true;

			// 前回の設定情報を復元する
			if(System.IO.File.Exists(c_UserFile) && !Convert.ToBoolean(m_com.InfoLoad(c_UserFile)))
			{
				MessageBox.Show("設定ファイルの復元に失敗しました", "Load error!!", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}
		/// <summary>
		/// 閉じるボタン
		/// </summary>
		/// <param name="sender">送信元</param>
		/// <param name="e">パラメータ</param>
		private void Button1_Click(object sender, EventArgs e)
		{
			// 設定情報を保存する
			if(!Convert.ToBoolean(m_com.InfoSave(c_UserFile)))
			{
				MessageBox.Show("設定ファイルの保存に失敗しました", "Save error!!", MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
			Close();
		}
		/// <summary>
		/// イメージの更新
		/// </summary>
		/// <param name="bImage">イメージ更新</param>
		/// <param name="bView">プレビュー更新</param>
		private void ImageUpdate(bool bImage, bool bView)
		{
			if(!System.IO.File.Exists(m_strFile))
			{
				MessageBox.Show("ファイルを指定してください", "File error!!", MessageBoxButtons.OK, MessageBoxIcon.Error);
				return;
			}
			try
			{
				if(bImage)
				{
					// 指定サイズのイメージ取得
					IntPtr	hBmp = m_com.GetImage(m_ImageSize, m_strFile);
					if(IntPtr.Zero != hBmp)
					{
						// ピクチャーボックスにイメージを貼り付ける
						Image img = Image.FromHbitmap(hBmp);
						pictureBox1.Image = null;
						pictureBox1.Image = img;

						// ハンドル解放
						Win32APICall.DeleteObject(hBmp);
					}
					else
					{
						MessageBox.Show("イメージ取得に失敗しました", "GetImage error!!", MessageBoxButtons.OK, MessageBoxIcon.Error);
					}
				}
				if(bView)
				{
					// 前回のプレビューを破棄
					if(IntPtr.Zero != m_hViewWnd)
					{
						Win32APICall.DestroyWindow(m_hViewWnd);
					}
					// ピクチャーボックスのサイズにプレビューを貼り付ける
					JwCADInfoLib.tagRECT	rect = new JwCADInfoLib.tagRECT
					{
						left	= pictureBox2.Left,
						top		= pictureBox2.Top,
						right	= pictureBox2.Right,
						bottom	= pictureBox2.Bottom
					};
					// プレビュー取得
					m_hViewWnd = m_com.GetImageView(m_strFile, ref rect, pictureBox2.Handle);
					if(IntPtr.Zero == m_hViewWnd)
					{
						MessageBox.Show("プレビュー取得に失敗しました", "GetImageView error!!", MessageBoxButtons.OK, MessageBoxIcon.Error);
					}
				}
			}
			catch(Exception e)
			{
				MessageBox.Show(e.Message, "JwCADInfo COM error!!",MessageBoxButtons.OK, MessageBoxIcon.Error);
			}
		}
		/// <summary>
		/// プレビューのサイズ変更
		/// </summary>
		/// <param name="sender">送信元</param>
		/// <param name="e">パラメータ</param>
		private void OnSizeChanged(object sender, EventArgs e)
		{
			const short SWP_NOMOVE		= 0x0002;
			const short SWP_NOZORDER	= 0x0004;
			const short SWP_NOACTIVATE	= 0x0010;
			Win32APICall.SetWindowPos(m_hViewWnd, 0, 0, 0, pictureBox2.Width, pictureBox2.Height,
				SWP_NOMOVE | SWP_NOZORDER | SWP_NOACTIVATE);
		}
		/// <summary>
		/// ファイル選択ボタン
		/// </summary>
		/// <param name="sender">送信元</param>
		/// <param name="e">パラメータ</param>
		private void button2_Click(object sender, EventArgs e)
		{
			OpenFileDialog ofd = new OpenFileDialog();
			ofd.Filter = "JwCAD File(*.jww;*.jws;*.jwc;*.jwk)|*.jww;*.jws;*.jwc;*.jwk";
			ofd.Title  = "ファイルを選択してください";
			if(ofd.ShowDialog() == DialogResult.OK)
			{
				m_strFile = ofd.FileName;
				ImageUpdate(true, true);
			}
		}
		/// <summary>
		/// Radioボタンの選択
		/// </summary>
		/// <param name="sender">送信元</param>
		/// <param name="e">パラメータ</param>
		private void OnRadioChange(object sender, EventArgs e)
		{
			RadioButton	radio = sender as RadioButton;
			if(null == radio)
				return;

			switch(radio.Text)
			{
			case	"16":	m_ImageSize = 16;	break;
			case	"32":	m_ImageSize = 32;	break;
			case	"48":	m_ImageSize = 48;	break;
			case	"64":	m_ImageSize = 64;	break;
			case	"128":	m_ImageSize = 128;	break;
			case	"256":	m_ImageSize = 256;	break;
			}
			ImageUpdate(true, false);
		}
	}
	/// <summary>
	/// Win32 APIコール
	/// </summary>
	public class Win32APICall
	{
		[DllImport("gdi32.dll")]
		internal static extern int DeleteObject(System.IntPtr hobject);
		[DllImport("user32.dll")]
		internal static extern bool DestroyWindow(IntPtr hWnd);
		[DllImport("user32.dll")]
		internal static extern IntPtr SetWindowPos(IntPtr hWnd, int hAfter, int x, int Y, int cx, int cy, int wFlags);
	}
}
