unit Frame;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, CalendarX, jpeg, GIFImage;

type
  TFrameForm = class(TForm)
    Panel1: TPanel;
    Edit1: TEdit;
    Label1: TLabel;
    Edit2: TEdit;
    Label2: TLabel;
    Memo1: TMemo;
    Button1: TButton;
    ScrollBox1: TScrollBox;
    CalendarX1: TCalendarX;
    Label3: TLabel;
    Edit3: TEdit;
    Label4: TLabel;
    Edit4: TEdit;
    Label5: TLabel;
    Edit5: TEdit;
    Label6: TLabel;
    Edit6: TEdit;
    Label7: TLabel;
    Edit7: TEdit;
    Label8: TLabel;
    Edit8: TEdit;
    Edit9: TEdit;
    Label9: TLabel;
    Edit10: TEdit;
    Label10: TLabel;
    Edit11: TEdit;
    Label11: TLabel;
    Edit12: TEdit;
    Label12: TLabel;
    CheckBox1: TCheckBox;
    CheckBox2: TCheckBox;
    Button2: TButton;
    FontDialog1: TFontDialog;
    CheckBox3: TCheckBox;
    CheckBox4: TCheckBox;
    Button3: TButton;
    OpenDialog1: TOpenDialog;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure CheckBox1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure CheckBox2Click(Sender: TObject);
    procedure CheckBox3Click(Sender: TObject);
    procedure CheckBox4Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
    procedure FormCloseQuery(Sender: TObject; var CanClose: Boolean);
  private
    { Private 錾 }
  public
    { Public 錾 }
    Year, Month: Integer;
    OrgBitmap: TBitmap;
    procedure MakeOrgBitmap;
  end;

var
  FrameForm: TFrameForm;

implementation

{$R *.DFM}

procedure TFrameForm.Button1Click(Sender: TObject);
begin
  {FileName := Application.ExeName;
  FileName := ExtractFilePath(FileName);
  CalendarX1.Picture.LoadFromFile(FileName + 'Sample.bmp');}


  CalendarX1.CalendarEnabled := False;
  CalendarX1.CalendarLeft := 10;
  CalendarX1.CalendarTop := 10;
  CalendarX1.StartYear := StrToInt(Edit1.Text);
  CalendarX1.StartMonth := StrToInt(Edit2.Text);
  CalendarX1.StartPoint := StrToInt(Edit3.Text);
  CalendarX1.Count := StrToInt(Edit4.Text);
  CalendarX1.ColB := StrToInt(Edit5.Text);
  CalendarX1.RowB := StrToInt(Edit6.Text);
  CalendarX1.ColC := StrToInt(Edit7.Text);
  CalendarX1.RowC := StrToInt(Edit8.Text);
  CalendarX1.DayH := StrToInt(Edit9.Text);
  CalendarX1.DayW := StrToInt(Edit10.Text);
  CalendarX1.GapH := StrToInt(Edit11.Text);
  CalendarX1.GapW := StrToInt(Edit12.Text);
  CalendarX1.Lines := CheckBox1.Checked;
  CalendarX1.SundayRed := CheckBox2.Checked;
  CalendarX1.HolidayRed := CheckBox3.Checked;
  CalendarX1.CalendarOnly := CheckBox4.Checked;
  CalendarX1.Canvas.Font := Memo1.Font;
  CalendarX1.CalendarEnabled := True;

  Memo1.Text := CalendarX1.ListC.Text;
  Edit4.Text := IntToStr(CalendarX1.Count);
  CalendarX1.CalendarEnabled := False;
end;

procedure TFrameForm.FormShow(Sender: TObject);
begin
  ClientWidth := 818;
  ClientHeight := 517;
  OrgBitmap := TBitmap.Create;
  CalendarX1.Canvas.Font := Memo1.Font;
  Button1Click(Sender);
end;

procedure TFrameForm.CheckBox1Click(Sender: TObject);
begin
  Button1Click(Sender);
end;

procedure TFrameForm.Button2Click(Sender: TObject);
begin
  FontDialog1.Font := Memo1.Font;
  if FontDialog1.Execute then
  begin
    Memo1.Font := FontDialog1.Font;
    Button1Click(Sender);
  end;
end;

procedure TFrameForm.CheckBox2Click(Sender: TObject);
begin
  Button1Click(Sender);
end;

procedure TFrameForm.CheckBox3Click(Sender: TObject);
begin
  Button1Click(Sender);
end;

procedure TFrameForm.CheckBox4Click(Sender: TObject);
begin
  Button1Click(Sender);
end;

procedure TFrameForm.Button3Click(Sender: TObject);
begin
  if Opendialog1.Execute then
  begin
    CheckBox4.Checked := False;
    CalendarX1.Picture.LoadFromFile(Opendialog1.FileName);
    MakeOrgBitmap;
    CalendarX1.Picture.Assign(OrgBitmap);
  end;
end;

procedure TFrameForm.MakeOrgBitmap; // ݂̉摜 OrgBitmap ɕۑ葱
begin
  if CalendarX1.Picture.Graphic = Nil then
    Exit;
  if (CalendarX1.Picture.Graphic is TBitmap) or
     (CalendarX1.Picture.Graphic is TJPEGImage) or
     (CalendarX1.Picture.Graphic is TGIFImage) then
    OrgBitmap.Assign(CalendarX1.Picture.Graphic)
  else
  begin
    OrgBitmap.Width := CalendarX1.Picture.Graphic.Width;
    OrgBitmap.Height := CalendarX1.Picture.Graphic.Height;
    OrgBitmap.Canvas.Draw(0, 0, CalendarX1.Picture.Graphic);
  end;
end;

procedure TFrameForm.FormCloseQuery(Sender: TObject;
  var CanClose: Boolean);
begin
  OrgBitmap.Free;
end;

end.
