unit CalendarX;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls;

const
  { ej1\W߂ }
  Whatdays: String = 'SMTWtFs'; // Sun, Mon, Tue, Wed, thu, Fri, sat ̓

  { ̓ }
  Monthdays: array[1..12] of Integer = (31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31);

  { 2025 N݂̏j̈ꗗf[^ }
  Holiday2025: String = '0101' + #13#10 + '01M2' + #13#10 + '0211' + #13#10 +
                        '0223' + #13#10 + '0320' + #13#10 + '0429' + #13#10 +
                        '0503' + #13#10 + '0504' + #13#10 + '0505' + #13#10 +
                        '07M3' + #13#10 + '0811' + #13#10 + '09M3' + #13#10 +
                        '0923' + #13#10 + '10M2' + #13#10 + '1103' + #13#10 +
                        '1123';

  { 2020 ` 2050 N̏HEt̗\l̃f[^ }
  HolidaySM2020: String = '22202020' + #13#10 + '23202021' + #13#10 +
                          '23212022' + #13#10 + '23212023' + #13#10 +
                          '22202024' + #13#10 + '23202025' + #13#10 +
                          '23202026' + #13#10 + '23212027' + #13#10 +
                          '22202028' + #13#10 + '23202029' + #13#10 +
                          '23202030' + #13#10 + '23212031' + #13#10 +
                          '22202032' + #13#10 + '23202033' + #13#10 +
                          '23202034' + #13#10 + '23212035' + #13#10 +
                          '22202036' + #13#10 + '23202037' + #13#10 +
                          '23202038' + #13#10 + '23212039' + #13#10 +
                          '22202040' + #13#10 + '23202041' + #13#10 +
                          '23202042' + #13#10 + '23212043' + #13#10 +
                          '22202044' + #13#10 + '22202045' + #13#10 +
                          '23202046' + #13#10 + '23212047' + #13#10 +
                          '22202048' + #13#10 + '22202049' + #13#10 +
                          '23202050';

type
  { TCalendarX Ŏgp{f[^^ }
  PDateC = ^TDateC;
  TDateC = record
    Year: Integer;     // N
    Month: Integer;    // (1 ` 12)
    Day: Integer;      // (1 ` 31)
    Whatday: Integer;  // j(1 ` 7 ==> ΐ؋y)
    Week: Integer;     // T(1 ` 6)
  end;

  { TCalendarX NX }
  TCalendarX = class(TImage)
  private
    { Private 錾 }
    FBmpM: TBitmap; // J_[1̃rbg}bvf[^̊i[
    FBmpB: TBitmap; // J_[1ubÑrbg}bvf[^̊i[
    FListM: TStringList; // J_[1̃eLXgf[^̊i[
    FListB: TStringList; // J_[1ubÑeLXgf[^̊i[
    FListC: TStringList; // J_[Ŝ̃eLXgf[^̊i[
    FHoliday: TStringList; // j̈ꗗf[^̊i[
    FHolidaySM: TStringList; // HEt̗\l̊i[
    FAutoSM: Boolean; // HEtIɕύX邩ǂ߂B
    FCalendarEnabled: Boolean; // J_[̕\Lɂ邩ǂ߂B
    FCalendarLeft: Integer; // J_[\鍶̃sNZPʂXW
    FCalendarTop: Integer; // J_[\鍶̃sNZPʂYW
    FCalendarOnly: Boolean; // J_[݂̂\B
    FStartYear: Integer; // J_[̕\JnN()
    FStartMonth: Integer; // J_[̕\Jn(1 ` 12)
    FRowB: Integer; // 1ubN̏č(1 ` 12)
    FColB: Integer; // 1ubN̉̌(1 ` 12)
    FRowC: Integer; // J_[̏c̍őubN(1 ` 12)
    FColC: Integer; // J_[̉̍őubN(1 ` 12)
    FStartPoint: Integer; // ubNɂ\Jnʒu(1 ` RowB * ColB)
    FCount: Integer; // v\(1 ` 12 * 12)
    FRCount: Integer; // ۂ̕\
    FDayH: Integer; // t̍(1 ` 10 )
    FDayW: Integer; // t̕(3 ` 10 )
    FGapH: Integer; // ԂubNԂ̏c̃Mbv(0 ` 10 )
    FGapW: Integer; // ԂubNԂ̉̃Mbv(0 ` 10 )
    FLines: Boolean; // J_[Ɍrǂ߂B
    FSundayRed: Boolean; // j̓tԂ\邩ǂ߂B
    FHolidayRed: Boolean; // j̓tԂ\邩ǂ߂B
    FSizeMT: TSize; // J_[1̃eLXg̍sƗ
    FSizeMB: TSize; // J_[1̃rbg}bv̏cƉ̃TCY
    FSizeBT: TSize; // ubN1̃eLXg̍sƗ
    FSizeBB: TSize; // ubN1̃rbg}bv̏cƉ̃TCY
    FSizeCT: TSize; // J_[Ŝ̃eLXg̍sƗ
    FSizeCB: TSize; // J_[Ŝ̃rbg}bv̏cƉ̃TCY
    FSpaceB: TSize;  // Xy[X1̃rbg}bv̏cƉ̃TCY
    procedure SetCalendarEnabled(const Value: Boolean);
    procedure SetCalendarLeft(const Value: Integer);
    procedure SetCalendarTop(const Value: Integer);
    procedure SetCalendarOnly(const Value: Boolean);
    procedure SetStartYear(const Value: Integer);
    procedure SetStartMonth(const Value: Integer);
    procedure SetRowB(const Value: Integer);
    procedure SetColB(const Value: Integer);
    procedure SetRowC(const Value: Integer);
    procedure SetColC(const Value: Integer);
    procedure SetStartPoint(const Value: Integer);
    procedure SetCount(const Value: Integer);
    procedure SetDayH(const Value: Integer);
    procedure SetDayW(const Value: Integer);
    procedure SetGapH(const Value: Integer);
    procedure SetGapW(const Value: Integer);
    procedure SetLines(const Value: Boolean);
    procedure SetSundayRed(const Value: Boolean);
    procedure SetHolidayRed(const Value: Boolean);
    procedure SetAutoSM(const Value: Boolean);
    procedure PrepareVoidBlock(Year: Integer);
    procedure PrepareVoidCalendar;
    procedure MoveStrToList(S: String; List: TStringList; Loc: TPoint);
    procedure MoveListToList(SList, DList: TStringList; Loc: TPoint);
    procedure CollectSize;
  protected
    { Protected 錾 }
    procedure MakeMonthT(Year, Month: Integer);
    procedure MakeMonthG(Year, Month: Integer);
    procedure MakeCalendar;
  public
    { Public 錾 }
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    { J\bh錾 }
    function LeapYear(Year: Integer): Boolean; virtual;
    function FirstWhatday(Year, Month: Integer): Integer; virtual;
    function GetDay(var DC: TDateC): Boolean; virtual;
    function GetWhatday(var DC: TDateC): Boolean; virtual;
    { vpeB錾 }
    property ListC: TStringList read FListC;
    property Holiday: TStringList read FHoliday;
    property HolidaySM: TStringList read FHolidaySM;
  published
    { Published 錾(vpeB錾) }
    property CalendarEnabled: Boolean read FCalendarEnabled write SetCalendarEnabled default False;
    property CalendarLeft: Integer read FCalendarLeft write SetCalendarLeft default 0;
    property CalendarTop: Integer read FCalendarTop write SetCalendarTop default 0;
    property CalendarOnly: Boolean read FCalendarOnly write SetCalendarOnly default True;
    property StartYear: Integer read FStartYear write SetStartYear nodefault;
    property StartMonth: Integer read FStartMonth write SetStartMonth default 1;
    property RowB: Integer read FRowB write SetRowB default 4;
    property ColB: Integer read FColB write SetColB default 3;
    property RowC: Integer read FRowC write SetRowC default 1;
    property ColC: Integer read FColC write SetColC default 1;
    property StartPoint: Integer read FStartPoint write SetStartPoint default 1;
    property Count: Integer read FCount write SetCount default 12;
    property RCount: Integer read FRCount;
    property DayH: Integer read FDayH write SetDayH default 1;
    property DayW: Integer read FDayW write SetDayW default 4;
    property GapH: Integer read FGapH write SetGapH default 1;
    property GapW: Integer read FGapW write SetGapW default 2;
    property Lines: Boolean read FLines write SetLines default False;
    property SundayRed: Boolean read FSundayRed write SetSundayRed default False;
    property HolidayRed: Boolean read FHolidayRed write SetHolidayRed default False;
    property AutoSM: Boolean read FAutoSM write SetAutoSM default True;
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('ToolBox', [TCalendarX]);
end;

{ TCalendarX }

constructor TCalendarX.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);
  FBmpM := TBitmap.Create; // J_[1̃rbg}bvf[^̊i[
  FBmpM.Width := 105;
  FBmpM.Height := 105;
  FBmpB := TBitmap.Create; // J_[1ubÑrbg}bvf[^̊i[
  FBmpB.Width := 105;
  FBmpB.Height := 105;
  FListM := TStringList.Create; // J_[1̃eLXgf[^̊i[
  FListM.Duplicates := dupAccept; // f[^̏d͂B
  FListB := TStringList.Create; // J_[1ubÑeLXgf[^̊i[
  FListB.Duplicates := dupAccept; // f[^̏d͂B
  FListC := TStringList.Create; // J_[Ŝ̃eLXgf[^̊i[
  FListC.Duplicates := dupAccept; // f[^̏d͂B
  FHoliday := TStringList.Create; // j̈ꗗf[^̊i[
  FHoliday.Duplicates := dupAccept; // f[^̏d͂B
  FHoliday.Text := Holiday2025; // 2025 N̏j̈ꗗf[^
  FHolidaySM := TStringList.Create; // HEt̗\l̊i[
  FHolidaySM.Duplicates := dupAccept; // f[^̏d͂B
  FHolidaySM.Text := HolidaySM2020; // 2020 ` 2050 N̏HEt̃f[^
  FRowB := 4; // 1ubN̏č
  FColB := 3; // 1ubN̉̌
  FRowC := 1; // J_[̏c̍őubN
  FColC := 1; // J_[̉̍őubN
  FCalendarEnabled := False; // J_[̕\Lɂ邩ǂ߂B
  FCalendarLeft := 0; // J_[\鍶XW
  FCalendarTop := 0; // J_[\鍶YW
  FCalendarOnly := True; // J_[݂̂\B
  FStartYear := 2024; // J_[̕\JnN()
  FStartMonth := 1; // J_[̕\Jn(1 ` 12)
  FStartPoint := 1; // ubNɂ\Jnʒu
  FCount := 12; // v\(1 ` 12 * 12)
  FRCount := 0; // ۂ̕\
  FDayH := 1; // t̍(1 ` 10 )
  FDayW := 4; // t̕(3 ` 10 )
  FGapH := 1; // ԂubNԂ̏c̃Mbv(0 ` 10 )
  FGapW := 2; // ԂubNԂ̉̃Mbv(0 ` 10 )
  FLines := False; // J_[̕\Lɂ邩ǂ߂B
  FSundayRed := False; // j̓tԂ\邩ǂ߂B
  FHolidayRed := False; // j̓tԂ\邩ǂ߂B
  FAutoSM := True; // HEtIɕύX邩ǂ߂B
end;

destructor TCalendarX.Destroy;
begin
  FHolidaySM.Free;
  FHoliday.Free;
  FListC.Free;
  FListB.Free;
  FListM.Free;
  FBmpB.Free;
  FBmpM.Free;
  inherited Destroy;
end;

{ J_[̊eTCXW葱łB}

procedure TCalendarX.CollectSize;
var
  W, H: Integer;
  S, Sp: String;
  E: TSize;
begin
  { tHg̐ݒ }
  FBmpM.Canvas.Font := Canvas.Font;  
  FBmpB.Canvas.Font := Canvas.Font;  

  { Xy[X1̃rbg}bv̏cƉ̃TCY߂B}
  Sp := ' ';
  E := FBmpM.Canvas.TextExtent(Sp);
  FSpaceB.cx := E.cx;
  FSpaceB.cy := E.cy;

  { J_[1̃TCY߂B}
  FSizeMT.cx := FDayW * 7;
  FSizeMT.cy := 1 + 1 + FDayH * 6;
  S := StringOfChar(' ', FDayW * 7);
  E := FBmpM.Canvas.TextExtent(S);
  FSizeMB.cx := E.cx;
  H := E.cy; // 1s̍
  FSizeMB.cy := H + H + H * FDayH * 6;

  { ubN1̃TCY߂B}
  FSizeBT.cx := FSizeMT.cx * FColB + FGapW * (FColB + 1);
  FSizeBT.cy := 1 +  FSizeMT.cy * FRowB + GapH * (FRowB + 1);
  W := FSpaceB.cx * FGapW;
  H := FSpaceB.cy * FGapH;
  FSizeBB.cx := FSizeMB.cx * FColB + W * (FColB + 1);
  FSizeBB.cy := FSpaceB.cy + FSizeMB.cy * FRowB + H * (FRowB + 1);

  { J_[Ŝ̃TCY߂B}
  FSizeCT.cx := FSizeBT.cx * FColC + FGapW * (FColC + 1);
  FSizeCT.cy := FSizeBT.cy * FRowC + FGapH * (FRowC + 1);
  FSizeCB.cx := FSizeBB.cx * FColC + W * (FColC + 1);
  FSizeCB.cy := FSizeBB.cy * FRowC + H * (FRowC + 1);
end;

{ ^ꂽ1̗jԂ֐łB}

function TCalendarX.FirstWhatday(Year, Month: Integer): Integer;
var
  i, Sum: Integer;
begin
  Result := 0; // G[̏ꍇ̖߂l
  if not (Month in [1..12]) then
    Exit;

  Sum := 2;
  if Year >= 1 then // 1N = I1N(AD1N) `
  begin 
    for i := 1 to Year - 1 do
    begin
      Sum := Sum + 365;
      if LeapYear(i) Then Inc(Sum);
    end;

    for i := 1 to Month - 1 do
    begin
      Sum := Sum + Monthdays[i];
      if (i = 2) and LeapYear(Year) then Inc(Sum);
    end;
  end
  else // ` 0N = IO1N(BC1N)
  begin 
    for i := 0 downto Year + 1 do
    begin
      Sum := Sum + 365;
      if LeapYear(i) Then Inc(Sum);
    end;

    for i := 12 downto Month do
    begin
      Sum := Sum + Monthdays[i];
      if (i = 2) and LeapYear(Year) then Inc(Sum);
    end;
  end;

  Result := ((Sum - 1) mod 7) + 1;
end;

{ TDateC  Day ȊÕo[ Day ߂֐łB}
{  True Ԃ܂B}

function TCalendarX.GetDay(var DC: TDateC): Boolean;
var
  Day, Whatday, Week, Mdays: Integer;
begin
  Result := False;
  if (not (DC.Month in [1..12])) or
     (not (DC.Whatday in [1..7]))  or
     (not (DC.Week in [1..6])) then
    Exit;

  Day := 1; // 1 
  Whatday := FirstWhatday(DC.Year, DC.Month);
  Week := 1; // 1 T
  Mdays := Monthdays[DC.Month]; // ̓
  if (DC.Month = 2) and LeapYear(DC.Year) then
    Inc(Mdays);

  while (Day <= Mdays) and (Week <= 6) do
  begin
    if (Week = DC.Week) and (Whatday = DC.Whatday) then
    begin
      Result := True;
      DC.Day := Day; // ߂ꂽB
      Break;
    end;
    Inc(Day); 
    Inc(Whatday);
    if Whatday > 7 then
    begin
      Whatday := 1; // j
      Inc(Week);
    end;
  end;
end;

{ TDateC  Whatday  Week ȊÕo[ Whatday  Week  }
{ ߂֐łB True Ԃ܂B}

function TCalendarX.GetWhatday(var DC: TDateC): Boolean;
var
  Day, Whatday, Week, Mdays: Integer;
begin
  Result := False;
  if not (DC.Month in [1..12]) then
    Exit;

  Mdays := Monthdays[DC.Month]; // ̓
  if (DC.Month = 2) and LeapYear(DC.Year) then
    Inc(Mdays);
  if (DC.Day < 1) or (DC.Day > Mdays) then
    Exit;

  Day := 1; // 1 
  Whatday := FirstWhatday(DC.Year, DC.Month);
  Week := 1; // 1 T

  while (Day <= Mdays) and (Week <= 6) do
  begin
    if Day = DC.Day then
    begin
      Result := True;
      DC.Whatday := Whatday; // j߂ꂽB
      DC.Week := Week; // Tڂ߂ꂽB
      Break;
    end;
    Inc(Day); 
    Inc(Whatday);
    if Whatday > 7 then
    begin
      Whatday := 1; // j
      Inc(Week);
    end;
  end;
end;

{ ^ꂽN邤Nł邩ǂԂ֐łB}

function TCalendarX.LeapYear(Year: Integer): Boolean;
begin
  Result := False;
  if (Year mod 4) = 0 then
  begin
    Result := True;
    if (Year mod 100) = 0 then
    begin
      Result := False;
      if (Year mod 400) = 0 then
        Result := True;
    end;
  end;
end;

procedure TCalendarX.MakeCalendar;
var
  iCount, // Ԗڂ̌\Ă邩 (1 ` Count)
  iPoint, // ubN̂ǂ̈ʒuɂ邩B(1 ` RowB * ColB)
  iBlock, // Ԗڂ̃ubN\Ă邩B(1 ` )
  iYear, // N\Ă邩B(StartYear ` )
  iMonth: Integer; // \Ă邩B(1 ` 12)
  MCount, Row, Col, X, Y: Integer;
  Loc: TPoint;
begin
  if FCalendarEnabled = False then
    Exit;

  FRCount := FCount;
  MCount := FRowB * FColB * FRowC * FColC; // ő匎
  if FRCount > MCount then
    FRCount := MCount; // ۂ̕\

  CollectSize;
  iYear := FStartYear;
  iMonth := FStartMonth;
  iBlock := 1;
  iPoint := FStartPoint;
  iCount := 1;
  PrepareVoidCalendar;

  While iCount <= FRCount do
  begin
    PrepareVoidBlock(iYear);
    while (iCount <= FRCount) and (iPoint <= FRowB * FColB) do
    begin
      MakeMonthT(iYear, iMonth);
      Row := (iPoint - 1) div ColB + 1;
      Col := (iPoint - 1) mod ColB + 1;
      Loc.Y := (FGapH + FSizeMT.cy) * (Row - 1) + FGapH + 1;
      Loc.X := (FGapW + FSizeMT.cx) * (Col - 1) + FGapW + 1;
      MoveListToList(FListM, FListB, Loc);
      X := FGapW * FSpaceB.cx + (Col - 1) * (FSizeMB.cx + FGapW * FSpaceB.cx);
      Y := (FGapH + 1) * FSpaceB.cy + (Row - 1) * (FSizeMB.cy + GapH * FSpaceB.cy);
      MakeMonthG(iYear, iMonth);
      FBmpB.Canvas.Draw(X, Y, FBmpM);
      Inc(iCount);
      Inc(iPoint);
      Inc(iMonth);
      if iMonth = 13 then
      begin
        Inc(iYear);
        iMonth := 1;
      end;
    end;
    Row := (iBlock - 1) div ColC + 1;
    Col := (iBlock - 1) mod ColC + 1;
    Loc.Y := (FGapH + FSizeBT.cy) * (Row - 1) + FGapH;
    Loc.X := (FGapW + FSizeBT.cx) * (Col - 1) + FGapW + 1;
    MoveListToList(FListB, FListC, Loc);
    X := FCalendarLeft + FGapW * FSpaceB.cx + (Col - 1) * (FSizeBB.cx + FGapW * FSpaceB.cx);
    Y := FCalendarTop + FGapH * FSpaceB.cy + (Row - 1) * (FSizeBB.cy + FGapH * FSpaceB.cy);
    Canvas.Draw(X, Y, FBmpB);
    Inc(iBlock);
    iPoint := 1;
  end;
end;

{ J_[1̃rbg}bvf[^ FBmpM ɍ쐬葱łB}
{ ̎葱 MakeMonthT() ŁAFListM 1̃eLXgf[^擾 }
{ ŌĂяoĉB}

procedure TCalendarX.MakeMonthG(Year, Month: Integer);
var
  i, j, k, X, Y, Mdays: Integer;
  H, W, RX, BY, FW: Integer;
  C, S, M: String;
  E: TSize;
  DC: TDateC;

  procedure PaintWhatdays;
  var
    i: Integer;
  begin
    for i := 1 to 7 do
    begin
      k := X + Round((i - 1) * (FSizeMB.cx / 7));
      S := Copy(FListM[1], (i - 1) * FDayW + 1, 2);
      FBmpM.Canvas.TextOut(k, Y, S);
    end;
  end;

  procedure PaintDay;
  begin
    S := Copy(FListM[DC.Week + 1], 1, FDayW * (DC.Whatday - 1));
    E := FBmpM.Canvas.TextExtent(S);
    X := E.cx + 3; //  3 sNZ炷B
    Y := FSpaceB.cy * 2 + FSpaceB.cy * FDayH * (DC.Week - 1) + 1; // c 1 sNZ炷B
    C := IntToStr(DC.Day);
    FBmpM.Canvas.TextOut(X, Y, C);
  end;

  { j̈ꗗf[^ Holiday: TStringList; ̏HEt }
  { t̔N̐lɕύX葱łB}

  procedure CorrectHolidaySM;
  var
    i: Integer;
    A, G, H: String;
  begin
    if (not FAutoSM) or (not (Month in [3, 9])) then
      Exit;

    for i := 0 to FHolidaySM.Count - 1 do
    begin
      H := FHolidaySM[i];
      A := Copy(H, 5, Length(H) - 4); // N𓾂B
      try
        if StrToInt(A) = Year then  Break // NvB
        else H := '';
      except
        H := '';
      end;
    end;
    if H = '' then Exit; // G[

    for i := 0 to FHoliday.Count - 1 do
    begin
      G := FHoliday[i];

      if (Month = 3) and (Pos('032', G) = 1)then
      begin
        A := Copy(H, 3, 2);
        G[3] := A[1]; G[4] := A[2];
        FHoliday[i] := G;
      end;

      if (Month = 9) and (Pos('092', G) = 1)then
      begin
        A := Copy(H, 1, 2);
        G[3] := A[1]; G[4] := A[2];
        FHoliday[i] := G;
      end;
    end;
  end;

begin
  FBmpM.Width := FSizeMB.cx + 1; // r 1 sNZ₷B
  FBmpM.Height := FSizeMB.cy + 1; // r 1 sNZ₷B
  FBmpM.Canvas.Brush.Color := clWhite;
  FBmpM.Canvas.FillRect(Rect(0, 0, FBmpM.Width, FBmpM.Height));

  X := 3; Y := 1; //  3 sNZAc 1 sNZ炷B
  for i := 0 to FListM.Count - 1 do
  begin
    if (i = 1) and (fsBold	in FBmpM.Canvas.Font.Style) then
      PaintWhatdays
    else
      FBmpM.Canvas.TextOut(X, Y, FListM[i]);
    Y := Y + FSpaceB.cy;
  end;

  if FSundayRed then // j̓tԂ\B
  begin
    FBmpM.Canvas.Font.Color := clRed;
    X := 3; Y := 1; //  3 sNZAc 1 sNZ炷B
    for i := 0 to FListM.Count - 1 do
    begin
      C := Copy(FListM[i], 1, 2);
      if C <> '  ' then
        FBmpM.Canvas.TextOut(X, Y, C);
      Y := Y + FSpaceB.cy;
    end;
    FBmpM.Canvas.Font.Color := clBlack;
  end;    

  if FHolidayRed then // j̓tԂ\B
  begin
    CorrectHolidaySM; // HEt̓t̔N̐tɕύXB

    FBmpM.Canvas.Font.Color := clRed;
    FW := FirstWhatday(Year, Month); // 1̗j
    Mdays := Monthdays[Month]; // ̓
    if (Month = 2) and LeapYear(Year) then Inc(Mdays);
    M := StringOfChar(' ', 35);

    j := FW;
    for i := 1 to 35 do
    begin 
      if i > Mdays then M[i] := 'E' // f[^GAO
      else if j = 1 then M[i] := 'S'; // j
      Inc(j); 
      if j = 8 then j := 1;
    end;

    DC.Year := Year;
    DC.Month := Month;
    DC.Day := 0;
    DC.Whatday := 0;
    DC.Week := 0;

    for i := FHoliday.Count - 1 downto 0 do
    begin
      C := Copy(FHoliday[i], 1, 2); // 擪 2 
      try
        X := StrToInt(C);
      except
        X := 0; // L蓾Ȃl
      end;
      if X = Month then // Y
      begin
        C := Copy(FHoliday[i], 3, 1); // 3 
        DC.Whatday := Pos(C, Whatdays);
        if DC.Whatday <> 0 then // 3 ڂB
        begin
          C := Copy(FHoliday[i], 4, 1); // 4 
          try
            DC.Week := StrToInt(C);
          except
            DC.Week := 7; // L蓾Ȃl
          end;
          if DC.Whatday < FirstWhatday(Year, Month) then
            DC.Week := DC.Week + 1; // ̏TɂB
          if GetDay(DC) = False then // DC.Day ߂B
            Continue; // G[
        end
        else // 3 ڂȂB
        begin
          C := Copy(FHoliday[i], 3, 2); // 3 ڂ 2 
          try
            DC.Day := StrToInt(C);
          except
            DC.Day := 0; // L蓾Ȃl
          end;
          if GetWhatday(DC) = False then // DC.Whatday  DC.Week ߂B
            Continue; // G[
        end;

        if DC.Whatday = 1 then // j̏ꍇ DC.Day ł߂B
        begin
          j := DC.Day + 1; K := DC.Whatday + 1; // ̓炳B
          while M[j] = 'H' do
          begin
            Inc(j); Inc(k);
          end;
          if M[j] = ' ' then // 
          begin
            DC.Day := j; DC.Whatday := k mod 7;
          end;
        end;
        
        PaintDay; // jԂŕ`
        M[DC.Day] := 'H'; // j̃TC
        if (M[DC.Day + 1] = ' ') and (M[DC.Day + 2] = 'H') then
        begin
          DC.Day := DC.Day + 1;
          DC.Whatday := (DC.Whatday + 1) mod 7;
          PaintDay; // jԂŕ`
          M[DC.Day] := 'H'; // j̃TC
        end;
      end;  
    end;  
    FBmpM.Canvas.Font.Color := clBlack;
  end;

  if FLines then // r
  begin
    X := Monthdays[Month];
    if (Month = 2) and  LeapYear(Year) then Inc(X);
    DC.Year := Year;
    DC.Month := Month;
    DC.Day := X; // ̍ŏI
    DC.Whatday := 0; // ߂l
    DC.Week := 0; // ߂l
    if GetWhatday(DC) = False then Exit; // G[

    W := Round(FSizeMB.cx / 7); // t1̕
    H := FSpaceB.cy * FDayH; // t1̍
    RX := W * 7; // E[ X W
    if RX > FSizeMB.cx then RX := FSizeMB.cx;
    BY := FSpaceB.cy * 2 + H * DC.Week; // [ Y W
    if BY > FSizeMB.cy then BY := FSizeMB.cy;

    X := 0; Y := 0;
    for i := 1 to 2 + DC.Week + 1 do
    begin
      FBmpM.Canvas.MoveTo(X, Y);
      FBmpM.Canvas.LineTo(RX, Y);
      if i in [1, 2] then Y := Y + FSpaceB.cy
      else Y := Y + H;
      if Y > BY then Y := BY;
    end;

    for i := 1 to 8 do
    begin
      if i in [1, 8] then Y := 0
      else Y := FSpaceB.cy;
      FBmpM.Canvas.MoveTo(X, Y);
      FBmpM.Canvas.LineTo(X, BY);
      X := X + W; if X > RX then X := RX;
    end;
  end;
end;

{ FListM ɃJ_[1̃eLXgf[^쐬葱łB}

procedure TCalendarX.MakeMonthT(Year, Month: Integer);
var
  i, n, W: Integer;
  Day, Whatday, Week, Mdays: Integer;
  S, Sp1, Sp2, Sp3, Sp4: String;
begin
  if not Month in [1..12] then
    Exit;

  { J_[1̃TCY߂B}
  W := FSizeMT.cx;

  { ̓߂B}
  Mdays := Monthdays[Month];
  if (Month = 2) and LeapYear(Year) then
    Inc(Mdays);

  { ł邩\B}
  FListM.Clear;
  S := StringOfChar(' ', FDayW * 3) + IntToStr(Month);
  n := W - Length(S);
  S := S + StringOfChar(' ', n);
  FListM.Add(S);

  { j\B}
  Sp2 := StringOfChar(' ', FDayW - 2);
  S := '' + Sp2 + '' + Sp2 + '' + Sp2 + '' + Sp2 +
       '' + Sp2 + '' + Sp2 + 'y' + Sp2;
  FListM.Add(S);

  Whatday := FirstWhatday(Year, Month); // Month 1̗j(1 ` 7)
  Day := 1 - Whatday + 1; // 1Tڂ̓j̘_Iȓt
  Week := 1;
  Sp1 := StringOfChar(' ', FDayW - 1);
  Sp3 := StringOfChar(' ', FDayW);
  Sp4 := StringOfChar(' ', FSizeMT.cx);

  while Week <= 6 do // 1͍ő6TԂłB
  begin
    S := '';
    Whatday := 1; // j
    while Whatday <= 7 do // j ` yj
    begin
      if (Day < 1) or (Day > Mdays) then
        S := S + Sp3 // DayW ̃Xy[X
      else if Day < 10 then
        S := S + IntToStr(Day) + Sp1
      else
        S := S + IntToStr(Day) + Sp2;
      Inc(Whatday);
      Inc(Day);
    end;
    FListM.Add(S); // 1 TԂ̓tǉ
    n := FDayH - 1;
    for i := 1 to n do
      FListM.Add(Sp4); // 1 TԂ̍ǉ
    Inc(Week);
  end;
end;

{ TStringList ̃f[^̈ꕔʂ TStringList ̃f[^ƒu }
{ 葱łBLoc  DList ̒uʒuł Loc.X ̍ŏl 1 }
{ Loc.Y ̍ŏl 0 ƂȂ ܂̂łӉB}

procedure TCalendarX.MoveListToList(SList, DList: TStringList; Loc: TPoint);
var
  i: Integer;
begin
  if (SList = Nil) or (DList = Nil) or (Loc.X < 1) or
     (Loc.Y < 0) or (Loc.Y > DList.Count - 1) then
    Exit;

  for i := 0 to SList.Count - 1 do
  begin
    MoveStrToList(SList[i], DList, Loc);
    Loc.Y := Loc.Y + 1;
  end;
end;

{ TStringList ̃f[^̈ꕔ𕶎ƒu葱łBLoc  }
{ List ̒uʒułALoc.X ̍ŏl 1ALoc.Y ̍ŏl }
{ 0 ƂȂ ܂̂łӉB}

procedure TCalendarX.MoveStrToList(S: String; List: TStringList; Loc: TPoint);
var
  i, n: Integer;
  L: String;
begin
  if (S = '') or (List = Nil) or (Loc.X < 1) or
     (Loc.Y < 0) or (Loc.Y > List.Count - 1) then
    Exit;

  L := List[Loc.Y];
  n := Length(L) - (Loc.X - 1);
  if n <= 0 then
    Exit
  else if n > Length(S) then
    n := Length(S);

  for i := 1 to n do
    L[Loc.X + i - 1] := S[i];

  List[Loc.Y] := L;
end;

{ ̃ubNpӂ֐łB}

procedure TCalendarX.PrepareVoidBlock(Year: Integer);
var
  i, W, H: Integer;
  S: String;
  Loc: TPoint;
begin
  { ubÑeLXg̑傫 }
  W := FSizeBT.cx;
  H := FSizeBT.cy;

  S := StringOfChar(' ', W);
  FListB.Clear;
  for i := 1 to H do
    FListB.Add(S);

  { N` }
  S := IntToStr(Year);
  Loc.X := (W - Length(S)) div 2;
  Loc.Y := 0;
  MoveStrToList(S, FListB, Loc);

  { ubÑrbg}bv̑傫 }
  W := FSizeBB.cx; H := FSizeBB.cy;
  FBmpB.Width := W; FBmpB.Height := H;
  FBmpB.Canvas.Brush.Color := clWhite;
  FBmpB.Canvas.FillRect(Rect(0, 0, W, H));

  { rbg}bvɔN` }
  FBmpB.Canvas.TextOut(0, 0, FListB[0]);
end;

{ ̃J_[pӂ֐łB}

procedure TCalendarX.PrepareVoidCalendar;
var
  i, W, H: Integer;
  S: String;
begin
  { J_[̃eLXg̑傫 }
  W := FSizeCT.cx;
  H := FSizeCT.cy;

  S := StringOfChar(' ', W);
  FListC.Clear;
  for i := 1 to H do
    FListC.Add(S);

  if FCalendarOnly then // J_[݂̂\ꍇ
  begin
    { J_[̃rbg}bv̑傫 }
    W := FCalendarLeft + FSizeCB.cx; H := FCalendarTop + FSizeCB.cy;
    Width := W; Height := H;
    Picture.Bitmap.Width := W; Picture.Bitmap.Height := H;
    Canvas.Brush.Color := clWhite;
    Canvas.FillRect(Rect(0, 0, W, H));
  end;
end;

procedure TCalendarX.SetAutoSM(const Value: Boolean);
begin
  FAutoSM := Value;
  MakeCalendar;
end;

procedure TCalendarX.SetCalendarEnabled(const Value: Boolean);
begin
  FCalendarEnabled := Value;
  MakeCalendar; 
end;

procedure TCalendarX.SetCalendarLeft(const Value: Integer);
begin
  FCalendarLeft := Value;
  MakeCalendar; 
end;

procedure TCalendarX.SetCalendarOnly(const Value: Boolean);
begin
  FCalendarOnly := Value;
  MakeCalendar; 
end;

procedure TCalendarX.SetCalendarTop(const Value: Integer);
begin
  FCalendarTop := Value;
  MakeCalendar; 
end;

procedure TCalendarX.SetColB(const Value: Integer);
begin
  if Value in [1..12] then
  begin
    FColB := Value;
    MakeCalendar;
  end; 
end;

procedure TCalendarX.SetColC(const Value: Integer);
begin
  if Value in [1..12] then
  begin
    FColC := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetCount(const Value: Integer);
begin
  if (Value >= 1) and (Value <= 12 * 12) then
  begin
    FCount := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetDayH(const Value: Integer);
begin
  if Value in [1..10] then
  begin
    FDayH := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetDayW(const Value: Integer);
begin
  if Value in [3..10] then
  begin
    FDayW := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetGapH(const Value: Integer);
begin
  if Value in [0..10] then
  begin
    FGapH := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetGapW(const Value: Integer);
begin
  if Value in [0..10] then
  begin
    FGapW := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetHolidayRed(const Value: Boolean);
begin
  FHolidayRed := Value;
  MakeCalendar;
end;

procedure TCalendarX.SetLines(const Value: Boolean);
begin
  FLines := Value;
  MakeCalendar;
end;

procedure TCalendarX.SetRowB(const Value: Integer);
begin
  if Value in [1..12] then
  begin
    FRowB := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetRowC(const Value: Integer);
begin
  if Value in [1..12] then
  begin
    FRowC := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetStartMonth(const Value: Integer);
begin
  if Value in [1..12] then
  begin
    FStartMonth := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetStartPoint(const Value: Integer);
begin
  if (Value >= 1) and (Value <= FRowB * FColB) then
  begin
    FStartPoint := Value;
    MakeCalendar;
  end;
end;

procedure TCalendarX.SetStartYear(const Value: Integer);
begin
  FStartYear := Value;
  MakeCalendar;
end;

procedure TCalendarX.SetSundayRed(const Value: Boolean);
begin
  FSundayRed := Value;
  MakeCalendar;
end;



end.

