/*------------------------------------------------------------------------------
    インクルード
------------------------------------------------------------------------------*/
#define COMMAND_CPP
#include "common.h"

/*------------------------------------------------------------------------------
    デファイン
------------------------------------------------------------------------------*/
#define RING_SIZE  200

/*------------------------------------------------------------------------------
    列挙
------------------------------------------------------------------------------*/
enum {
	NEW,
	ROTATE,
	DEFORM,
	RESIZE,
	CSV,
	APPEND,
	SEPARATE,
	TRIM,
};

/*------------------------------------------------------------------------------
    構造体
------------------------------------------------------------------------------*/
typedef struct st_Command {
	INT32 mode;
	WCHAR path[2][MAX_PATH];
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	BOOL v_h;
	INT32 pxl;
	WCHAR suffix[2][MAX_PATH];
	INT32 up;
	INT32 down;
	INT32 left;
	INT32 right;
} st_Command;

/*------------------------------------------------------------------------------
    ローカル変数
------------------------------------------------------------------------------*/
st_Command ring[RING_SIZE];
INT32 ringIdxPush;
INT32 ringIdxPop;
st_Command cmmn;

struct {
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	WCHAR path[2][MAX_PATH];
	BOOL v_h;
	INT32 pxl;
	INT32 up;
	INT32 down;
	INT32 left;
	INT32 right;
	st_Image img[2];
} cm;

struct {
	INT32 idx;
	WCHAR path[MAX_PATH];
	st_Image img;
} rd;

/*------------------------------------------------------------------------------
    プロトタイプ
------------------------------------------------------------------------------*/
void CmInit(void);
BOOL CmIsCommand(WCHAR *);
BOOL CmIsExist(WCHAR *);
void CmMode(WCHAR **, INT32);
void CmCopy(st_Command *, st_Command *);
BOOL CmRingPush(st_Command *);
BOOL CmRingPop(st_Command *);
void CmSetX(INT32);
void CmSetY(INT32);
void CmSetW(INT32);
void CmSetH(INT32);
void CmSetPath(WCHAR *, INT32);
void CmSetV_H(BOOL);
void CmSetPxl(INT32);
void CmSetUp(INT32);
void CmSetDown(INT32);
void CmSetLeft(INT32);
void CmSetRight(INT32);
INT32 CmGetX(void);
INT32 CmGetY(void);
INT32 CmGetW(void);
INT32 CmGetH(void);
WCHAR *CmGetPath(INT32);
BOOL CmGetV_H(void);
INT32 CmGetPxl(void);
INT32 CmGetUp(void);
INT32 CmGetDown(void);
INT32 CmGetLeft(void);
INT32 CmGetRight(void);
st_Image *CmGetImg(INT32);
void CmSaveFile(INT32);
void ThrCmStarting(void);
void ThrCmStart(void);
DWORD WINAPI ThrCmFunc(LPVOID);
BOOL ThrCmMsg(WPARAM, LPARAM);
void ThrCmLog(LCHAR *, ...);
WPARAM ThrCmWait(void);
void ThrCmEnd(void);
LRESULT CALLBACK WndProcCmd(HWND, UINT, WPARAM, LPARAM);
void ThrRdStart(INT32);
DWORD WINAPI ThrRdFunc(LPVOID);
void ThrRdImageRead(void);
void ThrRdEnd(void);

/*------------------------------------------------------------------------------
    書式：void CmInit(void)
    機能：コマンドモードを初期化する
------------------------------------------------------------------------------*/
void CmInit(void)
{
	INT32 i;
	
	for (i = 0; i < RING_SIZE; i++) {
		memset(&ring[i], 0x00, sizeof(st_Command));
	}
	ringIdxPush = 0;
	ringIdxPop  = 0;
	
	CmReady = TRUE;
	CmBusy  = FALSE;
	
	cm.x = 0;
	cm.y = 0;
	cm.w = 0;
	cm.h = 0;
	for (i = 0; i < 2; i++) {
		wmemset(cm.path[i], 0x0000, MAX_PATH);
		InitImg(&cm.img[i]);
	}
	
	rd.idx = 0;
	wmemset(rd.path, 0x0000, MAX_PATH);
	InitImg(&rd.img);
	
	WNDCLASS wc;
	wc.style         = CS_CLASSDC;
	wc.lpfnWndProc   = WndProcCmd;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = gInst;
	wc.hIcon         = NULL;
	wc.hCursor       = NULL;
	wc.hbrBackground = NULL;
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = NM_CMD;
	RegisterClass(&wc);
}

/*------------------------------------------------------------------------------
    書式：BOOL CmIsCommand(WCHAR *)
    引数：WCHAR *  -
    戻値：BOOL     -
    機能：コマンドモードかどうか判断する
------------------------------------------------------------------------------*/
BOOL CmIsCommand(WCHAR *pStr)
{
	if ((wcscmp(pStr, L"NEW")      == 0) ||
		(wcscmp(pStr, L"ROTATE") == 0) ||
		(wcscmp(pStr, L"DEFORM")   == 0) ||
		(wcscmp(pStr, L"RESIZE") == 0) ||
		(wcscmp(pStr, L"CSV")      == 0) ||
		(wcscmp(pStr, L"APPEND")   == 0) ||
		(wcscmp(pStr, L"SEPARATE") == 0) ||
		(wcscmp(pStr, L"TRIM")     == 0))
	{
		return TRUE;
	}
	else {
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    書式：BOOL CmIsExist(WCHAR *)
    引数：WCHAR *  -
    戻値：BOOL     -
    機能：ファイルの確認
------------------------------------------------------------------------------*/
BOOL CmIsExist(WCHAR *pStr)
{
	if (PathFileExists(pStr) == FALSE)                             {return FALSE;}
	if ((GetFileAttributes(pStr) & FILE_ATTRIBUTE_DIRECTORY) != 0) {return FALSE;}
	return TRUE;
}

/*------------------------------------------------------------------------------
    書式：void CmCopy(st_Command *, st_Command *)
    引数：st_Command *  -
          st_Command *  -
    機能：構造体データをコピー
------------------------------------------------------------------------------*/
void CmCopy(st_Command *adr1, st_Command *adr2)
{
	INT32 i;
	
	adr1->mode = adr2->mode;
	for (i = 0; i < 2; i++) {wcscpy(adr1->path[i], adr2->path[i]);}
	adr1->x     = adr2->x;
	adr1->y     = adr2->y;
	adr1->w     = adr2->w;
	adr1->h     = adr2->h;
	adr1->v_h   = adr2->v_h;
	adr1->pxl   = adr2->pxl;
	for (i = 0; i < 2; i++) {wcscpy(adr1->suffix[i], adr2->suffix[i]);}
	adr1->up    = adr2->up;
	adr1->down  = adr2->down;
	adr1->left  = adr2->left;
	adr1->right = adr2->right;
}

/*------------------------------------------------------------------------------
    書式：void CmMode(WCHAR **, INT32)
    引数：WCHAR **  -
          INT32     -
    機能：コマンドモードを振り分ける
------------------------------------------------------------------------------*/
void CmMode(WCHAR **ppStr, INT32 cnt)
{
	st_Command cmd;
	
	if (!CmReady) {return;}
	
	// NEW, [新規画像ファイル], [幅], [高さ]
	if (wcscmp(ppStr[0], L"NEW") == 0) {
		if (cnt != 4) {LgMsg(L"ERROR：NEW\r\n");  return;}
		cmd.mode = NEW;
		PathUnquoteSpaces(ppStr[1]);  wcscpy(cmd.path[0], ppStr[1]);
		cmd.w = _wtoi(ppStr[2]);
		cmd.h = _wtoi(ppStr[3]);
	}
	// ROTATE, [対象画像ファイル]
	else if (wcscmp(ppStr[0], L"ROTATE") == 0) {
		if (cnt != 2) {LgMsg(L"ERROR：ROTATE\r\n");  return;}
		cmd.mode = ROTATE;
		PathUnquoteSpaces(ppStr[1]);  wcscpy(cmd.path[0], ppStr[1]);
	}
	// DEFORM, [対象画像ファイル], [幅], [高さ]
	else if (wcscmp(ppStr[0], L"DEFORM") == 0) {
		if (cnt != 4) {LgMsg(L"ERROR：DEFORM\r\n");  return;}
		cmd.mode = DEFORM;
		PathUnquoteSpaces(ppStr[1]);  wcscpy(cmd.path[0], ppStr[1]);
		cmd.w = _wtoi(ppStr[2]);
		cmd.h = _wtoi(ppStr[3]);
	}
	// RESIZE, [対象画像ファイル]
	else if (wcscmp(ppStr[0], L"RESIZE") == 0) {
		if (cnt != 2) {LgMsg(L"ERROR：RESIZE\r\n");  return;}
		cmd.mode = RESIZE;
		PathUnquoteSpaces(ppStr[1]);  wcscpy(cmd.path[0], ppStr[1]);
	}
	// CSV, [対象画像ファイル], [CSVファイル]
	else if (wcscmp(ppStr[0], L"CSV") == 0) {
		if (cnt != 3) {LgMsg(L"ERROR：CSV\r\n");  return;}
		cmd.mode = CSV;
		PathUnquoteSpaces(ppStr[1]);  wcscpy(cmd.path[0], ppStr[1]);
		PathUnquoteSpaces(ppStr[2]);  wcscpy(cmd.path[1], ppStr[2]);
	}
	// APPEND, [対象画像ファイル], [追加画像ファイル], [X座標], [Y座標]
	else if (wcscmp(ppStr[0], L"APPEND") == 0) {
		if (cnt != 5) {LgMsg(L"ERROR：APPEND\r\n");  return;}
		cmd.mode = APPEND;
		PathUnquoteSpaces(ppStr[1]);  wcscpy(cmd.path[0], ppStr[1]);
		PathUnquoteSpaces(ppStr[2]);  wcscpy(cmd.path[1], ppStr[2]);
		cmd.x = _wtoi(ppStr[3]);
		cmd.y = _wtoi(ppStr[4]);
	}
	// SEPARATE, [縦か横か], [対象画像ファイル], [ドット数], [接尾辞１], [接尾辞２]
	else if (wcscmp(ppStr[0], L"SEPARATE") == 0) {
		if (cnt != 6) {LgMsg(L"ERROR：SEPARATE\r\n");  return;}
		cmd.mode = SEPARATE;
		if      (wcscmp(ppStr[1], L"VERT") == 0) {cmd.v_h = TRUE;}
		else if (wcscmp(ppStr[1], L"HORI") == 0) {cmd.v_h = FALSE;}
		else                                     {LgMsg(L"ERROR：");  return;}
		PathUnquoteSpaces(ppStr[2]);  wcscpy(cmd.path[0], ppStr[2]);
		cmd.pxl = _wtoi(ppStr[3]);
		wcscpy(cmd.suffix[0], ppStr[4]);
		wcscpy(cmd.suffix[1], ppStr[5]);
	}
	// TRIM, [対象画像ファイル], [上], [下], [左], [右]
	else if (wcscmp(ppStr[0], L"TRIM") == 0) {
		if (cnt != 6) {LgMsg(L"ERROR：TRIM\r\n");  return;}
		cmd.mode = TRIM;
		PathUnquoteSpaces(ppStr[1]);  wcscpy(cmd.path[0], ppStr[1]);
		cmd.up    = _wtoi(ppStr[2]);
		cmd.down  = _wtoi(ppStr[3]);
		cmd.left  = _wtoi(ppStr[4]);
		cmd.right = _wtoi(ppStr[5]);
	}
	else {
		LgMsg(L"ERROR：UNKNOWN\r\n");
		return;
	}
	
	if (CmRingPush(&cmd)) {
		ThrCmStarting();
	}
	else {
		LgShow();
		MessageBox(LgGetHwnd(), L"buffer over", L_ERROR, MB_OK);
		CmReady = FALSE;
	}
}

/*------------------------------------------------------------------------------
    書式：BOOL CmRingPush(st_Command *)
    引数：st_Command *  -
    戻値：BOOL          -
    機能：リングバッファに追加
------------------------------------------------------------------------------*/
BOOL CmRingPush(st_Command *pCmd)
{
	if (((ringIdxPush + 1) % RING_SIZE) == ringIdxPop) {return FALSE;}
	
	CmCopy(&ring[ringIdxPush], pCmd);
	
	ringIdxPush = (ringIdxPush + 1) % RING_SIZE;
	return TRUE;
}

/*------------------------------------------------------------------------------
    書式：BOOL CmRingPop(st_Command *)
    引数：st_Command *  -
    戻値：BOOL          -
    機能：リングバッファから取る
------------------------------------------------------------------------------*/
BOOL CmRingPop(st_Command *pCmd)
{
	if (ringIdxPop == ringIdxPush) {return FALSE;}
	
	CmCopy(pCmd, &ring[ringIdxPop]);
	
	ringIdxPop = (ringIdxPop + 1) % RING_SIZE;
	return TRUE;
}

/*------------------------------------------------------------------------------
    書式：void CmSetX(INT32)
          void CmSetY(INT32)
          void CmSetW(INT32)
          void CmSetH(INT32)
          void CmSetPath(WCHAR *, INT32)
          void CmSetV_H(BOOL)
          void CmSetPxl(INT32)
          void CmSetPxl(INT32)
          void CmSetUp(INT32)
          void CmSetDown(INT32)
          void CmSetLeft(INT32)
          void CmSetRight(INT32)
    引数：INT32    -
          WCHAR *  -
          BOOL     -
    機能：SET関数
------------------------------------------------------------------------------*/
void CmSetX(INT32 v) {cm.x = v;}
void CmSetY(INT32 v) {cm.y = v;}
void CmSetW(INT32 v) {cm.w = v;}
void CmSetH(INT32 v) {cm.h = v;}
void CmSetPath(WCHAR *path, INT32 idx) {wcscpy(cm.path[idx], path);}
void CmSetV_H(BOOL v) {cm.v_h = v;}
void CmSetPxl(INT32 v) {cm.pxl = v;}
void CmSetUp(INT32 v)   {cm.up   = v;}
void CmSetDown(INT32 v) {cm.down = v;}
void CmSetLeft(INT32 v) {cm.left = v;}
void CmSetRight(INT32 v){cm.right= v;}

/*------------------------------------------------------------------------------
    書式：INT32 CmGetX(void)
          INT32 CmGetY(void)
          INT32 CmGetW(void)
          INT32 CmGetH(void)
          WCHAR *CmGetPath(INT32)
          BOOL CmGetV_H(void)
          INT32 CmGetPxl(void)
          INT32 CmGetUp(void)
          INT32 CmGetDown(void)
          INT32 CmGetLeft(void)
          INT32 CmGetRight(void)
          st_Image *CmGetImg(INT32)
    引数：INT32       -
    戻値：INT32       -
          WCHAR *     -
          BOOL        -
          st_Image *  -
    機能：GET関数
------------------------------------------------------------------------------*/
INT32 CmGetX(void) {return cm.x;}
INT32 CmGetY(void) {return cm.y;}
INT32 CmGetW(void) {return cm.w;}
INT32 CmGetH(void) {return cm.h;}
WCHAR *CmGetPath(INT32 idx) {return cm.path[idx];}
BOOL CmGetV_H(void) {return cm.v_h;}
INT32 CmGetPxl(void) {return cm.pxl;}
INT32 CmGetUp(void)   {return cm.up;}
INT32 CmGetDown(void) {return cm.down;}
INT32 CmGetLeft(void) {return cm.left;}
INT32 CmGetRight(void){return cm.right;}
st_Image *CmGetImg(INT32 idx) {return &cm.img[idx];}

/*------------------------------------------------------------------------------
    書式：void CmSaveFile(INT32)
    引数：INT32  -
    機能：画像ファイルを保存
------------------------------------------------------------------------------*/
void CmSaveFile(INT32 idx)
{
	WCHAR *pStr;
	st_Image *pImg;
	WCHAR pathD[MAX_PATH];
	INT32 i, j;
	INT32 wSize;
	INT32 mod;
	PixelFormat pxFmt;
	BYTE *pByte;
	BYTE *pB1, *pB2;
	CLSID clsid;
	UINT cnt;
	UINT size;
	Gdiplus::ImageCodecInfo *pIci;
	WCHAR *pEnc = NULL;
	WCHAR encBmp[50] = L"image/bmp";
	WCHAR encPng[50] = L"image/png";
	WCHAR encJpg[50] = L"image/jpeg";
	BOOL res;
	
	pStr = CmGetPath(idx);
	pImg = CmGetImg(idx);
	
	ThrCmLog(L" save to file：%s", CmGetPath(idx));
	
	wcscpy(pathD, pStr);
	PathRemoveFileSpec(pathD);
	if (PathFileExists(pathD) == FALSE)                             {ThrCmLog(L" failure.");  return;}
	if ((GetFileAttributes(pathD) & FILE_ATTRIBUTE_DIRECTORY) == 0) {ThrCmLog(L" failure.");  return;}
	
	pImg->bpp = 24;
	
	pxFmt = PixelFormat24bppRGB;
	wSize = pImg->w * 3;
	mod   = (pImg->w * 3) % 4;
	if (mod != 0) {wSize += (4 - mod);}
	
	pByte = (BYTE *)a_malloc(wSize * pImg->h);
	
	pB1 = pImg->pB;
	for (i = 0; i < pImg->h; i++) {
		pB2 = pByte + wSize * (pImg->h - 1 - i);
		
		for (j = 0; j < pImg->w; j++) {
			*(pB2+2) = *(pB1+2);
			*(pB2+1) = *(pB1+1);
			*(pB2+0) = *(pB1+0);
			pB1 += 4;
			pB2 += 3;
		}
	}
	
	switch (pImg->fmt) {
	case BMP:  pEnc = encBmp;  break;
	case PNG:  pEnc = encPng;  break;
	case JPG:  pEnc = encJpg;  break;
	default:   pEnc = encPng;  break;
	}
	
	Gdiplus::GetImageEncodersSize(&cnt, &size);
	pIci = new Gdiplus::ImageCodecInfo[size];
	Gdiplus::GetImageEncoders(cnt, size, pIci);
	
	for (i = 0; i < cnt; i++) {
		if (wcscmp(pIci[i].MimeType, pEnc) == 0)
		{
			clsid = pIci[i].Clsid;
			break;
		}
	}
	delete pIci;
	
	Gdiplus::Bitmap bmp(pImg->w, pImg->h, wSize, pxFmt, pByte);
	if (bmp.Save(pStr, &clsid) == Ok) {res = TRUE;} else {res = FALSE;}
	
	free(pByte);
	
	if (res) {ThrCmLog(L" complete.");}
	else     {ThrCmLog(L" failure.");}
}

/*------------------------------------------------------------------------------
    書式：void ThrCmStarting(void)
    機能：スレッド開始したい コマンド
------------------------------------------------------------------------------*/
void ThrCmStarting(void)
{
	if (CmBusy) {return;}
	
	ThrCmStart();
}

/*------------------------------------------------------------------------------
    書式：void ThrCmStart(void)
    機能：スレッド開始 コマンド
------------------------------------------------------------------------------*/
void ThrCmStart(void)
{
	st_Command cmd;
	
	if (!CmRingPop(&cmd)) {CmReady = TRUE;  CmBusy = FALSE;  return;}
	CmBusy = TRUE;
	
	if (!LgIsShow()) {LgShow();}
	
	CmCopy(&cmmn, &cmd);
	
	CreateThread(NULL, 0, ThrCmFunc, hCore, 0, NULL);
}

/*------------------------------------------------------------------------------
    書式：DWORD WINAPI ThrCmFunc(LPVOID)
    引数：LPVOID    -
    戻値：DWORD     -
    機能：コマンドスレッド関数
------------------------------------------------------------------------------*/
DWORD WINAPI ThrCmFunc(LPVOID lpvoid)
{
	HWND hWnd = (HWND)lpvoid;
	WCHAR ext[MAX_PATH];
	INT32 srcW, srcH;
	INT32 dstW, dstH;
	
	SetThreadPriority(GetCurrentThread(), -1);
	
	switch (cmmn.mode) {
	case NEW:
		ThrCmLog(L"NEW：");
		
		if ((cmmn.w == 0) || (5000 < cmmn.w) || (cmmn.h == 0) || (5000 < cmmn.h)) {
			ThrCmLog(L" size error");
			break;
		}
		
		CmSetW(cmmn.w);
		CmSetH(cmmn.h);
		CmSetPath(cmmn.path[0], 0);
		ThrCmMsg(WMU_THRCMIMGCRE, 0);
		ThrCmMsg(WMU_THRCMIMGWHT, 0);
		CmSaveFile(0);
		ThrCmMsg(WMU_THRCMIMGDEL, NULL);
		break;
	case ROTATE:
		ThrCmLog(L"ROTATE：");
		
		if (!CmIsExist(cmmn.path[0])) {
			ThrCmLog(L" file not exist");
			break;
		}
		
		CmSetPath(cmmn.path[0], 0);
		if (!ThrCmMsg(WMU_THRCMIMGRD, 0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		ThrCmMsg(WMU_THRCMIMGROT, 0);
		CmSaveFile(0);
		ThrCmMsg(WMU_THRCMIMGDEL, NULL);
		break;
	case DEFORM:
		ThrCmLog(L"DEFORM：");
		
		if ((cmmn.w == 0) || (5000 < cmmn.w) || (cmmn.h == 0) || (5000 < cmmn.h)) {
			ThrCmLog(L" size error");
			break;
		}
		
		if (!CmIsExist(cmmn.path[0])) {
			ThrCmLog(L" file not exist");
			break;
		}
		
		CmSetW(cmmn.w);
		CmSetH(cmmn.h);
		CmSetPath(cmmn.path[0], 0);
		if (!ThrCmMsg(WMU_THRCMIMGRD, 0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		ThrCmMsg(WMU_THRCMIMGDFM, 0);
		CmSaveFile(0);
		ThrCmMsg(WMU_THRCMIMGDEL, 0);
		break;
	case RESIZE:
		ThrCmLog(L"RESIZE：");
		
		if (!CmIsExist(cmmn.path[0])) {
			ThrCmLog(L" file not exist");
			break;
		}
		
		CmSetPath(cmmn.path[0], 0);
		if (!ThrCmMsg(WMU_THRCMIMGRD, 0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		ThrCmMsg(WMU_THRCMIMGRSZ, 0);
		CmSaveFile(0);
		ThrCmMsg(WMU_THRCMIMGDEL, NULL);
		break;
	case CSV:
		ThrCmLog(L"CSV：");
		
		if ((!CmIsExist(cmmn.path[0])) || (!CmIsExist(cmmn.path[1]))) {
			ThrCmLog(L" file not exist");
			break;
		}
		
		CmSetPath(cmmn.path[0], 0);
		CmSetPath(cmmn.path[1], 1);
		if (!ThrCmMsg(WMU_THRCMIMGRD,  0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		if (!ThrCmMsg(WMU_THRCMIMGCSV, 0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		CmSaveFile(0);
		ThrCmMsg(WMU_THRCMIMGDEL, NULL);
		break;
	case APPEND:
		ThrCmLog(L"APPEND：");
		
		if ((cmmn.x == 0) || (5000 < cmmn.x) || (cmmn.y == 0) || (5000 < cmmn.y)) {
			ThrCmLog(L" coordinate error");
			break;
		}
		
		if ((!CmIsExist(cmmn.path[0])) || (!CmIsExist(cmmn.path[1]))) {
			ThrCmLog(L" file not exist");
			break;
		}
		
		CmSetX(cmmn.x);
		CmSetY(cmmn.y);
		CmSetPath(cmmn.path[0], 0);
		CmSetPath(cmmn.path[1], 1);
		if (!ThrCmMsg(WMU_THRCMIMGRD, 0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		if (!ThrCmMsg(WMU_THRCMIMGRD, 1)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		ThrCmMsg(WMU_THRCMIMGAPD, 0);
		CmSaveFile(0);
		ThrCmMsg(WMU_THRCMIMGDEL, NULL);
		break;
	case SEPARATE:
		ThrCmLog(L"SEPARATE：");
		
		if (!CmIsExist(cmmn.path[0])) {
			ThrCmLog(L" file not exist");
			break;
		}
		
		CmSetV_H(cmmn.v_h);
		CmSetPxl(cmmn.pxl);
		CmSetPath(cmmn.path[0], 0);
		if ((wcslen(cmmn.path[0]) + wcslen(cmmn.suffix[0])) >= MAX_PATH) {ThrCmLog(L" name too long");  break;}
		if ((wcslen(cmmn.path[0]) + wcslen(cmmn.suffix[1])) >= MAX_PATH) {ThrCmLog(L" name too long");  break;}
		if (!ThrCmMsg(WMU_THRCMIMGRD,  0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		
		if (cmmn.pxl == 0) {ThrCmLog(L" pixel size 0");  break;}
		
		if (cmmn.v_h) {
			if (cmmn.pxl >= CmGetImg(0)->h) {ThrCmLog(L" pixel size over");  break;}
		}
		else {
			if (cmmn.pxl >= CmGetImg(0)->w) {ThrCmLog(L" pixel size over");  break;}
		}
		
		if (!ThrCmMsg(WMU_THRCMIMGSEP, 0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		ThrCmMsg(WMU_THRCMDEL, 0);
		wcscpy(ext, PathFindExtension(cmmn.path[0]));
		PathRemoveExtension(cmmn.path[0]);
		wcscpy(cmmn.path[1], cmmn.path[0]);
		wcscat(cmmn.path[0], cmmn.suffix[0]);
		wcscat(cmmn.path[1], cmmn.suffix[1]);
		PathAddExtension(cmmn.path[0], ext);
		PathAddExtension(cmmn.path[1], ext);
		CmSetPath(cmmn.path[0], 0);
		CmSetPath(cmmn.path[1], 1);
		CmSaveFile(0);
		CmSaveFile(1);
		ThrCmMsg(WMU_THRCMIMGDEL, NULL);
		break;
	case TRIM:
		ThrCmLog(L"TRIM：");
		
		if (!CmIsExist(cmmn.path[0])) {
			ThrCmLog(L" file not exist");
			break;
		}
		
		CmSetPath(cmmn.path[0], 0);
		CmSetUp(cmmn.up);
		CmSetDown(cmmn.down);
		CmSetLeft(cmmn.left);
		CmSetRight(cmmn.right);
		if (!ThrCmMsg(WMU_THRCMIMGRD,  0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		
		srcW = CmGetImg(0)->w;
		srcH = CmGetImg(0)->h;
		dstW = CmGetImg(0)->w - cmmn.left - cmmn.right;
		dstH = CmGetImg(0)->h - cmmn.up - cmmn.down;
		if ((dstW < 0) || (srcW < dstW)) {ThrCmLog(L" trimming size error");}
		if ((dstH < 0) || (srcH < dstH)) {ThrCmLog(L" trimming size error");}
		
		if (!ThrCmMsg(WMU_THRCMIMGTRM, 0)) {ThrCmMsg(WMU_THRCMIMGDEL, NULL);  break;}
		CmSaveFile(0);
		ThrCmMsg(WMU_THRCMIMGDEL, NULL);
		break;
	default:
		break;
	}
	P_USER(hWnd, WMU_THRCMEND, NULL);
	return 0;
}

/*------------------------------------------------------------------------------
    書式：BOOL ThrCmMsg(WPARAM, LPARAM)
    引数：WPARAM  -
          LPARAM  -
    機能：メッセージを送信
------------------------------------------------------------------------------*/
BOOL ThrCmMsg(WPARAM wp, LPARAM lp)
{
	hCmd = CreateWindow(NM_CMD,NULL,NULL,0,0,0,0,HWND_MESSAGE,NULL,gInst,NULL);
	UpdateWindow(hCmd);
	P_USER(hCore, wp, lp);
	return ThrCmWait();
}

/*------------------------------------------------------------------------------
    書式：void ThrCmLog(LCHAR *, ...)
    引数：LCHAR *  -
          ...      -
    機能：ログを送信
------------------------------------------------------------------------------*/
void ThrCmLog(LCHAR *pStr, ...)
{
	WCHAR buff[1000+1];
	va_list args;
	
	va_start(args, pStr);
	wvsprintf(buff, pStr, args);
	va_end(args); 
	
	hCmd = CreateWindow(NM_CMD,NULL,NULL,0,0,0,0,HWND_MESSAGE,NULL,gInst,NULL);
	
	SetWindowText(hCmd, buff);
	UpdateWindow(hCmd);
	P_USER(hCore, WMU_THRCMLOG, NULL);
	
	ThrCmWait();
}

/*------------------------------------------------------------------------------
    書式：WPARAM ThrCmWait(void)
    戻値：WPARAM  -
    機能：応答待ち
------------------------------------------------------------------------------*/
WPARAM ThrCmWait(void)
{
	MSG msg;
	
	while (GetMessage(&msg, NULL, 0, 0) == TRUE) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
	return msg.wParam;
}

/*------------------------------------------------------------------------------
    書式：void ThrCmEnd(void)
    機能：スレッド終了 コマンド
------------------------------------------------------------------------------*/
void ThrCmEnd(void)
{
	ThrCmStart();
}

/*------------------------------------------------------------------------------
    書式：LRESULT CALLBACK WndProcCmd(,,,)
    引数：...        -
    戻値：LRESULT    -
    機能：CMDイベント
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProcCmd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	static WPARAM res;
	
	switch (msg) {
	case WM_USER:
		res = wp;
		break;
	case WM_CLOSE:
		break;
	case WM_DESTROY:
		P_QUIT(res);
		break;
	default:
		break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    書式：void ThrRdStart(INT32)
    引数：INT32  -
    機能：コマンドモードの画像読み込みスレッド開始
------------------------------------------------------------------------------*/
void ThrRdStart(INT32 idx)
{
	rd.idx = idx;
	wcscpy(rd.path, cm.path[rd.idx]);
	CreateThread(NULL, 0, ThrRdFunc, hCore, 0, NULL);
}

/*------------------------------------------------------------------------------
    書式：DWORD WINAPI ThrRdFunc(LPVOID)
    引数：LPVOID  -
    戻値：DWORD   -
    機能：コマンドモードの画像読み込みスレッド関数
------------------------------------------------------------------------------*/
DWORD WINAPI ThrRdFunc(LPVOID lpvoid)
{
	HWND hWnd = (HWND)lpvoid;
	
	SetThreadPriority(GetCurrentThread(), -1);
	
	ThrRdImageRead();
	
	P_USER(hWnd, WMU_THRRDEND, NULL);
	return 0;
}

/*------------------------------------------------------------------------------
    書式：void ThrRdImageRead(void)
    機能：画像を読み込み
------------------------------------------------------------------------------*/
void ThrRdImageRead(void)
{
	GUID guid;
	Bitmap *pBmp;
	st_Image *pImg = &rd.img;
	
	pBmp = Gdiplus::Bitmap::FromFile(rd.path);
	
	if((pBmp != NULL) && (pBmp->GetLastStatus() == Gdiplus::Ok) &&
	   (pBmp->GetWidth()  != 0) &&
	   (pBmp->GetHeight() != 0))
	{
		pImg->w = pBmp->GetWidth();
		pImg->h = pBmp->GetHeight();
		
		ImageCreate(pImg, pImg->w, pImg->h);
		
		Graphics graphics(pImg->hdc);
		graphics.DrawImage(pBmp, 0, 0, pImg->w, pImg->h);
		
		pBmp->GetRawFormat(&guid);
		if     ((guid == ImageFormatBMP) ||
				(guid == ImageFormatMemoryBMP)) {pImg->fmt = BMP;}
		else if (guid == ImageFormatPNG)        {pImg->fmt = PNG;}
		else if (guid == ImageFormatJPEG)       {pImg->fmt = JPG;}
		else                                    {pImg->fmt = UNDEF;}
		
		pImg->pxFmt = pBmp->GetPixelFormat();
		
		pImg->stat = BIT_SUCCESS;
		pImg->flg  = TRUE;
	}
	else {
		pImg->stat = BIT_FAILURE;
		pImg->flg  = FALSE;
	}
	delete pBmp;
}

/*------------------------------------------------------------------------------
    書式：void ThrRdEnd(void)
    機能：コマンドモードの画像読み込みスレッド終了
------------------------------------------------------------------------------*/
void ThrRdEnd(void)
{
	st_Image *pThr = &rd.img;
	st_Image *pImg = &cm.img[rd.idx];
	BOOL res;
	
	if (IsBit(pThr->stat, BIT_SUCCESS)) {
		ImageReplace(pImg, pThr);
		res = TRUE;
	}
	else {
		ImageDeleteSt(pThr);
		res = FALSE;
		LgMsg(L" file read error.\r\n");
	}
	
	P_USER(hCmd, res, NULL);
	P_CLOSE(hCmd);
}
