/*------------------------------------------------------------------------------
    VXeCN[h
------------------------------------------------------------------------------*/
#include <windows.h>
#include <shlwapi.h>

/*------------------------------------------------------------------------------
    ˑ
------------------------------------------------------------------------------*/
#pragma resource "icon_cui.res"

/*------------------------------------------------------------------------------
    ft@C
------------------------------------------------------------------------------*/
#define MIN_W     600
#define MIN_H     300
#define MAX_LEN   20000
#define MAX_LINE  1000

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void ProcessWithCommand(void);
void Process(void);
void SetFullPathName(void);
void Inst(void);
void MessageLoop(void);
LRESULT CALLBACK WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK WndProcEdit(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK WndProcBtn(HWND, UINT, WPARAM, LPARAM);
void Command(WPARAM, LPARAM);
void KeyDown(WPARAM, LPARAM, HWND);
void SetFocus(WPARAM, LPARAM, HWND);
void Execute(void);

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
WCHAR cmdStr[MAX_LINE];
HINSTANCE gInst;
HICON   hIcon;
HCURSOR hCurArrow;
HBRUSH hBrBrGray;
HFONT hFtMsGothic;
HWND hWnd;
HWND hEdit;
HWND hBtn;
LRESULT (CALLBACK *pCallEdit) (HWND,UINT,WPARAM,LPARAM);
LRESULT (CALLBACK *pCallBtn)  (HWND,UINT,WPARAM,LPARAM);
INT32 tabStopIdx;
HWND tabStops[2];

/*------------------------------------------------------------------------------
    Fint wWinMain(,,,)
    F,,,    -
    ߒlFint    -
    @\FX^[gAbv
------------------------------------------------------------------------------*/
int wWinMain(HINSTANCE v1, HINSTANCE v2, LPWSTR v3, int v4)
{
	INT32 len;
	
	gInst = v1;
	len   = wcslen(v3);
	
	if (len > MAX_LINE) {
		MessageBox(NULL, L"command too long error", L"Error", MB_OK);
	}
	else if (len == 0) {
		hIcon       = LoadIcon(gInst, L"MOONCUI");
		hCurArrow   = LoadCursor(NULL, IDC_ARROW);
		hBrBrGray   = CreateSolidBrush(RGB(0xEE, 0xEE, 0xEE));
		hFtMsGothic = CreateFont(14,0,0,0,FW_DONTCARE,FALSE,FALSE,FALSE,ANSI_CHARSET,
								 OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,
								 DEFAULT_PITCH|FF_DONTCARE,L"lr SVbN");
		Inst();
		MessageLoop();
		
		DeleteObject(hIcon);
		DeleteObject(hCurArrow);
		DeleteObject(hBrBrGray);
		DeleteObject(hFtMsGothic);
	}
	else {
		wcscpy(cmdStr, v3);
		ProcessWithCommand();
	}
	return 0;
}

/*------------------------------------------------------------------------------
    Fvoid ProcessWithCommand(void)
    @\FR}htspv.exes
------------------------------------------------------------------------------*/
void ProcessWithCommand(void)
{
	WCHAR path[MAX_PATH];
	WCHAR str [MAX_PATH + MAX_LINE];
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	BOOL  res;
	
	SetFullPathName();
	
	wmemset(path, 0x0000, MAX_PATH);
	GetModuleFileName(NULL, path, MAX_PATH);
	PathRemoveFileSpec(path);
	wcscat(path, L"\\spv.exe");
	
	wmemset(str, 0x0000, MAX_PATH + MAX_LINE);
	wcscat(str, path);
	wcscat(str, L" ");
	wcscat(str, cmdStr);
	
	memset(&si, 0, sizeof(STARTUPINFO));
	memset(&pi, 0, sizeof(PROCESS_INFORMATION));
	si.cb = sizeof(STARTUPINFO);
	
	res = CreateProcess(NULL,str,NULL,NULL,FALSE,NORMAL_PRIORITY_CLASS,NULL,NULL,&si,&pi);
	if (res) {
		WaitForInputIdle(pi.hProcess, INFINITE);
	}
	else {
		MessageBox(NULL, L"process start error", L"Error", MB_OK);
	}
}

/*------------------------------------------------------------------------------
    Fvoid Process(void)
    @\FR}hs
------------------------------------------------------------------------------*/
void Process(void)
{
	STARTUPINFO si;
	PROCESS_INFORMATION pi;
	BOOL  res;
	
	memset(&si, 0, sizeof(STARTUPINFO));
	memset(&pi, 0, sizeof(PROCESS_INFORMATION));
	si.cb = sizeof(STARTUPINFO);
	
	res = CreateProcess(NULL,cmdStr,NULL,NULL,FALSE,NORMAL_PRIORITY_CLASS,NULL,NULL,&si,&pi);
	if (res) {
		WaitForInputIdle(pi.hProcess, INFINITE);
	}
	else {
		MessageBox(NULL, L"process start error", L"Error", MB_OK);
	}
}

/*------------------------------------------------------------------------------
    Fvoid SetFullPathName(void)
    @\FR}h̃pXtpXɕύX
------------------------------------------------------------------------------*/
void SetFullPathName(void)
{
	WCHAR fullpath1[MAX_PATH];
	WCHAR fullpath2[MAX_PATH];
	WCHAR **ppStr;
	INT32 cnt;
	
	ppStr = CommandLineToArgvW(cmdStr, &cnt);
	
	// NEW, [VK摜t@C], [ - ], [ - ]
	if (wcscmp(ppStr[0], L"NEW") == 0) {
		if (cnt != 4) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[2]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);
	}
	// ROTATE, [Ώۉ摜t@C]
	else if (wcscmp(ppStr[0], L"ROTATE") == 0) {
		if (cnt != 2) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);
	}
	// DEFORM, [Ώۉ摜t@C], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"DEFORM") == 0) {
		if (cnt != 4) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[2]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);
	}
	// RESIZE, [Ώۉ摜t@C]
	else if (wcscmp(ppStr[0], L"RESIZE") == 0) {
		if (cnt != 2) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);
	}
	// CSV, [Ώۉ摜t@C], [CSVt@C]
	else if (wcscmp(ppStr[0], L"CSV") == 0) {
		if (cnt != 3) {return;}
		PathUnquoteSpaces(ppStr[1]);
		PathUnquoteSpaces(ppStr[2]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		GetFullPathName(ppStr[2], MAX_PATH, fullpath2, NULL);
		PathQuoteSpaces(fullpath1);
		PathQuoteSpaces(fullpath2);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath2);
	}
	// APPEND, [Ώۉ摜t@C], [ǉ摜t@C], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"APPEND") == 0) {
		if (cnt != 5) {return;}
		PathUnquoteSpaces(ppStr[1]);
		PathUnquoteSpaces(ppStr[2]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		GetFullPathName(ppStr[2], MAX_PATH, fullpath2, NULL);
		PathQuoteSpaces(fullpath1);
		PathQuoteSpaces(fullpath2);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath2);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[4]);
	}
	// SEPARATE, [ - ], [Ώۉ摜t@C], [ - ], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"SEPARATE") == 0) {
		if (cnt != 6) {return;}
		PathUnquoteSpaces(ppStr[2]);
		GetFullPathName(ppStr[2], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[1]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[4]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[5]);
	}
	// TRIM, [Ώۉ摜t@C], [ - ], [ - ], [ - ], [ - ]
	else if (wcscmp(ppStr[0], L"TRIM") == 0) {
		if (cnt != 6) {return;}
		PathUnquoteSpaces(ppStr[1]);
		GetFullPathName(ppStr[1], MAX_PATH, fullpath1, NULL);
		PathQuoteSpaces(fullpath1);
		
		wcscpy(cmdStr, ppStr[0]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, fullpath1);  wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[2]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[3]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[4]);   wcscat(cmdStr, L" ");
		wcscat(cmdStr, ppStr[5]);
	}
}

/*------------------------------------------------------------------------------
    Fvoid Inst(void)
    @\F̂쐬
------------------------------------------------------------------------------*/
void Inst(void)
{
	WNDCLASS wc;
	DWORD style = WS_CAPTION|WS_THICKFRAME|WS_SYSMENU/*|WS_MAXIMIZEBOX|WS_MINIMIZEBOX*/;
	DWORD styleEd = WS_CHILD|/*WS_VSCROLL|*/WS_VISIBLE|WS_BORDER|ES_LEFT|ES_MULTILINE|ES_AUTOHSCROLL/*|ES_READONLY*/;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	INT32 x, y;
	INT32 w, h;
	
	wc.style         = NULL;
	wc.lpfnWndProc   = DefWindowProc;
	wc.cbClsExtra    = 0;
	wc.cbWndExtra    = 0;
	wc.hInstance     = gInst;
	wc.hIcon         = hIcon;
	wc.hCursor       = hCurArrow;
	wc.hbrBackground = hBrBrGray;
	wc.lpszMenuName  = NULL;
	wc.lpszClassName = L"CONSOLE";
	RegisterClass(&wc);
	
	w = MIN_W;
	h = MIN_H;
	x = (GetSystemMetrics(SM_CXSCREEN)-w)/2;
	y = (GetSystemMetrics(SM_CYSCREEN)-h)/2;
	
	hWnd  = CreateWindow(L"CONSOLE",L"CONSOLE",style,x,y,w,h,NULL,NULL,gInst,NULL);
	hEdit = CreateWindow(L"Edit",NULL,styleEd,0,0,0,0,hWnd,NULL,gInst,NULL);
	hBtn  = CreateWindow(L"Button",L"Execute",styleBt,0,0,0,0, hWnd,NULL,gInst,NULL);
	SetWindowLong(hWnd, GWL_WNDPROC, (LONG)WndProc);
	
	pCallEdit = (LRESULT (CALLBACK *)(HWND,UINT,WPARAM,LPARAM))GetWindowLong(hEdit, GWL_WNDPROC);
	pCallBtn  = (LRESULT (CALLBACK *)(HWND,UINT,WPARAM,LPARAM))GetWindowLong(hBtn,  GWL_WNDPROC);
	SetWindowLong(hEdit, GWL_WNDPROC, (LONG)WndProcEdit);
	SetWindowLong(hBtn,  GWL_WNDPROC, (LONG)WndProcBtn);
	
	SendMessage(hEdit, WM_SETFONT, (WPARAM)hFtMsGothic, (LPARAM)NULL);
	SendMessage(hBtn,  WM_SETFONT, (WPARAM)hFtMsGothic, (LPARAM)NULL);
	
	tabStopIdx = 0;
	tabStops[0] = hEdit;
	tabStops[1] = hBtn;
	
	SetFocus(hEdit);
	ShowWindow(hWnd, 0x1);
}

/*------------------------------------------------------------------------------
    Fvoid MessageLoop(void)
    @\FbZ[W[v
------------------------------------------------------------------------------*/
void MessageLoop(void)
{
	MSG msg;
	
	while (GetMessage(&msg, NULL, 0, 0) == TRUE) {
		TranslateMessage(&msg);
		DispatchMessage (&msg);
	}
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK WndProc(,,,)
    F...        -
    ߒlFLRESULT    -
    @\FLOGCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	RECT rc;
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	
	switch (msg) {
	case WM_COMMAND:
		Command(wp, lp);
		break;
	case WM_GETMINMAXINFO:
		w = MIN_W;
		h = MIN_H;
		
		mmi = (MINMAXINFO *)lp;
		mmi->ptMinTrackSize.x = w;
		mmi->ptMinTrackSize.y = h;
		break;
	case WM_SIZE:
		GetClientRect(hWnd, &rc);
		x = rc.left;
		y = rc.top;
		w = rc.right - rc.left;
		h = rc.bottom - rc.top;
		
		SetWindowPos(hEdit, NULL, x+10, y+10, w-20, h-20-35, 0x071C);
		SetWindowPos(hBtn, NULL, w-80, h-35, 70, 25, 0x071C);
		
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow(hWnd);
		break;
	case WM_SETFOCUS:
		SetFocus(tabStops[tabStopIdx]);
		break;
	case WM_CLOSE:
		break;
	case WM_DESTROY:
		PostMessage(NULL, WM_QUIT, (WPARAM)NULL, (LPARAM)NULL);
		break;
	default:
		break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK WndProcEdit(,,,)
    F-
    ߒlF-
    @\FEDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_SETFOCUS:  SetFocus(wp, lp, hWnd);  break;
	default:
		break;
	}
	return pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK WndProcBtn(,,,)
    F-
    ߒlF-
    @\FBTNCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK WndProcBtn(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_SETFOCUS:  SetFocus(wp, lp, hWnd);  break;
	case WM_KEYDOWN:   KeyDown (wp, lp, hWnd);  break;
	default:
		break;
	}
	return pCallBtn(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid Command(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FWM_COMMANDCxg
------------------------------------------------------------------------------*/
void Command(WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if ((HWND)lp == hBtn) {Execute();}
}

/*------------------------------------------------------------------------------
    Fvoid KeyDown(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void KeyDown(WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (wp == 0x00D) {Execute();}
}

/*------------------------------------------------------------------------------
    Fvoid SetFocus(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void SetFocus(WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < 2; i++) {
		if (hWnd == tabStops[i]) {
			tabStopIdx = i;
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid Execute(void)
    @\Fs
------------------------------------------------------------------------------*/
void Execute(void)
{
	WCHAR str[MAX_LEN];
	WCHAR *p;
	
	GetWindowText(hEdit, str, MAX_LEN);
	
	p = wcstok(str, L"\r\n");
	
	while (p != NULL) {
		if (wcslen(p) != 0) {
			wcscpy(cmdStr, p);
			Process();
		}
		p = wcstok(NULL, L"\r\n");
	}
	
//	WCHAR str[MAX_LEN];
//	WCHAR buff[MAX_LINE];
//	WCHAR *p1;
//	WCHAR *p2;
//	
//	memset(buff, 0x00, MAX_LINE*2);
//	GetWindowText(hEdit, str, MAX_LEN);
//	p1 = str;
//	p2 = buff;
//	
//	while (1) {
//		if (*p1 == L'\r') {
//		}
//		else if (*p1 == L'\n') {
//			if (wcslen(buff) != 0) {
//				wcscpy(cmdStr, buff);
//				ProcessWithCommand();
//			}
//			memset(buff, 0x00, MAX_LINE*2);
//			p2 = buff;
//		}
//		else if (*p1 == L'\0') {
//			break;
//		}
//		else {
//			if ((p2-buff) > MAX_LINE) {
//				MessageBox(NULL, L"command too long error", L"Error", MB_OK);
//				break;
//			}
//			*p2 = *p1;
//			p2++;
//		}
//		p1++;
//	}
}
