/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define AN_CPP
#include "../common.h"
//  AngleFpx

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 angle;
	INT32 rgb;
	BOOL anti;
	BOOL keep;
	BOOL flgClick;
	BOOL flgUpdate;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_ANGLE];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			UINT32 percent;
			BOOL flgClick;
			st_Image tmp;} pc;
	
	HWND hWnd;
	HWND hPd[2];
	HWND hEdit[2];
	HWND hChk[2];
	HWND hRgb;
	HWND hBtn[2];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit[2]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallChk [2]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn [2]) (HWND,UINT,WPARAM,LPARAM);
} an[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void AnInitClass(void);
void AnInit(LONG);
void AnInst(LONG);
void AnDialog(LONG);
void AnLoad(LONG);
void AnStore(LONG);
LRESULT CALLBACK AnWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AnWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AnWndProcEditT (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AnWndProcEditB (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AnWndProcChkU  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AnWndProcChkK  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AnWndProcRgb   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AnWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AnWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK AnWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void AnSize         (LONG, WPARAM, LPARAM);
void AnGetMinMaxInfo(LONG, WPARAM, LPARAM);
void AnSetFocus     (LONG, WPARAM, LPARAM);
void AnKeyDown      (LONG, WPARAM, LPARAM, HWND);
void AnKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void AnKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void AnKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void AnKeyDownSpace (LONG, WPARAM, LPARAM, HWND);
void AnKeyDownF5    (LONG, WPARAM, LPARAM, HWND);
void AnKeyDownUpDw  (LONG, WPARAM, LPARAM, HWND);
void AnKeyDownRtLf  (LONG, WPARAM, LPARAM, HWND);
void AnClose        (LONG, WPARAM, LPARAM);
void AnDestroy      (LONG, WPARAM, LPARAM);
void AnPdCommand    (LONG, WPARAM, LPARAM);
void AnPdPaint      (LONG, WPARAM, LPARAM);
void AnEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
void AnEdKillFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL AnEdChar       (LONG, WPARAM, LPARAM, HWND);
void AnChSetCheck   (LONG, WPARAM, LPARAM);
void AnRbPaint      (LONG, WPARAM, LPARAM, HWND);
void AnRbSetFocus   (LONG, WPARAM, LPARAM, HWND);
void AnRbKillFocus  (LONG, WPARAM, LPARAM, HWND);
void AnRbLButtonDown(LONG, WPARAM, LPARAM, HWND);
void AnRbLButtonUp  (LONG, WPARAM, LPARAM, HWND);
void AnPcPaint      (LONG, WPARAM, LPARAM);
void AnPcLButtonDown(LONG, WPARAM, LPARAM);
void AnPcLButtonUp  (LONG, WPARAM, LPARAM);
void AnEnterOk(LONG);
void AnEnterCan(LONG);
void AnUpdate(LONG);
void AnTmpCreate(LONG, INT32, INT32, INT32);
void AnTmpDelete(LONG);
void AnImageView(LONG);
void AnSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid AnInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void AnInitClass(void)
{
	WNDCLASS wc;
	WNDCLASS wcPd;
	WNDCLASS wcCn;
	WNDCLASS wcPc;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_ANGLE,  &wc);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_ANGLEPD,&wcPd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_ANGLECN,&wcCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_ANGLEPC,&wcPc);
	
	RegisterClass(&wc);
	RegisterClass(&wcPd);
	RegisterClass(&wcCn);
	RegisterClass(&wcPc);
}

/*------------------------------------------------------------------------------
    Fvoid AnInit(LONG)
    FLONG    FORM ID
    @\F
------------------------------------------------------------------------------*/
void AnInit(LONG id)
{
	INT32 i;
	
	an[id].angle       = 0;
	an[id].rgb         = 0x000000;
	an[id].anti        = FALSE;
	an[id].keep        = FALSE;
	an[id].flgClick    = FALSE;
	an[id].flgUpdate   = FALSE;
	an[id].pc.percent  = 0;
	an[id].pc.flgClick = 0;
	an[id].tabStopIdx  = 0;
	for (i = 0; i < TBSP_ANGLE; i++) {an[id].tabStops[i] = NULL;}
	
	an[id].cn.x = 0;
	an[id].cn.y = 0;
	an[id].cn.w = 0;
	an[id].cn.h = 0;
	
	an[id].pc.x        = 0;
	an[id].pc.y        = 0;
	an[id].pc.w        = 0;
	an[id].pc.h        = 0;
	an[id].pc.percent  = 0;
	an[id].pc.flgClick = FALSE;
	InitImg(&an[id].pc.tmp);
	
	an[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {an[id].hPd  [i] = NULL;}
	for (i = 0; i < 2; i++) {an[id].hEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {an[id].hChk [i] = NULL;}
	an[id].hRgb = NULL;
	for (i = 0; i < 2; i++) {an[id].hBtn[i] = NULL;}
	an[id].hCn = NULL;
	an[id].hPc = NULL;
	
	for (i = 0; i < 2; i++) {an[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {an[id].pCallChk [i] = NULL;}
	for (i = 0; i < 2; i++) {an[id].pCallBtn [i] = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid AnInst(LONG)
    FLONG    FORM ID
    @\F̉
------------------------------------------------------------------------------*/
void AnInst(LONG id)
{
	DWORD styleAn  = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD stylePd1 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd2 = WS_CHILD;
	DWORD styleEd  = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleCk  = WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX;
	DWORD styleRb  = WS_CHILD|WS_VISIBLE|WS_BORDER;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleCn  = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD;
	INT32 w;
	WCHAR strRgb[6+1];
	WPARAM wp;
	
	_htow(an[id].rgb, strRgb, 6);
	
	w = SZ_WEDIT2-PADD8*2;
	an[id].hWnd    = a_CreateWindow(NM_ANGLE,  TxTl(E_TTLAGL),styleAn, 0, 0,  0, 0,  fm[id].hWnd);
	an[id].hPd[0]  = a_CreateWindow(NM_ANGLEPD,NULL,          stylePd1,8, 8,  w, 165,an[id].hWnd);
	an[id].hPd[1]  = a_CreateWindow(NM_ANGLEPD,NULL,          stylePd2,0, 0,  0, 0,  an[id].hWnd);
	an[id].hEdit[0]= a_CreateWindow(L"Edit",   L"0",          styleEd, 61,12, 65,17, an[id].hPd[0]);
	an[id].hEdit[1]= a_CreateWindow(L"Edit",   strRgb,        styleEd, 61,72, 65,17, an[id].hPd[0]);
	an[id].hChk[0] = a_CreateWindow(L"Button", TxEd(E_ANANTI),styleCk, 39,40, 90,25, an[id].hPd[0]);
	an[id].hChk[1] = a_CreateWindow(L"Button", TxEd(E_ANKEEP),styleCk, 39,100,80,25, an[id].hPd[0]);
	an[id].hRgb    = a_CreateWindow(NM_RGBBOX, NULL,          styleRb, 132,73,16,16, an[id].hPd[0]);
	an[id].hBtn[0] = a_CreateWindow(L"Button", TxEd(E_OK),    styleBt, 10,132,70,25, an[id].hPd[0]);
	an[id].hBtn[1] = a_CreateWindow(L"Button", TxEd(E_CANCEL),styleBt, 90,132,70,25, an[id].hPd[0]);
	an[id].hCn     = a_CreateWindow(NM_ANGLECN,NULL,          styleCn, 0, 0,  0, 0,  an[id].hPd[1]);
	an[id].hPc     = a_CreateWindow(NM_ANGLEPC,NULL,          stylePc, 0, 0,  0, 0,  an[id].hCn);
	
	SetWindowLong(an[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(an[id].hPd[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(an[id].hPd[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(an[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(an[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(an[id].hChk[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(an[id].hChk[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(an[id].hRgb,     GWL_USERDATA, id);
	SetWindowLong(an[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(an[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(an[id].hPc,      GWL_USERDATA, id);
	
	SetWindowLong(an[id].hWnd,   GWL_WNDPROC, (LONG)AnWndProc);
	SetWindowLong(an[id].hPd[0], GWL_WNDPROC, (LONG)AnWndProcPd);
	SetWindowLong(an[id].hPd[1], GWL_WNDPROC, (LONG)AnWndProcPd);
	SetWindowLong(an[id].hRgb,   GWL_WNDPROC, (LONG)AnWndProcRgb);
	SetWindowLong(an[id].hPc,    GWL_WNDPROC, (LONG)AnWndProcPc);
	
	E_SETFONT(an[id].hEdit[0], hFtCourier);
	E_SETFONT(an[id].hEdit[1], hFtCourier);
	B_SETFONT(an[id].hChk[0],  hFtArial14);
	B_SETFONT(an[id].hChk[1],  hFtArial14);
	
	E_SETLIMITTEXT(an[id].hEdit[0], 3);
	E_SETLIMITTEXT(an[id].hEdit[1], 6);
	
	if (an[id].anti) {wp = BST_CHECKED;} else {wp = BST_UNCHECKED;}
	B_SETCHECK(an[id].hChk[0], wp);
	
	if (an[id].keep) {wp = BST_CHECKED;} else {wp = BST_UNCHECKED;}
	B_SETCHECK(an[id].hChk[1], wp);
	
	B_SETFONT(an[id].hBtn[0], hFtArial14);
	B_SETFONT(an[id].hBtn[1], hFtArial14);
	
	an[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(an[id].hEdit[0], GWL_WNDPROC);
	an[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(an[id].hEdit[1], GWL_WNDPROC);
	an[id].pCallChk [0] = (CALLFUNC)GetWindowLong(an[id].hChk [0], GWL_WNDPROC);
	an[id].pCallChk [1] = (CALLFUNC)GetWindowLong(an[id].hChk [1], GWL_WNDPROC);
	an[id].pCallBtn [0] = (CALLFUNC)GetWindowLong(an[id].hBtn [0], GWL_WNDPROC);
	an[id].pCallBtn [1] = (CALLFUNC)GetWindowLong(an[id].hBtn [1], GWL_WNDPROC);
	SetWindowLong(an[id].hEdit[0], GWL_WNDPROC, (LONG)AnWndProcEditT);
	SetWindowLong(an[id].hEdit[1], GWL_WNDPROC, (LONG)AnWndProcEditB);
	SetWindowLong(an[id].hChk[0],  GWL_WNDPROC, (LONG)AnWndProcChkU);
	SetWindowLong(an[id].hChk[1],  GWL_WNDPROC, (LONG)AnWndProcChkK);
	SetWindowLong(an[id].hBtn[0],  GWL_WNDPROC, (LONG)AnWndProcBtnOk);
	SetWindowLong(an[id].hBtn[1],  GWL_WNDPROC, (LONG)AnWndProcBtnCan);
	
	an[id].tabStopIdx = 0;
	an[id].tabStops[0] = an[id].hEdit[0];
	an[id].tabStops[1] = an[id].hChk[0];
	an[id].tabStops[2] = an[id].hEdit[1];
	an[id].tabStops[3] = an[id].hRgb;
	an[id].tabStops[4] = an[id].hChk[1];
	an[id].tabStops[5] = an[id].hBtn[0];
	an[id].tabStops[6] = an[id].hBtn[1];
	SetFocus  (an[id].hEdit[0]);
	EditSelAll(an[id].hEdit[0]);
}

/*------------------------------------------------------------------------------
    Fvoid AnDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void AnDialog(LONG id)
{
	INT32 w;
	INT32 h;
	
	AnInit(id);
	AnLoad(id);
	
	w = fm[id].pc[0].img.w;
	h = fm[id].pc[0].img.h;
	AnTmpCreate(id, w, h, an[id].rgb);
	memcpy(an[id].pc.tmp.pB, fm[id].pc[0].img.pB, w * h * 4);
	
	AnInst(id);
	PpPlacement(id, an[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = an[id].hWnd;
	
	ShowWindow(an[id].hPd[1], 0x1);
	ShowWindow(an[id].hCn,    0x1);
	ShowWindow(an[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid AnLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void AnLoad(LONG id)
{
	an[id].rgb  = g_anRgb;
	an[id].anti = g_anAnti;
	an[id].keep = g_anKeep;
}

/*------------------------------------------------------------------------------
    Fvoid AnStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void AnStore(LONG id)
{
	g_anRgb  = an[id].rgb;
	g_anAnti = an[id].anti;
	g_anKeep = an[id].keep;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProc(,,,)
    F-
    ߒlF-
    @\FAN Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_USER:  AnUpdate(id);  break;  // WMU_RGBEND
	case WM_SIZE:           AnSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  AnGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       AnSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          AnClose        (id, wp, lp);  break;
	case WM_DESTROY:        AnDestroy      (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProcPd(,,,)
    F-
    ߒlF-
    @\FPDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {
			AnPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 0) {
			AnPdPaint(id, wp, lp);
		}
		break;
	case WM_CTLCOLORSTATIC:
		if ((HWND)lp == an[id].hChk[0]) {return (LRESULT)hBrWhite;}
		if ((HWND)lp == an[id].hChk[1]) {return (LRESULT)hBrWhite;}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProcEditT(,,,)
    F-
    ߒlF-
    @\FEDIT px Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProcEditT(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   AnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  AnEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		AnKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (AnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return an[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProcEditB(,,,)
    F-
    ߒlF-
    @\FEDIT wi Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProcEditB(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   AnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  AnEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		AnKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (AnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	default:
		break;
	}
	return an[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProcChkU(,,,)
    F-
    ߒlF-
    @\FCHECK v Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProcChkU(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  AnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   AnKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	
	res = an[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  AnChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProcChkK(,,,)
    F-
    ߒlF-
    @\FCHECK TCYێ Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProcChkK(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  AnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   AnKeyDown   (id, wp, lp, hWnd);  break;
	default:  break;
	}
	
	res = an[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  AnChSetCheck(id, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProcRgb(,,,)
    F-
    ߒlF-
    @\FRGB F Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProcRgb(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        AnRbPaint      (id, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     AnRbSetFocus   (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    AnRbKillFocus  (id, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  AnRbLButtonDown(id, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    AnRbLButtonUp  (id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      AnKeyDown      (id, wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FBTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  AnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   AnKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return an[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FBTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  AnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   AnKeyDown   (id, wp, lp, hWnd);  break;
	default: break;
	}
	return an[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK AnWndProcPc(,,,)
    F-
    ߒlF-
    @\FPCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK AnWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:  AnPcPaint(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid AnSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SIZECxg
------------------------------------------------------------------------------*/
void AnSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(an[id].hWnd, &rc);
	a_SetWindowPos(an[id].hPd[1], SZ_WEDIT2, PADD8, rc.right-SZ_WEDIT2-PADD8, rc.bottom-PADD8*2);
	
	AnSetPane(id);
	AnImageView(id);
	
	a_SetWindowPos(an[id].hPc, an[id].pc.x, an[id].pc.y,
							   an[id].pc.w, an[id].pc.h);
	
	InvalidateRect(an[id].hWnd,   NULL, TRUE);
	InvalidateRect(an[id].hPd[1], NULL, TRUE);
	InvalidateRect(an[id].hCn,    NULL, TRUE);
	InvalidateRect(an[id].hPc,    NULL, FALSE);
	UpdateWindow(an[id].hWnd);
	UpdateWindow(an[id].hPd[1]);
	UpdateWindow(an[id].hCn);
	UpdateWindow(an[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid AnGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void AnGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT2+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 165      +PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid AnSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void AnSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(an[id].tabStops[an[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid AnKeyDown(LONG, WPARAM, LPARAM, HWND hWnd)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void AnKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  AnKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    AnKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    AnKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_SP:     AnKeyDownSpace(id, wp, lp, hWnd);  break;
	case KEY_F5:     AnKeyDownF5   (id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     AnKeyDownUpDw (id, wp, lp, hWnd);  break;
	case KEY_RT:
	case KEY_LF:     AnKeyDownRtLf (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid AnKeyDownEnter(LONG, WPARAM, LPARAM, HWND hWnd)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[enter]L[Cxg
------------------------------------------------------------------------------*/
void AnKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == an[id].hBtn[1]) {AnEnterCan(id);}
	else                        {AnEnterOk (id);}
}

/*------------------------------------------------------------------------------
    Fvoid AnKeyDownEsc(LONG, WPARAM, LPARAM, HWND hWnd)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[esc]L[Cxg
------------------------------------------------------------------------------*/
void AnKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(an[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid AnKeyDownTab(LONG, WPARAM, LPARAM, HWND hWnd)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[tab]L[Cxg
------------------------------------------------------------------------------*/
void AnKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	if (shift == TRUE) {
		if (an[id].tabStopIdx == 0) {an[id].tabStopIdx = TBSP_ANGLE-1;}
		else                        {an[id].tabStopIdx--;}
	}
	else {
		an[id].tabStopIdx = (an[id].tabStopIdx + 1) % TBSP_ANGLE;
	}
	SetFocus(an[id].tabStops[an[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid AnKeyDownSpace(LONG, WPARAM, LPARAM, HWND hWnd)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[space]L[Cxg
------------------------------------------------------------------------------*/
void AnKeyDownSpace(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (hWnd != an[id].hRgb) {return;}
	
	GetWindowText(an[id].hEdit[1], buffRgb, 6+1);
	RbDialog(id, buffRgb, an[id].hWnd, an[id].hEdit[1], an[id].hRgb);
}

/*------------------------------------------------------------------------------
    Fvoid AnKeyDownF5(LONG, WPARAM, LPARAM, HWND hWnd)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FKEY_F5Cxg
------------------------------------------------------------------------------*/
void AnKeyDownF5(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	AnUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid AnKeyDownUpDw(LONG, WPARAM, LPARAM, HWND hWnd)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[][]L[Cxg
------------------------------------------------------------------------------*/
void AnKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	WCHAR text[3+1];
	INT32 val;
	INT32 limL;
	INT32 limH;
	INT32 step;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	if (hWnd != an[id].hEdit[0]) {return;}
	
	GetWindowText(hWnd, text, 3+1);
	val = _wtoi(text);
	
	limL = 0;
	limH = 360;
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
	
	AnUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid AnKeyDownRtLf(LONG, WPARAM, LPARAM, HWND hWnd)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[][]L[Cxg
------------------------------------------------------------------------------*/
void AnKeyDownRtLf(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == an[id].hBtn[0]) {
		if (wp == KEY_RT) {
			an[id].tabStopIdx++;
			SetFocus(an[id].tabStops[an[id].tabStopIdx]);
		}
	}
	else if (hWnd == an[id].hBtn[1]) {
		if (wp == KEY_LF) {
			an[id].tabStopIdx--;
			SetFocus(an[id].tabStops[an[id].tabStopIdx]);
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid AnClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_CLOSECxg
------------------------------------------------------------------------------*/
void AnClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid AnDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_DESTROYCxg
------------------------------------------------------------------------------*/
void AnDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	AnTmpDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid AnPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_COMMANDCxg
------------------------------------------------------------------------------*/
void AnPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	if (HIWORD(wp) != BN_CLICKED) {return;}
	
	if      ((HWND)lp == an[id].hBtn[0]) {AnEnterOk (id);}
	else if ((HWND)lp == an[id].hBtn[1]) {AnEnterCan(id);}
}

/*------------------------------------------------------------------------------
    Fvoid AnPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_PAINTCxg
------------------------------------------------------------------------------*/
void AnPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1;
	INT32 x2, y2;
	
	hdc = BeginPaint(an[id].hPd[0], &ps);
	GetClientRect(an[id].hPd[0], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	switch (g_idxLang) {
	case 0:  x1 = 28;  x2 = 29;  break;
	case 1:  x1 = 25;  x2 = 28;  break;
	default: break;
	}
	
	y1 = 13;
	y2 = 73;
	a_TextOut(hdc, x1, y1, TxEd(E_ANANGLE));
	a_TextOut(hdc, x2, y2, TxEd(E_ANBACK));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(an[id].hPd[0], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid AnEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FEDIT WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void AnEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_ANGLE; i++) {
		if (hWnd == an[id].tabStops[i]) {
			an[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid AnEdKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FEDIT WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void AnEdKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_ANGLE; i++) {
		if ((HWND)wp == an[id].tabStops[i]) {
			AnUpdate(id);
			break;
		}
	}
}

/*------------------------------------------------------------------------------
    FBOOL AnEdChar(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FEDIT WM_CHARCxg
------------------------------------------------------------------------------*/
BOOL AnEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd == an[id].hEdit[0]) {
		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	}
	else if (hWnd == an[id].hEdit[1])
	{
		if (((0x30 <= wp) && (wp <= 0x39)) ||  // 0-9
			((0x41 <= wp) && (wp <= 0x46)) ||  // a-f
			((0x61 <= wp) && (wp <= 0x66)))    // A-F
		{
			return TRUE;
		}
	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid AnChSetCheck(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FCHECK BM_SETCHECKCxg
------------------------------------------------------------------------------*/
void AnChSetCheck(LONG id, WPARAM wp, LPARAM lp)
{
	AnUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid AnRbPaint(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void AnRbPaint(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RbBoxPaint(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid AnRbSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void AnRbSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_ANGLE; i++) {
		if ((HWND)wp == an[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
	
	AnEdSetFocus(id, wp, lp, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid AnRbKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void AnRbKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_ANGLE; i++) {
		if ((HWND)wp == an[id].tabStops[i]) {
			res = TRUE;
		}
	}
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow  (hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid AnRbLButtonDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void AnRbLButtonDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	an[id].flgClick = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid AnRbLButtonUp(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void AnRbLButtonUp(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (an[id].flgClick == FALSE) {return;}
	an[id].flgClick = FALSE;
	SetFocus(hWnd);
	
	GetWindowText(an[id].hEdit[1], buffRgb, 6+1);
	RbDialog(id, buffRgb, an[id].hWnd, an[id].hEdit[1], an[id].hRgb);
}

/*------------------------------------------------------------------------------
    Fvoid AnPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_PAINTCxg
------------------------------------------------------------------------------*/
void AnPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
	
	hdc = BeginPaint(an[id].hPc, &ps);
	GetClientRect(an[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	
	x2 = 0;
	y2 = 0;
	w2 = an[id].pc.w;
	h2 = an[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = an[id].pc.tmp.w;
	h1 = an[id].pc.tmp.h;
	
	if (an[id].pc.percent < 10000) {mode = HALFTONE;}
	else                           {mode = COLORONCOLOR;}
	
	SetStretchBltMode(hdc, mode);
	StretchBlt(hdc,               x2, y2, w2, h2,
			   an[id].pc.tmp.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(an[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid AnEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void AnEnterOk(LONG id)
{
	INT32 w;
	INT32 h;
	WCHAR buffRgb[6+1];
	INT32 rgb;
	INT32 checkedA;
	INT32 checkedK;
	st_Image img;
	
	AnUpdate(id);
	if (an[id].flgUpdate == FALSE) {CLOSE(an[id].hWnd);  return;}
	
	w = an[id].pc.tmp.w;
	h = an[id].pc.tmp.h;
	ImageCreate(&img, w, h);
	memcpy(img.pB, an[id].pc.tmp.pB, w*h*4);
	DeleteObject(fm[id].pc[0].img.hBmp);
	DeleteDC    (fm[id].pc[0].img.hdc);
	fm[id].pc[0].img.hBmp = img.hBmp;
	fm[id].pc[0].img.hdc  = img.hdc;
	fm[id].pc[0].img.pB   = img.pB;
	fm[id].pc[0].img.w    = img.w;
	fm[id].pc[0].img.h    = img.h;
	fm[id].pc[0].div      = RAW;
	fm[id].flgAngle       = TRUE;
	LiImageDelete(id, 0);
	
	SetAverageColor(id, 0);
	FmSizeNeutral(id, NULL, NULL);
	
	SbFlush(id);
	SetFormText(id);
	MnFlushFile(id);
	
	GetWindowText(an[id].hEdit[1], buffRgb, 6+1);
	rgb = _wtoh(buffRgb, 6);
	an[id].rgb = rgb;
	
	checkedA = B_GETCHECK(an[id].hChk[0]);
	checkedK = B_GETCHECK(an[id].hChk[1]);
	if (checkedA == BST_CHECKED) {an[id].anti=TRUE;}  else {an[id].anti=FALSE;}
	if (checkedK == BST_CHECKED) {an[id].keep=TRUE;}  else {an[id].keep=FALSE;}
	
	AnStore(id);
	CLOSE(an[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid AnEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void AnEnterCan(LONG id)
{
	CLOSE(an[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid AnUpdate(LONG id)
    FLONG    FORM ID
    @\Fpx̕\XV
------------------------------------------------------------------------------*/
void AnUpdate(LONG id)
{
	INT32 i;
	INT32 j;
	WCHAR anEditAngle[3+1];
	WCHAR anEditRgb  [6+1];
	INT32 angle;
	INT32 rgb;
	RECT rc;
	POINT pt[3];
	double radian;
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	INT32 xCenter;
	INT32 yCenter;
	INT32 xMax;
	INT32 yMax;
	BYTE *pB1, *pB2;
	INT32 checkedA;
	INT32 checkedK;
	BOOL  anti;
	BOOL  keep;
	
	GetWindowText(an[id].hEdit[0], anEditAngle, 3+1);
	GetWindowText(an[id].hEdit[1], anEditRgb,   6+1);
	angle = _wtoi(anEditAngle);
	rgb = _wtoh(anEditRgb, 6);
	checkedA = B_GETCHECK(an[id].hChk[0]);
	checkedK = B_GETCHECK(an[id].hChk[1]);
	if (checkedA == BST_CHECKED) {anti=TRUE;}  else {anti=FALSE;}
	if (checkedK == BST_CHECKED) {keep=TRUE;}  else {keep=FALSE;}
	
	if ((angle == an[id].angle) &&
		(rgb   == an[id].rgb)   &&
		(anti  == an[id].anti)  &&
		(keep  == an[id].keep)) {return;}
	
	w = fm[id].pc[0].img.w;
	h = fm[id].pc[0].img.h;
	
	if ((angle == 0) || (angle == 360)) {
		AnTmpDelete(id);
		AnTmpCreate(id, w, h, rgb);
		memcpy(an[id].pc.tmp.pB, fm[id].pc[0].img.pB, w*h*4);
	}
	else if (angle == 180) {
		AnTmpDelete(id);
		AnTmpCreate(id, w, h, rgb);
		
		pB2 = an[id].pc.tmp.pB;
		for (i = 0; i < h; i++) {
			pB1 = fm[id].pc[0].img.pB + (h-1-i)*w*4 + (w-1)*4;
			
			for (j = 0; j < w; j++) {
				*(pB2+2) = *(pB1+2);
				*(pB2+1) = *(pB1+1);
				*(pB2+0) = *(pB1+0);
				pB2 += 4;
				pB1 -= 4;
			}
		}
	}
	else if ((((angle ==  90) && (anti == FALSE)) ||
			  ((angle == 270) && (anti == TRUE))) && (keep == FALSE))
	{
		AnTmpDelete(id);
		AnTmpCreate(id, h, w, rgb);
		
		pB1 = fm[id].pc[0].img.pB;
		for (i = 0; i < h; i++) {
			
			pB2 = an[id].pc.tmp.pB + (w-1)*h*4 + i*4;
			for (j = 0; j < w; j++) {
				*(pB2+2) = *(pB1+2);
				*(pB2+1) = *(pB1+1);
				*(pB2+0) = *(pB1+0);
				pB1 += 4;
				pB2 -= h * 4;
			}
		}
	}
	else if ((((angle == 270) && (anti == FALSE)) ||
			  ((angle ==  90) && (anti == TRUE))) && (keep == FALSE))
	{
		AnTmpDelete(id);
		AnTmpCreate(id, h, w, rgb);
		
		pB1 = fm[id].pc[0].img.pB;
		for (i = 0; i < h; i++) {
			
			pB2 = an[id].pc.tmp.pB + (h-1-i)*4;
			for (j = 0; j < w; j++) {
				*(pB2+2) = *(pB1+2);
				*(pB2+1) = *(pB1+1);
				*(pB2+0) = *(pB1+0);
				pB1 += 4;
				pB2 += h * 4;
			}
		}
	}
	else {
		if (anti == TRUE) {angle *= -1;}
		
		radian = (double)angle * 3.14159265 / 180;
		xCenter = w / 2;
		yCenter = h / 2;
		
		pt[0].x = 0;
		pt[0].y = 0;
		pt[1].x = w;
		pt[1].y = 0;
		pt[2].x = 0;
		pt[2].y = h;
		
		for (i = 0; i < 3; i++) {
			x = pt[i].x - xCenter;
			y = pt[i].y - yCenter;
			pt[i].x = x*cos(radian) - y*sin(radian);
			pt[i].y = x*sin(radian) + y*cos(radian);
		}
		
		xMax = 0;
		yMax = 0;
		for (i = 0; i < 3; i++) {
			if (xMax < ABS(pt[i].x)) {xMax = ABS(pt[i].x);}
			if (yMax < ABS(pt[i].y)) {yMax = ABS(pt[i].y);}
		}
		
		AnTmpDelete(id);
		
		if (keep == TRUE) {
			AnTmpCreate(id, w, h, rgb);
			
			for (i = 0; i < 3; i++) {
				pt[i].x += w/2;
				pt[i].y += h/2;
			}
			
			rc.left   = 0;
			rc.top    = 0;
			rc.right  = w;
			rc.bottom = h;
			SetClipRgn(an[id].pc.tmp.hdc, &rc);
		}
		else {
			AnTmpCreate(id, xMax*2, yMax*2, rgb);
			
			for (i = 0; i < 3; i++) {
				pt[i].x += xMax;
				pt[i].y += yMax;
			}
			
			rc.left   = 0;
			rc.top    = 0;
			rc.right  = xMax*2;
			rc.bottom = yMax*2;
			SetClipRgn(an[id].pc.tmp.hdc, &rc);
		}
		
		PlgBlt(an[id].pc.tmp.hdc, pt, fm[id].pc[0].img.hdc, 0, 0, w, h, NULL, 0, 0);
		
		SelectClipRgn(an[id].pc.tmp.hdc, NULL);
	}
	
	AnSetPane(id);
	AnImageView(id);
	a_SetWindowPos(an[id].hPc, an[id].pc.x, an[id].pc.y,
							   an[id].pc.w, an[id].pc.h);
	InvalidateRect(an[id].hCn, NULL, TRUE);
	InvalidateRect(an[id].hPc, NULL, FALSE);
	UpdateWindow  (an[id].hCn);
	UpdateWindow  (an[id].hPc);
	
	an[id].angle = angle;
	an[id].rgb   = rgb;
	an[id].anti  = anti;
	an[id].keep  = keep;
	an[id].flgUpdate = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid AnTmpCreate(LONG, INT32, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
          INT32    wiF
    @\Fpx ꎞC[W쐬
------------------------------------------------------------------------------*/
void AnTmpCreate(LONG id, INT32 w, INT32 h, INT32 rgb)
{
	INT32 i;
	INT32 *pB32;
	
	ImageCreate(&an[id].pc.tmp, w, h);
	
	pB32 = (INT32 *)an[id].pc.tmp.pB;
	for (i = 0; i < w*h; i++) {
		*pB32 = rgb;
		pB32++;
	}
}

/*------------------------------------------------------------------------------
    Fvoid AnTmpDelete(LONG)
    FLONG     FORM ID
    @\Fpx ꎞC[W폜
------------------------------------------------------------------------------*/
void AnTmpDelete(LONG id)
{
	DeleteDC    (an[id].pc.tmp.hdc);
	DeleteObject(an[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid AnImageView(LONG)
    FLONG    FORM ID
    @\Fpx̕ҏW\p
------------------------------------------------------------------------------*/
void AnImageView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	if (IsBit(fm[id].pc[0].img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	TryZeroDivision(an[id].pc.tmp.w);
	TryZeroDivision(an[id].pc.tmp.h);
	gainW = (double)an[id].cn.w / an[id].pc.tmp.w;
	gainH = (double)an[id].cn.h / an[id].pc.tmp.h;
	
	if ((1 < gainW) && (1 < gainH)) {
		gainW = gainH = (double)1;
	}
	else {
		if (CmpGain(gainW, gainH) == TRUE) {
			limW = TRUE;
			limH = TRUE;
		}
		else {
			if (gainW < gainH) {
				gainH = gainW;
				limW = TRUE;
			}
			else {
				gainW = gainH;
				limH = TRUE;
			}
		}
	}
	
	x = (double)an[id].cn.w / 2 - (double)an[id].pc.tmp.w * gainW / 2;
	y = (double)an[id].cn.h / 2 - (double)an[id].pc.tmp.h * gainH / 2;
	w = (double)an[id].pc.tmp.w * gainW;
	h = (double)an[id].pc.tmp.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = an[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = an[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(an[id].pc.tmp.w);  an[id].pc.percent = ((double)w / an[id].pc.tmp.w) * 10000;}
	else              {TryZeroDivision(an[id].pc.tmp.h);  an[id].pc.percent = ((double)h / an[id].pc.tmp.h) * 10000;}
	
	an[id].pc.x = x;
	an[id].pc.y = y;
	if (w <= 0) {an[id].pc.w = 1;}
	else        {an[id].pc.w = w;}
	if (h <= 0) {an[id].pc.h = 1;}
	else        {an[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid AnSetPane(LONG)
    FLONG    FORM ID
    @\F͈͂̕\̘g\
------------------------------------------------------------------------------*/
void AnSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(an[id].hPd[1], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(an[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(an[id].hCn, &rc);
	an[id].cn.x = rc.left;
	an[id].cn.y = rc.top;
	an[id].cn.w = rc.right - rc.left;
	an[id].cn.h = rc.bottom - rc.top;
}
