/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define LG_CPP
#include "../common.h"
//  LogF

// NA
/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	BOOL show;
	INT32 tabStopIdx;
	HWND tabStops[2];
	
	HWND hWnd;
	HWND hBtn;
	HWND hEdit;
	
	LRESULT (CALLBACK *pCallBtn)  (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallEdit) (HWND,UINT,WPARAM,LPARAM);
} lg;

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void LgInst(void);
BOOL LgIsShow(void);
void LgShow(void);
HWND LgGetHwnd(void);
void LgMsg(LCHAR *, ...);
void LgAddStr(WCHAR *);
void LgDestroy(void);
LRESULT CALLBACK LgWndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LgWndProcBtn(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LgWndProcEdit(HWND, UINT, WPARAM, LPARAM);
void LgCommand(WPARAM, LPARAM);
void LgSize(WPARAM, LPARAM);
void LgSetFocus(WPARAM, LPARAM);
void LgKeyDown(WPARAM, LPARAM, HWND);
void LgKeyDownEnter(WPARAM, LPARAM, HWND);
void LgKeyDownEsc(WPARAM, LPARAM, HWND);
void LgKeyDownTab(WPARAM, LPARAM, HWND);
void LgEdSetFocus(WPARAM, LPARAM, HWND);

/*------------------------------------------------------------------------------
    Fvoid LgInst(void)
    @\FLOG̉
------------------------------------------------------------------------------*/
void LgInst(void)
{
	WNDCLASS wc;
	DWORD styleLg = WS_CAPTION|WS_THICKFRAME|WS_SYSMENU/*|WS_MAXIMIZEBOX|WS_MINIMIZEBOX*/;
	DWORD styleBt = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleEd = WS_CHILD|WS_VSCROLL|WS_VISIBLE|WS_BORDER|ES_LEFT|ES_MULTILINE|ES_AUTOHSCROLL/*|ES_READONLY*/;
	
	InitWC(NULL,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_LOG,&wc);
	RegisterClass(&wc);
	
	lg.hWnd  = a_CreateWindow(NM_LOG,TxTl(E_TTLLOG),styleLg,0,0,0,0,NULL);
	lg.hBtn  = a_CreateWindow(L"Button",L"CLEAR",styleBt,0,0,0,0,lg.hWnd);
	lg.hEdit = a_CreateWindow(L"Edit",  NULL,styleEd,0,0,0,0,lg.hWnd);
	SetWindowLong(lg.hWnd, GWL_WNDPROC, (LONG)LgWndProc);
	
	lg.pCallBtn  = (CALLFUNC)GetWindowLong(lg.hBtn,  GWL_WNDPROC);
	lg.pCallEdit = (CALLFUNC)GetWindowLong(lg.hEdit, GWL_WNDPROC);
	SetWindowLong(lg.hBtn,  GWL_WNDPROC, (LONG)LgWndProcBtn);
	SetWindowLong(lg.hEdit, GWL_WNDPROC, (LONG)LgWndProcEdit);
	
	E_SETFONT(lg.hBtn,  hFtArial14);
	E_SETFONT(lg.hEdit, hFtMsGothic);
	
	lg.tabStopIdx = 0;
	lg.tabStops[0] = lg.hBtn;
	lg.tabStops[1] = lg.hEdit;
	
	SetFocus(lg.hEdit);
	
	lg.x = g_lgX;
	lg.y = g_lgY;
	lg.w = g_lgW;
	lg.h = g_lgH;
}

/*------------------------------------------------------------------------------
    FBOOL LgIsShow(void)
    ߒlFBOOL  -
    @\F\
------------------------------------------------------------------------------*/
BOOL LgIsShow(void)
{
	return lg.show;
}

/*------------------------------------------------------------------------------
    Fvoid LgShow(void)
    @\F\
------------------------------------------------------------------------------*/
void LgShow(void)
{
	WINDOWPLACEMENT plcm;
	
	if (!IsWindowVisible(lg.hWnd)) {
		lg.show = TRUE;
		InitPlcm(&plcm);
		plcm.rcNormalPosition.left   = lg.x;
		plcm.rcNormalPosition.top    = lg.y;
		plcm.rcNormalPosition.right  = lg.x + lg.w;
		plcm.rcNormalPosition.bottom = lg.y + lg.h;
		plcm.showCmd = SHOWCMD_NORMAL;
		
		AdjustWorkArea(INVALID_ID, &plcm);
		SetWindowPlacement(lg.hWnd, &plcm);
	}
	
	SetForegroundWindow(lg.hWnd);
}

/*------------------------------------------------------------------------------
    FHWND LgGetHwnd(void)
    ߒlFHWND  -
    @\F\
------------------------------------------------------------------------------*/
HWND LgGetHwnd(void)
{
	return lg.hWnd;
}

/*------------------------------------------------------------------------------
    Fvoid LgMsg(LCHAR *, ...)
    FLCHAR *    -
          ...        -
    @\FOP쐬
------------------------------------------------------------------------------*/
void LgMsg(LCHAR *str, ...)
{
	WCHAR buff[1000];
	
	va_list args;
	va_start(args, str);
	wvsprintf(buff, str, args);
	va_end(args); 
	
	LgAddStr(buff);
}

/*------------------------------------------------------------------------------
    Fvoid LgAddStr(WCHAR *)
    FWCHAR *    -
    @\FPs̕ǉ
------------------------------------------------------------------------------*/
void LgAddStr(WCHAR *str)
{
	INT32 len;
	
	if (wcslen(str) > 1000) {
		MessageBox(NULL, L"danger log line length over", L_FATAL, MB_OK);
		exit(1);
	}
	
	len = GetWindowTextLength(lg.hEdit);
	E_SETSEL(lg.hEdit, len, len);
	E_REPLACESEL(lg.hEdit, str);
	E_SCROLLCARET(lg.hEdit);
}

/*------------------------------------------------------------------------------
    Fvoid LgDestroy(void)
    @\Fj󂷂
------------------------------------------------------------------------------*/
void LgDestroy(void)
{
	g_lgX = lg.x;
	g_lgY = lg.y;
	g_lgW = lg.w;
	g_lgH = lg.h;
	
	DESTROY(lg.hWnd);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LgWndProc(,,,)
    F...        -
    ߒlFLRESULT    -
    @\FLOGCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LgWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	switch (msg) {
	case WM_COMMAND:   LgCommand(wp, lp);   break;
	case WM_SIZE:      LgSize(wp, lp);      break;
	case WM_SETFOCUS:  LgSetFocus(wp, lp);  break;
	case WM_CLOSE:
		lg.show = FALSE;
		GetWindowRect(lg.hWnd, &rc);
		lg.x = rc.left;
		lg.y = rc.top;
		lg.w = rc.right - rc.left;
		lg.h = rc.bottom - rc.top;
		ShowWindow(lg.hWnd, 0x0);
		
		if (FormCount() != 0) {return 0;}
		CLOSE(hCore);
		break;
	case WM_DESTROY:
		break;
	default:
		break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LgWndProcBtn(,,,)
    F-
    ߒlF-
    @\FLOG BTNCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LgWndProcBtn(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_SETFOCUS:  LgEdSetFocus(wp, lp, hWnd);  break;
	case WM_KEYDOWN:   LgKeyDown(wp, lp, hWnd);  break;
	default:
		break;
	}
	return lg.pCallBtn(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LgWndProcEdit(,,,)
    F-
    ߒlF-
    @\FLOG EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LgWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	switch (msg) {
	case WM_SETFOCUS:  LgEdSetFocus(wp, lp, hWnd);  break;
	case WM_KEYDOWN:   LgKeyDown(wp, lp, hWnd);  break;
	case WM_CHAR:
		if (wp == KEY_TAB) {return 0;}
		break;
	default: break;
	}
	return lg.pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid LgCommand(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FLOG WM_COMMANDCxg
------------------------------------------------------------------------------*/
void LgCommand(WPARAM wp, LPARAM lp)
{
	if ((HWND)lp == lg.hBtn) {SetWindowText(lg.hEdit, L"");}
}

/*------------------------------------------------------------------------------
    Fvoid LgCommand(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FLOG WM_SIZECxg
------------------------------------------------------------------------------*/
void LgSize(WPARAM wp, LPARAM lp)
{
	RECT rc;
	INT32 x;
	INT32 y;
	INT32 w;
	INT32 h;
	
	GetClientRect(lg.hWnd, &rc);
	x = rc.left;
	y = rc.top;
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	
	a_SetWindowPos(lg.hBtn, w-50-10, y+5, 50, 20);
	a_SetWindowPos(lg.hEdit, x+5, y+5+25, w-10, h-10-25);
	
	InvalidateRect(lg.hWnd,  NULL, TRUE);
	UpdateWindow(lg.hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LgSetFocus(WPARAM, LPARAM)
    FWPARAM  -
          LPARAM  -
    @\FLOG WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void LgSetFocus(WPARAM wp, LPARAM lp)
{
	SetFocus(lg.tabStops[lg.tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid LgKeyDown(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FLOG WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void LgKeyDown(WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  LgKeyDownEnter(wp, lp, hWnd);  break;
	case KEY_ESC:    LgKeyDownEsc  (wp, lp, hWnd);  break;
	case KEY_TAB:    LgKeyDownTab  (wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid LgKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FLOG [enter]L[Cxg
------------------------------------------------------------------------------*/
void LgKeyDownEnter(WPARAM wp, LPARAM lp, HWND hWnd)
{
	if (hWnd != lg.hBtn) {return;}
	
	SetWindowText(lg.hEdit, L"");
}

/*------------------------------------------------------------------------------
    Fvoid LgKeyDownEsc(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FLOG [esc]L[Cxg
------------------------------------------------------------------------------*/
void LgKeyDownEsc(WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(lg.hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LgKeyDownTab(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FLOG [tab]L[Cxg
------------------------------------------------------------------------------*/
void LgKeyDownTab(WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT8 tmp;
	BOOL shift;
	
	tmp = GetKeyState(KEY_SHIFT);
	if((tmp & 0x80)!=0){shift=TRUE;}else{shift=FALSE;}
	
	if (shift == TRUE) {
		if (lg.tabStopIdx == 0) {lg.tabStopIdx = TBSP_LOG-1;}
		else                    {lg.tabStopIdx--;}
	}
	else {
		lg.tabStopIdx = (lg.tabStopIdx + 1) % TBSP_LOG;
	}
	SetFocus(lg.tabStops[lg.tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid LgEdSetFocus(WPARAM, LPARAM, HWND)
    FWPARAM  -
          LPARAM  -
          HWND    -
    @\FLOG WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void LgEdSetFocus(WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_LOG; i++) {
		if (hWnd == lg.tabStops[i]) {
			lg.tabStopIdx = i;
		}
	}
}
