/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define LN_CPP
#include "../common.h"
//  LineF

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 x1;
	INT32 y1;
	INT32 x2;
	INT32 y2;
	BOOL x2Fx;
	BOOL y2Fx;
	INT32 rgb;
	INT32 t;
	BOOL flgClick;
	BOOL flgUpdate;
	INT32 tabStopIdx;
	HWND tabStops[TBSP_LINE];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			INT32 x1;
			INT32 y1;
			INT32 x2;
			INT32 y2;
			UINT32 percent;
			BOOL flgClick;
			BOOL flgShift;
			INT32 flgsBorder;
			st_Image tmp;} pc;
	
	HWND hWnd;
	HWND hPd[2];
	HWND hEdit[6];
	HWND hChk[2];
	HWND hRgb;
	HWND hBtn[3];
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallEdit[6]) (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallChk[2])  (HWND,UINT,WPARAM,LPARAM);
	LRESULT (CALLBACK *pCallBtn[3])  (HWND,UINT,WPARAM,LPARAM);
} ln[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void LnInitClass(void);
void LnInit(LONG);
void LnInst(LONG);
void LnDialog(LONG);
void LnLoad(LONG);
void LnStore(LONG);
LRESULT CALLBACK LnWndProc      (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcPd    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcEditX1(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcEditY1(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcEditX2(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcEditY2(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcEditC (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcEditT (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcChkX2 (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcChkY2 (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcRgb   (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcBtnOk (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcBtnCan(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcBtnApl(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LnWndProcPc    (HWND, UINT, WPARAM, LPARAM);
void LnSize         (LONG, WPARAM, LPARAM);
void LnGetMinMaxInfo(LONG, WPARAM, LPARAM);
void LnSetFocus     (LONG, WPARAM, LPARAM);
void LnKeyDown      (LONG, WPARAM, LPARAM, HWND);
void LnKeyDownEnter (LONG, WPARAM, LPARAM, HWND);
void LnKeyDownEsc   (LONG, WPARAM, LPARAM, HWND);
void LnKeyDownTab   (LONG, WPARAM, LPARAM, HWND);
void LnKeyDownSpace (LONG, WPARAM, LPARAM, HWND);
void LnKeyDownF5    (LONG, WPARAM, LPARAM, HWND);
void LnKeyDownShift (LONG, WPARAM, LPARAM, HWND);
void LnKeyDownUpDw  (LONG, WPARAM, LPARAM, HWND);
void LnKeyUp        (LONG, WPARAM, LPARAM);
void LnClose        (LONG, WPARAM, LPARAM);
void LnDestroy      (LONG, WPARAM, LPARAM);
void LnPdCommand    (LONG, WPARAM, LPARAM);
void LnPdPaint      (LONG, WPARAM, LPARAM);
void LnEdSetFocus   (LONG, WPARAM, LPARAM, HWND);
void LnEdKillFocus  (LONG, WPARAM, LPARAM, HWND);
BOOL LnEdChar       (LONG, WPARAM, LPARAM, HWND);
void LnChSetCheck   (LONG, LONG, WPARAM, LPARAM);
void LnRbPaint      (LONG, WPARAM, LPARAM, HWND);
void LnRbSetFocus   (LONG, WPARAM, LPARAM, HWND);
void LnRbKillFocus  (LONG, WPARAM, LPARAM, HWND);
void LnRbLButtonDown(LONG, WPARAM, LPARAM, HWND);
void LnRbLButtonUp  (LONG, WPARAM, LPARAM, HWND);
void LnPcPaint      (LONG, WPARAM, LPARAM);
void LnPcMouseMove  (LONG, WPARAM, LPARAM);
void LnPcLButtonDown(LONG, WPARAM, LPARAM);
void LnPcLButtonUp  (LONG, WPARAM, LPARAM);
void LnEnterOk(LONG);
void LnEnterCan(LONG);
void LnEnterApl(LONG);
void LnUpdate(LONG);
void LnTmpCreate(LONG, INT32, INT32);
void LnTmpDraw(LONG);
void LnTmpDelete(LONG);
void LnSetCursor(LONG, INT32, INT32);
void LnMouse(LONG, INT32, INT32);
void LnImageView(LONG);
void LnSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid LnInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void LnInitClass(void)
{
	WNDCLASS wcLine;
	WNDCLASS wcLinePd;
	WNDCLASS wcLineCn;
	WNDCLASS wcLinePc;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_LINE,  &wcLine);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_LINEPD,&wcLinePd);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_LINECN,&wcLineCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_LINEPC,&wcLinePc);
	
	RegisterClass(&wcLine);
	RegisterClass(&wcLinePd);
	RegisterClass(&wcLineCn);
	RegisterClass(&wcLinePc);
}

/*------------------------------------------------------------------------------
    Fvoid LnInit(LONG)
    FLONG    FORM ID
    @\F
------------------------------------------------------------------------------*/
void LnInit(LONG id)
{
	INT32 i;
	
	ln[id].x1         = 0;
	ln[id].y1         = 0;
	ln[id].x2         = 0;
	ln[id].y2         = 0;
	ln[id].x2Fx       = FALSE;
	ln[id].y2Fx       = FALSE;
	ln[id].rgb        = 0x000000;
	ln[id].t          = 0;
	ln[id].flgUpdate  = FALSE;
	ln[id].tabStopIdx = 0;
	for (i = 0; i < TBSP_LINE; i++) {ln[id].tabStops[i] = NULL;}
	
	ln[id].cn.x = 0;
	ln[id].cn.y = 0;
	ln[id].cn.w = 0;
	ln[id].cn.h = 0;
	
	ln[id].pc.x          = 0;
	ln[id].pc.y          = 0;
	ln[id].pc.w          = 0;
	ln[id].pc.h          = 0;
	ln[id].pc.x1         = 0;
	ln[id].pc.y1         = 0;
	ln[id].pc.x2         = 0;
	ln[id].pc.y2         = 0;
	ln[id].pc.percent    = 0;
	ln[id].pc.flgClick   = FALSE;
	ln[id].pc.flgShift   = FALSE;
	ln[id].pc.flgsBorder = 0x00000000;
	InitImg(&ln[id].pc.tmp);
	
	ln[id].hWnd = NULL;
	for (i = 0; i < 2; i++) {ln[id].hPd[i]   = NULL;}
	for (i = 0; i < 6; i++) {ln[id].hEdit[i] = NULL;}
	ln[id].hRgb = NULL;
	for (i = 0; i < 3; i++) {ln[id].hBtn[i] = NULL;}
	ln[id].hCn = NULL;
	ln[id].hPc = NULL;
	
	for (i = 0; i < 6; i++) {ln[id].pCallEdit[i] = NULL;}
	for (i = 0; i < 2; i++) {ln[id].pCallChk[i]  = NULL;}
	for (i = 0; i < 3; i++) {ln[id].pCallBtn[i]  = NULL;}
}

/*------------------------------------------------------------------------------
    Fvoid LnInst(LONG)
    FLONG      FORM ID
    @\F̉
------------------------------------------------------------------------------*/
void LnInst(LONG id)
{
	DWORD styleLn  = WS_OVERLAPPED|WS_CAPTION|WS_MAXIMIZEBOX|WS_THICKFRAME|WS_SYSMENU;
	DWORD stylePd1 = WS_CHILD|WS_VISIBLE;
	DWORD stylePd2 = WS_CHILD;
	DWORD styleEd  = WS_CHILD|WS_VISIBLE|WS_BORDER|ES_CENTER|ES_AUTOHSCROLL;
	DWORD styleCk  = WS_CHILD|WS_VISIBLE|BS_AUTOCHECKBOX;
	DWORD styleRb  = WS_CHILD|WS_VISIBLE|WS_BORDER;
//	DWORD styleCm  = WS_CHILD|WS_VISIBLE|CBS_DROPDOWNLIST;
	DWORD styleBt  = WS_CHILD|WS_VISIBLE|BS_PUSHBUTTON;
	DWORD styleCn  = WS_CHILD|WS_CLIPCHILDREN;
	DWORD stylePc  = WS_CHILD;
	INT32 y[6] = {12,42,72,102,132,162,};
	INT32 w;
	WCHAR strRgb  [6+1];
	WCHAR strThick[2+1];
	WPARAM wp[2];
	
	_htow(ln[id].rgb, strRgb,   6);
	_itow(ln[id].t,   strThick, 10);
	
	w = SZ_WEDIT3-PADD8*2;
	ln[id].hWnd     = a_CreateWindow(NM_LINE,  TxTl(E_TTLLIN),styleLn, 0,   0,   0, 0,  fm[id].hWnd);
	ln[id].hPd[0]   = a_CreateWindow(NM_LINEPD,NULL,          stylePd1,8,   8,   w, 224,ln[id].hWnd);
	ln[id].hPd[1]   = a_CreateWindow(NM_LINEPD,NULL,          stylePd2,0,   0,   0, 0,  ln[id].hWnd);
	ln[id].hEdit[0] = a_CreateWindow(L"Edit",  L"0",          styleEd, 91,  y[0],65,17, ln[id].hPd[0]);
	ln[id].hEdit[1] = a_CreateWindow(L"Edit",  L"0",          styleEd, 91,  y[1],65,17, ln[id].hPd[0]);
	ln[id].hEdit[2] = a_CreateWindow(L"Edit",  L"0",          styleEd, 91,  y[2],65,17, ln[id].hPd[0]);
	ln[id].hEdit[3] = a_CreateWindow(L"Edit",  L"0",          styleEd, 91,  y[3],65,17, ln[id].hPd[0]);
	ln[id].hEdit[4] = a_CreateWindow(L"Edit",  strRgb,        styleEd, 91,  y[4],65,17, ln[id].hPd[0]);
	ln[id].hEdit[5] = a_CreateWindow(L"Edit",  strThick,      styleEd, 91,  y[5],65,17, ln[id].hPd[0]);
	ln[id].hChk [0] = a_CreateWindow(L"Button",L"",           styleCk, 164, 75,  13,13, ln[id].hPd[0]);
	ln[id].hChk [1] = a_CreateWindow(L"Button",L"",           styleCk, 164, 105, 13,13, ln[id].hPd[0]);
	ln[id].hRgb     = a_CreateWindow(NM_RGBBOX,NULL,          styleRb, 162, 133, 16,16, ln[id].hPd[0]);
	ln[id].hBtn[0]  = a_CreateWindow(L"Button",TxEd(E_OK),    styleBt, 10,  191, 70,25, ln[id].hPd[0]);
	ln[id].hBtn[1]  = a_CreateWindow(L"Button",TxEd(E_CANCEL),styleBt, 90,  191, 70,25, ln[id].hPd[0]);
	ln[id].hBtn[2]  = a_CreateWindow(L"Button",TxEd(E_APPLY), styleBt, 170, 191, 70,25, ln[id].hPd[0]);
	ln[id].hCn      = a_CreateWindow(NM_LINECN,NULL,          styleCn, 0,   0,   0, 0,  ln[id].hPd[1]);
	ln[id].hPc      = a_CreateWindow(NM_LINEPC,NULL,          stylePc, 0,   0,   0, 0,  ln[id].hCn);
	
	SetWindowLong(ln[id].hWnd,     GWL_USERDATA, id);
	SetWindowLong(ln[id].hPd[0],   GWL_USERDATA, 0*100+id);
	SetWindowLong(ln[id].hPd[1],   GWL_USERDATA, 1*100+id);
	SetWindowLong(ln[id].hEdit[0], GWL_USERDATA, 0*100+id);
	SetWindowLong(ln[id].hEdit[1], GWL_USERDATA, 1*100+id);
	SetWindowLong(ln[id].hEdit[2], GWL_USERDATA, 2*100+id);
	SetWindowLong(ln[id].hEdit[3], GWL_USERDATA, 3*100+id);
	SetWindowLong(ln[id].hEdit[4], GWL_USERDATA, 4*100+id);
	SetWindowLong(ln[id].hEdit[5], GWL_USERDATA, 5*100+id);
	SetWindowLong(ln[id].hChk[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(ln[id].hChk[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(ln[id].hRgb,     GWL_USERDATA, id);
	SetWindowLong(ln[id].hBtn[0],  GWL_USERDATA, 0*100+id);
	SetWindowLong(ln[id].hBtn[1],  GWL_USERDATA, 1*100+id);
	SetWindowLong(ln[id].hBtn[2],  GWL_USERDATA, 2*100+id);
	SetWindowLong(ln[id].hPc,      GWL_USERDATA, id);
	
	SetWindowLong(ln[id].hWnd,   GWL_WNDPROC, (LONG)LnWndProc);
	SetWindowLong(ln[id].hPd[0], GWL_WNDPROC, (LONG)LnWndProcPd);
	SetWindowLong(ln[id].hPd[1], GWL_WNDPROC, (LONG)LnWndProcPd);
	SetWindowLong(ln[id].hRgb,   GWL_WNDPROC, (LONG)LnWndProcRgb);
	SetWindowLong(ln[id].hPc,    GWL_WNDPROC, (LONG)LnWndProcPc);
	
	E_SETLIMITTEXT(ln[id].hEdit[0], 5);
	E_SETLIMITTEXT(ln[id].hEdit[1], 5);
	E_SETLIMITTEXT(ln[id].hEdit[2], 5);
	E_SETLIMITTEXT(ln[id].hEdit[3], 5);
	E_SETLIMITTEXT(ln[id].hEdit[4], 6);
	E_SETLIMITTEXT(ln[id].hEdit[5], 2);
	
	E_SETFONT(ln[id].hEdit[0], hFtCourier);
	E_SETFONT(ln[id].hEdit[1], hFtCourier);
	E_SETFONT(ln[id].hEdit[2], hFtCourier);
	E_SETFONT(ln[id].hEdit[3], hFtCourier);
	E_SETFONT(ln[id].hEdit[4], hFtCourier);
	E_SETFONT(ln[id].hEdit[5], hFtCourier);
	B_SETFONT(ln[id].hBtn[0],  hFtArial14);
	B_SETFONT(ln[id].hBtn[1],  hFtArial14);
	B_SETFONT(ln[id].hBtn[2],  hFtArial14);
	
	ln[id].pCallEdit[0] = (CALLFUNC)GetWindowLong(ln[id].hEdit[0], GWL_WNDPROC);
	ln[id].pCallEdit[1] = (CALLFUNC)GetWindowLong(ln[id].hEdit[1], GWL_WNDPROC);
	ln[id].pCallEdit[2] = (CALLFUNC)GetWindowLong(ln[id].hEdit[2], GWL_WNDPROC);
	ln[id].pCallEdit[3] = (CALLFUNC)GetWindowLong(ln[id].hEdit[3], GWL_WNDPROC);
	ln[id].pCallEdit[4] = (CALLFUNC)GetWindowLong(ln[id].hEdit[4], GWL_WNDPROC);
	ln[id].pCallEdit[5] = (CALLFUNC)GetWindowLong(ln[id].hEdit[5], GWL_WNDPROC);
	ln[id].pCallChk[0]  = (CALLFUNC)GetWindowLong(ln[id].hChk[0],  GWL_WNDPROC);
	ln[id].pCallChk[1]  = (CALLFUNC)GetWindowLong(ln[id].hChk[1],  GWL_WNDPROC);
	ln[id].pCallBtn[0]  = (CALLFUNC)GetWindowLong(ln[id].hBtn[0],  GWL_WNDPROC);
	ln[id].pCallBtn[1]  = (CALLFUNC)GetWindowLong(ln[id].hBtn[1],  GWL_WNDPROC);
	ln[id].pCallBtn[2]  = (CALLFUNC)GetWindowLong(ln[id].hBtn[2],  GWL_WNDPROC);
	SetWindowLong(ln[id].hEdit[0], GWL_WNDPROC, (LONG)LnWndProcEditX1);
	SetWindowLong(ln[id].hEdit[1], GWL_WNDPROC, (LONG)LnWndProcEditY1);
	SetWindowLong(ln[id].hEdit[2], GWL_WNDPROC, (LONG)LnWndProcEditX2);
	SetWindowLong(ln[id].hEdit[3], GWL_WNDPROC, (LONG)LnWndProcEditY2);
	SetWindowLong(ln[id].hEdit[4], GWL_WNDPROC, (LONG)LnWndProcEditC);
	SetWindowLong(ln[id].hEdit[5], GWL_WNDPROC, (LONG)LnWndProcEditT);
	SetWindowLong(ln[id].hChk[0],  GWL_WNDPROC, (LONG)LnWndProcChkX2);
	SetWindowLong(ln[id].hChk[1],  GWL_WNDPROC, (LONG)LnWndProcChkY2);
	SetWindowLong(ln[id].hBtn[0],  GWL_WNDPROC, (LONG)LnWndProcBtnOk);
	SetWindowLong(ln[id].hBtn[1],  GWL_WNDPROC, (LONG)LnWndProcBtnCan);
	SetWindowLong(ln[id].hBtn[2],  GWL_WNDPROC, (LONG)LnWndProcBtnApl);
	
	ln[id].tabStopIdx = 0;
	ln[id].tabStops[0]  = ln[id].hEdit[0];
	ln[id].tabStops[1]  = ln[id].hEdit[1];
	ln[id].tabStops[2]  = ln[id].hEdit[2];
	ln[id].tabStops[3]  = ln[id].hChk[0];
	ln[id].tabStops[4]  = ln[id].hEdit[3];
	ln[id].tabStops[5]  = ln[id].hChk[1];
	ln[id].tabStops[6]  = ln[id].hEdit[4];
	ln[id].tabStops[7]  = ln[id].hRgb;
	ln[id].tabStops[8]  = ln[id].hEdit[5];
	ln[id].tabStops[9]  = ln[id].hBtn[0];
	ln[id].tabStops[10] = ln[id].hBtn[1];
	ln[id].tabStops[11] = ln[id].hBtn[2];
	
	SetFocus  (ln[id].hEdit[0]);
	EditSelAll(ln[id].hEdit[0]);
	
	if (g_lnX2Fx == TRUE) {wp[0] = BST_UNCHECKED;} else {wp[0] = BST_CHECKED;}
	if (g_lnY2Fx == TRUE) {wp[1] = BST_UNCHECKED;} else {wp[1] = BST_CHECKED;}
	B_SETCHECK(ln[id].hChk[0], wp[0]);
	B_SETCHECK(ln[id].hChk[1], wp[1]);
}

/*------------------------------------------------------------------------------
    Fvoid LnDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void LnDialog(LONG id)
{
	LnInit(id);
	LnLoad(id);
	LnTmpCreate(id, fm[id].pc[0].img.w, fm[id].pc[0].img.h);
	LnInst(id);
	
	PpPlacement(id, ln[id].hWnd);
	
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = ln[id].hWnd;
	
	ShowWindow(ln[id].hPd[1], 0x1);
	ShowWindow(ln[id].hCn,    0x1);
	ShowWindow(ln[id].hPc,    0x1);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid LnLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void LnLoad(LONG id)
{
	ln[id].x2Fx = g_lnX2Fx;
	ln[id].y2Fx = g_lnY2Fx;
	ln[id].rgb  = g_lnRgb;
	ln[id].t    = g_lnThick;
}

/*------------------------------------------------------------------------------
    Fvoid LnStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void LnStore(LONG id)
{
	g_lnX2Fx  = ln[id].x2Fx;
	g_lnY2Fx  = ln[id].y2Fx;
	g_lnRgb   = ln[id].rgb;
	g_lnThick = ln[id].t;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProc(,,,)
    F-
    ߒlF-
    @\FLNCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_USER:  LnUpdate(id);  break;  // WMU_RGBEND
	case WM_SIZE:           LnSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  LnGetMinMaxInfo(id, wp, lp);  break;
	case WM_SETFOCUS:       LnSetFocus     (id, wp, lp);  break;
	case WM_CLOSE:          LnClose        (id, wp, lp);  break;
	case WM_DESTROY:        LnDestroy      (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcPd(,,,)
    F-
    ߒlF-
    @\FPDCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcPd(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idP;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idP = tmp / 100;
	
	switch (msg) {
	case WM_COMMAND:
		if (idP == 0) {
			LnPdCommand(id, wp, lp);
		}
		break;
	case WM_PAINT:
		if (idP == 0) {
			LnPdPaint(id, wp, lp);
		}
		break;
	case WM_CTLCOLORSTATIC:
		if (((HWND)lp == ln[id].hChk[0]) ||
			((HWND)lp == ln[id].hChk[1])) {return (LRESULT)hBrWhite;}
		break;
	default:  break;
	}
	
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcEditX1(,,,)
    F-
    ߒlF-
    @\FEDIT X1Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcEditX1(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   LnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  LnEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		LnKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (LnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	case WM_KEYUP:  LnKeyUp(id, wp, lp);  break;
	default: break;
	}
	
	return ln[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcEditY1(,,,)
    F-
    ߒlF-
    @\FEDIT Y1Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcEditY1(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   LnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  LnEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		LnKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (LnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	case WM_KEYUP:  LnKeyUp(id, wp, lp);  break;
	default: break;
	}
	
	return ln[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcEditX2(,,,)
    F-
    ߒlF-
    @\FEDIT X2Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcEditX2(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   LnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  LnEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		LnKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (LnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	case WM_KEYUP:  LnKeyUp(id, wp, lp);  break;
	default: break;
	}
	
	return ln[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcEditY2(,,,)
    F-
    ߒlF-
    @\FEDIT Y2Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcEditY2(HWND hWnd,UINT msg,WPARAM wp,LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   LnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  LnEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		LnKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (LnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	case WM_KEYUP:  LnKeyUp(id, wp, lp);  break;
	default: break;
	}
	
	return ln[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcEditC(,,,)
    F-
    ߒlF-
    @\FEDIT COLORCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcEditC(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   LnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  LnEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:    LnKeyDown    (id, wp, lp, hWnd);  break;
	case WM_CHAR:
		if (LnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	case WM_KEYUP:  LnKeyUp(id, wp, lp);  break;
	default:  break;
	}
	
	return ln[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcEditT(,,,)
    F-
    ߒlF-
    @\FEDIT THICKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcEditT(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idE;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idE = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:   LnEdSetFocus (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:  LnEdKillFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:
		LnKeyDown(id, wp, lp, hWnd);
		if (wp == KEY_UP) {return 0;}
		if (wp == KEY_DW) {return 0;}
		break;
	case WM_CHAR:
		if (LnEdChar(id, wp, lp, hWnd) == FALSE) {return 0;}
		break;
	case WM_KEYUP:  LnKeyUp(id, wp, lp);  break;
	default:  break;
	}
	
	return ln[id].pCallEdit[idE](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcChkX2(,,,)
    F-
    ߒlF-
    @\FCHECK X2Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcChkX2(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  LnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   LnKeyDown   (id, wp, lp, hWnd);  break;
	case WM_KEYUP:     LnKeyUp     (id, wp, lp);        break;
	default:  break;
	}
	
	res = ln[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  LnChSetCheck(id, idC, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcChkY2(,,,)
    F-
    ߒlF-
    @\FCHECK Y2Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcChkY2(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LRESULT res;
	LONG tmp;
	LONG id;
	LONG idC;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idC = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  LnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   LnKeyDown   (id, wp, lp, hWnd);  break;
	case WM_KEYUP:     LnKeyUp     (id, wp, lp);        break;
	default:  break;
	}
	
	res = ln[id].pCallChk[idC](hWnd, msg, wp, lp);
	
	switch (msg) {
	case BM_SETCHECK:  LnChSetCheck(id, idC, wp, lp);  break;
	default: break;
	}
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcRgb(,,,)
    F-
    ߒlF-
    @\FRGB F  Cxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcRgb(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        LnRbPaint      (id, wp, lp, hWnd);  break;
	case WM_SETFOCUS:     LnRbSetFocus   (id, wp, lp, hWnd);  break;
	case WM_KILLFOCUS:    LnRbKillFocus  (id, wp, lp, hWnd);  break;
	case WM_LBUTTONDOWN:  LnRbLButtonDown(id, wp, lp, hWnd);  break;
	case WM_LBUTTONUP:    LnRbLButtonUp  (id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:      LnKeyDown      (id, wp, lp, hWnd);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcBtnOk(,,,)
    F-
    ߒlF-
    @\FBTN OKCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcBtnOk(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  LnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   LnKeyDown   (id, wp, lp, hWnd);  break;
	case WM_KEYUP:     LnKeyUp     (id, wp, lp);        break;
	default: break;
	}
	return ln[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcBtnCan(,,,)
    F-
    ߒlF-
    @\FBTN CANCELCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcBtnCan(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  LnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   LnKeyDown   (id, wp, lp, hWnd);  break;
	case WM_KEYUP:     LnKeyUp     (id, wp, lp);        break;
	default: break;
	}
	return ln[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcBtnApl(,,,)
    F-
    ߒlF-
    @\FBTN APPLYCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcBtnApl(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG tmp;
	LONG id;
	LONG idB;
	
	tmp = GetWindowLong(hWnd, GWL_USERDATA);
	id  = tmp % 100;
	idB = tmp / 100;
	
	switch (msg) {
	case WM_SETFOCUS:  LnEdSetFocus(id, wp, lp, hWnd);  break;
	case WM_KEYDOWN:   LnKeyDown   (id, wp, lp, hWnd);  break;
	case WM_KEYUP:     LnKeyUp     (id, wp, lp);        break;
	default: break;
	}
	return ln[id].pCallBtn[idB](hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LnWndProcPc(,,,)
    F-
    ߒlF-
    @\FPCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LnWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:        LnPcPaint      (id, wp, lp);  break;
	case WM_MOUSEMOVE:    LnPcMouseMove  (id, wp, lp);  break;
	case WM_LBUTTONDOWN:  LnPcLButtonDown(id, wp, lp);  break;
	case WM_LBUTTONUP:    LnPcLButtonUp  (id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid LnSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SIZECxg
------------------------------------------------------------------------------*/
void LnSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	if (fm[id].cntSkipEdit != 0) {fm[id].cntSkipEdit--;  return;}
	
	GetClientRect(ln[id].hWnd, &rc);
	a_SetWindowPos(ln[id].hPd[1], SZ_WEDIT3, PADD8, rc.right-SZ_WEDIT3-PADD8, rc.bottom-PADD8*2);
	
	LnSetPane(id);
	LnImageView(id);
	
	a_SetWindowPos(ln[id].hPc, ln[id].pc.x, ln[id].pc.y,
								   ln[id].pc.w, ln[id].pc.h);
	
	InvalidateRect(ln[id].hWnd,   NULL, TRUE);
	InvalidateRect(ln[id].hPd[1], NULL, TRUE);
	InvalidateRect(ln[id].hCn,    NULL, TRUE);
	InvalidateRect(ln[id].hPc,    NULL, FALSE);
	UpdateWindow(ln[id].hWnd);
	UpdateWindow(ln[id].hPd[1]);
	UpdateWindow(ln[id].hCn);
	UpdateWindow(ln[id].hPc);
}

/*------------------------------------------------------------------------------
    Fvoid LnGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void LnGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	INT32 w;
	INT32 h;
	
	w = SZ_WEDIT3+PADD8*3+GetSystemMetrics(SM_CYSIZEFRAME)*2;
	h = 224      +PADD8*2+GetSystemMetrics(SM_CYSIZEFRAME)*2+GetSystemMetrics(SM_CYCAPTION);
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = w;
	mmi->ptMinTrackSize.y = h;
}

/*------------------------------------------------------------------------------
    Fvoid LnSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void LnSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(ln[id].tabStops[ln[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid LnKeyDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void LnKeyDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	switch (wp) {
	case KEY_ENTER:  LnKeyDownEnter(id, wp, lp, hWnd);  break;
	case KEY_ESC:    LnKeyDownEsc  (id, wp, lp, hWnd);  break;
	case KEY_TAB:    LnKeyDownTab  (id, wp, lp, hWnd);  break;
	case KEY_SP:     LnKeyDownSpace(id, wp, lp, hWnd);  break;
	case KEY_F5:     LnKeyDownF5   (id, wp, lp, hWnd);  break;
	case KEY_SHIFT:  LnKeyDownShift(id, wp, lp, hWnd);  break;
	case KEY_UP:
	case KEY_DW:     LnKeyDownUpDw (id, wp, lp, hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid LnKeyDownEnter(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[enter]L[Cxg
------------------------------------------------------------------------------*/
void LnKeyDownEnter(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if      (hWnd == ln[id].hBtn[1]) {LnEnterCan(id);}
	else if (hWnd == ln[id].hBtn[2]) {LnEnterApl(id);}
	else                             {LnEnterOk(id);}
}

/*------------------------------------------------------------------------------
    Fvoid LnKeyDownEsc(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[esc]L[Cxg
------------------------------------------------------------------------------*/
void LnKeyDownEsc(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	CLOSE(ln[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LnKeyDownTab(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[tab]L[Cxg
------------------------------------------------------------------------------*/
void LnKeyDownTab(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	BOOL shift;
	
	if ((GetKeyState(KEY_SHIFT) & 0x80) != 0) {shift = TRUE;}
	else                                      {shift = FALSE;}
	
	do {
		if (shift == TRUE) {
			if (ln[id].tabStopIdx == 0) {ln[id].tabStopIdx = TBSP_LINE-1;}
			else                        {ln[id].tabStopIdx--;}
		}
		else {
			ln[id].tabStopIdx = (ln[id].tabStopIdx + 1) % TBSP_LINE;
		}
	} while (IsWindowEnabled(ln[id].tabStops[ln[id].tabStopIdx]) == FALSE);
	
	SetFocus(ln[id].tabStops[ln[id].tabStopIdx]);
}

/*------------------------------------------------------------------------------
    Fvoid LnKeyDownSpace(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[space]L[Cxg
------------------------------------------------------------------------------*/
void LnKeyDownSpace(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (hWnd != ln[id].hRgb) {return;}
	
	GetWindowText(ln[id].hEdit[4], buffRgb, 6+1);
	RbDialog(id, buffRgb, ln[id].hWnd, ln[id].hEdit[4], ln[id].hRgb);
}

/*------------------------------------------------------------------------------
    Fvoid LnKeyDownF5(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[F5]L[Cxg
------------------------------------------------------------------------------*/
void LnKeyDownF5(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	LnUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid LnKeyDownShift(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[shift]L[Cxg
------------------------------------------------------------------------------*/
void LnKeyDownShift(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	POINT pt;
	
	if (ln[id].pc.flgShift == FALSE) {
		ln[id].pc.flgShift = TRUE;
		
		if (ln[id].pc.flgClick == TRUE) {
			GetCursorPos(&pt);
			ScreenToClient(ln[id].hPc, &pt);
			LnMouse(id, pt.x, pt.y);
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid LnKeyDownUpDw(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\F[][]L[Cxg
------------------------------------------------------------------------------*/
void LnKeyDownUpDw(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT16 tmp;
	UINT16 comb;
	BOOL shift;
	INT32 step;
	WCHAR text[5+1];
	INT32 val;
	INT32 limL;
	INT32 limH;
	
	comb  = 0x000;
	shift = FALSE;
	tmp = GetKeyState(KEY_CTRL);   if((tmp & 0x80)!=0){comb |= 0x100;}
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){comb |= 0x010;  shift = TRUE;}
	
	if ((hWnd != ln[id].hEdit[0]) &&
		(hWnd != ln[id].hEdit[1]) &&
		(hWnd != ln[id].hEdit[2]) &&
		(hWnd != ln[id].hEdit[3]) &&
		(hWnd != ln[id].hEdit[5]))
	{
		return;
	}
	
	if      (comb == 0x000) {step = 1;}
	else if (comb == 0x100) {step = 10;}
	else if (comb == 0x010) {step = 100;}
	else                    {return;}
	
	GetWindowText(hWnd, text, 5+1);
	val = _wtoi(text);
	
	if (hWnd == ln[id].hEdit[5]) {limL = 0;      limH = 99;}
	else                             {limL = -9999;  limH = 9999;}
	
	if (wp == KEY_UP) {val += step;}
	else              {val -= step;}
	
	if (val < limL) {val = limL;}
	if (limH < val) {val = limH;}
	
	_itow(val, text, 10);
	SetWindowText(hWnd, text);
	EditSelAll(hWnd);
	
	LnUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid LnKeyUp(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_KEYUPCxg
------------------------------------------------------------------------------*/
void LnKeyUp(LONG id, WPARAM wp, LPARAM lp)
{
	POINT pt;
	
	switch (wp) {
	case KEY_SHIFT:
		if (ln[id].pc.flgShift == TRUE) {
			if (ln[id].pc.flgClick == TRUE) {
				GetCursorPos(&pt);
				ScreenToClient(ln[id].hPc, &pt);
				LnMouse(id, pt.x, pt.y);
			}
		}
		ln[id].pc.flgShift = FALSE;
		break;
	default:
		break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid LnClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_CLOSECxg
------------------------------------------------------------------------------*/
void LnClose(LONG id, WPARAM wp, LPARAM lp)
{
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LnDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_DESTROYCxg
------------------------------------------------------------------------------*/
void LnDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	LnTmpDelete(id);
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid LnPdCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FWM_COMMANDCxg
------------------------------------------------------------------------------*/
void LnPdCommand(LONG id, WPARAM wp, LPARAM lp)
{
	WCHAR text[5+1];
	INT32 checked;
	HWND hWnd;
	
	hWnd = (HWND)lp;
	
	if (hWnd == ln[id].hBtn[0]) {
		if (HIWORD(wp) != BN_CLICKED) {return;}
		LnEnterOk(id);
	}
	else if (hWnd == ln[id].hBtn[1]) {
		if (HIWORD(wp) != BN_CLICKED) {return;}
		LnEnterCan(id);
	}
	else if (hWnd == ln[id].hBtn[2]) {
		if (HIWORD(wp) != BN_CLICKED) {return;}
		LnEnterApl(id);
	}
	else if (hWnd == ln[id].hEdit[0]) {
		if (HIWORD(wp) != EN_CHANGE) {return;}
		
		checked = B_GETCHECK(ln[id].hChk[0]);
		if (checked == BST_CHECKED) {
			GetWindowText(ln[id].hEdit[0], text, 5+1);
			SetWindowText(ln[id].hEdit[2], text);
		}
	}
	else if (hWnd == ln[id].hEdit[1]) {
		if (HIWORD(wp) != EN_CHANGE) {return;}
		
		checked = B_GETCHECK(ln[id].hChk[1]);
		if (checked == BST_CHECKED) {
			GetWindowText(ln[id].hEdit[1], text, 5+1);
			SetWindowText(ln[id].hEdit[3], text);
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid LnPdPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPD WM_PAINTCxg
------------------------------------------------------------------------------*/
void LnPdPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1;
	INT32 x2, y2;
	
	hdc = BeginPaint(ln[id].hPd[0], &ps);
	GetClientRect(ln[id].hPd[0], &rc);
	SetClipRgn(hdc, &rc);
	
	SelectObject(hdc, hFtArial14);
	
	SetBkMode(hdc, TRANSPARENT);
	SetTextColor(hdc, RGB_DPGRAY);
	
	a_TextOut(hdc, 61,  13, L"X1");
	a_TextOut(hdc, 61,  43, L"Y1");
	a_TextOut(hdc, 61,  73, L"X2");
	a_TextOut(hdc, 61, 103, L"Y2");
	
	switch (g_idxLang) {
	case 0:
		x1 = 61;
		x2 = 57;
		break;
	case 1:
		x1 = 55;
		x2 = 55;
		break;
	default: break;
	}
	y1 = 133;
	y2 = 163;
	a_TextOut(hdc, x1, y1, TxEd(E_LNCOLOR));
	a_TextOut(hdc, x2, y2, TxEd(E_LNTHICK));
	
	SelectClipRgn(hdc, NULL);
	EndPaint(ln[id].hPd[0], &ps);
}

/*------------------------------------------------------------------------------
    Fvoid LnEdSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void LnEdSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_LINE; i++) {
		if (hWnd == ln[id].tabStops[i]) {
			ln[id].tabStopIdx = i;
		}
	}
	
	EditSelAll(hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LnEdKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FWM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void LnEdKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	
	for (i = 0; i < TBSP_LINE; i++) {
		if ((HWND)wp == ln[id].tabStops[i]) {
			LnUpdate(id);
			break;
		}
	}
}

/*------------------------------------------------------------------------------
    FBOOL LnEdChar(LONG, WPARAM, LPARAM, HWND )
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    ߒlFBOOL    -
    @\FWM_CHARCxg
------------------------------------------------------------------------------*/
BOOL LnEdChar(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	if ((hWnd == ln[id].hEdit[0]) ||
		(hWnd == ln[id].hEdit[1]) ||
		(hWnd == ln[id].hEdit[2]) ||
		(hWnd == ln[id].hEdit[3]) ||
		(hWnd == ln[id].hEdit[5]))
	{
		if ((0x30 <= wp) && (wp <= 0x39)) {return TRUE;}	// 0-9
	}
	else if (hWnd == ln[id].hEdit[4])
	{
		if (((0x30 <= wp) && (wp <= 0x39)) ||  // 0-9
			((0x41 <= wp) && (wp <= 0x46)) ||  // a-f
			((0x61 <= wp) && (wp <= 0x66)))    // A-F
		{
			return TRUE;
		}
	}
	
	switch (wp) {
	case 0x03:  // ctrl+C
	case 0x08:  // back space
	case 0x16:  // ctrl+V
		return TRUE;
	default:
		return FALSE;
	}
}

/*------------------------------------------------------------------------------
    Fvoid LnChSetCheck(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          LONG    CHK  ID
          WPARAM  -
          LPARAM  -
    @\FRECT CHECK BM_SETCHECKCxg
------------------------------------------------------------------------------*/
void LnChSetCheck(LONG id, LONG idC, WPARAM wp, LPARAM lp)
{
	INT32 checked;
	BOOL enable;
	WCHAR text[5+1];
	
	checked = B_GETCHECK(ln[id].hChk[idC]);
	
	if (checked == BST_CHECKED) {enable = FALSE;}
	else                        {enable = TRUE;}
	
	EnableWindow(ln[id].hEdit[idC+2], enable);
	
	if (checked == BST_CHECKED) {
		GetWindowText(ln[id].hEdit[idC],   text, 5+1);
		SetWindowText(ln[id].hEdit[idC+2], text);
	}
	LnUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid LnRbPaint(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_PAINTCxg
------------------------------------------------------------------------------*/
void LnRbPaint(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	RbBoxPaint(id, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LnRbSetFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void LnRbSetFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_LINE; i++) {
		if ((HWND)wp == ln[id].tabStops[i]) {
			res = TRUE;
		}
	}
	
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow(hWnd);
	}
	
	LnEdSetFocus(id, wp, lp, hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LnRbKillFocus(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_KILLFOCUSCxg
------------------------------------------------------------------------------*/
void LnRbKillFocus(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	INT32 i;
	BOOL res;
	
	res = FALSE;
	for (i = 0; i < TBSP_LINE; i++) {
		if ((HWND)wp == ln[id].tabStops[i]) {
			res = TRUE;
		}
	}
	if (res == TRUE) {
		InvalidateRect(hWnd, NULL, TRUE);
		UpdateWindow(hWnd);
	}
}

/*------------------------------------------------------------------------------
    Fvoid LnRbLButtonDown(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void LnRbLButtonDown(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	ln[id].flgClick = TRUE;
}

/*------------------------------------------------------------------------------
    Fvoid LnRbLButtonUp(LONG, WPARAM, LPARAM, HWND)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
          HWND    -
    @\FRGBBOX WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void LnRbLButtonUp(LONG id, WPARAM wp, LPARAM lp, HWND hWnd)
{
	WCHAR buffRgb[6+1];
	
	if (ln[id].flgClick == FALSE) {return;}
	ln[id].flgClick = FALSE;
	SetFocus(hWnd);
	
	GetWindowText(ln[id].hEdit[4], buffRgb, 6+1);
	RbDialog(id, buffRgb, ln[id].hWnd, ln[id].hEdit[4], ln[id].hRgb);
}

/*------------------------------------------------------------------------------
    Fvoid LnPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_PAINTCxg
------------------------------------------------------------------------------*/
void LnPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	INT32 mode;
	
	hdc = BeginPaint(ln[id].hPc, &ps);
	GetClientRect(ln[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	
	x2 = 0;
	y2 = 0;
	w2 = ln[id].pc.w;
	h2 = ln[id].pc.h;
	x1 = 0;
	y1 = 0;
	w1 = fm[id].pc[0].img.w;
	h1 = fm[id].pc[0].img.h;
	
	if (ln[id].pc.percent < 10000) {mode = HALFTONE;}
	else                              {mode = COLORONCOLOR;}
	
	memcpy(ln[id].pc.tmp.pB, fm[id].pc[0].img.pB, w1 * h1 * 4);
	
	LnTmpDraw(id);
	
	SetStretchBltMode(hdc, mode);
	StretchBlt(hdc,                  x2, y2, w2, h2,
			   ln[id].pc.tmp.hdc, x1, y1, w1, h1, SRCCOPY);
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = w2;
	rc.bottom = h2;
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(ln[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid LnPcMouseMove(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_MOUSEMOVECxg
------------------------------------------------------------------------------*/
void LnPcMouseMove(LONG id, WPARAM wp, LPARAM lp)
{
	INT16 x, y;
	
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	if ((wp & MK_LBUTTON) != 0) {LnMouse(id, x, y);}
	else                        {LnSetCursor(id, x, y);}
}

/*------------------------------------------------------------------------------
    Fvoid LnPcLButtonDown(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_LBUTTONDOWNCxg
------------------------------------------------------------------------------*/
void LnPcLButtonDown(LONG id, WPARAM wp, LPARAM lp)
{
	INT32 x, y;
	INT32 x1, y1, x2, y2;
	INT32 x1L, x1H;
	INT32 y1L, y1H;
	INT32 x2L, x2H;
	INT32 y2L, y2H;
	INT32 xSrc;
	INT32 ySrc;
	INT32 xDst;
	INT32 yDst;
	WCHAR buff[4][10+1];
	
	x = LOWORD(lp);
	y = HIWORD(lp);
	
	SetCapture(ln[id].hPc);
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(ln[id].pc.x1     * ln[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(ln[id].pc.y1     * ln[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((ln[id].pc.x2+1) * ln[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((ln[id].pc.y2+1) * ln[id].pc.h) / fm[id].pc[0].img.h;
	x1L = x1-5;    x1H = x1+5;
	y1L = y1-5;    y1H = y1+5;
	x2L = x2-5;    x2H = x2+5;
	y2L = y2-5;    y2H = y2+5;
	
	ln[id].pc.flgsBorder = 0;
	if ((x1L<x) && (x<x1H) && (y1L<y) && (y<y1H)) {
		ln[id].pc.flgsBorder = BIT_XY1;
	}
	
	if ((x2L<x) && (x<x2H) && (y2L<y) && (y<y2H)) {
		ln[id].pc.flgsBorder = BIT_XY2;
	}
	
	if(ln[id].pc.flgsBorder != 0x00000000) {
		ln[id].pc.flgClick = TRUE;
		LnSetCursor(id, x, y);
	}
	else {
		xSrc = (double)(x * fm[id].pc[0].img.w) / ln[id].pc.w;
		ySrc = (double)(y * fm[id].pc[0].img.h) / ln[id].pc.h;
		xDst = xSrc + (ln[id].pc.x2 - ln[id].pc.x1);
		yDst = ySrc + (ln[id].pc.y2 - ln[id].pc.y1);
		
		_itow(xSrc, buff[0], 10);
		_itow(ySrc, buff[1], 10);
		_itow(xDst, buff[2], 10);
		_itow(yDst, buff[3], 10);
		SetWindowText(ln[id].hEdit[0], buff[0]);
		SetWindowText(ln[id].hEdit[1], buff[1]);
		SetWindowText(ln[id].hEdit[2], buff[2]);
		SetWindowText(ln[id].hEdit[3], buff[3]);
		
		LnUpdate(id);
	}
}

/*------------------------------------------------------------------------------
    Fvoid LnPcLButtonUp(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FPC WM_LBUTTONUPCxg
------------------------------------------------------------------------------*/
void LnPcLButtonUp(LONG id, WPARAM wp, LPARAM lp)
{
	ReleaseCapture();
	ln[id].pc.flgClick = FALSE;
}

/*------------------------------------------------------------------------------
    Fvoid LnEnterOk(LONG id)
    FLONG    FORM ID
    @\F[OK]{^s
------------------------------------------------------------------------------*/
void LnEnterOk(LONG id)
{
	WCHAR buffRgb[6+1];
	WCHAR buffT  [2+1];
	INT32 rgb;
	INT32 checked[2];
	
	LnUpdate(id);
	if (ln[id].flgUpdate == FALSE) {CLOSE(ln[id].hWnd);  return;}
	
	memcpy(fm[id].pc[0].img.pB, ln[id].pc.tmp.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
	LiImageDelete(id, 0);
	
	InvalidateRect(fm[id].hPict[0], NULL, TRUE);
	UpdateWindow(fm[id].hPict[0]);
	
	fm[id].flgLine = TRUE;
	SetFormText(id);
	MnFlushFile(id);
	
	GetWindowText(ln[id].hEdit[4], buffRgb, 6+1);
	GetWindowText(ln[id].hEdit[5], buffT,   2+1);
	
	rgb = _wtoh(buffRgb, 6);
	ln[id].rgb = rgb;
	ln[id].t   = _wtoi(buffT);
	
	checked[0] = B_GETCHECK(ln[id].hChk[0]);
	checked[1] = B_GETCHECK(ln[id].hChk[1]);
	if (checked[0] == BST_CHECKED) {ln[id].x2Fx = FALSE;} else {ln[id].x2Fx = TRUE;}
	if (checked[1] == BST_CHECKED) {ln[id].y2Fx = FALSE;} else {ln[id].y2Fx = TRUE;}
	
	LnStore(id);
	CLOSE(ln[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LnEnterCan(LONG id)
    FLONG    FORM ID
    @\F[CANCEL]{^s
------------------------------------------------------------------------------*/
void LnEnterCan(LONG id)
{
	CLOSE(ln[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LnEnterApl(LONG id)
    FLONG    FORM ID
    @\F[APPLY]{^s
------------------------------------------------------------------------------*/
void LnEnterApl(LONG id)
{
	WCHAR fmt[100] = L"%d\r\n"
					 L"%d\r\n"
					 L"%d\r\n"
					 L"%d\r\n"
					 L"%s\r\n"
					 L"%s\r\n"
					 L"%s\r\n"
					 L"%d\r\n";
	WCHAR str[100];
	WCHAR strX2 [5+1];
	WCHAR strY2 [5+1];
	WCHAR strRgb[6+1];
	
	LnUpdate(id);
	memcpy(fm[id].pc[0].img.pB, ln[id].pc.tmp.pB, fm[id].pc[0].img.w * fm[id].pc[0].img.h * 4);
	LiImageDelete(id, 0);
	
	InvalidateRect(fm[id].hPict[0], NULL, TRUE);
	UpdateWindow(fm[id].hPict[0]);
	
	fm[id].flgLine = TRUE;
	SetFormText(id);
	
	_btow(ln[id].x2Fx, strX2);
	_btow(ln[id].y2Fx, strY2);
	_rtow(ln[id].rgb,  strRgb);
	swprintf(str, fmt, ln[id].x1,
					   ln[id].y1,
					   ln[id].x2,
					   ln[id].y2,
					   strX2,
					   strY2,
					   strRgb,
					   ln[id].t);
	MessageBox(ln[id].hWnd, str, TxEd(E_APPLY), MB_OK);
}

/*------------------------------------------------------------------------------
    Fvoid LnUpdate(LONG id)
    FLONG    FORM ID
    @\F`̕\XV
------------------------------------------------------------------------------*/
void LnUpdate(LONG id)
{
	WCHAR lnEditX1 [5+1];
	WCHAR lnEditY1 [5+1];
	WCHAR lnEditX2 [5+1];
	WCHAR lnEditY2 [5+1];
	WCHAR lnEditRgb[6+1];
	WCHAR lnEditT  [2+1];
	INT32 x1;
	INT32 y1;
	INT32 x2;
	INT32 y2;
	INT32 rgb;
	INT32 t;
	INT32 checked[2];
	BOOL x2Fx;
	BOOL y2Fx;
	
	GetWindowText(ln[id].hEdit[0], lnEditX1,  5+1);
	GetWindowText(ln[id].hEdit[1], lnEditY1,  5+1);
	GetWindowText(ln[id].hEdit[2], lnEditX2,  5+1);
	GetWindowText(ln[id].hEdit[3], lnEditY2,  5+1);
	GetWindowText(ln[id].hEdit[4], lnEditRgb, 6+1);
	GetWindowText(ln[id].hEdit[5], lnEditT,   2+1);
	
	x1  = _wtoi(lnEditX1);
	y1  = _wtoi(lnEditY1);
	x2  = _wtoi(lnEditX2);
	y2  = _wtoi(lnEditY2);
	rgb = _wtoh(lnEditRgb, 6);
	t   = _wtoi(lnEditT);
	
	checked[0] = B_GETCHECK(ln[id].hChk[0]);
	checked[1] = B_GETCHECK(ln[id].hChk[1]);
	
	if (checked[0] == BST_CHECKED) {x2Fx = FALSE;} else {x2Fx = TRUE;}
	if (checked[1] == BST_CHECKED) {y2Fx = FALSE;} else {y2Fx = TRUE;}
	
	if ((x1   != ln[id].x1)   ||
		(y1   != ln[id].y1)   ||
		(x2   != ln[id].x2)   ||
		(y2   != ln[id].y2)   ||
		(rgb  != ln[id].rgb)  ||
		(t    != ln[id].t)    ||
		(x2Fx != ln[id].x2Fx) ||
		(y2Fx != ln[id].y2Fx))
	{
		InvalidateRect(ln[id].hPc, NULL, FALSE);
		UpdateWindow(ln[id].hPc);
		
		ln[id].flgUpdate = TRUE;
	}
	
	ln[id].x1   = x1;
	ln[id].y1   = y1;
	ln[id].x2   = x2;
	ln[id].y2   = y2;
	ln[id].rgb  = rgb;
	ln[id].t    = t;
	ln[id].x2Fx = x2Fx;
	ln[id].y2Fx = y2Fx;
	
	ln[id].pc.x1 = x1;
	ln[id].pc.y1 = y1;
	ln[id].pc.x2 = x2;
	ln[id].pc.y2 = y2;
}

/*------------------------------------------------------------------------------
    Fvoid LnTmpCreate(LONG, INT32, INT32)
    FLONG     FORM ID
          INT32    
          INT32    
    @\F ꎞC[W쐬
------------------------------------------------------------------------------*/
void LnTmpCreate(LONG id, INT32 w, INT32 h)
{
	ImageCreate(&ln[id].pc.tmp, w, h);
}

/*------------------------------------------------------------------------------
    Fvoid LnTmpDraw(LONG)
    FLONG     FORM ID
    @\F ꎞC[W`
------------------------------------------------------------------------------*/
void LnTmpDraw(LONG id)
{
	HDC hdc;
	WCHAR buffX1 [5+1];
	WCHAR buffY1 [5+1];
	WCHAR buffX2 [5+1];
	WCHAR buffY2 [5+1];
	WCHAR buffRgb[6+1];
	WCHAR buffT  [2+1];
	INT32 x1;
	INT32 y1;
	INT32 x2;
	INT32 y2;
	INT32 rgb;
	INT32 r, g, b;
	INT32 t;
	HPEN hPen;
	HPEN hPenOld;
	RECT rc;
	
	GetWindowText(ln[id].hEdit[0], buffX1,  5+1);
	GetWindowText(ln[id].hEdit[1], buffY1,  5+1);
	GetWindowText(ln[id].hEdit[2], buffX2,  5+1);
	GetWindowText(ln[id].hEdit[3], buffY2,  5+1);
	GetWindowText(ln[id].hEdit[4], buffRgb, 6+1);
	GetWindowText(ln[id].hEdit[5], buffT,   2+1);
	x1 = _wtoi(buffX1);
	y1 = _wtoi(buffY1);
	x2 = _wtoi(buffX2);
	y2 = _wtoi(buffY2);
	if ((x1 == 0) && (y1 == 0) && (x2 == 0) && (y2 == 0)) {return;}
	
	rgb = _wtoh(buffRgb, 6);
	r = (rgb & 0x00FF0000) >> 16;
	g = (rgb & 0x0000FF00) >> 8;
	b = (rgb & 0x000000FF) >> 0;
	
	t = _wtoi(buffT);
	
	hdc = ln[id].pc.tmp.hdc;
	
	rc.left   = 0;
	rc.top    = 0;
	rc.right  = ln[id].pc.tmp.w;
	rc.bottom = ln[id].pc.tmp.h;
	SetClipRgn(hdc, &rc);
	
	SetBkMode(hdc, TRANSPARENT);
	hPen = CreatePen(PS_SOLID, t, RGB(r,g,b));
	hPenOld = (HPEN)SelectObject(hdc, hPen);
	
	MoveToEx(hdc, x1, y1, NULL);
	LineTo  (hdc, x2, y2);
	
	SelectObject(hdc, hPenOld);
	DeleteObject(hPen);
	SelectClipRgn(hdc, NULL);
}

/*------------------------------------------------------------------------------
    Fvoid LnTmpDelete(LONG)
    FLONG     FORM ID
    @\F ꎞC[W폜
------------------------------------------------------------------------------*/
void LnTmpDelete(LONG id)
{
	DeleteDC    (ln[id].pc.tmp.hdc);
	DeleteObject(ln[id].pc.tmp.hBmp);
}

/*------------------------------------------------------------------------------
    Fvoid LnSetCursor(LONG id, INT32, INT32)
    FLONG    FORM ID
          INT32   XW
          INT32   YW
    @\F J[\ύX
------------------------------------------------------------------------------*/
void LnSetCursor(LONG id, INT32 x, INT32 y)
{
	INT32 x1, y1, x2, y2;
	INT32 x1L, x1H;
	INT32 y1L, y1H;
	INT32 x2L, x2H;
	INT32 y2L, y2H;
	HCURSOR hCur;
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	x1 = (double)(ln[id].pc.x1     * ln[id].pc.w) / fm[id].pc[0].img.w;
	y1 = (double)(ln[id].pc.y1     * ln[id].pc.h) / fm[id].pc[0].img.h;
	x2 = (double)((ln[id].pc.x2+1) * ln[id].pc.w) / fm[id].pc[0].img.w;
	y2 = (double)((ln[id].pc.y2+1) * ln[id].pc.h) / fm[id].pc[0].img.h;
	x1L = x1-5;    x1H = x1+5;
	y1L = y1-5;    y1H = y1+5;
	x2L = x2-5;    x2H = x2+5;
	y2L = y2-5;    y2H = y2+5;
	
	hCur = hCurArrow;
	if ((x1L<x) && (x<x1H) && (y1L<y) && (y<y1H)) {
		hCur = hCurSzAll;
	}
	
	if ((x2L<x) && (x<x2H) && (y2L<y) && (y<y2H)) {
		hCur = hCurSzAll;
	}
	
	SetCursor(hCur);
	SetClassLong(ln[id].hPc, GCL_HCURSOR, (LONG)hCur);
}

/*------------------------------------------------------------------------------
    Fvoid LnMouse(LONG id, INT32, INT32)
    FLONG    FORM ID
          INT32   XW
          INT32   YW
    @\F }EX
------------------------------------------------------------------------------*/
void LnMouse(LONG id, INT32 x, INT32 y)
{
	WCHAR text[4][5+1];
	INT16 tmp;
	BOOL shift;
	INT32 idxX;
	INT32 idxY;
	INT32 w;
	INT32 h;
	INT32 checked[2];
	
	if (ln[id].pc.flgClick == FALSE) {return;}
	if (ln[id].pc.flgsBorder == 0)   {return;}
	
	tmp = GetKeyState(KEY_SHIFT);  if((tmp & 0x80)!=0){shift = TRUE;}else{shift = FALSE;}
	
	if (ln[id].pc.flgsBorder == BIT_XY1) {
		TryZeroDivision(ln[id].pc.w);
		TryZeroDivision(ln[id].pc.h);
		x = (double)(x * fm[id].pc[0].img.w) / ln[id].pc.w;
		y = (double)(y * fm[id].pc[0].img.h) / ln[id].pc.h;
		
		if (shift == TRUE) {
			w = abs(ln[id].pc.x2 - x);
			h = abs(ln[id].pc.y2 - y);
			
			if (w < h) {x = ln[id].pc.x2;}
			else       {y = ln[id].pc.y2;}
		}
		
		idxX = 0;
		idxY = 1;
	}
	else {
		TryZeroDivision(ln[id].pc.w);
		TryZeroDivision(ln[id].pc.h);
		x = (double)(x * fm[id].pc[0].img.w) / ln[id].pc.w;
		y = (double)(y * fm[id].pc[0].img.h) / ln[id].pc.h;
		
		if (shift == TRUE) {
			w = abs(ln[id].pc.x1 - x);
			h = abs(ln[id].pc.y1 - y);
			
			if (w < h) {x = ln[id].pc.x1;}
			else       {y = ln[id].pc.y1;}
		}
		
		checked[0] = B_GETCHECK(ln[id].hChk[0]);
		checked[1] = B_GETCHECK(ln[id].hChk[1]);
		if (checked[0] == BST_UNCHECKED) {idxX = 2;} else {idxX = 0;}
		if (checked[1] == BST_UNCHECKED) {idxY = 3;} else {idxY = 1;}
	}
	
	_itow(x, text[idxX], 10);
	_itow(y, text[idxY], 10);
	SetWindowText(ln[id].hEdit[idxX], text[idxX]);
	SetWindowText(ln[id].hEdit[idxY], text[idxY]);
	UpdateWindow(ln[id].hEdit[0]);
	UpdateWindow(ln[id].hEdit[1]);
	UpdateWindow(ln[id].hEdit[2]);
	UpdateWindow(ln[id].hEdit[3]);
	
	LnUpdate(id);
}

/*------------------------------------------------------------------------------
    Fvoid LnImageView(LONG)
    FLONG    FORM ID
    @\F̕ҏW\p
------------------------------------------------------------------------------*/
void LnImageView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	if (IsBit(fm[id].pc[0].img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	TryZeroDivision(fm[id].pc[0].img.w);
	TryZeroDivision(fm[id].pc[0].img.h);
	gainW = (double)ln[id].cn.w / fm[id].pc[0].img.w;
	gainH = (double)ln[id].cn.h / fm[id].pc[0].img.h;
	
	if ((1 < gainW) && (1 < gainH)) {
		gainW = gainH = (double)1;
	}
	else {
		if (CmpGain(gainW, gainH) == TRUE) {
			limW = TRUE;
			limH = TRUE;
		}
		else {
			if (gainW < gainH) {
				gainH = gainW;
				limW = TRUE;
			}
			else {
				gainW = gainH;
				limH = TRUE;
			}
		}
	}
	
	x = (double)ln[id].cn.w / 2 - (double)fm[id].pc[0].img.w * gainW / 2;
	y = (double)ln[id].cn.h / 2 - (double)fm[id].pc[0].img.h * gainH / 2;
	w = (double)fm[id].pc[0].img.w * gainW;
	h = (double)fm[id].pc[0].img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = ln[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = ln[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(fm[id].pc[0].img.w);  ln[id].pc.percent = ((double)w / fm[id].pc[0].img.w) * 10000;}
	else              {TryZeroDivision(fm[id].pc[0].img.h);  ln[id].pc.percent = ((double)h / fm[id].pc[0].img.h) * 10000;}
	
	ln[id].pc.x = x;
	ln[id].pc.y = y;
	if (w <= 0) {ln[id].pc.w = 1;}
	else        {ln[id].pc.w = w;}
	if (h <= 0) {ln[id].pc.h = 1;}
	else        {ln[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid LnSetPane(LONG)
    FLONG    FORM ID
    @\F̕\̘g\
------------------------------------------------------------------------------*/
void LnSetPane(LONG id)
{
	RECT rc;
	INT32 w;
	INT32 h;
	
	GetClientRect(ln[id].hPd[1], &rc);
	w = rc.right - rc.left;
	h = rc.bottom - rc.top;
	a_SetWindowPos(ln[id].hCn, PADD8, PADD8, w-PADD8*2, h-PADD8*2);
	
	GetClientRect(ln[id].hCn, &rc);
	ln[id].cn.x = rc.left;
	ln[id].cn.y = rc.top;
	ln[id].cn.w = rc.right - rc.left;
	ln[id].cn.h = rc.bottom - rc.top;
}
