/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define LIST_CPP
#include "../common.h"

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 w;
	INT32 h;
	INT32 wMin;
	INT32 wBx;
	INT32 wCn;
	WCHAR pathD    [MAX_PATH];
	WCHAR pathDBack[MAX_PATH];
	WCHAR path     [MAX_PATH];
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;} cn;
	
	struct {INT32 x;
			INT32 y;
			INT32 w;
			INT32 h;
			st_Image img;
			UINT32 percent;
			WCHAR path[MAX_PATH];} pc;
	
	HWND hWnd;
	HWND hBx;
	HWND hCn;
	HWND hPc;
	
	LRESULT (CALLBACK *pCallBx) (HWND,UINT,WPARAM,LPARAM);
} lt[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void LtInitClass(void);
void LtInit(LONG);
void LtInst(LONG);
void LtDialog(LONG);
void LtLoad(LONG);
void LtStore(LONG);
LRESULT CALLBACK LtWndProc  (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LtWndProcBx(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK LtWndProcPc(HWND, UINT, WPARAM, LPARAM);
void LtCommand      (LONG, WPARAM, LPARAM);
void LtKeyDwon      (LONG, WPARAM, LPARAM);
void LtSize         (LONG, WPARAM, LPARAM);
void LtGetMinMaxInfo(LONG, WPARAM, LPARAM);
void LtClose        (LONG, WPARAM, LPARAM);
void LtDestroy      (LONG, WPARAM, LPARAM);
void LtBxSetFocus   (LONG, WPARAM, LPARAM);
void LtPcPaint      (LONG, WPARAM, LPARAM);
void         ThrLtStarting(LONG, WCHAR *);
void         ThrLtStart   (LONG, WCHAR *);
DWORD WINAPI ThrLtFunc    (LPVOID);
void         ThrLtEnd     (LONG);
void LtImageRead(LONG, st_Image *, WCHAR *);
BOOL LtImageReadGdi(LONG, st_Image *, WCHAR *);
void LtImageDraw(LONG, st_Image *, Bitmap *);
void LtImageThum(LONG, st_Image *);
void LtImageView(LONG);
void LtImageDelete(LONG);
void LtCreate(LONG);
void LtCreateLtBx(LONG);
void LtEnter(LONG);
void LtEnterFile(LONG, WCHAR *);
void LtEnterFolder(LONG);
void LtEnterRoot(LONG);
void LtDelete(LONG);
void LtGetText(LONG, WCHAR *);
BOOL LtGetItem(LONG);
void LtSetPane(LONG);

/*------------------------------------------------------------------------------
    Fvoid LtInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void LtInitClass(void)
{
	WNDCLASS wcList;
	WNDCLASS wcListCn;
	WNDCLASS wcListPc;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_LIST,  &wcList);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrWhite, NM_LISTCN,&wcListCn);
	InitWC(CS_OWNDC,DefWindowProc,NULL, hCurArrow,hBrNull,  NM_LISTPC,&wcListPc);
	
	RegisterClass(&wcList);
	RegisterClass(&wcListCn);
	RegisterClass(&wcListPc);
}

/*------------------------------------------------------------------------------
    Fvoid LtInit(LONG)
    FLONG    FORM ID
    @\Fꗗ
------------------------------------------------------------------------------*/
void LtInit(LONG id)
{
	lt[id].hWnd = NULL;
	
	lt[id].w     = 0;
	lt[id].h     = 0;
	lt[id].wMin  = 0;
	lt[id].wBx   = 0;
	lt[id].wCn   = 0;
	wmemset(lt[id].pathD,     0x0000, MAX_PATH);
	wmemset(lt[id].pathDBack, 0x0000, MAX_PATH);
	wmemset(lt[id].path,      0x0000, MAX_PATH);
	
	lt[id].cn.x = 0;
	lt[id].cn.y = 0;
	lt[id].cn.w = 0;
	lt[id].cn.h = 0;
	
	lt[id].pc.x = 0;
	lt[id].pc.y = 0;
	lt[id].pc.w = 0;
	lt[id].pc.h = 0;
	InitImg(&lt[id].pc.img);
	lt[id].pc.percent = 10000;
	wmemset(lt[id].pc.path, 0x0000, MAX_PATH);
	
	lt[id].hWnd = NULL;
	lt[id].hBx  = NULL;
	lt[id].hCn  = NULL;
	lt[id].hPc  = NULL;
	
	lt[id].pCallBx = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid LtInst(LONG)
    FLONG    FORM ID
    @\FLIST̉
------------------------------------------------------------------------------*/
void LtInst(LONG id)
{
	DWORD styleLt = WS_CAPTION|WS_THICKFRAME|WS_SYSMENU|WS_CLIPCHILDREN;
	DWORD styleLb = WS_CHILD|WS_VISIBLE|WS_VSCROLL|LBS_NOTIFY|
					LBS_DISABLENOSCROLL|LBS_WANTKEYBOARDINPUT;		// JNJNȂ LBS_NOINTEGRALHEIGHT
	DWORD styleCn = WS_CHILD|WS_VISIBLE|WS_CLIPCHILDREN;
	DWORD stylePc = WS_CHILD;
	
	lt[id].hWnd = a_CreateWindow(NM_LIST,   NULL,styleLt,0,0,0,0,fm[id].hWnd);
	lt[id].hBx  = a_CreateWindow(L"ListBox",NULL,styleLb,0,0,0,0,lt[id].hWnd);
	lt[id].hCn  = a_CreateWindow(NM_LISTCN, NULL,styleCn,0,0,0,0,lt[id].hWnd);
	lt[id].hPc  = a_CreateWindow(NM_LISTPC, NULL,stylePc,0,0,0,0,lt[id].hCn);
	
	SetWindowLong(lt[id].hWnd, GWL_USERDATA, id);
	SetWindowLong(lt[id].hBx,  GWL_USERDATA, id);
	SetWindowLong(lt[id].hPc,  GWL_USERDATA, id);
	
	SetWindowLong(lt[id].hWnd, GWL_WNDPROC, (LONG)LtWndProc);
	SetWindowLong(lt[id].hPc,  GWL_WNDPROC, (LONG)LtWndProcPc);
	
	lt[id].pCallBx = (CALLFUNC)GetWindowLong(lt[id].hBx, GWL_WNDPROC);
	SetWindowLong(lt[id].hBx, GWL_WNDPROC, (LONG)LtWndProcBx);
	
	L_SETFONT(lt[id].hBx, hFtArial16);
}

/*------------------------------------------------------------------------------
    Fvoid LtDialog(LONG)
    FLONG    FORM ID
    @\F_CAO
------------------------------------------------------------------------------*/
void LtDialog(LONG id)
{
	LtInit(id);
	LtLoad(id);
	InitThrLt(id);
	
	wcscpy(lt[id].pathD, fm[id].pathD);
	LtCreate(id);
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid LtLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void LtLoad(LONG id)
{
	lt[id].wBx = g_ltWBx;
	lt[id].wCn = g_ltWCn;
	lt[id].h   = g_ltH;
}

/*------------------------------------------------------------------------------
    Fvoid LtStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void LtStore(LONG id)
{
	g_ltWBx = lt[id].wBx;
	g_ltWCn = lt[id].wCn;
	g_ltH   = lt[id].h;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LtWndProc(,,,)
    F...      -
    ߒlFLRESULT  -
    @\FLISTCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LtWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_COMMAND:        LtCommand      (id, wp, lp);  break;
	case WM_KEYDOWN:        LtKeyDwon      (id, wp, lp);  break;
	case WM_SIZE:           LtSize         (id, wp, lp);  break;
	case WM_GETMINMAXINFO:  LtGetMinMaxInfo(id, wp, lp);  break;
	case WM_CLOSE:          LtClose        (id, wp, lp);  break;
	case WM_DESTROY:        LtDestroy      (id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LtWndProcBx(,,,)
    F...      -
    ߒlFLRESULT  -
    @\FLIST LISTBOXCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LtWndProcBx(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	LRESULT res;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SETFOCUS:  LtBxSetFocus(id, wp, lp);  break;
	default:  break;
	}
	res = lt[id].pCallBx(hWnd, msg, wp, lp);
	return res;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK LtWndProcPc(,,,)
    F...      -
    ߒlFLRESULT  -
    @\FLTPCCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK LtWndProcPc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_PAINT:  LtPcPaint(id, wp, lp);  break;
	default:  break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid LtCommand(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FLIST  WM_COMMANDCxg
------------------------------------------------------------------------------*/
void LtCommand(LONG id, WPARAM wp, LPARAM lp)
{
	WCHAR pathF[MAX_PATH];
	WCHAR path [MAX_PATH];
	
	if ((INT32)HIWORD(wp) == LBN_ERRSPACE) {	// ̂H
		MessageBox(lt[id].hWnd, L"list box limit", L_TITLE, MB_OK);
		exit(1);
	}
	
	switch (HIWORD(wp)) {
	case LBN_DBLCLK:
		LtEnter(id);
		break;
	case LBN_SELCHANGE:
		LtGetText(id, pathF);
		wcscpy(path, lt[id].pathD);
		wcscmb(path, pathF);
		ThrLtStarting(id, path);
		break;
	default:
		break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid LtKeyDwon(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FLIST  WM_KEYDOWNCxg
------------------------------------------------------------------------------*/
void LtKeyDwon(LONG id, WPARAM wp, LPARAM lp)
{
	switch (wp) {
	case KEY_ESC:
		LtImageDelete(id);
		CLOSE(lt[id].hWnd);
		break;
	case KEY_ENTER:
		LtEnter(id);
		break;
	case KEY_BKSP:
		if (wcslen(lt[id].pathD) == 0) {return;}
		
		if (PathIsNetworkPath(lt[id].pathD)) {
			if (!PathIsRoot(lt[id].pathD)) {
				wcscpy(lt[id].pathDBack, PathFindFileName(lt[id].pathD));
				PathRemoveFileSpec(lt[id].pathD);
				LtEnterFolder(id);
			}
		}
		else {
			if (PathIsRoot(lt[id].pathD)) {
				wcscpy(lt[id].pathDBack, PathFindFileName(lt[id].pathD));
				wmemset(lt[id].pathD, 0x0000, MAX_PATH);
				LtEnterRoot(id);
			}
			else {
				wcscpy(lt[id].pathDBack, PathFindFileName(lt[id].pathD));
				PathRemoveFileSpec(lt[id].pathD);
				LtEnterFolder(id);
			}
		}
		break;
	case KEY_UP:
	case KEY_DW:
	case KEY_RT:
	case KEY_LF:
	case KEY_PGUP:
	case KEY_PGDW:
	case KEY_HOME:
	case KEY_END:
		L_KEYDOWN(lt[id].hBx, wp);
		break;
	case KEY_M:  SysCmdMove(lt[id].hWnd);  break;
	case KEY_S:  SysCmdSize(lt[id].hWnd);  break;
	default: break;
	}
}

/*------------------------------------------------------------------------------
    Fvoid LtSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FLIST  WM_SIZECxg
------------------------------------------------------------------------------*/
void LtSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	INT32 w;
	INT32 h;
	INT32 xLtBx;
	INT32 wLtBx;
	INT32 xLtCn;
	INT32 wLtCn;
	
	if (fm[id].flgPv == FALSE) {
		GetClientRect(lt[id].hWnd, &rc);
		w = rc.right - rc.left - PADD5*2;
		h = rc.bottom - rc.top - PADD5*2;
		
		if ((w <= 0) || (h <= 0)) {
			a_SetWindowPos(lt[id].hBx, 0, 0, 0, 0);
		}
		else {
			a_SetWindowPos(lt[id].hBx, rc.left + PADD5, rc.top + PADD5, w, h);
		}
		InvalidateRect(lt[id].hBx,   NULL, TRUE);
		InvalidateRect(lt[id].hWnd, NULL, TRUE);
		UpdateWindow(lt[id].hBx);
	}
	else {
		GetClientRect(lt[id].hWnd, &rc);
		w = rc.right - rc.left;
		h = rc.bottom - rc.top - PADD8*2;
		
		xLtBx = rc.left + PADD8;
		wLtBx = lt[id].wBx;
		
		xLtCn = rc.left + lt[id].wBx + PADD8*2;
		wLtCn = w - (wLtBx + PADD8*3);
		
		if ((h <= 0) || (wLtBx <= 0)) {
			a_SetWindowPos(lt[id].hBx, 0, 0, 0, 0);
			a_SetWindowPos(lt[id].hCn, 0, 0, 0, 0);
			LtSetPane(id);
			a_SetWindowPos(lt[id].hPc, 0, 0, 0, 0);
		}
		else {
			a_SetWindowPos(lt[id].hBx, xLtBx, rc.top + PADD8, wLtBx, h);
			
			if (wLtCn <= 0) {
				a_SetWindowPos(lt[id].hCn, 0, 0, 0, 0);
			}
			else {
				a_SetWindowPos(lt[id].hCn, xLtCn, rc.top + PADD8, wLtCn, h);
			}
			
			LtSetPane(id);
			if (IsBit(lt[id].pc.img.stat, BIT_SUCCESS)) {
				LtImageView(id);
				a_SetWindowPos(lt[id].hPc, lt[id].pc.x, lt[id].pc.y, lt[id].pc.w, lt[id].pc.h);
			}
			else {
				a_SetWindowPos(lt[id].hPc, 0, 0, 0, 0);
			}
		}
		
		InvalidateRect(lt[id].hWnd, NULL, TRUE);
		InvalidateRect(lt[id].hBx,  NULL, TRUE);
		InvalidateRect(lt[id].hCn,  NULL, TRUE);
		InvalidateRect(lt[id].hPc,  NULL, FALSE);
		UpdateWindow(lt[id].hBx);
		UpdateWindow(lt[id].hCn);
		UpdateWindow(lt[id].hPc);
	}
}

/*------------------------------------------------------------------------------
    Fvoid LtGetMinMaxInfo(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FLIST WM_GETMINMAXINFOCxg
------------------------------------------------------------------------------*/
void LtGetMinMaxInfo(LONG id, WPARAM wp, LPARAM lp)
{
	MINMAXINFO *mmi;
	
	mmi = (MINMAXINFO *)lp;
	mmi->ptMinTrackSize.x = lt[id].wMin;
}

/*------------------------------------------------------------------------------
    Fvoid LtClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FLIST WM_CLOSECxg
------------------------------------------------------------------------------*/
void LtClose(LONG id, WPARAM wp, LPARAM lp)
{
	LinearDelete(id);
	LtImageDelete(id);
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
	
	lt[id].hWnd = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid LtDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FLIST  WM_DESTROYCxg
------------------------------------------------------------------------------*/
void LtDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid LtBxSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FLIST LISTBOX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void LtBxSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(lt[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid LtPcPaint(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FLISTTPC  WM_PAINTCxg
------------------------------------------------------------------------------*/
void LtPcPaint(LONG id, WPARAM wp, LPARAM lp)
{
	BOOL resBlt;
	HDC hdc;
	PAINTSTRUCT ps;
	RECT rc;
	INT32 x1, y1, w1, h1;
	INT32 x2, y2, w2, h2;
	
	if (!IsBit(lt[id].pc.img.stat, BIT_SUCCESS)) {return;}
	
	hdc = BeginPaint(lt[id].hPc, &ps);
	GetClientRect(lt[id].hPc, &rc);
	SetClipRgn(hdc, &rc);
	
	if (lt[id].pc.percent == 10000) {
		resBlt = BitBlt(hdc,               0, 0, lt[id].pc.w, lt[id].pc.h,
						lt[id].pc.img.hdc, 0, 0, SRCCOPY);
	}
	else {
		if (lt[id].pc.percent < 10000) {SetStretchBltMode(hdc, HALFTONE);}
		else                           {SetStretchBltMode(hdc, COLORONCOLOR);}
		
		x2 = 0;
		y2 = 0;
		w2 = lt[id].pc.w;
		h2 = lt[id].pc.h;
		x1 = 0;
		y1 = 0;
		w1 = lt[id].pc.img.w;
		h1 = lt[id].pc.img.h;
		
		resBlt = StretchBlt(hdc,               x2, y2, w2, h2,
							lt[id].pc.img.hdc, x1, y1, w1, h1, SRCCOPY);
	}
	if (resBlt == FALSE) {
		SetWindowText(fm[id].hWnd, L"blt error");
	}
	FrameRect(hdc, &rc, hBrGray);
	
	SelectClipRgn(hdc, NULL);
	EndPaint(lt[id].hPc, &ps);
}

/*------------------------------------------------------------------------------
    Fvoid ThrLtStarting(LONG, WCHAR *)
    FLONG     FORM ID
          WCHAR *  t@C
    @\Fvr[XbhJn
------------------------------------------------------------------------------*/
void ThrLtStarting(LONG id, WCHAR *path)
{
	wcscpy(lt[id].path, path);
	if (fm[id].flgPv == FALSE) {return;}
	
	if (fm[id].thrLt.busy == TRUE) {return;}
	else                           {ThrLtStart(id, path);}
}

/*------------------------------------------------------------------------------
    Fvoid ThrLtStart(LONG, WCHAR *)
    FLONG     FORM ID
          WCHAR *  t@C
    @\Fvr[XbhJn
------------------------------------------------------------------------------*/
void ThrLtStart(LONG id, WCHAR *path)
{
	if (wcscmp(lt[id].pc.path, path) == 0) {return;}
	
	if (pstThrLt[id] != NULL) {MessageBox(lt[id].hWnd, L"cannot create thr data", L_TITLE, MB_OK); return;}
	pstThrLt[id] = (st_ThrLt *)a_malloc(sizeof(st_ThrLt));
	
	wcscpy(pstThrLt[id]->path, path);
	InitImg(&pstThrLt[id]->img);
	
	fm[id].thrLt.busy = TRUE;
	CreateThread(NULL, 0, ThrLtFunc, fm[id].hWnd, 0, NULL);
}

/*------------------------------------------------------------------------------
    FDWORD WINAPI ThrLtFunc(LPVOID)
    FLPVOID  -
    ߒlFDWORD   -
    @\Fvr[Xbh֐
------------------------------------------------------------------------------*/
DWORD WINAPI ThrLtFunc(LPVOID lpvoid)
{
	HWND hWnd = (HWND)lpvoid;
	LONG id;
	
	id = ThrGetFormId(hWnd);
	
	ThrSetPrio(g_idxThrLt);
	
	LtImageRead(id, &pstThrLt[id]->img, pstThrLt[id]->path);
	P_USER(hWnd, WMU_THRLTEND, NULL);
	
	return 0;
}

/*------------------------------------------------------------------------------
    Fvoid ThrLtEnd(LONG)
    FLONG    FORM ID
    @\Fvr[XbhI
------------------------------------------------------------------------------*/
void ThrLtEnd(LONG id)
{
	st_Image *pThr = &pstThrLt[id]->img;
	st_Image *pImg = &lt[id].pc.img;
	
	if (lt[id].hWnd == NULL) {
		ImageDeleteSt(pThr);
		free(pstThrLt[id]);
		pstThrLt[id] = NULL;
		fm[id].thrLt.busy = FALSE;
		return;
	}
	
	wcscpy(lt[id].pc.path, pstThrLt[id]->path);
	
	// Ǐ](follow)  (one more)  \XVO
	if (wcscmp(lt[id].path, lt[id].pc.path) != 0) {
		ImageDeleteSt(pThr);
		free(pstThrLt[id]);
		pstThrLt[id] = NULL;
		ThrLtStart(id, lt[id].path);
		return;
	}
	
	if (!IsBit(pThr->stat, BIT_SUCCESS)) {
		ImageDeleteSt(pThr);
		LtImageDelete(id);
	}
	else {
		ImageReplace(pImg, pThr);
	}
	
	LtSetPane(id);
	LtImageView(id);
	a_SetWindowPos(lt[id].hPc, lt[id].pc.x,lt[id].pc.y,
								   lt[id].pc.w,lt[id].pc.h);
	
	InvalidateRect(lt[id].hCn, NULL, TRUE);
	InvalidateRect(lt[id].hPc, NULL, FALSE);
	UpdateWindow(lt[id].hCn);
	UpdateWindow(lt[id].hPc);
	
	free(pstThrLt[id]);
	pstThrLt[id]      = NULL;
	fm[id].thrLt.busy = FALSE;
}

/*------------------------------------------------------------------------------
    Fvoid LtImageRead(LONG, st_Image *)
    FLONG        FORM ID
          st_Image *  -
    @\Fvr[̉摜ǂݍ
------------------------------------------------------------------------------*/
void LtImageRead(LONG id, st_Image *pImg, WCHAR *path)
{
	BOOL res;
	INT32 fmt;
	
	fmt = IsImageFile(path);
	
	if (fmt == UNDEF) {
		res = FALSE;
	}
	else if ((fmt == BMP) && (g_idxBmp == 0)) {
		res = BmImageRead(pImg, path);
	}
	else if (fmt == ICO) {
		res = IcImageRead(pImg, path);
	}
	else {
		res = LtImageReadGdi(id, pImg, path);
	}
	
	if (res == TRUE) {
		LtImageThum(id, pImg);
		pImg->stat = BIT_SUCCESS;
	}
	else {
		pImg->stat = BIT_FAILURE;
	}
}

/*------------------------------------------------------------------------------
    FBOOL LtImageReadGdi(LONG, st_Image *, WCHAR *)
    FLONG        FORM ID
          st_Image *  -
          WCHAR *     pX
    ߒlFBOOL        -
    @\Fvr[̉摜GDI+œǂݍ
------------------------------------------------------------------------------*/
BOOL LtImageReadGdi(LONG id, st_Image *pImg, WCHAR *path)
{
	BOOL res;
	Bitmap *pBmp;
	
	pBmp = Gdiplus::Bitmap::FromFile(path);
	
	if((pBmp != NULL) && (pBmp->GetLastStatus() == Gdiplus::Ok) &&
	   (pBmp->GetWidth()  != 0) &&
	   (pBmp->GetHeight() != 0))
	{
		pImg->w = pBmp->GetWidth();
		pImg->h = pBmp->GetHeight();
		if ((pImg->w > MAX_IMGW) ||
			(pImg->h > MAX_IMGH))
		{
			delete pBmp;
			return FALSE;
		}
		LtImageDraw(id, pImg, pBmp);
		res = TRUE;
	}
	else {
		pImg->w = 0;
		pImg->h = 0;
		res = FALSE;
	}
	delete pBmp;
	return res;
}

/*------------------------------------------------------------------------------
    Fvoid LtImageDraw(LONG, st_Image *, Bitmap *)
    FLONG        FORM ID
          st_Image *  -
          Bitmap *    -
    @\Fvr[̏k摜ǂݍ
------------------------------------------------------------------------------*/
void LtImageDraw(LONG id, st_Image *pImg, Bitmap *pBmp)
{
	INT32 w;
	INT32 h;
	
	w = pImg->w;
	h = pImg->h;
	ImageCreate(pImg, w, h);
	
	Graphics graphics(pImg->hdc);
	graphics.DrawImage(pBmp, 0, 0, w, h);
	// oCgẑ܂܎擾łȂBRs[Ă܂BGetBitmapBits  GetDIBits
	// CreateDIBSectionō鎞
}

/*------------------------------------------------------------------------------
    Fvoid LtImageThum(LONG, st_Image *)
    FLONG         FORM ID
          st_Image *   -
    @\Fvr[̃TlC쐬
------------------------------------------------------------------------------*/
void LtImageThum(LONG id, st_Image *pImg)
{
	INT32 w;
	INT32 h;
	st_Image img;
	
	w = pImg->w;
	h = pImg->h;
	
	if ((BASE_W*4*BASE_H*4) <= (w*h)) {w /= 4;  h /= 4;}
	if ((BASE_W*2*BASE_H*2) <= (w*h)) {w /= 2;  h /= 2;}
	
	if (( BASE_W          * BASE_H)           <= (w*h)) {w /= 4;       h /= 4;}
	if (((BASE_W/1.41)    *(BASE_H/1.41))     <= (w*h)) {w /= 2*1.41;  h /= 2*1.41;}
	if (((BASE_W/2)       *(BASE_H/2))        <= (w*h)) {w /= 2;       h /= 2;}
	if (((BASE_W/(2*1.41))*(BASE_H/(2*1.41))) <= (w*h)) {w /= 1.41;    h /= 1.41;}
	
	ImageCreate(&img, w, h);
	
	SetStretchBltMode(img.hdc, HALFTONE);
	StretchBlt(img.hdc,   0, 0, w,       h,
			   pImg->hdc, 0, 0, pImg->w, pImg->h, SRCCOPY);
	
	DeleteObject(pImg->hBmp);
	DeleteDC    (pImg->hdc);
	pImg->hBmp = img.hBmp;
	pImg->hdc  = img.hdc;
	pImg->pB   = img.pB;
	pImg->w    = img.w;
	pImg->h    = img.h;
}

/*------------------------------------------------------------------------------
    Fvoid LtImageView(LONG)
    FLONG    FORM ID
    @\Fvr[\p
------------------------------------------------------------------------------*/
void LtImageView(LONG id)
{
	double gainW, gainH;
	INT32 x, y, w, h;
	BOOL limW = FALSE;
	BOOL limH = FALSE;
	
	if (IsBit(lt[id].pc.img.stat, BIT_NONE|BIT_FAILURE)) {return;}
	
	TryZeroDivision(lt[id].pc.img.w);
	TryZeroDivision(lt[id].pc.img.h);
	gainW = (double)lt[id].cn.w / lt[id].pc.img.w;
	gainH = (double)lt[id].cn.h / lt[id].pc.img.h;
	
	if ((1 < gainW) && (1 < gainH))
	{
		gainW = gainH = (double)1;
	}
	else {
		if (CmpGain(gainW, gainH) == TRUE) {
			limW = TRUE;
			limH = TRUE;
		}
		else {
			if (gainW < gainH) {
				gainH = gainW;
				limW = TRUE;
			}
			else {
				gainW = gainH;
				limH = TRUE;
			}
		}
	}
	
	x = (double)lt[id].cn.w / 2 - (double)lt[id].pc.img.w * gainW / 2;
	y = (double)lt[id].cn.h / 2 - (double)lt[id].pc.img.h * gainH / 2;
	w = (double)lt[id].pc.img.w * gainW;
	h = (double)lt[id].pc.img.h * gainH;
	
	if (limW == TRUE) {x = 0;  w = lt[id].cn.w;}
	if (limH == TRUE) {y = 0;  h = lt[id].cn.h;}
	
	if (limW == TRUE) {TryZeroDivision(lt[id].pc.img.w);  lt[id].pc.percent = ((double)w / lt[id].pc.img.w) * 10000;}
	else              {TryZeroDivision(lt[id].pc.img.h);  lt[id].pc.percent = ((double)h / lt[id].pc.img.h) * 10000;}
	
	lt[id].pc.x = x;
	lt[id].pc.y = y;
	if (w <= 0) {lt[id].pc.w = 1;}
	else        {lt[id].pc.w = w;}
	if (h <= 0) {lt[id].pc.h = 1;}
	else        {lt[id].pc.h = h;}
}

/*------------------------------------------------------------------------------
    Fvoid LtImageDelete(LONG)
    FLONG    FORM ID
    @\Fvr[̉摜폜܂B
------------------------------------------------------------------------------*/
void LtImageDelete(LONG id)
{
	ImageDeleteSt(&lt[id].pc.img);
	
	lt[id].pc.x       = 0;
	lt[id].pc.y       = 0;
	lt[id].pc.w       = 0;
	lt[id].pc.h       = 0;
	lt[id].pc.percent = 10000;
	
	wmemset(lt[id].pc.path, 0x0000, MAX_PATH);
}

/*------------------------------------------------------------------------------
    Fvoid LtCreate(LONG)
    FLONG     FORM ID
    @\FXg쐬
------------------------------------------------------------------------------*/
void LtCreate(LONG id)
{
	WINDOWPLACEMENT plcm;
	INT32 wFrame = GetSystemMetrics(SM_CYSIZEFRAME)*2;
	WCHAR pathF[MAX_PATH];
	WCHAR path [MAX_PATH];
	
	LtInst(id);
	wmemset(lt[id].pathDBack, 0x0000, MAX_PATH);
	
	if (fm[id].flgPv == FALSE) {
		lt[id].w    = lt[id].wBx + PADD5*2 + wFrame;
		lt[id].wMin = NULL;
	}
	else {
		lt[id].w    = lt[id].wBx + PADD8*3 + wFrame + lt[id].wCn;
		lt[id].wMin = lt[id].wBx + PADD8*3 + wFrame;
	}
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + lt[id].w;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + lt[id].h;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	
	LinearCreate(id, lt[id].pathD);
	LinearArray(id);
	LinearSort(id, lt[id].pathD);
	
	L_SETREDRAW(lt[id].hBx, FALSE);
	SetWindowPlacement(lt[id].hWnd, &plcm);
	LtCreateLtBx(id);
	L_SETREDRAW(lt[id].hBx, TRUE);
	
	SetFocus(lt[id].hWnd);
	fm[id].hModal = lt[id].hWnd;
	
	LtGetText(id, pathF);
	wcscpy(path, lt[id].pathD);
	wcscmb(path, pathF);
	ThrLtStarting(id, path);
	
	ShowWindow(lt[id].hPc, 0x1);
}

/*------------------------------------------------------------------------------
    Fvoid LtCreateLtBx(LONG)
    FLONG     FORM ID
    @\FXg쐬
------------------------------------------------------------------------------*/
void LtCreateLtBx(LONG id)
{
	INT32 i;
	BOOL res = FALSE;
	WCHAR title [MAX_PATH+6];
	WCHAR folder[MAX_PATH+2];
	WCHAR tmp  [MAX_PATH];
	WCHAR pathF[MAX_PATH];
	INT32 idx;
	
	if (IsModeVert(id)) {
		idx = CmdVertYtoIdx(id);
		wcscpy(pathF, PathFindFileName(fm[id].vpc[idx].path));
	}
	else if (IsModeThumb(id)) {
		idx = CmdThumbYtoIdx(id);
		wcscpy(pathF, PathFindFileName(fm[id].tpc[idx].path));
	}
	else {
		wcscpy(pathF, fm[id].pc[0].pathF);
	}
	
	wcscpy(title, lt[id].pathD);
	SetWindowText(lt[id].hWnd, title);
	
	if ((fm[id].cntF == 0) && (fm[id].cntD == 0)) {
		L_ADDSTRING(lt[id].hBx, L"@");
		L_SETCURSEL(lt[id].hBx, 0);
	}
	else {
		for (i = 0; i < fm[id].cntF; i++) {
			L_ADDSTRING  (lt[id].hBx, fm[id].arrayF[i]->pathF);
			L_SETITEMDATA(lt[id].hBx, i, TRUE);
			
			if ((wcscmp(pathF, fm[id].arrayF[i]->pathF) == 0) &&
				(wcscmp(fm[id].pathD, lt[id].pathD) == 0))
			{
				L_SETCURSEL(lt[id].hBx, i);
				res = TRUE;
			}
		}
		
		for (i = 0; i < fm[id].cntD; i++) {
			wcscpy(folder, L"> ");
			wcscat(folder, fm[id].arrayD[i]->pathF);
			
			L_ADDSTRING  (lt[id].hBx, folder);
			L_SETITEMDATA(lt[id].hBx, i + fm[id].cntF, FALSE);
			
			wcscpy(tmp, lt[id].pathD);
			wcscmb(tmp, fm[id].arrayD[i]->pathF);
			
			if (IsIncludePathD(tmp, fm[id].pathD) == TRUE) {
				L_SETCURSEL(lt[id].hBx, fm[id].cntF + i);
				res = TRUE;
			}
		}
	}
	
	if (wcslen(lt[id].pathDBack) != 0) {
		wcscpy(folder, L"> ");
		wcscat(folder, lt[id].pathDBack);
		L_SELECTSTRING(lt[id].hBx, -1, folder);  // ĈvnCCg
	}
	else {
		if (res == FALSE) {
			L_SETCURSEL(lt[id].hBx, 0);
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid LtEnter(LONG)
    FLONG    FORM ID
    @\F[ENTER]ꂽ
------------------------------------------------------------------------------*/
void LtEnter(LONG id)
{
	WCHAR path[MAX_PATH];
	WCHAR pathF[MAX_PATH];
	WCHAR tmp [MAX_PATH+2];
	
	if ((fm[id].cntF == 0) && (fm[id].cntD == 0)) {return;}
	
	wmemset(lt[id].pathDBack, 0x0000, MAX_PATH);
	
	LtGetText(id, tmp);
	
	if (LtGetItem(id)) {
		wcscpy(pathF, tmp);
		wcscpy(path, lt[id].pathD);
		wcscmb(path, tmp);
		if (IsExistFile(path)) {
			LtEnterFile(id, pathF);
		}
		else {
			MessageBox(lt[id].hWnd, L"not exist file", L_TITLE, MB_OK);
		}
	}
	else {
		wcscpy(path, lt[id].pathD);
		wcscmb(path, tmp+2);
		if (IsExistFolder(path)) {
			wcscpy(lt[id].pathD, path);
			LtEnterFolder(id);
		}
		else {
			MessageBox(lt[id].hWnd, L"not exist folder", L_TITLE, MB_OK);
		}
	}
}

/*------------------------------------------------------------------------------
    Fvoid LtEnterFile(LONG, WCHAR *)
    FLONG     FORM ID
          WCHAR *  t@C
    @\Ft@CJ
------------------------------------------------------------------------------*/
void LtEnterFile(LONG id, WCHAR *pathF)
{
	INT32 i;
	INT32 cnt;
	RECT rcList;
	RECT rcLtBx;
	RECT rcLtCn;
	
	GetWindowRect(lt[id].hWnd, &rcList);
	GetWindowRect(lt[id].hBx,  &rcLtBx);
	GetWindowRect(lt[id].hCn,  &rcLtCn);
	
	lt[id].wBx = rcLtBx.right - rcLtBx.left;
	if (fm[id].flgPv == TRUE) {lt[id].wCn = rcLtCn.right - rcLtCn.left;}
	lt[id].h = rcList.bottom - rcList.top;
	
	LtStore(id);
	CLOSE(lt[id].hWnd);
	
	if (IsModeNeutral(id) &&
		(wcscmp(pathF,        fm[id].pc[0].pathF) == 0) &&
		(wcscmp(lt[id].pathD, fm[id].pathD)       == 0) &&
		(IsOverSave(id) == FALSE))
	{
		return;
	}
	
	if (IsModeNeutral(id)) {
		ImageDelete(id, 0);
	}
	else {
		cnt = GetCntPictCntn(id);
		
		SetModeNeutral(id);
		SetPaneCntn(id);
		
		for (i = 0; i < cnt; i++) {
			ImageDelete(id, i);
			a_SetWindowPos(fm[id].hPict[i], 0, 0, 0, 0);
		}
		
		SetAverageColor(id, 0);
		InvalidateRect(fm[id].hCntn[0], NULL, TRUE);
		UpdateWindow(fm[id].hCntn[0]);
		FormMoveMin(id);
	}
	VtImageDeleteAll(id);
	ThImageDeleteAll(id);
	WindowsReset(id);
	
	InMsg(id, LOADING, TRUE);
	InSize(id);
	
	wcscpy(fm[id].pathD, lt[id].pathD);
	wcscpy(fm[id].pc[0].pathF, pathF);
	wcscpy(fm[id].pc[0].path, fm[id].pathD);
	wcscmb(fm[id].pc[0].path, pathF);
	ThrStarting(id, 1, FALSE, NULL);
}

/*------------------------------------------------------------------------------
    Fvoid LtEnterFolder(LONG)
    FLONG     FORM ID
    @\FtH_J
------------------------------------------------------------------------------*/
void LtEnterFolder(LONG id)
{
	WCHAR pathF[MAX_PATH];
	WCHAR path [MAX_PATH];
	
	L_SETREDRAW(lt[id].hBx, FALSE);
	
	LinearDelete(id);
	LtDelete(id);
	
	LinearCreate(id, lt[id].pathD);
	LinearArray(id);
	LinearSort(id, lt[id].pathD);
	
	LtCreateLtBx(id);
	
	LtGetText(id, pathF);
	wcscpy(path, lt[id].pathD);
	wcscmb(path, pathF);
	ThrLtStarting(id, path);
	
	L_SETREDRAW(lt[id].hBx, TRUE);
}

/*------------------------------------------------------------------------------
    Fvoid LtEnterRoot(LONG)
    FLONG     FORM ID
    @\F[gJ
------------------------------------------------------------------------------*/
void LtEnterRoot(LONG id)
{
	L_SETREDRAW(lt[id].hBx, FALSE);
	LinearDelete(id);
	LtDelete(id);
	
	LinearRoot(id);
	LinearArray(id);
	LinearSort(id, lt[id].pathD);
	
	LtCreateLtBx(id);
	
	ThrLtStarting(id, lt[id].pathD);
	
	L_SETREDRAW(lt[id].hBx, TRUE);
}

/*------------------------------------------------------------------------------
    Fvoid LtDelete(LONG)
    FLONG    FORM ID
    @\FS폜
------------------------------------------------------------------------------*/
void LtDelete(LONG id)
{
	INT32 i;
	INT32 cnt;
	
	cnt = L_GETCOUNT(lt[id].hBx);
	for (i = 0; i < cnt; i++) {
		L_DELETESTRING(lt[id].hBx);
	}
}

/*------------------------------------------------------------------------------
    Fvoid LtGetText(LONG, WCHAR *)
    FLONG     FORM ID
          WCHAR *  -
    @\F݂̃J[\̕擾
------------------------------------------------------------------------------*/
void LtGetText(LONG id, WCHAR *pStr)
{
	INT32 idx;
	idx = L_GETCURSEL(lt[id].hBx);
	L_GETTEXT(lt[id].hBx, idx, pStr);
}

/*------------------------------------------------------------------------------
    FBOOL LtGetItem(LONG)
    FLONG     FORM ID
    ߒlFBOOL     -
    @\FACe擾
------------------------------------------------------------------------------*/
BOOL LtGetItem(LONG id)
{
	INT32 idx;
	idx = L_GETCURSEL(lt[id].hBx);
	return L_GETITEMDATA(lt[id].hBx, idx);
}

/*------------------------------------------------------------------------------
    Fvoid LtSetPane(LONG)
    FLONG    FORM ID
    @\Fvr[̘g\
------------------------------------------------------------------------------*/
void LtSetPane(LONG id)
{
	RECT rc;
	
	GetClientRect(lt[id].hCn, &rc);
	lt[id].cn.x = rc.left;
	lt[id].cn.y = rc.top;
	lt[id].cn.w = rc.right - rc.left;
	lt[id].cn.h = rc.bottom - rc.top;
}
