/*------------------------------------------------------------------------------
    CN[h
------------------------------------------------------------------------------*/
#define MB_CPP
#include "../common.h"
//  MsgBxFbZ[W{bNX

/*------------------------------------------------------------------------------
    [Jϐ
------------------------------------------------------------------------------*/
struct {
	INT32 w;
	INT32 h;
	
	HWND hWnd;
	HWND hEdit;
	
	LRESULT (CALLBACK *pCallEdit) (HWND,UINT,WPARAM,LPARAM);
} mb[CNT_FORM];

/*------------------------------------------------------------------------------
    vg^Cv
------------------------------------------------------------------------------*/
void MbInitClass(void);
void MbInit(LONG);
void MbInst(LONG);
void MbDialog(LONG, WCHAR *, const WCHAR *, HFONT);
void MbLoad(LONG);
void MbStore(LONG);
LRESULT CALLBACK MbWndProc    (HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK MbWndProcEdit(HWND, UINT, WPARAM, LPARAM);
void MbSize    (LONG, WPARAM, LPARAM);
void MbClose   (LONG, WPARAM, LPARAM);
void MbDestroy (LONG, WPARAM, LPARAM);
void MbSetFocus(LONG, WPARAM, LPARAM);

/*------------------------------------------------------------------------------
    Fvoid MbInitClass(void)
    @\FEBhE̐݌v}o^
------------------------------------------------------------------------------*/
void MbInitClass(void)
{
	WNDCLASS wcMsgbx;
	
	InitWC(CS_OWNDC,DefWindowProc,hIcon,hCurArrow,hBrBrGray,NM_MSGBX,&wcMsgbx);
	
	RegisterClass(&wcMsgbx);
}

/*------------------------------------------------------------------------------
    Fvoid MbInit(LONG)
    FLONG    FORM ID
    @\FbZ[W{bNX 
------------------------------------------------------------------------------*/
void MbInit(LONG id)
{
	mb[id].w = 0;
	mb[id].h = 0;
	
	mb[id].hWnd  = NULL;
	mb[id].hEdit = NULL;
	
	mb[id].pCallEdit = NULL;
}

/*------------------------------------------------------------------------------
    Fvoid MbInst(LONG)
    FLONG      FORM ID
    @\FMSGBX̉
------------------------------------------------------------------------------*/
void MbInst(LONG id)
{
	DWORD styleMb = WS_CAPTION|WS_THICKFRAME|WS_SYSMENU;
	DWORD styleEd = WS_CHILD|WS_VSCROLL|WS_VISIBLE|WS_BORDER|ES_LEFT|ES_MULTILINE|ES_AUTOHSCROLL;
	
	mb[id].hWnd  = a_CreateWindow(NM_MSGBX,NULL,styleMb,0,0,0,0,fm[id].hWnd);
	mb[id].hEdit = a_CreateWindow(L"Edit", NULL,styleEd,0,0,0,0,mb[id].hWnd);
	SetWindowLong(mb[id].hWnd,  GWL_USERDATA, id);
	SetWindowLong(mb[id].hEdit, GWL_USERDATA, id);
	SetWindowLong(mb[id].hWnd,  GWL_WNDPROC, (LONG)MbWndProc);
	
	mb[id].pCallEdit = (CALLFUNC)GetWindowLong(mb[id].hEdit, GWL_WNDPROC);
	SetWindowLong(mb[id].hEdit, GWL_WNDPROC, (LONG)MbWndProcEdit);
}

/*------------------------------------------------------------------------------
    Fvoid MbDialog(LONG, WCHAR *, const WCHAR *, HFONT)
    FLONG           FORM ID
          WCHAR *        -
          const WCHAR *  -
          HFONT          -
    @\F_CAO
------------------------------------------------------------------------------*/
void MbDialog(LONG id, WCHAR *pStr, const WCHAR *pTitle, HFONT hFt)
{
	WINDOWPLACEMENT plcm;
	
	MbInst(id);
	MbLoad(id);
	SetWindowText(mb[id].hWnd,  pTitle);
	SetWindowText(mb[id].hEdit, pStr);
	E_SETFONT(mb[id].hEdit, hFt);
	
	if ((mb[id].w == 0) && (mb[id].h == 0)) {
		mb[id].w = 500;
		mb[id].h = 600;
	}
	
	InitPlcm(&plcm);
	plcm.rcNormalPosition.left   = fm[id].x - 5;
	plcm.rcNormalPosition.top    = fm[id].y + 5;
	plcm.rcNormalPosition.right  = plcm.rcNormalPosition.left + mb[id].w;
	plcm.rcNormalPosition.bottom = plcm.rcNormalPosition.top  + mb[id].h;
	plcm.showCmd = SHOWCMD_NORMAL;
	AdjustWorkArea(INVALID_ID, &plcm);
	SetWindowPlacement(mb[id].hWnd, &plcm);
	EnableWindow(fm[id].hWnd, FALSE);
	fm[id].hModal = mb[id].hWnd;
	
	MessageLoop();
}

/*------------------------------------------------------------------------------
    Fvoid MbLoad(LONG)
    FLONG    FORM ID
    @\FO[of[^ǂݍ
------------------------------------------------------------------------------*/
void MbLoad(LONG id)
{
	mb[id].w = g_msgbxW;
	mb[id].h = g_msgbxH;
}

/*------------------------------------------------------------------------------
    Fvoid MbStore(LONG)
    FLONG    FORM ID
    @\FO[of[^XV
------------------------------------------------------------------------------*/
void MbStore(LONG id)
{
	g_msgbxW = mb[id].w;
	g_msgbxH = mb[id].h;
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MbWndProc(,,,)
    F-
    ߒlF-
    @\FMsgbxCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MbWndProc(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_SIZE:      MbSize    (id, wp, lp);  break;
	case WM_CLOSE:     MbClose   (id, wp, lp);  break;
	case WM_DESTROY:   MbDestroy (id, wp, lp);  break;
	case WM_SETFOCUS:  MbSetFocus(id, wp, lp);  break;
	default: break;
	}
	return DefWindowProc(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    FLRESULT CALLBACK MbWndProcEdit(,,,)
    F-
    ߒlF-
    @\FMSGBX EDITCxg
------------------------------------------------------------------------------*/
LRESULT CALLBACK MbWndProcEdit(HWND hWnd, UINT msg, WPARAM wp, LPARAM lp)
{
	LONG id;
	
	id = GetWindowLong(hWnd, GWL_USERDATA);
	
	switch (msg) {
	case WM_KEYDOWN:
		switch (wp) {
		case KEY_ESC:  CLOSE(mb[id].hWnd);  break;
		default:  break;
		}
		break;
	default:
		break;
	}
	return mb[id].pCallEdit(hWnd, msg, wp, lp);
}

/*------------------------------------------------------------------------------
    Fvoid MbSize(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMSGBX WM_SIZECxg
------------------------------------------------------------------------------*/
void MbSize(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rc;
	
	GetClientRect(mb[id].hWnd, &rc);
	a_SetWindowPos(mb[id].hEdit, rc.left+5, rc.top+5,
								 rc.right-rc.left-10, rc.bottom-rc.top-10);
	InvalidateRect(mb[id].hEdit, NULL, FALSE);
	InvalidateRect(mb[id].hWnd,     NULL, TRUE);
}

/*------------------------------------------------------------------------------
    Fvoid MbClose(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMSGBX WM_CLOSECxg
------------------------------------------------------------------------------*/
void MbClose(LONG id, WPARAM wp, LPARAM lp)
{
	RECT rcMsgbx;
	
	GetWindowRect(mb[id].hWnd, &rcMsgbx);
	mb[id].w = rcMsgbx.right  - rcMsgbx.left;
	mb[id].h = rcMsgbx.bottom - rcMsgbx.top;
	MbStore(id);
	
	fm[id].hModal = NULL;
	EnableWindow(fm[id].hWnd, TRUE);
	SetForegroundWindow(fm[id].hWnd);
}

/*------------------------------------------------------------------------------
    Fvoid MbDestroy(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMSGBX WM_DESTROYCxg
------------------------------------------------------------------------------*/
void MbDestroy(LONG id, WPARAM wp, LPARAM lp)
{
	P_QUIT(NULL);
}

/*------------------------------------------------------------------------------
    Fvoid MbSetFocus(LONG, WPARAM, LPARAM)
    FLONG    FORM ID
          WPARAM  -
          LPARAM  -
    @\FMSGBX WM_SETFOCUSCxg
------------------------------------------------------------------------------*/
void MbSetFocus(LONG id, WPARAM wp, LPARAM lp)
{
	SetFocus(mb[id].hEdit);
}
